/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.publishing.FilterForView;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.ProcessRecursively;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingArtifactLoader;
import org.eclipse.osee.framework.core.publishing.PublishingErrorLog;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;

public abstract class PublishingSharedArtifactsFolder {
    private static PublishingSharedArtifactsFolder createErrorImplementation(String reason, PublishingErrorLog publishingErrorLog, BranchSpecification publishingBranchSpecification, String sharedFolderDescription, ArtifactToken sharedFolderArtifactToken) {
        String message = new Message().title((CharSequence)reason).indentInc().segment((CharSequence)"Shared Folder Description", (Object)sharedFolderDescription).segment((CharSequence)"Shared Folder Id", (Object)sharedFolderArtifactToken.getIdString()).segment((CharSequence)"Publishing Branch Specification", (Object)publishingBranchSpecification).toString();
        publishingErrorLog.error((Id)sharedFolderArtifactToken, message);
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return false;
            }

            @Override
            public Optional<PublishingArtifact> getSharedPublishingFolder() {
                return Optional.empty();
            }

            @Override
            public List<PublishingArtifact> getSharedArtifacts(String attributeValue) {
                return List.of();
            }
        };
    }

    public static PublishingSharedArtifactsFolder create(final PublishingArtifactLoader publishingArtifactLoader, final PublishingErrorLog publishingErrorLog, final BranchSpecification publishingBranchSpecification, final String sharedFolderDescription, final ArtifactToken sharedFolderArtifactToken, final AttributeTypeToken childAttributeTypeId, final ProcessRecursively processRecursively) {
        Objects.requireNonNull(publishingArtifactLoader, "PublishingSharedArtifactsFolder::create, parameter \"publishingArtifactLoader\" is null.");
        Objects.requireNonNull(publishingErrorLog, "PublishingSharedArtifactsFolder::create, parameter \"publishingErrorLog\" is null.");
        Objects.requireNonNull(publishingBranchSpecification, "PublishingSharedArtifactsFolder::create, parameter \"publishingBranchSpecification\" is null.");
        Objects.requireNonNull(sharedFolderDescription, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderDescription\" is null.");
        Objects.requireNonNull(sharedFolderArtifactToken, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderArtifactToken\" is null.");
        Objects.requireNonNull(childAttributeTypeId, "PublishingSharedArtifactsFolder::create, parameter \"childAttributeTypeId\" is null.");
        if (AttributeTypeId.SENTINEL.equals(childAttributeTypeId)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Attribute Type Identifier is SENTINEL.", publishingErrorLog, publishingBranchSpecification, sharedFolderDescription, sharedFolderArtifactToken);
        }
        final PublishingArtifact sharedFolder = (PublishingArtifact)publishingArtifactLoader.getPublishingArtifactByArtifactIdentifier(PublishingArtifactLoader.BranchIndicator.PUBLISHING_BRANCH, (ArtifactId)sharedFolderArtifactToken, FilterForView.YES, PublishingArtifactLoader.WhenNotFound.SENTINEL, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"PublishingSharedArtifactsFolder::create, failed to load shared folder artifact.").indentInc().segment((CharSequence)"Shared Folder Artifact", (Object)sharedFolderArtifactToken).reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException));
        if (sharedFolder.isInvalid()) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Unable to locate the shared folder.", publishingErrorLog, publishingBranchSpecification, sharedFolderDescription, sharedFolderArtifactToken);
        }
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return true;
            }

            @Override
            public Optional<PublishingArtifact> getSharedPublishingFolder() {
                return Optional.of(sharedFolder);
            }

            @Override
            public List<PublishingArtifact> getSharedArtifacts(String attributeValue) {
                return (List)publishingArtifactLoader.getChildrenPublishingArtifacts((ArtifactId)sharedFolderArtifactToken, ArtifactTypeToken.SENTINEL, (AttributeTypeId)childAttributeTypeId, attributeValue, publishingBranchSpecification.hasView() ? FilterForView.YES : FilterForView.NO, processRecursively).peekError(exception -> publishingErrorLog.error((Id)sharedFolderArtifactToken, new Message().title((CharSequence)"Failed to get artifacts from the shared folder.").indentInc().segment((CharSequence)"Shared Folder Description", (Object)sharedFolderDescription).segment((CharSequence)"Shared Folder Id", (Object)sharedFolderArtifactToken.getIdString()).segment((CharSequence)"Publishing Branch Specification", (Object)publishingBranchSpecification).segment((CharSequence)"Search Attribute Type Id", (Object)childAttributeTypeId.getIdString()).segment((CharSequence)"Search Attribute Value", (Object)attributeValue).reasonFollows((Throwable)exception).toString())).orElseGet(new LinkedList());
            }
        };
    }

    public static PublishingSharedArtifactsFolder create(final PublishingArtifactLoader publishingArtifactLoader, final PublishingErrorLog publishingErrorLog, final BranchSpecification publishingBranchSpecification, final String sharedFolderDescription, final ArtifactToken sharedFolderArtifactToken, final ArtifactTypeToken childArtifactTypeToken, final AttributeTypeToken childAttributeTypeId, final ProcessRecursively processRecursively) {
        Objects.requireNonNull(publishingArtifactLoader, "PublishingSharedArtifactsFolder::create, parameter \"publishingArtifactLoader\" is null.");
        Objects.requireNonNull(publishingErrorLog, "PublishingSharedArtifactsFolder::create, parameter \"publishingErrorLog\" is null.");
        Objects.requireNonNull(publishingBranchSpecification, "PublishingSharedArtifactsFolder::create, parameter \"publishingBranchSpecification\" is null.");
        Objects.requireNonNull(sharedFolderDescription, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderDescription\" is null.");
        Objects.requireNonNull(sharedFolderArtifactToken, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderArtifactToken\" is null.");
        Objects.requireNonNull(childArtifactTypeToken, "PublishingSharedArtifactsFolder::create, parameter \"childArtifactTypeToken\" is null.");
        Objects.requireNonNull(childAttributeTypeId, "PublishingSharedArtifactsFolder::create, parameter \"childAttributeTypeId\" is null.");
        if (AttributeTypeId.SENTINEL.equals(childAttributeTypeId)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Attribute Type Identifier is SENTINEL.", publishingErrorLog, publishingBranchSpecification, sharedFolderDescription, sharedFolderArtifactToken);
        }
        if (ArtifactTypeToken.SENTINEL.equals(childArtifactTypeToken)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Artifact Type Token is SENTINEL.", publishingErrorLog, publishingBranchSpecification, sharedFolderDescription, sharedFolderArtifactToken);
        }
        final PublishingArtifact sharedFolder = (PublishingArtifact)publishingArtifactLoader.getPublishingArtifactByArtifactIdentifier(PublishingArtifactLoader.BranchIndicator.PUBLISHING_BRANCH, (ArtifactId)sharedFolderArtifactToken, FilterForView.YES, PublishingArtifactLoader.WhenNotFound.SENTINEL, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"PublishingSharedArtifactsFolder::create, failed to load shared folder artifact.").indentInc().segment((CharSequence)"Shared Folder Artifact", (Object)sharedFolderArtifactToken).reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException));
        if (sharedFolder.isInvalid()) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Unable to locate the shared folder.", publishingErrorLog, publishingBranchSpecification, sharedFolderDescription, sharedFolderArtifactToken);
        }
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return true;
            }

            @Override
            public Optional<PublishingArtifact> getSharedPublishingFolder() {
                return Optional.of(sharedFolder);
            }

            @Override
            public List<PublishingArtifact> getSharedArtifacts(String attributeValue) {
                return (List)publishingArtifactLoader.getChildrenPublishingArtifacts((ArtifactId)sharedFolderArtifactToken, childArtifactTypeToken, (AttributeTypeId)childAttributeTypeId, attributeValue, publishingBranchSpecification.hasView() ? FilterForView.YES : FilterForView.NO, processRecursively).peekError(exception -> publishingErrorLog.error((Id)sharedFolderArtifactToken, new Message().title((CharSequence)"Failed to get artifacts from the shared folder.").segment((CharSequence)"Shared Folder Description", (Object)sharedFolderDescription).segment((CharSequence)"Shared Folder Id", (Object)sharedFolderArtifactToken.getIdString()).segment((CharSequence)"Publishing Branch Specification", (Object)publishingBranchSpecification).segment((CharSequence)"Search Artifact Type", (Object)childArtifactTypeToken.getName()).segment((CharSequence)"Search Attribute Type Id", (Object)childAttributeTypeId.getIdString()).segment((CharSequence)"Search Attribute Value", (Object)attributeValue).reasonFollows((Throwable)exception).toString())).orElseGet(new LinkedList());
            }
        };
    }

    public abstract boolean sharedPublishingFolderFound();

    public abstract Optional<PublishingArtifact> getSharedPublishingFolder();

    public abstract List<PublishingArtifact> getSharedArtifacts(String var1);
}

