/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookReader;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookUtils;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.types.ConnectionValidationResult;
import org.eclipse.osee.mim.types.ElementArrayIndexOrder;
import org.eclipse.osee.mim.types.IcdElementIndex;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimChangeSummary;
import org.eclipse.osee.mim.types.MimChangeSummaryItem;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class MimIcdGenerator {
    private final MimApi mimApi;
    private final OrcsApi orcsApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceDifferenceReportApi interfaceDifferenceReportApi;
    private final Set<String> logicalTypes;
    private final Set<String> units;
    private final Set<String> txRates;
    private final Set<String> categories;
    private final Map<String, StructureInfo> structureInfoMap;
    private final Map<String, StructureInfo> headerStructureInfoMap;
    private final Map<ArtifactId, InterfaceSubMessageToken> messageHeaders;
    private final Map<String, InterfaceStructureToken> messageHeaderStructures;
    private final Map<String, InterfaceStructureToken> parentMessageHeaderStructures;
    private final Map<String, ExcelWorkbookWriter.CELLSTYLE> headerNameStyles;
    private final Map<ArtifactId, List<InterfaceEnumeration>> arrayDescriptions;
    private final Map<ArtifactId, MimChangeSummaryItem> diffs;
    private final Map<String, String> logicalTypeMaxRange;
    private final Map<ArtifactId, Pair<String, String>> releaseArtifacts = new HashMap<ArtifactId, Pair<String, String>>();
    private final Map<ArtifactId, List<Pair<ArtifactId, String>>> msgHeaderICDCNs = new HashMap<ArtifactId, List<Pair<ArtifactId, String>>>();

    public MimIcdGenerator(MimApi mimApi) {
        this.mimApi = mimApi;
        this.orcsApi = mimApi.getOrcsApi();
        this.structureInfoMap = new HashMap<String, StructureInfo>();
        this.headerStructureInfoMap = new HashMap<String, StructureInfo>();
        this.messageHeaders = new HashMap<ArtifactId, InterfaceSubMessageToken>();
        this.messageHeaderStructures = new HashMap<String, InterfaceStructureToken>();
        this.parentMessageHeaderStructures = new HashMap<String, InterfaceStructureToken>();
        this.headerNameStyles = new HashMap<String, ExcelWorkbookWriter.CELLSTYLE>();
        this.arrayDescriptions = new HashMap<ArtifactId, List<InterfaceEnumeration>>();
        this.diffs = new HashMap<ArtifactId, MimChangeSummaryItem>();
        this.logicalTypes = new HashSet<String>();
        this.units = new HashSet<String>();
        this.txRates = new HashSet<String>();
        this.categories = new HashSet<String>();
        this.interfaceMessageApi = mimApi.getInterfaceMessageApi();
        this.interfaceStructureApi = mimApi.getInterfaceStructureApi();
        this.interfaceDifferenceReportApi = mimApi.getInterfaceDifferenceReportApi();
        this.logicalTypeMaxRange = new HashMap<String, String>();
        this.logicalTypeMaxRange.put("boolean", "0 to 1");
        this.logicalTypeMaxRange.put("character", "0 to 255");
        this.logicalTypeMaxRange.put("sShort", "-32,768 to 32,767");
        this.logicalTypeMaxRange.put("uShort", "0 to 2^16-1");
        this.logicalTypeMaxRange.put("enumeration", "See Enumerated Literals");
        this.logicalTypeMaxRange.put("float", "-3.4e+38 to 3.4e+38");
        this.logicalTypeMaxRange.put("sInteger", "-2^31 to 2^31-1");
        this.logicalTypeMaxRange.put("uInteger", "0 to 2^32-1");
        this.logicalTypeMaxRange.put("double", "-1.8e+308 to 1.8e+308");
        this.logicalTypeMaxRange.put("uLong", "0 to 2^64-1");
    }

    public void runOperation(OutputStream outputStream, BranchId branch, ArtifactId view, ArtifactId connectionId, boolean diff, boolean showErrors) {
        InterfaceConnection conn = this.mimApi.getInterfaceConnectionViewApi().get(branch, view, connectionId, Arrays.asList(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionNode_Node), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionTransportType_TransportType), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceConnectionMessage_Message), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceSubMessageContent_Structure), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceStructureContent_DataElement), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType, (FollowRelation[])new FollowRelation[]{FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceEnumeration_EnumerationState)}), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayIndexDescriptionSet_Set), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceEnumeration_EnumerationState)));
        ConnectionValidationResult validation = showErrors ? this.mimApi.getInterfaceValidationApi().validateConnection(branch, view, connectionId) : new ConnectionValidationResult();
        Branch currentBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        BranchId parentBranch = currentBranch.getParentBranch();
        MimChangeSummary summary = new MimChangeSummary(new HashMap<ArtifactId, MimChangeSummaryItem>());
        if (diff) {
            summary = this.interfaceDifferenceReportApi.getChangeSummary(branch, parentBranch, view, connectionId);
            this.diffs.putAll(summary.getAll());
        }
        InterfaceNode primaryNode = InterfaceNode.SENTINEL;
        InterfaceNode secondaryNode = InterfaceNode.SENTINEL;
        List<InterfaceNode> nodes = conn.getNodes();
        if (nodes.size() == 2) {
            primaryNode = nodes.get(0);
            secondaryNode = nodes.get(1);
        }
        if (!(conn.isValid() && primaryNode.isValid() && secondaryNode.isValid())) {
            return;
        }
        LinkedList<InterfaceSubMessageToken> subMessagesWithHeaders = new LinkedList<InterfaceSubMessageToken>();
        LinkedList<InterfaceStructureToken> structures = new LinkedList<InterfaceStructureToken>();
        ExcelWorkbookWriter writer = new ExcelWorkbookWriter(outputStream, ExcelWorkbookWriter.WorkbookFormat.XLSX);
        writer.setDefaultZoom(80);
        this.createChangeHistory(writer, currentBranch, conn.getId(), diff);
        List messages = conn.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceConnectionMessage_Message).getList();
        for (ArtifactReadable message : messages) {
            InterfaceMessageToken msg = new InterfaceMessageToken(message);
            this.mimApi.getInterfaceMessageApi().setUpMessage(branch, msg);
            List messageSubMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            List smsgTokens = messageSubMessages.stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "error").equals("Operational")) {
                InterfaceSubMessageToken header = this.interfaceMessageApi.getMessageHeader(msg);
                this.messageHeaders.put(message.getArtifactId(), header);
                smsgTokens.add(0, header);
                InterfaceStructureToken headerStruct = this.interfaceStructureApi.getMessageHeaderStructure(branch, conn, msg);
                this.messageHeaderStructures.put((String)header.getName().getValue(), headerStruct);
            }
            subMessagesWithHeaders.addAll(smsgTokens);
            for (InterfaceSubMessageToken smsg : smsgTokens) {
                LinkedList<InterfaceStructureToken> structs = new LinkedList<InterfaceStructureToken>();
                if (smsg.getId() == 0L) {
                    structs.add(this.messageHeaderStructures.get(smsg.getName().getValue()));
                } else {
                    structs.addAll(smsg.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                    for (InterfaceStructureToken struct : structs) {
                        MimChangeSummaryItem structDiff = this.diffs.get(struct.getArtifactId());
                        if (structDiff == null) continue;
                        InterfaceStructureToken parentStructHeader = this.interfaceStructureApi.getMessageHeaderStructure(parentBranch, connectionId, message.getArtifactId(), view);
                        String headerName = String.valueOf((String)msg.getPublisherNodes().get(0).getName().getValue()) + " M" + msg.getInterfaceMessageNumber() + " Header";
                        this.parentMessageHeaderStructures.put(headerName, parentStructHeader);
                        break;
                    }
                }
                structures.addAll(structs);
            }
        }
        this.createStructureInfo(branch, parentBranch, view, conn, messages);
        if (diff) {
            this.createChangeSummary(writer, summary);
        }
        if (!validation.isPassed()) {
            this.writeValidationErrorsSheet(writer, validation);
        }
        this.writeMessageSubMessageSummary(writer, conn.getArtifactReadable(), primaryNode.getArtifactReadable(), secondaryNode.getArtifactReadable(), messages);
        this.writeStoredSheets(writer, branch, view, conn);
        this.createUnitsAndTypesSheet(writer);
        this.createStructureNamesSheet(writer);
        this.createStructureSummarySheet(writer);
        this.writeStructureSheets(writer, subMessagesWithHeaders, messages, validation);
        this.writeUnitsAndTypesSheet(writer, branch, view, primaryNode, secondaryNode);
        this.writeStructureNamesSheet(writer, structures, validation);
        this.writeStructureSummarySheet(writer, messages, validation);
        writer.writeWorkbook();
        writer.closeWorkbook();
    }

    private void createStructureInfo(BranchId branch, BranchId parentBranch, ArtifactId view, InterfaceConnection connection, List<ArtifactReadable> messages) {
        for (ArtifactReadable message : messages) {
            String msgRateText;
            MimChangeSummaryItem msgDiffItem = this.diffs.get(message.getArtifactId());
            boolean txRateChanged = msgDiffItem != null && msgDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMessageRate.getId());
            boolean msgPeriodicityChanged = msgDiffItem != null && msgDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMessagePeriodicity.getId());
            boolean msgNumChanged = msgDiffItem != null && msgDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMessageNumber.getId());
            ArtifactReadable sendingNode = (ArtifactReadable)message.getRelated(CoreRelationTypes.InterfaceMessagePubNode_Node).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
            String msgNumber = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber, "0");
            int msgRate = -1;
            String msgPeriodicity = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePeriodicity, "Aperiodic");
            if (msgPeriodicity.equals("Periodic")) {
                msgRateText = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Error");
                try {
                    msgRate = Integer.parseInt(msgRateText);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                msgRateText = msgPeriodicity;
            }
            if (message.getExistingAttributeTypes().contains(CoreAttributeTypes.InterfaceMessageRate)) {
                msgRateText = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic");
                if (!msgRateText.equals("Aperiodic")) {
                    try {
                        msgRate = Integer.parseInt(msgRateText);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (msgPeriodicity.equals("Aperiodic") && !msgRateText.equals("Aperiodic")) {
                    msgRateText = String.valueOf(msgRateText) + "-A";
                }
            }
            List subMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "Error").equals("Operational")) {
                subMessages.add(0, this.messageHeaders.get(ArtifactId.valueOf((Long)message.getId())));
            }
            if (msgDiffItem != null && (txRateChanged || msgPeriodicityChanged)) {
                this.msgHeaderICDCNs.put(message.getArtifactId(), new ArrayList<Pair>(Arrays.asList(new Pair((Object)message.getArtifactId(), (Object)this.getRelatedWorkFlow(msgDiffItem.getItemTxIds())))));
            }
            for (InterfaceSubMessageToken subMessage : subMessages) {
                MimChangeSummaryItem subMsgDiffItem = this.diffs.get(subMessage.getArtifactId());
                if (subMsgDiffItem != null && (subMsgDiffItem.isAdded() || subMsgDiffItem.isAddedDueToApplicChange())) {
                    if (this.msgHeaderICDCNs.containsKey(message.getArtifactId())) {
                        List<Pair<ArtifactId, String>> list = this.msgHeaderICDCNs.get(message.getArtifactId());
                        Optional<Pair> currentSubMsgPair = list.stream().filter(a -> ((ArtifactId)a.getFirst()).equals(subMessage.getArtifactId())).findFirst();
                        if (currentSubMsgPair.isPresent()) {
                            String subMsgLevelICDCN;
                            String currentList = (String)currentSubMsgPair.get().getSecond();
                            if (!currentList.contains(subMsgLevelICDCN = this.getRelatedWorkFlow(subMsgDiffItem.getItemTxIds()))) {
                                currentList = String.valueOf(currentList) + "," + subMsgLevelICDCN;
                            }
                        } else {
                            list.add((Pair<ArtifactId, String>)new Pair((Object)subMessage.getArtifactId(), (Object)this.getRelatedWorkFlow(subMsgDiffItem.getItemTxIds())));
                        }
                    } else {
                        this.msgHeaderICDCNs.put(message.getArtifactId(), new ArrayList<Pair>(Arrays.asList(new Pair((Object)subMessage.getArtifactId(), (Object)this.getRelatedWorkFlow(subMsgDiffItem.getItemTxIds())))));
                    }
                }
                LinkedList<InterfaceStructureToken> structures = new LinkedList<InterfaceStructureToken>();
                if (subMessage.getId() == 0L) {
                    structures.add(this.messageHeaderStructures.get(subMessage.getName().getValue()));
                } else {
                    structures.addAll(subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                }
                for (InterfaceStructureToken struct : structures) {
                    String sheetName;
                    MimChangeSummaryItem structDiffItem = this.diffs.get(struct.getArtifactId());
                    if (structDiffItem != null && (structDiffItem.isAdded() || structDiffItem.isAddedDueToApplicChange() || structDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMinSimultaneity.getId()) || structDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMinSimultaneity.getId()))) {
                        if (this.msgHeaderICDCNs.containsKey(message.getArtifactId())) {
                            List<Pair<ArtifactId, String>> list = this.msgHeaderICDCNs.get(message.getArtifactId());
                            Optional<Pair> currentSubMsgPair = list.stream().filter(a -> ((ArtifactId)a.getFirst()).equals(subMessage.getArtifactId())).findFirst();
                            if (currentSubMsgPair.isPresent()) {
                                String structLevelICDCN;
                                Object currentList = (String)currentSubMsgPair.get().getSecond();
                                if (!((String)currentList).contains(structLevelICDCN = this.getRelatedWorkFlow(structDiffItem.getItemTxIds()))) {
                                    currentList = String.valueOf(currentList) + "," + structLevelICDCN;
                                }
                                if (!structDiffItem.isAdded() && !structDiffItem.isAddedDueToApplicChange()) {
                                    HashSet<TransactionId> simTxIds = new HashSet<TransactionId>();
                                    if (structDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMinSimultaneity.getId())) {
                                        simTxIds.add(structDiffItem.getAttributeChanges(CoreAttributeTypes.InterfaceMinSimultaneity.getId()).get(0).getTxId());
                                    }
                                    if (structDiffItem.hasAttributeChanges(CoreAttributeTypes.InterfaceMaxSimultaneity.getId())) {
                                        simTxIds.add(structDiffItem.getAttributeChanges(CoreAttributeTypes.InterfaceMaxSimultaneity.getId()).get(0).getTxId());
                                    }
                                    if (simTxIds.size() > 0) {
                                        String simICDCNs = this.getRelatedWorkFlow(simTxIds);
                                        if (!((String)currentList).contains(structLevelICDCN)) {
                                            currentList = String.valueOf(currentList) + "," + simICDCNs;
                                        }
                                    }
                                }
                            } else {
                                list.add((Pair<ArtifactId, String>)new Pair((Object)subMessage.getArtifactId(), (Object)this.getRelatedWorkFlow(structDiffItem.getItemTxIds())));
                            }
                        } else {
                            this.msgHeaderICDCNs.put(message.getArtifactId(), new ArrayList<Pair>(Arrays.asList(new Pair((Object)subMessage.getArtifactId(), (Object)this.getRelatedWorkFlow(structDiffItem.getItemTxIds())))));
                        }
                    }
                    LinkedList<InterfaceStructureElementToken> flatElements = new LinkedList<InterfaceStructureElementToken>();
                    for (InterfaceStructureElementToken element : struct.getElements()) {
                        if (((Boolean)element.getInterfaceElementArrayHeader().getValue()).booleanValue()) {
                            int startIndex = (Integer)element.getInterfaceElementIndexStart().getValue();
                            int endIndex = (Integer)element.getInterfaceElementIndexEnd().getValue();
                            int i = startIndex;
                            while (i <= endIndex) {
                                for (InterfaceStructureElementToken arrayElement : element.getArrayElements()) {
                                    if (this.arrayDescriptions.get(arrayElement.getArtifactId()) == null && arrayElement.getArrayDescriptionSet().isValid()) {
                                        this.arrayDescriptions.put(arrayElement.getArtifactId(), this.orcsApi.getQueryFactory().fromBranch(branch, view).andRelatedTo(CoreRelationTypes.InterfaceArrayIndexDescription_Set, arrayElement.getArrayDescriptionSet().getArtifactId()).asArtifacts().stream().map(a -> new InterfaceEnumeration((ArtifactReadable)a)).collect(Collectors.toList()));
                                    }
                                    InterfaceStructureElementToken arrayElementCopy = new InterfaceStructureElementToken(arrayElement.getArtifactReadable());
                                    String arrayElementName = (Boolean)element.getInterfaceElementWriteArrayHeaderName().getValue() != false || (Boolean)arrayElement.getInterfaceElementWriteArrayHeaderName().getValue() != false ? String.valueOf((String)element.getName().getValue()) + " " + i + " " + (String)arrayElement.getName().getValue() : String.valueOf((String)arrayElement.getName().getValue()) + " " + i;
                                    arrayElementCopy.setName(arrayElementName);
                                    arrayElementCopy.setInterfaceElementWriteArrayHeaderName((Boolean)element.getInterfaceElementWriteArrayHeaderName().getValue() != false || (Boolean)arrayElement.getInterfaceElementWriteArrayHeaderName().getValue() != false);
                                    arrayElementCopy.setArrayChild(true);
                                    arrayElementCopy.setInterfaceElementArrayIndexOrder(element.getInterfaceElementArrayIndexOrder());
                                    arrayElementCopy.setInterfaceElementArrayIndexDelimiterOne(element.getInterfaceElementArrayIndexDelimiterOne());
                                    arrayElementCopy.setInterfaceElementArrayIndexDelimiterTwo(element.getInterfaceElementArrayIndexDelimiterTwo());
                                    arrayElementCopy.setName(((String)arrayElementCopy.getName().getValue()).replace("$parentindex", Integer.toString(i)).replace("$parentname", (CharSequence)element.getName().getValue()));
                                    arrayElementCopy.setDescription(((String)arrayElementCopy.getDescription().getValue()).replace("$parentindex", Integer.toString(i)).replace("$parentname", (CharSequence)element.getName().getValue()));
                                    arrayElementCopy.setNotes(((String)arrayElementCopy.getNotes().getValue()).replace("$parentindex", Integer.toString(i)).replace("$parentname", (CharSequence)element.getName().getValue()));
                                    flatElements.add(arrayElementCopy);
                                }
                                ++i;
                            }
                            continue;
                        }
                        flatElements.add(element);
                    }
                    Integer sizeInBytes = 0;
                    int elementCount = 0;
                    boolean structureChanged = false;
                    int i = 0;
                    while (i < flatElements.size()) {
                        InterfaceStructureElementToken element = (InterfaceStructureElementToken)((Object)flatElements.get(i));
                        elementCount = struct.isAutogenerated() ? elementCount + 1 : elementCount + element.getArrayLength();
                        sizeInBytes = sizeInBytes + (int)element.getElementSizeInBytes();
                        MimChangeSummaryItem elementDiffItem = this.diffs.get(element.getArtifactId());
                        MimChangeSummaryItem pTypeDiffItem = this.diffs.get(element.getPlatformType().getArtifactId());
                        structureChanged = structureChanged || elementDiffItem != null || pTypeDiffItem != null;
                        ++i;
                    }
                    String minSim = (String)struct.getInterfaceMinSimultaneity().getValue();
                    String maxSim = (String)struct.getInterfaceMaxSimultaneity().getValue();
                    String minBps = "Classified";
                    String maxBps = "Classified";
                    if (msgRate > 0) {
                        try {
                            minBps = Integer.toString(Integer.parseInt(minSim) * sizeInBytes * msgRate);
                        }
                        catch (NumberFormatException numberFormatException) {
                            minBps = "Classified";
                        }
                        try {
                            maxBps = Integer.toString(Integer.parseInt(maxSim) * sizeInBytes * msgRate);
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxBps = "Classified";
                        }
                    }
                    String cat = (String)struct.getInterfaceStructureCategory().getValue();
                    String subMsgNumber = (String)subMessage.getInterfaceSubMessageNumber().getValue();
                    String taskFileType = (Integer)struct.getInterfaceTaskFileType().getValue() == 0 ? "n/a" : "" + struct.getInterfaceTaskFileType().getValue();
                    String desc = (String)struct.getDescription().getValue();
                    boolean numElementsChanged = false;
                    boolean sizeInBytesChanged = false;
                    structureChanged = structureChanged || structDiffItem != null || txRateChanged || msgPeriodicityChanged || msgNumChanged;
                    HashSet<TransactionId> structTxIds = new HashSet<TransactionId>();
                    if (msgDiffItem != null && (txRateChanged || msgPeriodicityChanged || msgNumChanged)) {
                        structTxIds.addAll(msgDiffItem.getItemTxIds());
                    }
                    if (structDiffItem != null) {
                        structTxIds.addAll(structDiffItem.getItemTxIds());
                    }
                    String icdcn = !structTxIds.isEmpty() ? this.getRelatedWorkFlow(structTxIds) : "";
                    this.txRates.add(msgRateText);
                    this.categories.add(cat);
                    InterfaceStructureToken parentStructure = InterfaceStructureToken.SENTINEL;
                    if (!struct.isAutogenerated() && struct.getArtifactId().isValid() && structDiffItem != null) {
                        parentStructure = this.interfaceStructureApi.get(parentBranch, connection, struct.getArtifactId(), view);
                        numElementsChanged = !struct.getNumElements().equals(parentStructure.getNumElements());
                        sizeInBytesChanged = !struct.getSizeInBytes().equals(parentStructure.getSizeInBytes());
                    }
                    String string = sheetName = ((String)struct.getNameAbbrev().getValue()).isEmpty() ? ((String)struct.getName().getValue()).replace("Command Taskfile", "CT").replace("Status Taskfile", "ST") : (String)struct.getNameAbbrev().getValue();
                    if (this.structureInfoMap.values().stream().anyMatch(a -> a.sheetName.equals(((String)struct.getNameAbbrev().getValue()).isEmpty() ? ((String)struct.getName().getValue()).replace("Command Taskfile", "CT").replace("Status Taskfile", "ST") : struct.getNameAbbrev().getValue()))) {
                        String ids = String.valueOf(sendingNode.getName()) + msgNumber + subMsgNumber + struct.getIdString();
                        String hash = String.format("%08x", ids.hashCode());
                        sheetName = (String.valueOf(sheetName) + "_" + hash).length() > 31 ? sheetName.substring(1, sheetName.length() - hash.length() + 1) : String.valueOf(sheetName) + "_" + hash;
                    }
                    StructureInfo structureInfo = new StructureInfo(struct.getId(), (String)struct.getName().getValue(), (String)struct.getNameAbbrev().getValue(), cat, msgRateText, minSim, maxSim, minBps, maxBps, elementCount, sizeInBytes, sendingNode.getName(), msgNumber, subMsgNumber, taskFileType, desc, message, subMessage.getArtifactReadable(), flatElements, structureChanged, txRateChanged, numElementsChanged, sizeInBytesChanged, false, icdcn, parentStructure, sheetName);
                    if (struct.getId() == 0L) {
                        this.headerStructureInfoMap.put((String)struct.getName().getValue(), structureInfo);
                        continue;
                    }
                    this.structureInfoMap.put(String.valueOf(subMessage.getIdString()) + "." + struct.getIdString(), structureInfo);
                }
            }
        }
    }

    private void createChangeHistory(ExcelWorkbookWriter writer, Branch branch, long connectionId, boolean diff) {
        Object[] headers = new String[]{"Team Workflow", "Date", "Change Description", "Related Workflow"};
        writer.createSheet("Change History");
        writer.setColumnWidth(0, 5000);
        writer.setColumnWidth(1, 3000);
        writer.setColumnWidth(2, 10000);
        writer.setColumnWidth(3, 10000);
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        boolean working = branch.getBranchType().equals((Object)BranchType.WORKING);
        TransactionId baselineTx = branch.getBaselineTx();
        Long queryBranch = working ? branch.getParentBranch().getId() : branch.getId();
        String query = "WITH " + this.orcsApi.getJdbcService().getClient().getDbType().getPostgresRecurse() + " rootArtTime(time) AS ( SELECT min(time) FROM  osee_txs txs, osee_tx_details txd, osee_artifact art " + "WHERE  txs.branch_id IN (?,?) " + " AND txs.tx_current = 1 AND txs.gamma_id = art.gamma_id AND art.art_id = ?" + " AND txd.branch_id = txs.branch_id AND txd.transaction_id = txs.transaction_id), " + " allRels (a_art_id,b_art_id,gamma_id,rel_type) as ( select a_art_id, b_art_id, txs.gamma_id, rel_type from osee_txs txs, osee_relation rel " + "where txs.branch_id in (?,?) " + "and txs.tx_current = 1 and txs.gamma_id = rel.gamma_id " + "union select a_art_id,   b_art_id,   txs.gamma_id,  rel_link_type_id rel_type from osee_txs txs, osee_relation_link rel " + "where txs.branch_id in (?,?) " + "and txs.tx_current = 1 and txs.gamma_id = rel.gamma_id), " + "cte_query(a_art_id,b_art_id,rel_type,gamma_id) as ( " + "   select a_art_id,  b_art_id,   rel_type, gamma_id from allRels where a_art_id = ? " + "union all select e.a_art_id, e.b_art_id, e.rel_type, e.gamma_id from allRels e " + "inner join cte_query c on c.b_art_id = e.a_art_id), " + "gammas (transaction_id,gamma_id,commit_art_id,time) as ( select txd1.transaction_id,changedTxs.gamma_id,txd1.commit_art_id,txd1.time " + "from rootArtTime rat, osee_tx_details txd1, osee_txs attrTxs,osee_attribute attr,osee_txs changedTxs " + "where txd1.branch_id in (?,?) " + "and attrTxs.branch_id = ? " + "and attrTxs.tx_current = 1 and attrTxs.gamma_id = attr.gamma_id and attr.art_id = txd1.commit_art_id and txd1.time > rat.time " + "and attr.attr_type_id = ? " + "and attr.value in (select distinct " + this.orcsApi.getJdbcService().getClient().getDbType().getPostgresCastStart() + " art.art_id " + this.orcsApi.getJdbcService().getClient().getDbType().getPostgresCastVarCharEnd() + "from osee_txs artTxs, osee_artifact art, osee_txs attrTxs, osee_attribute attr " + "where artTxs.branch_id = ? " + "and artTxs.tx_current = 1 and art.art_type_id = ? " + "and artTxs.gamma_id = art.gamma_id and attrTxs.branch_id = ? " + "and attrTxs.tx_current = 1 and attrTxs.gamma_id = attr.gamma_id and attr.art_id = art.art_id " + "and attr.attr_type_id = ? " + "and attr.value = 'MIM') and txd1.transaction_id = changedTxs.transaction_id and changedTxs.branch_id in (?,?)), " + "arts (commit_art_id,transaction_id,art_id,time) as (select commit_art_id,   transaction_id,   art_id,  time " + "from gammas, osee_artifact art where gammas.gamma_id = art.gamma_id " + "union select commit_art_id, transaction_id,   art_id,  time from gammas, osee_attribute attr where gammas.gamma_id = attr.gamma_id " + "union select gammas.commit_art_id,   gammas.transaction_id,  rel.a_art_id,  gammas.time from gammas, cte_query cq, osee_relation rel " + "where cq.gamma_id = gammas.gamma_id and gammas.gamma_id = rel.gamma_id AND " + "rel.rel_type in (6039606571486514300,6039606571486514298,6039606571486514301,6039606571486514302,126164394421696912,2455059983007225780,3899709087455064780,126164394421696914,2455059983007225781,3899709087455064781,2455059983007225794,2455059983007225795,5540416179400488807,8734224778892840579,1859749228181133209,2283114833979032380) " + "union select gammas.commit_art_id,   gammas.transaction_id,  rel.b_art_id,  gammas.time from gammas, cte_query cq, osee_relation rel " + "where cq.gamma_id = gammas.gamma_id and gammas.gamma_id = rel.gamma_id and " + "rel.rel_type in (6039606571486514300,6039606571486514298,6039606571486514301,6039606571486514302,126164394421696912,2455059983007225780,3899709087455064780,126164394421696914,2455059983007225781,3899709087455064781,2455059983007225794,2455059983007225795,5540416179400488807,8734224778892840579,1859749228181133209,2283114833979032380) )" + "select name, commit_art_id, atsid, time, row_number() over (order by time desc) rn, relTw, transaction_id " + "from (select distinct attr.value name, attr2.value atsid, arts.time time, arts.commit_art_id, arts.transaction_id from " + "cte_query, arts, osee_txs attrTxs, osee_attribute attr, osee_txs attrTxs2, osee_attribute attr2 " + "where b_art_id = arts.art_id and attrTxs.branch_id = ? " + "and attrTxs.tx_current = 1 and attrTxs.gamma_id = attr.gamma_id and attr.art_id = arts.commit_art_id and attr.attr_type_id = ? " + "and attrTxs2.branch_id = ? " + "and attrTxs2.tx_current = 1 and attrTxs2.gamma_id = attr2.gamma_id and attr2.art_id = arts.commit_art_id " + "and attr2.attr_type_id = ? " + ") t1 left outer join (select rel_link.a_art_id, attr3.value relTw, rel_link.b_art_id from osee_txs relTxs, osee_relation_link rel_link, osee_txs attrTxs3, " + "osee_attribute attr3 where rel_link.rel_link_type_id = ? " + "and relTxs.branch_id = ? " + "and relTxs.gamma_id = rel_link.gamma_id and rel_link.b_art_id = attr3.art_id and relTxs.tx_current = 1 " + "and attrTxs3.branch_id = ? " + "and attrTxs3.gamma_id = attr3.gamma_id and attrTxs3.tx_current = 1 and attr3.attr_type_id = ? " + ") t2 on t2.a_art_id = t1.commit_art_id";
        Consumer<JdbcStatement> consumer = stmt -> {
            ExcelWorkbookWriter.CELLSTYLE cellStyle = ExcelWorkbookWriter.CELLSTYLE.NONE;
            int row = stmt.getInt("rn");
            String atsId = stmt.getString("atsId");
            Timestamp timestamp = stmt.getTimestamp("time");
            String name = stmt.getString("name");
            String relTw = stmt.getString("relTw");
            Long txId = stmt.getLong("transaction_id");
            ArtifactId commitArtId = ArtifactId.valueOf((Long)stmt.getLong("commit_art_id"));
            this.releaseArtifacts.put(commitArtId, (Pair<String, String>)new Pair((Object)atsId, (Object)relTw));
            if (diff && txId > baselineTx.getId()) {
                cellStyle = ExcelWorkbookWriter.CELLSTYLE.YELLOW;
            }
            writer.writeCell(row, 0, (Object)atsId, new ExcelWorkbookWriter.CELLSTYLE[]{cellStyle});
            writer.writeCell(row, 1, (Object)timestamp, new ExcelWorkbookWriter.CELLSTYLE[]{cellStyle});
            writer.writeCell(row, 2, (Object)name, new ExcelWorkbookWriter.CELLSTYLE[]{cellStyle});
            writer.writeCell(row, 3, (Object)relTw, new ExcelWorkbookWriter.CELLSTYLE[]{cellStyle});
        };
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, query, new Object[]{branch, queryBranch, connectionId, branch, queryBranch, branch, queryBranch, connectionId, branch, queryBranch, CoreBranches.COMMON.getId(), AtsAttributeTypes.TeamDefinitionReference, CoreBranches.COMMON.getId(), AtsArtifactTypes.TeamDefinition, CoreBranches.COMMON.getId(), AtsAttributeTypes.WorkType, branch, queryBranch, CoreBranches.COMMON.getId(), CoreAttributeTypes.Name, CoreBranches.COMMON.getId(), AtsAttributeTypes.AtsId, CoreRelationTypes.Dependency_Dependency, CoreBranches.COMMON, CoreBranches.COMMON, AtsAttributeTypes.AtsId});
    }

    private void createChangeSummary(ExcelWorkbookWriter writer, MimChangeSummary summary) {
        writer.createSheet("Change Summary");
        Object[] headers = new String[]{"Item Type", "", "", "Item Name", "Change Type", "Modification Type", "What Changed", "Is Value", "Was Value", "ICDCN"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        int rowIndex = 1;
        for (MimChangeSummaryItem message : summary.getMessages().values()) {
            rowIndex = this.writeArtifactChanges(writer, message, rowIndex, 0);
            ++rowIndex;
        }
        for (MimChangeSummaryItem submessage : summary.getSubMessages().values()) {
            rowIndex = this.writeArtifactChanges(writer, submessage, rowIndex, 0);
            ++rowIndex;
        }
        for (MimChangeSummaryItem structure : summary.getStructures().values()) {
            rowIndex = this.writeArtifactChanges(writer, structure, rowIndex, 0);
            ++rowIndex;
        }
        writer.autoSizeAllColumns(headers.length);
        writer.setColumnWidth(0, writer.getColumnWidth(0) + 500);
        writer.setColumnWidth(1, writer.getColumnWidth(1) + 500);
        writer.setColumnWidth(2, writer.getColumnWidth(2) + 500);
        writer.setColumnWidth(6, 20000);
        writer.setColumnWidth(7, 20000);
        writer.addMergedRegion(0, 0, 0, 2);
        writer.writeCell(0, 0, (Object)"Item Type", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
    }

    private int writeArtifactChanges(ExcelWorkbookWriter writer, MimChangeSummaryItem item, int rowIndex, int subArtifactOffset) {
        int startRow = rowIndex;
        writer.writeCell(rowIndex, subArtifactOffset, (Object)this.formatArtifactType(item.getArtType()), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        writer.writeCell(rowIndex, 3, (Object)item.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        if (item.isAdded()) {
            writer.writeCell(rowIndex, 4, (Object)"Added", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.GREEN});
            writer.writeCell(rowIndex, 9, (Object)this.getRelatedWorkFlow(item.getAllTxIds()));
            return ++rowIndex;
        }
        if (item.isDeleted()) {
            writer.writeCell(rowIndex, 4, (Object)"Deleted", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED});
            writer.writeCell(rowIndex, 9, (Object)this.getRelatedWorkFlow(item.getAllTxIds()));
            return ++rowIndex;
        }
        if (!item.getAttributeChanges().isEmpty()) {
            int firstRow = rowIndex;
            writer.writeCell(rowIndex, 4, (Object)"Modified", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.YELLOW, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
            writer.writeCell(rowIndex, 5, (Object)"Attributes", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERV});
            if (item.getArtType().equals(CoreArtifactTypes.InterfaceDataElement) || item.getArtType().equals(CoreArtifactTypes.InterfaceDataElementArray)) {
                item.removeAttributeChanges(Arrays.asList(CoreAttributeTypes.InterfaceElementArrayHeader.getId(), CoreAttributeTypes.InterfaceElementWriteArrayHeaderName.getId(), CoreAttributeTypes.InterfaceElementArrayIndexOrder.getId(), CoreAttributeTypes.InterfaceElementBlockData.getId(), CoreAttributeTypes.InterfaceElementArrayIndexDelimiterOne.getId(), CoreAttributeTypes.InterfaceElementArrayIndexDelimiterTwo.getId(), CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription.getId()));
            }
            for (ChangeReportRowDto change : item.getAttributeChanges()) {
                writer.writeCell(rowIndex, 6, (Object)change.getItemType());
                writer.writeCell(rowIndex, 7, (Object)change.getIsValue(), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex, 8, (Object)change.getWasValue(), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex, 9, (Object)this.getRelatedWorkFlow(Collections.singleton(change.getTxId())));
                ++rowIndex;
            }
            if (firstRow < rowIndex - 1) {
                writer.addMergedRegion(firstRow, rowIndex - 1, 4, 4);
                writer.addMergedRegion(firstRow, rowIndex - 1, 5, 5);
            }
        }
        if (startRow < rowIndex - 1) {
            writer.addMergedRegion(startRow, rowIndex - 1, 0, 0);
            writer.addMergedRegion(startRow, rowIndex - 1, 1, 1);
            writer.addMergedRegion(startRow, rowIndex - 1, 2, 2);
            writer.addMergedRegion(startRow, rowIndex - 1, 3, 3);
        }
        if (!item.getChildren().isEmpty()) {
            if (item.getAttributeChanges().isEmpty()) {
                ++rowIndex;
            }
            for (MimChangeSummaryItem child : item.getChildren()) {
                rowIndex = this.writeArtifactChanges(writer, child, rowIndex, subArtifactOffset + 1);
            }
        }
        return rowIndex;
    }

    private String formatArtifactType(ArtifactTypeToken artType) {
        return artType.getName().replace("Interface ", "").replace("DataElement", "Element");
    }

    private void writeValidationErrorsSheet(ExcelWorkbookWriter writer, ConnectionValidationResult validation) {
        writer.createSheet("Validation Errors");
        int rowIndex = 0;
        int colIndex = 0;
        if (!validation.getStructureByteAlignmentErrors().isEmpty()) {
            writer.writeCell(rowIndex, colIndex, (Object)"Structures Not Byte Aligned", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
            ++rowIndex;
            for (String structure : validation.getStructureByteAlignmentErrors().values()) {
                writer.writeCell(rowIndex, colIndex, (Object)structure);
                ++rowIndex;
            }
            rowIndex = 0;
            ++colIndex;
        }
        if (!validation.getStructureWordAlignmentErrors().isEmpty()) {
            writer.writeCell(rowIndex, colIndex, (Object)"Structures Not Word Aligned", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
            ++rowIndex;
            for (String structure : validation.getStructureWordAlignmentErrors().values()) {
                writer.writeCell(rowIndex, colIndex, (Object)structure);
                ++rowIndex;
            }
            rowIndex = 0;
            ++colIndex;
        }
        if (!validation.getMessageTypeErrors().isEmpty()) {
            writer.writeCell(rowIndex, colIndex, (Object)"Messages Missing Message Type", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
            ++rowIndex;
            for (String structure : validation.getMessageTypeErrors().values()) {
                writer.writeCell(rowIndex, colIndex, (Object)structure);
                ++rowIndex;
            }
            ++colIndex;
        }
        writer.autoSizeAllColumns(colIndex);
        writer.setTabColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED);
    }

    private void createStructureNamesSheet(ExcelWorkbookWriter writer) {
        writer.createSheet("Structure Names");
    }

    private void writeStructureNamesSheet(ExcelWorkbookWriter writer, List<InterfaceStructureToken> structureTokens, ConnectionValidationResult validation) {
        writer.setActiveSheet("Structure Names");
        Object[] headers = new String[]{"Structure Name", "Structure Name", "Structure Name"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        LinkedList<StructureInfo> structures = new LinkedList<StructureInfo>();
        for (StructureInfo struct : this.headerStructureInfoMap.values()) {
            structures.add(struct);
        }
        for (StructureInfo struct : this.structureInfoMap.values()) {
            structures.add(struct);
        }
        structures.sort(new Comparator<StructureInfo>(){

            @Override
            public int compare(StructureInfo o1, StructureInfo o2) {
                if (o1.name.equals(o2.name)) {
                    return o1.sheetName.toLowerCase().compareTo(o2.sheetName.toLowerCase());
                }
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        ExcelWorkbookWriter.CELLSTYLE tabColor = ExcelWorkbookWriter.CELLSTYLE.NONE;
        int colLength = (int)Math.ceil((double)structures.size() / 3.0);
        int i = 0;
        while (i < structures.size()) {
            ExcelWorkbookWriter.CELLSTYLE color;
            int rowNum = i + 1;
            int colNum = 0;
            StructureInfo struct = (StructureInfo)structures.get(i);
            if (i >= colLength * 2) {
                colNum = 2;
                rowNum -= colLength * 2;
            } else if (i >= colLength) {
                colNum = 1;
                rowNum -= colLength;
            }
            InterfaceStructureToken structure = structureTokens.stream().filter(a -> a.getId() == structureInfo.id).findFirst().get();
            InterfaceSubMessageToken subMessage = InterfaceSubMessageToken.SENTINEL;
            if (structure.getArtifactReadable().isValid()) {
                subMessage = new InterfaceSubMessageToken((ArtifactReadable)structure.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_SubMessage).getList().get(0));
            }
            ExcelWorkbookWriter.CELLSTYLE cELLSTYLE = color = structure.isAutogenerated() ? this.getHeaderStructureNameColor(subMessage, structure) : this.getStructureNameColor(subMessage, structure);
            if (this.isStructureValidationError(validation, structure.getArtifactId())) {
                color = ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED;
                tabColor = ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED;
            }
            writer.writeCell(rowNum, colNum, (Object)struct.name, "'" + struct.sheetName + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.HYPERLINK, color});
            ++rowNum;
            ++i;
        }
        writer.autoSizeAllColumns(headers.length);
        if (!ExcelWorkbookWriter.CELLSTYLE.NONE.equals((Object)tabColor)) {
            writer.setTabColor(tabColor);
        }
    }

    private ExcelWorkbookWriter.CELLSTYLE getHeaderStructureNameColor(InterfaceSubMessageToken subMessage, InterfaceStructureToken struct) {
        ExcelWorkbookWriter.CELLSTYLE style = this.headerNameStyles.getOrDefault(struct.getName().getValue(), ExcelWorkbookWriter.CELLSTYLE.NONE);
        if (!style.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE)) {
            return style;
        }
        return this.getStructureNameColor(subMessage, struct);
    }

    private ExcelWorkbookWriter.CELLSTYLE getStructureNameColor(InterfaceSubMessageToken subMessage, InterfaceStructureToken struct) {
        MimChangeSummaryItem diffItem;
        StructureInfo info = this.getStructureInfo(subMessage, struct);
        boolean msgRatePeriodicityChange = false;
        if (this.diffs.containsKey(info.message)) {
            boolean bl = msgRatePeriodicityChange = this.diffs.get(info.message).getAttributeChanges(CoreAttributeTypes.InterfaceMessageRate.getId()).size() > 0 || this.diffs.get(info.message).getAttributeChanges(CoreAttributeTypes.InterfaceMessagePeriodicity.getId()).size() > 0;
        }
        if ((diffItem = this.diffs.get(struct.getArtifactId())) != null && diffItem.isAdded()) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        if (info.structureChanged || msgRatePeriodicityChange) {
            return ExcelWorkbookWriter.CELLSTYLE.YELLOW;
        }
        return ExcelWorkbookWriter.CELLSTYLE.NONE;
    }

    private void createStructureSummarySheet(ExcelWorkbookWriter writer) {
        writer.createSheet("Structure Summary");
    }

    private void writeStructureSummarySheet(ExcelWorkbookWriter writer, List<ArtifactReadable> messages, ConnectionValidationResult validation) {
        writer.setActiveSheet("Structure Summary");
        int totalMinSim = 0;
        int totalMaxSim = 0;
        int totalNumAttrs = 0;
        int totalMinBps = 0;
        int totalMaxBps = 0;
        int maxAttrs = 0;
        int totalStructs = 0;
        int rowIndex = 1;
        Object[] headers = new String[]{"Category", "Structure Name", "Tx Rate", "Sim Min", "Sim Max", "# of Attributes", "Size in Bytes", "BPS Min", "BPS Max", "Initiator", "Msg #", "SubMsg #", "Taskfile Type", "Description"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        ExcelWorkbookWriter.CELLSTYLE tabColor = ExcelWorkbookWriter.CELLSTYLE.NONE;
        for (ArtifactReadable message : messages) {
            List subMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "Error").equals("Operational")) {
                subMessages.add(0, this.messageHeaders.get(ArtifactId.valueOf((Long)message.getId())));
            }
            for (InterfaceSubMessageToken subMessage : subMessages) {
                LinkedList<InterfaceStructureToken> structures = new LinkedList<InterfaceStructureToken>();
                if (subMessage.getId() == 0L) {
                    structures.add(this.messageHeaderStructures.get(subMessage.getName().getValue()));
                } else {
                    structures.addAll(subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                }
                for (InterfaceStructureToken struct : structures) {
                    StructureInfo structureInfo = this.getStructureInfo(subMessage, struct);
                    String sheetName = structureInfo.sheetName;
                    ArtifactReadable structReadable = struct.getArtifactReadable();
                    totalMinSim += this.stringToInt(structureInfo.minSim);
                    totalMaxSim += this.stringToInt(structureInfo.maxSim);
                    totalNumAttrs += structureInfo.numAttributes.intValue();
                    totalMinBps += this.stringToInt(structureInfo.minBps);
                    totalMaxBps += this.stringToInt(structureInfo.maxBps);
                    maxAttrs = Math.max(maxAttrs, structureInfo.numAttributes);
                    ++totalStructs;
                    if (this.isStructureValidationError(validation, struct.getArtifactId())) {
                        tabColor = ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED;
                    }
                    if (struct.isAutogenerated()) {
                        InterfaceStructureToken parentHeader = this.parentMessageHeaderStructures.get(struct.getName().getValue());
                        boolean sizeChanged = parentHeader == null ? false : !struct.getSizeInBytes().equals(parentHeader.getSizeInBytes());
                        writer.writeCell(rowIndex, 0, (Object)structureInfo.category, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded)});
                        writer.writeCell(rowIndex, 1, struct.getName().getValue(), "'" + sheetName + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded), ExcelWorkbookWriter.CELLSTYLE.HYPERLINK});
                        writer.writeCell(rowIndex, 2, (Object)structureInfo.txRate, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageRate.getId()).equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE) ? this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessagePeriodicity.getId()) : this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageRate.getId())});
                        writer.writeCell(rowIndex, 3, (Object)structureInfo.minSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded)});
                        writer.writeCell(rowIndex, 4, (Object)structureInfo.maxSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded)});
                        Number diffValue = parentHeader == null ? null : parentHeader.getNumElements();
                        ExcelWorkbookWriter.CELLSTYLE color = this.getHeaderStructureCellColor(struct.getNumElements(), diffValue, structureInfo.isAdded);
                        writer.writeCell(rowIndex, 5, (Object)structureInfo.numAttributes, new ExcelWorkbookWriter.CELLSTYLE[]{color});
                        diffValue = parentHeader == null ? null : parentHeader.getSizeInBytes();
                        color = this.getHeaderStructureCellColor(struct.getSizeInBytes(), diffValue, structureInfo.isAdded);
                        writer.writeCell(rowIndex, 6, (Object)structureInfo.sizeInBytes, new ExcelWorkbookWriter.CELLSTYLE[]{color});
                        color = structureInfo.isAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (structureInfo.txRateChanged || sizeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
                        writer.writeCell(rowIndex, 7, (Object)structureInfo.minBps, new ExcelWorkbookWriter.CELLSTYLE[]{color});
                        writer.writeCell(rowIndex, 8, (Object)structureInfo.maxBps, new ExcelWorkbookWriter.CELLSTYLE[]{color});
                        writer.writeCell(rowIndex, 9, (Object)structureInfo.initiator, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded)});
                        writer.writeCell(rowIndex, 10, (Object)structureInfo.msgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageNumber.getId())});
                        color = this.getCellColor(structReadable, subMessage.getArtifactReadable(), CoreAttributeTypes.InterfaceSubMessageNumber.getId());
                        color = color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE) ? this.getHeaderStructureCellColor(structureInfo.isAdded) : color;
                        writer.writeCell(rowIndex, 11, (Object)structureInfo.subMsgNum, new ExcelWorkbookWriter.CELLSTYLE[]{color});
                        writer.writeCell(rowIndex, 12, (Object)structureInfo.taskfile, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded)});
                        writer.writeCell(rowIndex, 13, (Object)structureInfo.description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(structureInfo.isAdded), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    } else {
                        writer.writeCell(rowIndex, 0, (Object)structureInfo.category, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceStructureCategory.getId())});
                        writer.writeCell(rowIndex, 1, struct.getName().getValue(), "'" + sheetName + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Name.getId(), validation), ExcelWorkbookWriter.CELLSTYLE.HYPERLINK});
                        writer.writeCell(rowIndex, 2, (Object)structureInfo.txRate, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageRate.getId()).equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE) ? this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessagePeriodicity.getId()) : this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageRate.getId())});
                        writer.writeCell(rowIndex, 3, (Object)structureInfo.minSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMinSimultaneity.getId())});
                        writer.writeCell(rowIndex, 4, (Object)structureInfo.maxSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMaxSimultaneity.getId())});
                        writer.writeCell(rowIndex, 5, (Object)structureInfo.numAttributes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.numElementsChanged)});
                        writer.writeCell(rowIndex, 6, (Object)structureInfo.sizeInBytes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.structureSizeChanged, validation)});
                        writer.writeCell(rowIndex, 7, (Object)structureInfo.minBps, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.txRateChanged || structureInfo.structureSizeChanged)});
                        writer.writeCell(rowIndex, 8, (Object)structureInfo.maxBps, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.txRateChanged || structureInfo.structureSizeChanged)});
                        writer.writeCell(rowIndex, 9, (Object)structureInfo.initiator, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
                        writer.writeCell(rowIndex, 10, (Object)structureInfo.msgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageNumber.getId())});
                        writer.writeCell(rowIndex, 11, (Object)structureInfo.subMsgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, subMessage.getArtifactReadable(), CoreAttributeTypes.InterfaceSubMessageNumber.getId())});
                        writer.writeCell(rowIndex, 12, (Object)structureInfo.taskfile, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceTaskFileType.getId())});
                        writer.writeCell(rowIndex, 13, (Object)structureInfo.description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    }
                    ++rowIndex;
                }
            }
        }
        Object[] totalsHeaders = new String[]{" ", " ", " ", "Sim Min", "Sim Max", "# of Attributes", " ", "Min", "Max"};
        writer.writeRow(++rowIndex, totalsHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(++rowIndex, 2, (Object)"Totals:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 3, (Object)totalMinSim);
        writer.writeCell(rowIndex, 4, (Object)totalMaxSim);
        writer.writeCell(rowIndex, 5, (Object)totalNumAttrs);
        writer.writeCell(rowIndex, 6, (Object)"B/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)totalMinBps);
        writer.writeCell(rowIndex, 8, (Object)totalMaxBps);
        writer.writeCell(++rowIndex, 3, (Object)"Unique Structures:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 4, (Object)totalStructs);
        writer.writeCell(rowIndex, 6, (Object)"MB/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)((double)totalMinBps / 1048576.0));
        writer.writeCell(rowIndex, 8, (Object)((double)totalMaxBps / 1048576.0));
        writer.writeCell(++rowIndex, 3, (Object)"Max # Attributes:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 4, (Object)maxAttrs);
        writer.writeCell(rowIndex, 6, (Object)"Mb/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)((double)totalMinBps * 8.0 / 1048576.0));
        writer.writeCell(rowIndex, 8, (Object)((double)totalMaxBps * 8.0 / 1048576.0));
        writer.autoSizeAllColumns(headers.length);
        writer.setColumnWidth(13, 15000);
        if (!ExcelWorkbookWriter.CELLSTYLE.NONE.equals((Object)tabColor)) {
            writer.setTabColor(tabColor);
        }
    }

    private StructureInfo getStructureInfo(InterfaceSubMessageToken subMessage, InterfaceStructureToken struct) {
        return struct.getId() == 0L ? this.headerStructureInfoMap.get(struct.getName().getValue()) : this.structureInfoMap.get(String.valueOf(subMessage.getIdString()) + "." + struct.getIdString());
    }

    private int stringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private int[] printFirstRowInStructureSheet(ExcelWorkbookWriter writer, InterfaceStructureToken structure, StructureInfo info, ConnectionValidationResult validation) {
        ArtifactReadable structReadable = structure.getArtifactReadable();
        String date = structure.getId() == 0L ? "" : ((TransactionReadable)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andTxId(structure.getArtifactReadable().getTransaction())).getResults().getAtMostOneOrDefault((Object)TransactionReadable.SENTINEL)).getDate();
        Object[] values = new Object[]{"Functional", info.name, info.nameAbbrev, date, info.category, info.txRate, info.minSim, info.maxSim, info.numAttributes, info.sizeInBytes, info.initiator, info.msgNum, info.subMsgNum, info.taskfile, info.description, info.icdcn};
        writer.writeCell(1, 0, values[0], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 1, values[1], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Name.getId())});
        writer.writeCell(1, 2, values[2], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.NameAbbrev.getId())});
        writer.writeCell(1, 3, values[3], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 4, values[4], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceStructureCategory.getId())});
        writer.writeCell(1, 5, values[5], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageRate.getId()).equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE) ? this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessagePeriodicity.getId()) : this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageRate.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 6, values[6], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMinSimultaneity.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 7, values[7], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMaxSimultaneity.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 8, values[8], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.numElementsChanged), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 9, values[9], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.structureSizeChanged, validation), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 10, values[10], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 11, values[11], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageNumber.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 12, values[12], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.submessage, CoreAttributeTypes.InterfaceSubMessageNumber.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 13, values[13], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceTaskFileType.getId()), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 14, values[14], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
        writer.writeCell(1, 15, values[15], new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false).equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (info.icdcn.length() > 0 ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE)});
        return this.createStringLengthArray(values);
    }

    private int[] printFirstRowInHeaderStructureSheet(ExcelWorkbookWriter writer, InterfaceStructureToken structure, InterfaceStructureToken diffStructure, StructureInfo info, boolean isAdded) {
        ExcelWorkbookWriter.CELLSTYLE currentStyle;
        ArtifactReadable structReadable = structure.getArtifactReadable();
        String icdcn = info.icdcn;
        if (this.msgHeaderICDCNs.containsKey(info.message.getArtifactId())) {
            boolean first = true;
            if (!icdcn.isEmpty()) {
                first = false;
            }
            for (Pair<ArtifactId, String> pair : this.msgHeaderICDCNs.get(info.message.getArtifactId())) {
                if (first) {
                    icdcn = (String)pair.getSecond();
                    first = false;
                    continue;
                }
                if (icdcn.contains((CharSequence)pair.getSecond())) continue;
                icdcn = String.valueOf(icdcn) + "," + (String)pair.getSecond();
            }
        }
        String date = structure.getId() == 0L ? "" : ((TransactionReadable)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andTxId(structure.getArtifactReadable().getTransaction())).getResults().getAtMostOneOrDefault((Object)TransactionReadable.SENTINEL)).getDate();
        Object[] values = new Object[]{"Functional", info.name, info.nameAbbrev, date, info.category, info.txRate, info.minSim, info.maxSim, info.numAttributes, info.sizeInBytes, info.initiator, info.msgNum, info.subMsgNum, info.taskfile, info.description, icdcn};
        boolean changed = false;
        writer.writeCell(1, 0, values[0], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(1, 1, values[1], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(1, 2, values[2], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(1, 3, values[3], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(1, 4, values[4], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        ExcelWorkbookWriter.CELLSTYLE color = this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageRate.getId()).equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE) ? this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessagePeriodicity.getId()) : this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageRate.getId());
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 5, values[5], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 6, values[6], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 7, values[7], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        Object diffValue = diffStructure == null ? null : Integer.valueOf(diffStructure.getElements().size());
        color = this.getHeaderStructureCellColor(structure.getNumElements(), diffValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 8, values[8], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        diffValue = diffStructure == null ? null : diffStructure.getSizeInBytes();
        color = this.getHeaderStructureCellColor(structure.getSizeInBytes(), diffValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 9, values[9], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 10, values[10], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        color = this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageNumber.getId());
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 11, values[11], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        writer.writeCell(1, 12, values[12], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        diffValue = diffStructure == null ? null : diffStructure.getInterfaceTaskFileType();
        color = this.getHeaderStructureCellColor(structure.getInterfaceTaskFileType(), diffValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 13, values[13], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
        diffValue = diffStructure == null ? null : diffStructure.getDescription();
        color = this.getHeaderStructureCellColor(structure.getDescription(), diffValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 14, values[14], new ExcelWorkbookWriter.CELLSTYLE[]{color, ExcelWorkbookWriter.CELLSTYLE.WRAP});
        color = this.getHeaderStructureCellColor(isAdded).equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (info.icdcn.length() > 0 ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(1, 15, values[15], new ExcelWorkbookWriter.CELLSTYLE[]{color});
        if (changed && (currentStyle = this.headerNameStyles.get(structure.getName().getValue())) != null && !currentStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN)) {
            this.headerNameStyles.put((String)structure.getName().getValue(), ExcelWorkbookWriter.CELLSTYLE.YELLOW);
        }
        return this.createStringLengthArray(values);
    }

    private int[] createStringLengthArray(Object[] objs) {
        int[] lengths = new int[objs.length];
        int i = 0;
        while (i < objs.length) {
            lengths[i] = objs[i] == null ? 0 : objs[i].toString().length();
            ++i;
        }
        return lengths;
    }

    private int[] getMaxLengthsArray(int[] arr1, int[] arr2) {
        int[] larger = arr1.length > arr2.length ? arr1 : arr2;
        int[] res = new int[larger.length];
        int i = 0;
        while (i < larger.length) {
            res[i] = larger[i];
            ++i;
        }
        i = 0;
        while (i < Math.min(arr1.length, arr2.length)) {
            res[i] = Math.max(arr1[i], arr2[i]);
            ++i;
        }
        return res;
    }

    private void writeStructureSheets(ExcelWorkbookWriter writer, List<InterfaceSubMessageToken> subMessages, List<ArtifactReadable> messages, ConnectionValidationResult validation) {
        Object[] structureHeaders = new String[]{"Sheet Type", "Full Sheet Name", "Abbrev. Sheet Name", "Most Recent Update", "Category", "Transmission Rate", "Min Simultaneity", "Max Simultaneity", "# of attributes", "Size in Bytes", "Initiator", "Msg #", "SubMsg #", "Taskfile", "Description", "ICDCN"};
        Object[] elementHeaders = new String[]{"Begin Word", "Begin Byte", "Number of Bytes", "Ending Word", "Ending Byte", "ICDCN", "Type", "Attribute Name", "Units", "Valid Range", "Alterable After Creation", "Description", "Enumerated Literals", "Notes", "Default Value"};
        for (InterfaceSubMessageToken subMessage : subMessages) {
            LinkedList<InterfaceStructureToken> structs = new LinkedList<InterfaceStructureToken>();
            if (subMessage.getId() == 0L) {
                structs.add(this.messageHeaderStructures.get(subMessage.getName().getValue()));
            } else {
                structs.addAll(subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
            }
            for (InterfaceStructureToken struct : structs) {
                StructureInfo info;
                int[] columnWidths = this.createStringLengthArray(elementHeaders);
                int[] resultWidths = new int[16];
                AtomicInteger rowIndex = new AtomicInteger(4);
                int byteLocation = 0;
                StructureInfo structureInfo = struct.getId() == 0L ? this.headerStructureInfoMap.get(struct.getName().getValue()) : this.structureInfoMap.get(String.valueOf(subMessage.getIdString()) + "." + struct.getIdString());
                writer.createSheet(structureInfo.sheetName);
                writer.writeRow(0, structureHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.WRAP, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                columnWidths = this.getMaxLengthsArray(columnWidths, this.createStringLengthArray(structureHeaders));
                if (struct.getId() == 0L) {
                    boolean isAdded;
                    info = this.headerStructureInfoMap.get(struct.getName().getValue());
                    InterfaceStructureToken parentHeader = this.parentMessageHeaderStructures.get(struct.getName().getValue());
                    boolean bl = isAdded = parentHeader != null && parentHeader.getId() == -1L;
                    if (isAdded) {
                        this.headerNameStyles.put((String)struct.getName().getValue(), ExcelWorkbookWriter.CELLSTYLE.GREEN);
                        info.isAdded = true;
                    }
                    resultWidths = this.printFirstRowInHeaderStructureSheet(writer, struct, parentHeader, info, isAdded);
                    columnWidths = this.getMaxLengthsArray(columnWidths, resultWidths);
                    writer.writeRow(3, elementHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.WRAP, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                    int i = 0;
                    while (i < struct.getElements().size()) {
                        InterfaceStructureElementToken diffElement;
                        String icdcns = "";
                        if (isAdded && this.msgHeaderICDCNs.containsKey(info.message.getArtifactId())) {
                            icdcns = (String)this.msgHeaderICDCNs.get(info.message.getArtifactId()).get(0).getSecond();
                        }
                        InterfaceStructureElementToken element = struct.getElements().get(i);
                        if (!isAdded && this.msgHeaderICDCNs.containsKey(info.message.getArtifactId()) && ((String)element.getName().getValue()).contains("Number of Structures in Submessage")) {
                            String subMsgNum = ((String)element.getName().getValue()).substring(((String)element.getName().getValue()).lastIndexOf(" ") + 1);
                            List subMsgsChanged = this.msgHeaderICDCNs.get(info.message.getArtifactId()).stream().map(a -> (ArtifactId)a.getFirst()).collect(Collectors.toList());
                            Optional<ArtifactReadable> subMsg = info.message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().filter(a -> a.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceSubMessageNumber).equals(subMsgNum)).findFirst();
                            if (subMsg.isPresent() && subMsgsChanged.contains(subMsg.get().getArtifactId())) {
                                icdcns = (String)this.msgHeaderICDCNs.get(info.message.getArtifactId()).stream().filter(a -> ((ArtifactId)a.getFirst()).equals(((ArtifactReadable)subMsg.get()).getArtifactId())).findFirst().get().getSecond();
                            }
                        }
                        Integer byteSize = (int)element.getElementSizeInBytes();
                        InterfaceStructureElementToken interfaceStructureElementToken = diffElement = parentHeader != null && parentHeader.getId() != -1L && parentHeader.getElements().size() > i ? parentHeader.getElements().get(i) : null;
                        if (parentHeader != null && (diffElement == null || i == parentHeader.getElements().size() - 1 && ((String)diffElement.getName().getValue()).equals("Byte Alignment Spare") && !((String)element.getName().getValue()).equals("Byte Alignment Spare"))) {
                            isAdded = true;
                        }
                        resultWidths = this.printHeaderStructureElementRow(writer, rowIndex, struct, element, diffElement, byteLocation, byteSize, isAdded, icdcns);
                        columnWidths = this.getMaxLengthsArray(columnWidths, resultWidths);
                        byteLocation += byteSize.intValue();
                        rowIndex.getAndAdd(1);
                        ++i;
                    }
                } else {
                    info = this.structureInfoMap.get(String.valueOf(subMessage.getIdString()) + "." + struct.getIdString());
                    resultWidths = this.printFirstRowInStructureSheet(writer, struct, info, validation);
                    columnWidths = this.getMaxLengthsArray(columnWidths, resultWidths);
                    if (this.isStructureValidationError(validation, struct.getArtifactId())) {
                        writer.setTabColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED);
                    }
                    writer.writeRow(3, elementHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.WRAP, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                    int parentIndex = 0;
                    int i = 0;
                    while (i < info.elements.size()) {
                        int endIndex;
                        InterfaceStructureElementToken element = info.elements.get(i);
                        Integer byteSize = (int)element.getInterfacePlatformTypeByteSize();
                        MimChangeSummaryItem structDiff = this.diffs.get(struct.getArtifactId());
                        Optional elementDiff = structDiff == null ? Optional.empty() : structDiff.getChild(element.getArtifactId());
                        boolean elementAdded = elementDiff.isPresent() && ((MimChangeSummaryItem)elementDiff.get()).isAdded();
                        InterfaceStructureElementToken parentElement = InterfaceStructureElementToken.SENTINEL;
                        if (!elementAdded && info.parentStructure.isValid()) {
                            while (parentIndex < info.parentStructure.getElements().size()) {
                                Optional parentElementDiff;
                                parentElement = info.parentStructure.getElements().get(parentIndex);
                                ++parentIndex;
                                Optional<Object> optional = parentElementDiff = structDiff == null ? Optional.empty() : structDiff.getChild(parentElement.getArtifactId());
                                if (!parentElementDiff.isPresent() || !((MimChangeSummaryItem)parentElementDiff.get()).isDeleted()) break;
                            }
                        }
                        resultWidths = this.printDataElementRow(writer, rowIndex, struct.getArtifactReadable(), element, byteLocation, byteSize, parentElement);
                        columnWidths = this.getMaxLengthsArray(columnWidths, resultWidths);
                        int startIndex = (Integer)element.getInterfaceElementIndexStart().getValue();
                        if (startIndex < (endIndex = ((Integer)element.getInterfaceElementIndexEnd().getValue()).intValue())) {
                            byteSize = byteSize * (endIndex - startIndex + 1);
                        }
                        byteLocation += byteSize.intValue();
                        ++i;
                    }
                }
                ExcelWorkbookWriter.CELLSTYLE color = struct.isAutogenerated() ? this.getHeaderStructureNameColor(subMessage, struct) : this.getStructureNameColor(subMessage, struct);
                writer.setTabColor(color);
                int i = 0;
                while (i < columnWidths.length) {
                    writer.setColumnWidthInCharacters(i, columnWidths[i], 15000);
                    ++i;
                }
                writer.setColumnWidthInCharacters(0, 10, 3000);
                writer.setColumnWidthInCharacters(1, 10, 3000);
                writer.setColumnWidthInCharacters(2, 10, 3000);
                writer.setColumnWidthInCharacters(3, 10, 3000);
                writer.setColumnWidthInCharacters(4, 10, 3000);
                writer.setColumnWidth(9, Math.min(writer.getColumnWidth(9), 5000));
                writer.setColumnWidthInCharacters(10, 10, 4000);
                writer.setColumnWidth(11, Math.max(writer.getColumnWidth(10), 15000));
                writer.setColumnWidth(13, Math.max(writer.getColumnWidth(12), 10000));
                writer.setColumnWidth(14, Math.max(writer.getColumnWidth(14), 15000));
            }
        }
    }

    private String getRelatedWorkFlow(Set<TransactionId> txIds) {
        List txRs;
        String rtn = "";
        if (!(this.releaseArtifacts.isEmpty() || txIds.isEmpty() || (txRs = ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andTxIds(txIds)).getResults().getList()).isEmpty())) {
            List commitArts = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((Collection)txRs.stream().map(a -> a.getCommitArt()).collect(Collectors.toList())).asArtifacts();
            for (ArtifactId artifactId : this.releaseArtifacts.keySet().stream().filter(a -> commitArts.contains(a)).collect(Collectors.toList())) {
                String tw = this.releaseArtifacts.get(artifactId).getSecond() != null ? (String)this.releaseArtifacts.get(artifactId).getSecond() : (String)this.releaseArtifacts.get(artifactId).getFirst();
                rtn = String.valueOf(rtn) + "," + tw;
            }
        }
        return rtn.replaceAll("^,+", "");
    }

    private int[] printHeaderStructureElementRow(ExcelWorkbookWriter writer, AtomicInteger rowIndex, InterfaceStructureToken structure, InterfaceStructureElementToken element, InterfaceStructureElementToken diffElement, Integer byteLocation, Integer byteSize, boolean isAdded, String icdcn) {
        ExcelWorkbookWriter.CELLSTYLE currentStyle;
        PlatformTypeToken platformType = element.getPlatformType();
        Integer beginWord = Math.floorDiv(byteLocation, 4);
        Integer beginByte = Math.floorMod(byteLocation, 4);
        Integer endWord = Math.floorDiv(byteLocation + byteSize - 1, 4);
        Integer endByte = Math.floorMod(byteLocation + byteSize - 1, 4);
        String elementName = (String)element.getName().getValue();
        String dataType = this.logicalTypeToDataType((String)element.getPlatformType().getInterfaceLogicalType().getValue());
        String units = platformType == null || platformType.getInterfacePlatformTypeUnits().getValue() == "" ? "n/a" : (String)platformType.getInterfacePlatformTypeUnits().getValue();
        String validRange = this.getValidRangeString(element, platformType, dataType);
        String alterable = (Boolean)element.getInterfaceElementAlterable().getValue() != false ? "Yes" : "No";
        String description = element.getDescription().getValue() == "" ? "n/a" : (String)element.getDescription().getValue();
        String notes = (String)element.getNotes().getValue();
        Object[] values = new Object[]{beginWord, beginByte, byteSize, endWord, endByte, icdcn, dataType, elementName, units, validRange, alterable, description, "n/a", notes, ""};
        boolean changed = false;
        writer.writeCell(rowIndex.get(), 0, values[0], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, this.getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX, isAdded)});
        writer.writeCell(rowIndex.get(), 1, values[1], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, this.getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX, isAdded)});
        writer.writeCell(rowIndex.get(), 2, values[2], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, this.getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX, isAdded)});
        writer.writeCell(rowIndex.get(), 3, values[3], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, this.getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX, isAdded)});
        writer.writeCell(rowIndex.get(), 4, values[4], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, this.getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX, isAdded)});
        writer.writeCell(rowIndex.get(), 5, values[5], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 6, values[6], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 7, values[7], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 8, values[8], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        AttributePojo<Boolean> diffElementValue = diffElement == null ? null : this.getValidRangeString(diffElement, diffElement.getPlatformType(), this.logicalTypeToDataType((String)diffElement.getPlatformType().getInterfaceLogicalType().getValue()));
        ExcelWorkbookWriter.CELLSTYLE color = this.getHeaderStructureCellColor(validRange, diffElementValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(rowIndex.get(), 9, values[9], new ExcelWorkbookWriter.CELLSTYLE[]{color});
        diffElementValue = diffElement == null ? null : diffElement.getInterfaceElementAlterable();
        color = this.getHeaderStructureCellColor(element.getInterfaceElementAlterable(), diffElementValue, isAdded);
        changed = changed || !color.equals((Object)ExcelWorkbookWriter.CELLSTYLE.NONE);
        writer.writeCell(rowIndex.get(), 10, values[10], new ExcelWorkbookWriter.CELLSTYLE[]{color});
        writer.writeCell(rowIndex.get(), 11, values[11], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.WRAP, this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 12, values[12], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 13, values[13], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        writer.writeCell(rowIndex.get(), 14, values[14], new ExcelWorkbookWriter.CELLSTYLE[]{this.getHeaderStructureCellColor(isAdded)});
        this.logicalTypes.add(String.valueOf(dataType) + ";" + byteSize);
        this.units.add(units);
        if (changed && ((currentStyle = this.headerNameStyles.get(structure.getName().getValue())) == null || !currentStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN))) {
            this.headerNameStyles.put((String)structure.getName().getValue(), ExcelWorkbookWriter.CELLSTYLE.YELLOW);
        }
        return this.createStringLengthArray(values);
    }

    private ExcelWorkbookWriter.CELLSTYLE getHeaderStructureCellColor(boolean isAdded) {
        return this.getHeaderStructureCellColor("", "", ExcelWorkbookWriter.CELLSTYLE.NONE, isAdded);
    }

    private ExcelWorkbookWriter.CELLSTYLE getHeaderStructureCellColor(ExcelWorkbookWriter.CELLSTYLE defaultColor, boolean isAdded) {
        return this.getHeaderStructureCellColor("", "", defaultColor, isAdded);
    }

    private ExcelWorkbookWriter.CELLSTYLE getHeaderStructureCellColor(Object elementValue, Object diffElementValue, boolean isAdded) {
        return this.getHeaderStructureCellColor(elementValue, diffElementValue, ExcelWorkbookWriter.CELLSTYLE.NONE, isAdded);
    }

    private ExcelWorkbookWriter.CELLSTYLE getHeaderStructureCellColor(Object elementValue, Object diffElementValue, ExcelWorkbookWriter.CELLSTYLE defaultColor, boolean isAdded) {
        if (isAdded) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        if (diffElementValue == null || elementValue.equals(diffElementValue)) {
            return defaultColor;
        }
        return ExcelWorkbookWriter.CELLSTYLE.YELLOW;
    }

    private int[] printDataElementRow(ExcelWorkbookWriter writer, AtomicInteger rowIndex, ArtifactReadable structure, InterfaceStructureElementToken elementToken, Integer byteLocation, Integer byteSize, InterfaceStructureElementToken parentElement) {
        ExcelWorkbookWriter.CELLSTYLE pUnitsStyle;
        ExcelWorkbookWriter.CELLSTYLE pRangeStyle;
        ExcelWorkbookWriter.CELLSTYLE logicalTypeStyle;
        ExcelWorkbookWriter.CELLSTYLE byteSizeStyle;
        ExcelWorkbookWriter.CELLSTYLE endByteStyle;
        ExcelWorkbookWriter.CELLSTYLE beginByteStyle;
        ExcelWorkbookWriter.CELLSTYLE endWordStyle;
        ExcelWorkbookWriter.CELLSTYLE beginWordStyle;
        ExcelWorkbookWriter.CELLSTYLE enumStyle;
        ExcelWorkbookWriter.CELLSTYLE pTypeStyle;
        MimChangeSummaryItem structDiff;
        HashSet<TransactionId> txIds = new HashSet<TransactionId>();
        PlatformTypeToken platformType = elementToken.getPlatformType();
        Integer beginWord = Math.floorDiv(byteLocation, 4);
        Integer beginByte = Math.floorMod(byteLocation, 4);
        Integer endWord = Math.max(0, Math.floorDiv(byteLocation + byteSize - 1, 4));
        Integer endByte = Math.max(0, Math.floorMod(byteLocation + byteSize - 1, 4));
        String enumLiterals = (String)elementToken.getEnumLiteral().getValue();
        String dataType = ((String)elementToken.getPlatformType().getInterfaceLogicalType().getValue()).isEmpty() ? "n/a" : (String)elementToken.getPlatformType().getInterfaceLogicalType().getValue();
        dataType = this.logicalTypeToDataType(dataType);
        String units = ((String)elementToken.getPlatformType().getInterfacePlatformTypeUnits().getValue()).isEmpty() ? "n/a" : (String)elementToken.getPlatformType().getInterfacePlatformTypeUnits().getValue();
        Integer startIndex = (Integer)elementToken.getInterfaceElementIndexStart().getValue();
        Integer endIndex = (Integer)elementToken.getInterfaceElementIndexEnd().getValue();
        String validRange = this.getValidRangeString(elementToken, platformType, dataType);
        String alterable = (Boolean)elementToken.getInterfaceElementAlterable().getValue() != false ? "Yes" : "No";
        String description = ((String)elementToken.getDescription().getValue()).isEmpty() ? "n/a" : (String)elementToken.getDescription().getValue();
        String notes = ((String)elementToken.getNotes().getValue()).isEmpty() ? "" : (String)elementToken.getNotes().getValue();
        String defaultValue = (String)elementToken.getInterfaceDefaultValue().getValue();
        boolean enumChanged = false;
        if (this.diffs.containsKey(platformType.getArtifactId())) {
            txIds.addAll(this.diffs.get(platformType.getArtifactId()).getAllTxIds());
        }
        if (dataType.equals("enumeration")) {
            ArtifactReadable enumSet = (ArtifactReadable)platformType.getArtifactReadable().getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            enumLiterals = String.valueOf(enumSet.getName()) + ":\n";
            boolean bl = enumChanged = enumChanged || this.diffs.containsKey(enumSet.getArtifactId());
            if (this.diffs.containsKey(enumSet.getArtifactId())) {
                txIds.addAll(this.diffs.get(enumSet.getArtifactId()).getAllTxIds());
            }
            for (ArtifactReadable enumState : enumSet.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationState).getList()) {
                enumLiterals = String.valueOf(enumLiterals) + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, "0") + " = " + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Name, "") + "\n";
                boolean bl2 = enumChanged = enumChanged || this.diffs.containsKey(enumState.getArtifactId());
                if (!this.diffs.containsKey(enumState.getArtifactId())) continue;
                txIds.addAll(this.diffs.get(enumState.getArtifactId()).getAllTxIds());
            }
        }
        if ((dataType.equals("uInteger") || dataType.equals("sInteger")) && enumLiterals.isEmpty()) {
            enumLiterals = "n/a";
        }
        if (((Boolean)elementToken.isInterfaceElementBlockData().getValue()).booleanValue()) {
            dataType = (String)elementToken.getDescription().getValue();
        }
        Optional elementDiff = (structDiff = this.diffs.get(structure.getArtifactId())) == null ? Optional.empty() : structDiff.getChild(elementToken.getArtifactId());
        String icdcns = "";
        if (elementDiff.isPresent()) {
            txIds.addAll(((MimChangeSummaryItem)elementDiff.get()).getAllTxIds());
        }
        icdcns = this.getRelatedWorkFlow(txIds);
        boolean elementAdded = elementDiff.isPresent() && ((MimChangeSummaryItem)elementDiff.get()).isAdded();
        boolean platformTypeChanged = elementDiff.isPresent() && !((MimChangeSummaryItem)elementDiff.get()).getRelationChanges(CoreRelationTypes.InterfaceElementPlatformType.getId()).isEmpty();
        boolean enumLiteralsChanged = elementDiff.isPresent() && ((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfaceElementEnumLiteral.getId()));
        boolean logicalTypeChanged = platformTypeChanged;
        boolean unitsChanged = platformTypeChanged;
        boolean rangeChanged = platformTypeChanged;
        if (platformTypeChanged) {
            logicalTypeChanged = elementDiff.isPresent() && ((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfaceLogicalType.getId()) && a.getChangeType().equals("Modified"));
            unitsChanged = elementDiff.isPresent() && ((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfacePlatformTypeUnits.getId()) && a.getChangeType().equals("Modified"));
            rangeChanged = elementDiff.isPresent() && (((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfacePlatformTypeMinval.getId()) && a.getChangeType().equals("Modified")) || ((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfacePlatformTypeMaxval.getId()) && a.getChangeType().equals("Modified")) || ((MimChangeSummaryItem)elementDiff.get()).getAttributeChanges().stream().anyMatch(a -> a.getItemTypeId().equals(CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription.getId()) && a.getChangeType().equals("Modified")));
        }
        ExcelWorkbookWriter.CELLSTYLE elementStyle = this.getCellColor(elementToken.getArtifactReadable(), false);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (pTypeStyle = platformTypeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE2 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (enumStyle = enumChanged || enumLiteralsChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE3 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (beginWordStyle = parentElement.isValid() && beginWord.intValue() != parentElement.getBeginWord().intValue() ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE4 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (endWordStyle = parentElement.isValid() && endWord.intValue() != parentElement.getEndWord().intValue() ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE5 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (beginByteStyle = parentElement.isValid() && beginByte.intValue() != parentElement.getBeginByte().intValue() ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE6 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (endByteStyle = parentElement.isValid() && endByte.intValue() != parentElement.getEndByte().intValue() ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE7 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (byteSizeStyle = parentElement.isValid() && elementToken.getElementSizeInBytes() != parentElement.getElementSizeInBytes() ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.LIGHT_BLUE_XLSX);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE8 = (Boolean)elementToken.isInterfaceElementBlockData().getValue() != false ? this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Description.getId(), 0) : (elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (logicalTypeStyle = logicalTypeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE));
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE9 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (pRangeStyle = rangeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE10 = elementAdded || elementStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (pUnitsStyle = unitsChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE icdcnStyle = elementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (txIds.size() > 0 ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        Object[] values = new Object[]{beginWord, beginByte, byteSize, endWord, endByte, icdcns, dataType, elementToken.getName().getValue(), units, validRange, alterable, description, enumLiterals.trim(), notes, defaultValue};
        if (startIndex < endIndex) {
            int i = startIndex;
            while (i < endIndex + 1) {
                boolean arrayElementAdded = elementAdded || elementDiff.isPresent() && this.isNewArrayElement((MimChangeSummaryItem)elementDiff.get(), i);
                ExcelWorkbookWriter.CELLSTYLE arrByteSizeStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : byteSizeStyle;
                ExcelWorkbookWriter.CELLSTYLE arrBeginWordStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : beginWordStyle;
                ExcelWorkbookWriter.CELLSTYLE arrEndWordStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : endWordStyle;
                ExcelWorkbookWriter.CELLSTYLE arrBeginByteStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : beginByteStyle;
                ExcelWorkbookWriter.CELLSTYLE arrEndByteStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : endByteStyle;
                ExcelWorkbookWriter.CELLSTYLE arrPTypeStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : pTypeStyle;
                ExcelWorkbookWriter.CELLSTYLE arrEnumStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : enumStyle;
                ExcelWorkbookWriter.CELLSTYLE arrLogicalTypeStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : logicalTypeStyle;
                ExcelWorkbookWriter.CELLSTYLE arrPUnitsStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : pUnitsStyle;
                ExcelWorkbookWriter.CELLSTYLE arrPRangeStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : pRangeStyle;
                ExcelWorkbookWriter.CELLSTYLE arrIcdcnStyle = arrayElementAdded ? ExcelWorkbookWriter.CELLSTYLE.GREEN : icdcnStyle;
                values[0] = beginWord;
                values[1] = beginByte;
                values[3] = endWord;
                values[4] = endByte;
                values[11] = description.replace("$index", Integer.toString(i));
                String elementName = (String)elementToken.getName().getValue();
                if (elementToken.isArrayChild() && !((Boolean)elementToken.getInterfaceElementWriteArrayHeaderName().getValue()).booleanValue()) {
                    String[] split = ((String)elementToken.getName().getValue()).split(" ");
                    String elementIndex = split[split.length - 1];
                    if (Strings.isNumeric((String)elementIndex)) {
                        elementName = elementName.substring(0, elementName.length() - (elementIndex.length() + 1)).trim();
                        String delimiter1 = (String)elementToken.getInterfaceElementArrayIndexDelimiterOne().getValue();
                        String delimiter2 = (String)elementToken.getInterfaceElementArrayIndexDelimiterTwo().getValue();
                        elementName = ((String)elementToken.getInterfaceElementArrayIndexOrder().getValue()).equals(ElementArrayIndexOrder.INNER_OUTER.toString()) ? String.valueOf(elementName) + delimiter1 + i + delimiter2 + elementIndex : String.valueOf(elementName) + delimiter1 + elementIndex + delimiter2 + i;
                    }
                } else {
                    elementName = String.valueOf(elementName) + " " + i;
                }
                values[7] = elementName;
                writer.writeCell(rowIndex.get(), IcdElementIndex.beginWord.ordinal(), values[IcdElementIndex.beginWord.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrBeginWordStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), IcdElementIndex.beginByte.ordinal(), values[IcdElementIndex.beginByte.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrBeginByteStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), IcdElementIndex.byteSize.ordinal(), values[IcdElementIndex.byteSize.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrByteSizeStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), IcdElementIndex.endWord.ordinal(), values[IcdElementIndex.endWord.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrEndWordStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), IcdElementIndex.endByte.ordinal(), values[IcdElementIndex.endByte.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrEndByteStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), IcdElementIndex.icdcns.ordinal(), values[IcdElementIndex.icdcns.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrIcdcnStyle});
                writer.writeCell(rowIndex.get(), IcdElementIndex.dataType.ordinal(), values[IcdElementIndex.dataType.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrLogicalTypeStyle});
                if (!((Boolean)elementToken.isInterfaceElementBlockData().getValue()).booleanValue()) {
                    writer.writeCell(rowIndex.get(), IcdElementIndex.name.ordinal(), values[IcdElementIndex.name.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Name.getId(), i)});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.units.ordinal(), values[IcdElementIndex.units.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrPTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) || arrPTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? arrPUnitsStyle : this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeUnits.getId(), i)});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.validRange.ordinal(), values[IcdElementIndex.validRange.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrPTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) || arrPTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? arrPRangeStyle : (this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeMinval.getId(), i).equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeMaxval.getId(), i)), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.alterable.ordinal(), values[IcdElementIndex.alterable.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfaceElementAlterable.getId(), i), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.description.ordinal(), values[IcdElementIndex.description.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Description.getId(), i), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.enumLiterals.ordinal(), values[IcdElementIndex.enumLiterals.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{arrEnumStyle, ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.notes.ordinal(), values[IcdElementIndex.notes.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Notes.getId(), i), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    writer.writeCell(rowIndex.get(), IcdElementIndex.defaultValue.ordinal(), values[IcdElementIndex.defaultValue.ordinal()], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfaceDefaultValue.getId(), i)});
                }
                byteLocation = byteLocation + byteSize;
                beginWord = Math.floorDiv(byteLocation, 4);
                beginByte = Math.floorMod(byteLocation, 4);
                endWord = Math.max(0, Math.floorDiv(byteLocation + byteSize - 1, 4));
                endByte = Math.max(0, Math.floorMod(byteLocation + byteSize - 1, 4));
                if (((Boolean)elementToken.isInterfaceElementBlockData().getValue()).booleanValue()) {
                    writer.addMergedRegion(rowIndex.get(), rowIndex.get(), 6, 13);
                }
                rowIndex.getAndAdd(1);
                ++i;
            }
        } else {
            if (elementToken.isArrayChild()) {
                String elementName = (String)elementToken.getName().getValue();
                String[] split = ((String)elementToken.getName().getValue()).split(" ");
                String elementIndex = split[split.length - 1];
                if (Strings.isNumeric((String)elementIndex)) {
                    List descriptions;
                    Long elementIndexLong = Long.parseLong(elementIndex);
                    if (this.arrayDescriptions.containsKey(elementToken.getArtifactId()) && (descriptions = this.arrayDescriptions.get(elementToken.getArtifactId()).stream().filter(d -> (Long)d.getOrdinal().getValue() <= elementIndexLong).collect(Collectors.toList())).size() > 0) {
                        values[11] = ((InterfaceEnumeration)((Object)descriptions.get(descriptions.size() - 1))).getName().getValue();
                    }
                    if (!((Boolean)elementToken.getInterfaceElementWriteArrayHeaderName().getValue()).booleanValue()) {
                        elementName = elementName.substring(0, elementName.length() - (elementIndex.length() + 1)).trim();
                        elementName = ((String)elementToken.getInterfaceElementArrayIndexOrder().getValue()).equals(ElementArrayIndexOrder.INNER_OUTER.toString()) ? String.valueOf(elementName) + elementToken.getInterfaceElementArrayIndexDelimiterTwo() + elementIndex : String.valueOf(elementName) + elementToken.getInterfaceElementArrayIndexDelimiterOne() + elementIndex;
                        values[7] = elementName;
                    }
                }
            }
            writer.writeCell(rowIndex.get(), 0, values[0], new ExcelWorkbookWriter.CELLSTYLE[]{beginWordStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
            writer.writeCell(rowIndex.get(), 1, values[1], new ExcelWorkbookWriter.CELLSTYLE[]{beginByteStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
            writer.writeCell(rowIndex.get(), 2, values[2], new ExcelWorkbookWriter.CELLSTYLE[]{byteSizeStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
            writer.writeCell(rowIndex.get(), 3, values[3], new ExcelWorkbookWriter.CELLSTYLE[]{endWordStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
            writer.writeCell(rowIndex.get(), 4, values[4], new ExcelWorkbookWriter.CELLSTYLE[]{endByteStyle, ExcelWorkbookWriter.CELLSTYLE.CENTERH});
            writer.writeCell(rowIndex.get(), 5, values[5], new ExcelWorkbookWriter.CELLSTYLE[]{icdcnStyle});
            writer.writeCell(rowIndex.get(), 6, values[6], new ExcelWorkbookWriter.CELLSTYLE[]{logicalTypeStyle});
            if (!((Boolean)elementToken.isInterfaceElementBlockData().getValue()).booleanValue()) {
                writer.writeCell(rowIndex.get(), 7, values[7], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Name.getId(), 0)});
                writer.writeCell(rowIndex.get(), 8, values[8], new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) || pTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? pUnitsStyle : this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeUnits.getId(), 0)});
                writer.writeCell(rowIndex.get(), 9, values[9], new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) || pTypeStyle.equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? pRangeStyle : (this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeMinval.getId(), 0).equals((Object)ExcelWorkbookWriter.CELLSTYLE.YELLOW) ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfacePlatformTypeMaxval.getId(), 0)), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex.get(), 10, values[10], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfaceElementAlterable.getId(), 0), ExcelWorkbookWriter.CELLSTYLE.CENTERH});
                writer.writeCell(rowIndex.get(), 11, values[11], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Description.getId(), 0), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex.get(), 12, values[12], new ExcelWorkbookWriter.CELLSTYLE[]{enumStyle, ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex.get(), 13, values[13], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.Notes.getId(), 0), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex.get(), 14, values[14], new ExcelWorkbookWriter.CELLSTYLE[]{this.getStructureCellColor(structure, elementToken.getArtifactReadable(), CoreAttributeTypes.InterfaceDefaultValue.getId(), 0)});
            }
            if (((Boolean)elementToken.isInterfaceElementBlockData().getValue()).booleanValue()) {
                writer.addMergedRegion(rowIndex.get(), rowIndex.get(), 6, 13);
            }
            rowIndex.getAndAdd(1);
        }
        if (this.logicalTypeMaxRange.containsKey(dataType)) {
            this.logicalTypes.add(String.valueOf(dataType) + ";" + byteSize);
        }
        this.units.add(units);
        return this.createStringLengthArray(values);
    }

    private String getValidRangeString(InterfaceStructureElementToken elementToken, PlatformTypeToken platformType, String dataType) {
        String minVal = ((String)elementToken.getPlatformType().getInterfacePlatformTypeMinval().getValue()).isEmpty() ? "n/a" : (String)elementToken.getPlatformType().getInterfacePlatformTypeMinval().getValue();
        String maxVal = ((String)elementToken.getPlatformType().getInterfacePlatformTypeMaxval().getValue()).isEmpty() ? "n/a" : (String)elementToken.getPlatformType().getInterfacePlatformTypeMaxval().getValue();
        String validRange = "";
        if (dataType.equals("enumeration")) {
            validRange = "see enumerated literals";
        } else if (platformType != null && ((validRange = minVal.equals(maxVal) ? minVal : (maxVal.equals("n/a") ? minVal : (minVal.equals("n/a") ? maxVal : String.valueOf(minVal) + " to " + maxVal))).isEmpty() || validRange.equals("n/a")) && !((String)platformType.getInterfacePlatformTypeValidRangeDescription().getValue()).isEmpty()) {
            validRange = (String)platformType.getInterfacePlatformTypeValidRangeDescription().getValue();
        }
        return validRange;
    }

    private void writeMessageSubMessageSummary(ExcelWorkbookWriter writer, ArtifactReadable connection, ArtifactReadable primaryNode, ArtifactReadable secondaryNode, List<ArtifactReadable> messages) {
        List connectionMessages = messages.stream().filter(e -> !e.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType).equals("Connection")).collect(Collectors.toList());
        List primaryList = connectionMessages.stream().filter(e -> primaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessagePubNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        List secondaryList = connectionMessages.stream().filter(e -> secondaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessagePubNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        writer.createSheet("Message and SubMessage Summary");
        writer.addMergedRegion("A1:E1");
        writer.addMergedRegion("F1:J1");
        writer.addMergedRegion("D2:E2");
        writer.addMergedRegion("I2:J2");
        writer.setRowHeight(0, 300);
        writer.writeCell(0, 0, (Object)(String.valueOf(primaryNode.getName()) + " Initiated Message"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        writer.writeCell(0, 5, (Object)(String.valueOf(secondaryNode.getName()) + " Initiated Message"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        Object[] rowValues = new String[]{"No.", "Rate", "Read/Write", "Content", "", "No.", "Rate", "Read/Write", "Content"};
        writer.writeRow(1, rowValues, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        AtomicInteger rowIndex = new AtomicInteger(2);
        AtomicInteger noteIndex = new AtomicInteger(1);
        HashMap<Integer, MessageNote> messageNotes = new HashMap<Integer, MessageNote>();
        int i = 0;
        while (i < Math.max(primaryList.size(), secondaryList.size())) {
            ArtifactReadable primaryMessage = ArtifactReadable.SENTINEL;
            ArtifactReadable secondaryMessage = ArtifactReadable.SENTINEL;
            List primarySubMessages = new ArrayList();
            List secondarySubMessages = new ArrayList();
            if (i < primaryList.size()) {
                primaryMessage = (ArtifactReadable)primaryList.get(i);
                primarySubMessages = primaryMessage.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            }
            if (i < secondaryList.size()) {
                secondaryMessage = (ArtifactReadable)secondaryList.get(i);
                secondarySubMessages = secondaryMessage.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            }
            if (primaryMessage.isValid()) {
                this.writeMessageSummary(writer, primaryMessage, rowIndex, noteIndex, 0, messageNotes);
            }
            if (secondaryMessage.isValid()) {
                this.writeMessageSummary(writer, secondaryMessage, rowIndex, noteIndex, 5, messageNotes);
            }
            rowIndex.addAndGet(1);
            if (primaryMessage.isValid()) {
                writer.writeCell(rowIndex.get(), 3, (Object)"Software Interface Header", new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, false)});
                writer.addMergedRegion(rowIndex.get(), rowIndex.get(), 3, 4);
            }
            if (secondaryMessage.isValid()) {
                writer.writeCell(rowIndex.get(), 8, (Object)"Software Interface Header", new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, false)});
                writer.addMergedRegion(rowIndex.get(), rowIndex.get(), 8, 9);
            }
            rowIndex.addAndGet(1);
            int numSubMessages = Math.max(primarySubMessages.size(), secondarySubMessages.size());
            int j = 0;
            while (j < numSubMessages) {
                ArtifactReadable subMessage;
                if (j < primarySubMessages.size()) {
                    subMessage = (ArtifactReadable)primarySubMessages.get(j);
                    this.writeSubmessageSummary(writer, subMessage, rowIndex, noteIndex, 0, messageNotes);
                }
                if (j < secondarySubMessages.size()) {
                    subMessage = (ArtifactReadable)secondarySubMessages.get(j);
                    this.writeSubmessageSummary(writer, subMessage, rowIndex, noteIndex, 5, messageNotes);
                }
                rowIndex.addAndGet(1);
                ++j;
            }
            if (primaryMessage.isValid()) {
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 0, 0);
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 1, 1);
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 2, 2);
            }
            if (secondaryMessage.isValid()) {
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 5, 5);
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 6, 6);
                writer.addMergedRegion(rowIndex.get() - numSubMessages - 2, rowIndex.get() - 1, 7, 7);
            }
            ++i;
        }
        String connectionDesc = connection.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "");
        if (!connectionDesc.isEmpty() && !connectionDesc.equals("null")) {
            writer.writeCell(rowIndex.get(), 0, (Object)connectionDesc);
        }
        rowIndex.addAndGet(1);
        writer.writeCell(rowIndex.get(), 11, (Object)"Notes:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        rowIndex.addAndGet(1);
        for (Integer superscript : messageNotes.keySet()) {
            MessageNote note = (MessageNote)messageNotes.get(superscript);
            writer.writeCell(rowIndex.get(), 11, (Object)(superscript + ". " + note.getText()), new ExcelWorkbookWriter.CELLSTYLE[]{note.getColor(), ExcelWorkbookWriter.CELLSTYLE.WRAP});
            rowIndex.addAndGet(1);
        }
        writer.autoSizeAllColumns(10);
        writer.setColumnWidth(0, 3000);
        writer.setColumnWidth(1, 3000);
        writer.setColumnWidth(2, 3000);
        writer.setColumnWidth(3, 5000);
        writer.setColumnWidth(4, writer.getColumnWidth(4) + 1200);
        writer.setColumnWidth(5, 3000);
        writer.setColumnWidth(6, 3000);
        writer.setColumnWidth(7, 3000);
        writer.setColumnWidth(8, 5000);
        writer.setColumnWidth(9, writer.getColumnWidth(9) + 1200);
        writer.setColumnWidth(11, 20000);
    }

    private void writeMessageSummary(ExcelWorkbookWriter writer, ArtifactReadable message, AtomicInteger rowIndex, AtomicInteger noteIndex, int colOffset, Map<Integer, MessageNote> messageNotes) {
        writer.writeCell(rowIndex.get(), 0 + colOffset, (Object)message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV, this.getCellColor(message, CoreAttributeTypes.InterfaceMessageNumber.getId())});
        writer.writeCell(rowIndex.get(), 1 + colOffset, (Object)message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV, this.getCellColor(message, CoreAttributeTypes.InterfaceMessageRate.getId())});
        writer.writeCell(rowIndex.get(), 2 + colOffset, (Object)((Boolean)message.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess, (Object)false) != false ? "W" : "R"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV, this.getCellColor(message, CoreAttributeTypes.InterfaceMessageWriteAccess.getId())});
        String description = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "");
        if (!description.isEmpty()) {
            ExcelWorkbookWriter.CELLSTYLE superscriptColor = this.getCellColor(message, CoreAttributeTypes.Description.getId());
            String messageNameWithSuperscript = String.valueOf(message.getName()) + " [" + noteIndex + "]";
            messageNotes.put(noteIndex.get(), new MessageNote(description, superscriptColor));
            noteIndex.getAndAdd(1);
            writer.writeCellStringWithSuperscript(rowIndex.get(), 3 + colOffset, messageNameWithSuperscript, message.getName().length(), messageNameWithSuperscript.length(), superscriptColor, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(message, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.BOLD});
        } else {
            writer.writeCell(rowIndex.get(), 3 + colOffset, (Object)message.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(message, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.BOLD});
        }
        writer.addMergedRegion(rowIndex.get(), rowIndex.get(), 3 + colOffset, 4 + colOffset);
    }

    private void writeSubmessageSummary(ExcelWorkbookWriter writer, ArtifactReadable subMessage, AtomicInteger rowIndex, AtomicInteger noteIndex, int colOffset, Map<Integer, MessageNote> messageNotes) {
        writer.writeCell(rowIndex.get(), 3 + colOffset, (Object)("Submessage " + subMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceSubMessageNumber) + ":"), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
        String description = subMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "");
        if (!description.isEmpty()) {
            ExcelWorkbookWriter.CELLSTYLE superscriptColor = this.getCellColor(subMessage, CoreAttributeTypes.Description.getId());
            String subMessageNameWithSuperscript = String.valueOf(subMessage.getName()) + " [" + noteIndex + "]";
            messageNotes.put(noteIndex.get(), new MessageNote(description, superscriptColor));
            noteIndex.addAndGet(1);
            writer.writeCellStringWithSuperscript(rowIndex.get(), 4 + colOffset, subMessageNameWithSuperscript, subMessage.getName().length(), subMessageNameWithSuperscript.length(), superscriptColor, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.NONE});
        } else {
            writer.writeCell(rowIndex.get(), 4 + colOffset, (Object)subMessage.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
        }
    }

    private void createUnitsAndTypesSheet(ExcelWorkbookWriter writer) {
        writer.createSheet("Units and Types");
    }

    private void writeUnitsAndTypesSheet(ExcelWorkbookWriter writer, BranchId branch, ArtifactId view, InterfaceNode primaryNode, InterfaceNode secondaryNode) {
        LinkedList<String> logicalTypes = new LinkedList<String>(this.logicalTypes);
        logicalTypes.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer byteSize2;
                String[] split1 = o1.split(";");
                String[] split2 = o2.split(";");
                Integer byteSize1 = Integer.parseInt(split1[1]);
                if (byteSize1.equals(byteSize2 = Integer.valueOf(Integer.parseInt(split2[1])))) {
                    return split1[0].compareTo(split2[0]);
                }
                return byteSize1.compareTo(byteSize2);
            }
        });
        LinkedList<String> units = new LinkedList<String>(this.units);
        units.sort(Comparator.comparing(String::toString));
        if (units.remove("n/a")) {
            units.add(0, "n/a");
        }
        List unitArts = this.orcsApi.getQueryFactory().fromBranch(branch, view).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceUnit}).asArtifacts();
        HashMap unitsToMeasurementType = new HashMap();
        unitArts.stream().forEach(art -> {
            if (units.contains(art.getName())) {
                unitsToMeasurementType.put(art.getName(), art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceUnitMeasurement, ""));
            }
        });
        LinkedList<String> txRates = new LinkedList<String>(this.txRates);
        txRates.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("Aperiodic")) {
                    return 1;
                }
                if (o2.equals("Aperiodic")) {
                    return -1;
                }
                String[] split1 = o1.split("-");
                String[] split2 = o2.split("-");
                Integer rate1 = Integer.parseInt(split1[0]);
                Integer rate2 = Integer.parseInt(split2[0]);
                if (split1.length > 1 && split2.length == 1) {
                    return -1;
                }
                if (split2.length > 1 && split1.length == 1) {
                    return 1;
                }
                return rate1.compareTo(rate2);
            }
        });
        LinkedList<String> categories = new LinkedList<String>(this.categories);
        categories.sort(Comparator.comparing(String::toString));
        writer.setActiveSheet("Units and Types");
        Object[] headers = new String[]{"Sheet Type", "Full Sheet Name", "Abbrev. Sheet Name"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(1, 0, (Object)"Admin", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(1, 1, (Object)"Units and Types", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(1, 2, (Object)"Units and Types", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.addMergedRegion(4, 4, 0, 2);
        writer.writeCell(4, 0, (Object)"Unit Name and Size", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(4, 1, (Object)"", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(4, 2, (Object)"", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(5, 0, (Object)"Data Types", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(5, 1, (Object)"Size in Bytes", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(5, 2, (Object)"Maximum Valid Range", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        int rowIndex = 6;
        for (String logicalType : logicalTypes) {
            String[] typeSplit = logicalType.split(";");
            writer.writeCell(rowIndex, 0, (Object)typeSplit[0], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL, ExcelWorkbookWriter.CELLSTYLE.BORDER_TOP});
            writer.writeCell(rowIndex, 1, (Object)typeSplit[1], new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            writer.writeCell(rowIndex, 2, (Object)this.logicalTypeMaxRange.getOrDefault(typeSplit[0], ""), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            ++rowIndex;
        }
        writer.writeCell(4, 4, (Object)"Measurement", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(4, 5, (Object)"Units", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        rowIndex = 5;
        for (String unit : units) {
            writer.writeCell(rowIndex, 4, unitsToMeasurementType.get(unit), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            writer.writeCell(rowIndex, 5, (Object)unit, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            ++rowIndex;
        }
        writer.writeCell(4, 7, (Object)"Category", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        rowIndex = 5;
        for (String category : categories) {
            writer.writeCell(rowIndex, 7, (Object)category, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            ++rowIndex;
        }
        writer.writeCell(4, 9, (Object)"Transmission Rate (Hz)", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        rowIndex = 5;
        for (String rate : txRates) {
            writer.writeCell(rowIndex, 9, (Object)rate, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
            ++rowIndex;
        }
        writer.writeCell(4, 11, (Object)"Systems", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(5, 11, primaryNode.getName().getValue(), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(6, 11, secondaryNode.getName().getValue(), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(4, 13, (Object)"Alterable After", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(5, 13, (Object)"Yes", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.writeCell(6, 13, (Object)"No", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.BORDER_ALL});
        writer.autoSizeAllColumns(16);
        writer.setColumnWidth(0, writer.getColumnWidth(0) + 500);
        writer.setColumnWidth(1, writer.getColumnWidth(1) + 500);
        writer.setColumnWidth(2, writer.getColumnWidth(2) + 500);
        writer.setColumnWidth(4, writer.getColumnWidth(4) + 500);
        writer.setColumnWidth(5, writer.getColumnWidth(5) + 500);
        writer.setColumnWidth(7, writer.getColumnWidth(7) + 500);
    }

    private void writeStoredSheets(ExcelWorkbookWriter writer, BranchId branch, ArtifactId view, InterfaceConnection connection) {
        List supportDocs = this.orcsApi.getQueryFactory().fromBranch(branch, view).andRelatedTo(CoreRelationTypes.SupportingInfo_IsSupportedBy, connection.getArtifactId()).asArtifacts();
        for (ArtifactReadable support : supportDocs) {
            InputStream inputStream;
            String fileExtension = support.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Extension, "");
            if (!fileExtension.equals("xlsx") && !fileExtension.equals("xls") || (inputStream = (InputStream)support.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.NativeContent)) == null) continue;
            ExcelWorkbookWriter.WorkbookFormat format = fileExtension.equals("xlsx") ? ExcelWorkbookWriter.WorkbookFormat.XLSX : ExcelWorkbookWriter.WorkbookFormat.XLS;
            ExcelWorkbookReader reader = new ExcelWorkbookReader(inputStream, format);
            int i = 0;
            while (i < reader.getNumberOfSheets()) {
                reader.setActiveSheet(i);
                writer.createSheet(reader.getActiveSheetName());
                ExcelWorkbookUtils.copyActiveSheet((ExcelWorkbookReader)reader, (ExcelWorkbookWriter)writer);
                ++i;
            }
        }
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, boolean changed) {
        return this.getCellColor(artifact, changed, null);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, boolean changed, ConnectionValidationResult validation) {
        if (artifact != null && this.isStructureValidationError(validation, artifact.getArtifactId())) {
            return ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED;
        }
        MimChangeSummaryItem diffItem = artifact == null ? null : this.diffs.get(artifact.getArtifactId());
        ExcelWorkbookWriter.CELLSTYLE style = ExcelWorkbookWriter.CELLSTYLE.NONE;
        if (diffItem != null) {
            style = diffItem.isAdded() ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (changed ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        }
        return style;
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, Long attrId) {
        return this.getCellColor(artifact, artifact, attrId);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, Long attrId, ConnectionValidationResult validation) {
        return this.getCellColor(artifact, artifact, attrId, validation);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable rowArtifact, ArtifactReadable cellArtifact, Long attrId) {
        return this.getCellColor(rowArtifact, cellArtifact, attrId, null);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable rowArtifact, ArtifactReadable cellArtifact, Long attrId, ConnectionValidationResult validation) {
        if (rowArtifact != null && this.isStructureValidationError(validation, rowArtifact.getArtifactId())) {
            return ExcelWorkbookWriter.CELLSTYLE.LIGHT_RED;
        }
        MimChangeSummaryItem rowDiffItem = rowArtifact == null ? null : this.diffs.get(rowArtifact.getArtifactId());
        MimChangeSummaryItem cellDiffItem = cellArtifact == null ? null : this.diffs.get(cellArtifact.getArtifactId());
        return this.getCellColor(rowDiffItem, cellDiffItem, attrId);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(MimChangeSummaryItem rowChange, MimChangeSummaryItem cellChange, Long attrId) {
        MimChangeSummaryItem diffItem;
        if (rowChange != null && rowChange.isAdded()) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        ExcelWorkbookWriter.CELLSTYLE color = ExcelWorkbookWriter.CELLSTYLE.NONE;
        MimChangeSummaryItem mimChangeSummaryItem = diffItem = rowChange != null && rowChange.isAdded() ? rowChange : cellChange;
        if (diffItem != null) {
            color = diffItem.isAdded() ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (diffItem.hasAttributeChanges(attrId) ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        }
        return color;
    }

    private ExcelWorkbookWriter.CELLSTYLE getStructureCellColor(ArtifactReadable structure, ArtifactReadable element, Long attrId, int arrayIndex) {
        Optional elementDiffItem;
        MimChangeSummaryItem structureDiffItem = structure == null ? null : this.diffs.get(structure.getArtifactId());
        Optional<Object> optional = elementDiffItem = structureDiffItem == null ? Optional.empty() : structureDiffItem.getChild(element.getArtifactId());
        if (structureDiffItem == null || elementDiffItem.isEmpty()) {
            return ExcelWorkbookWriter.CELLSTYLE.NONE;
        }
        if (elementDiffItem.isPresent() && this.isNewArrayElement((MimChangeSummaryItem)elementDiffItem.get(), arrayIndex)) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        return this.getCellColor(structureDiffItem, (MimChangeSummaryItem)elementDiffItem.get(), attrId);
    }

    private boolean isNewArrayElement(MimChangeSummaryItem elementDiff, int arrayIndex) {
        ChangeReportRowDto change;
        List<ChangeReportRowDto> attributeChanges = elementDiff.getAttributeChanges(CoreAttributeTypes.InterfaceElementIndexStart.getId());
        if (attributeChanges.size() > 0 && (change = attributeChanges.get(0)).getChangeType().equals("Modified") && arrayIndex < Integer.parseInt(change.getWasValue())) {
            return true;
        }
        attributeChanges = elementDiff.getAttributeChanges(CoreAttributeTypes.InterfaceElementIndexEnd.getId());
        return attributeChanges.size() > 0 && (change = attributeChanges.get(0)).getChangeType().equals("Modified") && arrayIndex > Integer.parseInt(change.getWasValue());
    }

    private boolean isStructureValidationError(ConnectionValidationResult validation, ArtifactId structureId) {
        return validation != null && (validation.getStructureByteAlignmentErrors().containsKey(structureId) || validation.getStructureWordAlignmentErrors().containsKey(structureId));
    }

    private String logicalTypeToDataType(String logicalType) {
        return logicalType.replace("unsigned long", "uLong").replace("unsigned short", "uShort").replace("short", "sShort").replace("unsigned integer", "uInteger").replace("integer", "sInteger");
    }

    private class MessageNote {
        final String text;
        final ExcelWorkbookWriter.CELLSTYLE color;

        public MessageNote(String text, ExcelWorkbookWriter.CELLSTYLE color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public ExcelWorkbookWriter.CELLSTYLE getColor() {
            return this.color;
        }
    }

    private class StructureInfo {
        final Long id;
        final String name;
        final String nameAbbrev;
        final String category;
        final String txRate;
        final String minSim;
        final String maxSim;
        final String minBps;
        final String maxBps;
        final Integer numAttributes;
        final Integer sizeInBytes;
        final String initiator;
        final String msgNum;
        final String subMsgNum;
        final String taskfile;
        final String description;
        final ArtifactReadable message;
        final ArtifactReadable submessage;
        final List<InterfaceStructureElementToken> elements;
        final boolean structureChanged;
        final boolean txRateChanged;
        final boolean numElementsChanged;
        final boolean structureSizeChanged;
        boolean isAdded;
        final String icdcn;
        final InterfaceStructureToken parentStructure;
        final String sheetName;

        public StructureInfo(Long id, String name, String nameAbbrev, String cat, String msgRateText, String minSim, String maxSim, String minBps, String maxBps, Integer elementCount, Integer sizeInBytes, String sendingNode, String msgNumber, String subMsgNumber, String taskfile, String desc, ArtifactReadable message, ArtifactReadable submessage, List<InterfaceStructureElementToken> elements, boolean structureChanged, boolean txRateChanged, boolean numElementsChanged, boolean structureSizeChanged, boolean isAdded, String icdcn, InterfaceStructureToken parentStructure, String sheetName) {
            this.id = id;
            this.name = name;
            this.nameAbbrev = nameAbbrev;
            this.category = cat;
            this.txRate = msgRateText;
            this.minSim = minSim;
            this.maxSim = maxSim;
            this.minBps = minBps;
            this.maxBps = maxBps;
            this.numAttributes = elementCount;
            this.sizeInBytes = sizeInBytes;
            this.initiator = sendingNode;
            this.msgNum = msgNumber;
            this.subMsgNum = subMsgNumber;
            this.taskfile = taskfile;
            this.description = desc;
            this.message = message;
            this.submessage = submessage;
            this.elements = elements;
            this.structureChanged = structureChanged;
            this.txRateChanged = txRateChanged;
            this.numElementsChanged = numElementsChanged;
            this.structureSizeChanged = structureSizeChanged;
            this.isAdded = isAdded;
            this.icdcn = icdcn;
            this.parentStructure = parentStructure;
            this.sheetName = sheetName;
        }
    }
}

