/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceValidationApi;
import org.eclipse.osee.mim.types.ConnectionValidationResult;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class InterfaceValidationApiImpl
implements InterfaceValidationApi {
    private final InterfaceConnectionViewApi connectionApi;
    private final InterfaceStructureApi structureApi;

    InterfaceValidationApiImpl(InterfaceConnectionViewApi connectionApi, InterfaceStructureApi structureApi) {
        this.connectionApi = connectionApi;
        this.structureApi = structureApi;
    }

    @Override
    public ConnectionValidationResult validateConnection(BranchId branch, ArtifactId viewId, ArtifactId connectionId) {
        InterfaceConnection connection = this.connectionApi.get(branch, viewId, connectionId, Arrays.asList(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionNode_Node), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionTransportType_TransportType), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceConnectionMessage_Message), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceMessagePubNode_Node), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceSubMessageContent_Structure), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceStructureContent_DataElement), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement, (FollowRelation[])new FollowRelation[]{FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType)}), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType)));
        List messages = connection.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceConnectionMessage_Message).getList().stream().map(art -> new InterfaceMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
        LinkedList structures = new LinkedList();
        ConnectionValidationResult result = new ConnectionValidationResult(branch, viewId, (String)connection.getName().getValue());
        for (InterfaceMessageToken message : messages) {
            if (Strings.isInvalid((String)((String)message.getInterfaceMessageType().getValue()))) {
                result.getMessageTypeErrors().put(message.getArtifactId(), (String)message.getName().getValue());
            }
            structures.addAll(message.getSubMessages().stream().flatMap(subMsg -> subMsg.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream()).map(art -> new InterfaceStructureToken((ArtifactReadable)art)).map(struct -> this.structureApi.parseStructure(branch, connectionId, (InterfaceStructureToken)((Object)struct), viewId, struct.getElements())).collect(Collectors.toList()));
        }
        HashSet<String> structureSheetNames = new HashSet<String>();
        for (InterfaceStructureToken structure : structures) {
            String structureSheetName;
            structure.getElements().stream().filter(a -> a.getId() == -1L).collect(Collectors.toList());
            if (structure.getIncorrectlySized()) {
                result.getStructureByteAlignmentErrors().put(structure.getArtifactId(), (String)structure.getName().getValue());
            }
            if (structure.getElements().stream().anyMatch(a -> a.getId() == -1L)) {
                result.getStructureWordAlignmentErrors().put(structure.getArtifactId(), (String)structure.getName().getValue());
            }
            String string = structureSheetName = ((String)structure.getNameAbbrev().getValue()).isEmpty() ? (String)structure.getName().getValue() : (String)structure.getNameAbbrev().getValue();
            if (structureSheetNames.contains(structureSheetName)) {
                result.getDuplicateStructureNameErrors().put(structure.getArtifactId(), structureSheetName);
            }
            structureSheetNames.add(structureSheetName);
        }
        return result;
    }
}

