/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceStructureCategoryApi;
import org.eclipse.osee.mim.InterfaceStructureCategoryEndpoint;

public class InterfaceStructureCategoryEndpointImpl
implements InterfaceStructureCategoryEndpoint {
    private final InterfaceStructureCategoryApi structureCategoryApi;
    private final BranchId branch;

    public InterfaceStructureCategoryEndpointImpl(BranchId branch, InterfaceStructureCategoryApi structureCategoryApi) {
        this.structureCategoryApi = structureCategoryApi;
        this.branch = branch;
    }

    @Override
    public Collection<ArtifactAccessorResultWithoutGammas> getAllStructureCategories(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.structureCategoryApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.structureCategoryApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public ArtifactAccessorResultWithoutGammas getStructureCategory(ArtifactId rateId) {
        return this.structureCategoryApi.get(this.branch, rateId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.structureCategoryApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

