/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.ArtifactAccessor;
import org.eclipse.osee.accessor.types.ArtifactMatch;
import org.eclipse.osee.accessor.types.AttributeQuery;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.token.InterfaceStructureCategoryAttribute;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.internal.InterfaceStructureAccessor;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class InterfaceStructureApiImpl
implements InterfaceStructureApi {
    private ArtifactAccessor<InterfaceStructureToken> accessor;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final List<AttributeTypeId> structureAttributeList;
    private final List<AttributeTypeId> elementAttributeList;
    private final List<RelationTypeSide> affectedRelations;

    InterfaceStructureApiImpl(OrcsApi orcsApi, InterfaceConnectionViewApi connectionApi, InterfaceElementApi interfaceElementApi, InterfaceMessageApi interfaceMessageApi) {
        this.setAccessor((ArtifactAccessor<InterfaceStructureToken>)new InterfaceStructureAccessor(orcsApi));
        this.interfaceConnectionApi = connectionApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceMessageApi = interfaceMessageApi;
        this.structureAttributeList = this.createStructureAttributeList();
        this.elementAttributeList = this.createElementAttributeList();
        this.affectedRelations = this.createAffectedRelationTypeSideList();
    }

    private ArtifactAccessor<InterfaceStructureToken> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceStructureToken> accessor) {
        this.accessor = accessor;
    }

    private List<RelationTypeSide> createAffectedRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceSubMessageContent_Structure);
        return relations;
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceDefaultValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementEnumLiteral);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        return attributes;
    }

    private InterfaceStructureElementToken defaultSetUpElement(InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement, boolean shouldValidate, int validationSize) {
        if (previousElement.isInvalid() && !previousElement.isAutogenerated()) {
            element.setBeginByte(0.0);
            element.setBeginWord(0.0);
        } else {
            element.setBeginByte((previousElement.getEndByte() + 1.0) % (double)(validationSize / 2));
            element.setBeginWord(Math.floor((previousElement.getEndWord() * (double)(validationSize / 2) + previousElement.getEndByte() + 1.0) / (double)(validationSize / 2)));
        }
        element.setShouldValidate(shouldValidate);
        element.setValidationSize(validationSize);
        return element;
    }

    private InterfaceStructureToken parseStructure(BranchId branch, ArtifactId connectionId, InterfaceStructureToken structure) {
        return this.parseStructure(branch, connectionId, structure, ArtifactId.SENTINEL, new LinkedList<InterfaceStructureElementToken>());
    }

    private InterfaceStructureToken parseStructure(BranchId branch, ArtifactId connectionId, InterfaceStructureToken structure, String elementFilter) {
        return this.parseStructure(branch, connectionId, structure, ArtifactId.SENTINEL, this.interfaceElementApi.getAllRelatedAndFilter(branch, ArtifactId.valueOf((Long)structure.getId()), elementFilter));
    }

    private InterfaceStructureToken parseStructure(BranchId branch, InterfaceConnection connection, InterfaceStructureToken structure, List<InterfaceStructureElementToken> defaultElements) {
        return this.parseStructure(branch, connection, structure, ArtifactId.SENTINEL, defaultElements);
    }

    @Override
    public InterfaceStructureToken parseStructure(BranchId branch, ArtifactId connectionId, InterfaceStructureToken structure, ArtifactId viewId, List<InterfaceStructureElementToken> defaultElements) {
        InterfaceConnection connection = this.interfaceConnectionApi.get(branch, connectionId);
        return this.parseStructure(branch, connection, structure, viewId, defaultElements);
    }

    private InterfaceStructureToken parseStructure(BranchId branch, InterfaceConnection connection, InterfaceStructureToken structure, ArtifactId viewId, List<InterfaceStructureElementToken> defaultElements) {
        boolean shouldValidate = (Boolean)connection.getTransportType().getByteAlignValidation().getValue();
        int validationSize = (Integer)connection.getTransportType().getByteAlignValidationSize().getValue();
        LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
        elements.addAll(defaultElements.size() > 0 ? defaultElements : this.interfaceElementApi.getAllRelated(branch, structure.getArtifactId(), viewId));
        structure.setElements(this.parseElements(elements, InterfaceStructureElementToken.SENTINEL, validationSize, shouldValidate, false));
        return structure;
    }

    private List<InterfaceStructureElementToken> parseElements(Collection<InterfaceStructureElementToken> elements, InterfaceStructureElementToken parentPrevious, int validationSize, boolean shouldValidate, boolean isArray) {
        LinkedList<InterfaceStructureElementToken> tempElements;
        block19: {
            tempElements = new LinkedList<InterfaceStructureElementToken>();
            if (elements.size() >= 2) {
                List<InterfaceStructureElementToken> arrayElements;
                Iterator<InterfaceStructureElementToken> elementIterator = elements.iterator();
                InterfaceStructureElementToken previousElement = elementIterator.next();
                InterfaceStructureElementToken currentElement = elementIterator.next();
                if (previousElement.getArrayElements().isEmpty()) {
                    previousElement = this.defaultSetUpElement(previousElement, parentPrevious, shouldValidate, validationSize);
                } else {
                    arrayElements = this.parseElements(previousElement.getArrayElements(), InterfaceStructureElementToken.SENTINEL, validationSize, shouldValidate, true);
                    previousElement.setArrayElements(arrayElements);
                    previousElement.setBeginByte(arrayElements.get(0).getBeginByte());
                    previousElement.setBeginWord(arrayElements.get(0).getBeginWord());
                }
                tempElements.add(previousElement);
                while (true) {
                    if (currentElement.getArrayElements().isEmpty()) {
                        currentElement = this.defaultSetUpElement(currentElement, previousElement, shouldValidate, validationSize);
                        if (!isArray && currentElement.getInterfacePlatformTypeByteSize() >= (double)(validationSize / 2) && shouldValidate) {
                            if (previousElement.getEndByte() != (double)(validationSize / 2 - 1) && !isArray) {
                                previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (previousElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((previousElement.getEndWord() * (double)(validationSize / 2) + previousElement.getEndByte() + 1.0) / (double)(validationSize / 2)), (int)Math.floor((double)(validationSize / 2 - 1) - previousElement.getEndByte()), true);
                                previousElement.setShouldValidate(shouldValidate);
                                previousElement.setValidationSize(validationSize);
                                tempElements.add(previousElement);
                            }
                            if (!((Boolean)currentElement.isInterfaceElementBlockData().getValue()).booleanValue() && currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                                previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (previousElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((previousElement.getEndWord() * (double)(validationSize / 2) + previousElement.getEndByte() + 1.0) / (double)(validationSize / 2)), (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * (double)(validationSize / 2)) - 1);
                                previousElement.setShouldValidate(shouldValidate);
                                previousElement.setValidationSize(validationSize);
                                tempElements.add(previousElement);
                            }
                            currentElement = this.defaultSetUpElement(currentElement, previousElement, shouldValidate, validationSize);
                        }
                        tempElements.add(currentElement);
                        previousElement = currentElement;
                        if (!elementIterator.hasNext()) {
                            if (!isArray && currentElement.getEndByte() != (double)(validationSize / 2 - 1)) {
                                InterfaceStructureElementToken tempElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) / (double)(validationSize / 2)), (int)Math.floor((double)(validationSize / 2 - 1) - currentElement.getEndByte()), true);
                                tempElement.setShouldValidate(shouldValidate);
                                tempElement.setValidationSize(validationSize);
                                tempElements.add(tempElement);
                            }
                            if (!((Boolean)currentElement.isInterfaceElementBlockData().getValue()).booleanValue() && !isArray && currentElement.getEndWord() % 2.0 != 1.0 && shouldValidate) {
                                currentElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) / (double)(validationSize / 2)), validationSize / 2);
                                currentElement.setShouldValidate(shouldValidate);
                                currentElement.setValidationSize(validationSize);
                                tempElements.add(currentElement);
                            }
                            break block19;
                        }
                        currentElement = elementIterator.next();
                        continue;
                    }
                    arrayElements = this.parseElements(currentElement.getArrayElements(), previousElement, validationSize, shouldValidate, true);
                    currentElement.setArrayElements(arrayElements);
                    currentElement.setBeginByte(arrayElements.get(0).getBeginByte());
                    currentElement.setBeginWord(arrayElements.get(0).getBeginWord());
                    tempElements.add(currentElement);
                    previousElement = currentElement;
                    if (!elementIterator.hasNext()) {
                        if (!((Boolean)currentElement.isInterfaceElementBlockData().getValue()).booleanValue() && !isArray && currentElement.getEndByte() != (double)(validationSize / 2 - 1)) {
                            InterfaceStructureElementToken tempElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) / (double)(validationSize / 2)), (int)Math.floor((double)(validationSize / 2 - 1) - currentElement.getEndByte()), true);
                            tempElement.setShouldValidate(shouldValidate);
                            tempElement.setValidationSize(validationSize);
                            tempElements.add(tempElement);
                        }
                        if (!((Boolean)currentElement.isInterfaceElementBlockData().getValue()).booleanValue() && !isArray && currentElement.getEndWord() % 2.0 != 1.0 && shouldValidate) {
                            currentElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((currentElement.getEndWord() * (double)(validationSize / 2) + currentElement.getEndByte() + 1.0) / (double)(validationSize / 2)), validationSize / 2);
                            currentElement.setShouldValidate(shouldValidate);
                            currentElement.setValidationSize(validationSize);
                            tempElements.add(currentElement);
                        }
                        break block19;
                    }
                    currentElement = elementIterator.next();
                }
            }
            InterfaceStructureElementToken lastElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", 0.0, 0.0, 0);
            lastElement.setShouldValidate(shouldValidate);
            lastElement.setValidationSize(validationSize);
            for (InterfaceStructureElementToken element : elements) {
                if (element.getArrayElements().isEmpty()) {
                    element = this.defaultSetUpElement(element, parentPrevious, shouldValidate, validationSize);
                } else {
                    List<InterfaceStructureElementToken> arrayElements = this.parseElements(element.getArrayElements(), parentPrevious, validationSize, shouldValidate, true);
                    element.setArrayElements(arrayElements);
                    element.setBeginByte(arrayElements.get(0).getBeginByte());
                    element.setBeginWord(arrayElements.get(0).getBeginWord());
                }
                lastElement = element;
            }
            tempElements.addAll(elements);
            if (!isArray && lastElement.getEndByte() != (double)(validationSize / 2 - 1) && shouldValidate) {
                InterfaceStructureElementToken tempElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (lastElement.getEndWord() * (double)(validationSize / 2) + lastElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((lastElement.getEndWord() * (double)(validationSize / 2) + lastElement.getEndByte() + 1.0) / (double)(validationSize / 2)), (int)Math.floor((double)(validationSize / 2 - 1) - lastElement.getEndByte()), true);
                tempElement.setShouldValidate(shouldValidate);
                tempElement.setValidationSize(validationSize);
                tempElements.add(tempElement);
            }
            if (!isArray && lastElement.getEndWord() % 2.0 != 1.0 && shouldValidate) {
                lastElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (lastElement.getEndWord() * (double)(validationSize / 2) + lastElement.getEndByte() + 1.0) % (double)(validationSize / 2), Math.floor((lastElement.getEndWord() * (double)(validationSize / 2) + lastElement.getEndByte() + 1.0) / (double)(validationSize / 2)), validationSize / 2);
                lastElement.setShouldValidate(shouldValidate);
                lastElement.setValidationSize(validationSize);
                tempElements.add(lastElement);
            }
        }
        return tempElements;
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId) {
        return this.getAllRelated(branch, connectionId, subMessageId, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureToken> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureToken> getAllWithoutRelations(BranchId branch) {
        return this.getAllWithoutRelations(branch, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureToken> getFiltered(BranchId branch, String filter) {
        return this.getFiltered(branch, filter, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureToken> getFilteredWithoutRelations(BranchId branch, String filter) {
        return this.getFilteredWithoutRelations(branch, filter, 0L, 0L);
    }

    @Override
    public InterfaceStructureToken get(BranchId branch, ArtifactId artId) {
        return this.get(branch, artId, ArtifactId.SENTINEL);
    }

    @Override
    public InterfaceStructureToken get(BranchId branch, ArtifactId artId, ArtifactId viewId) {
        InterfaceStructureToken structure;
        try {
            structure = (InterfaceStructureToken)((Object)this.getAccessor().get(branch, artId, this.getFullFollowRelationDetails(), viewId));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            structure = InterfaceStructureToken.SENTINEL;
        }
        return structure;
    }

    @Override
    public InterfaceStructureToken get(BranchId branch, InterfaceConnection connection, ArtifactId structureId, ArtifactId viewId) {
        InterfaceStructureToken structure;
        try {
            structure = (InterfaceStructureToken)((Object)this.getAccessor().get(branch, structureId, this.getFullFollowRelationDetails(), viewId));
            structure = this.parseStructure(branch, connection, structure, viewId, structure.getElements());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            structure = InterfaceStructureToken.SENTINEL;
        }
        return structure;
    }

    @Override
    public Collection<InterfaceStructureToken> get(BranchId branch, Collection<ArtifactId> artIds, Collection<FollowRelation> followRelations) {
        try {
            return this.getAccessor().get(branch, artIds, followRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    @Override
    public InterfaceStructureToken getRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId structureId) {
        return this.getRelated(branch, connectionId, subMessageId, structureId, ArtifactId.SENTINEL);
    }

    @Override
    public InterfaceStructureToken getRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId structureId, ArtifactId viewId) {
        try {
            InterfaceStructureToken structure = (InterfaceStructureToken)((Object)this.getAccessor().getByRelation(branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, this.getFullFollowRelationDetails(), viewId));
            return this.parseStructure(branch, connectionId, structure, viewId, structure.getElements());
        }
        catch (Exception ex) {
            System.out.println(ex);
            return InterfaceStructureToken.SENTINEL;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, String filter) {
        List<InterfaceStructureToken> totalStructureList = new LinkedList<InterfaceStructureToken>();
        try {
            totalStructureList = this.getAllRelated(branch, connectionId, subMessageId);
            for (InterfaceStructureToken structure : totalStructureList) {
                structure = this.parseStructure(branch, connectionId, structure);
            }
            List<InterfaceStructureToken> structureList = totalStructureList;
            for (InterfaceStructureToken struct : structureList) {
                double sizeInBytes = struct.getSizeInBytes();
                int numElements = struct.getNumElements();
                LinkedList<InterfaceStructureElementToken> elementList = new LinkedList<InterfaceStructureElementToken>();
                for (InterfaceStructureElementToken element : struct.getElements()) {
                    ArtifactReadable art = element.getArtifactReadable();
                    List allAttributes = art.getExistingAttributeTypes().stream().map(a -> art.getAttributeValuesAsString(a)).filter(b -> b.toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
                    if (allAttributes.isEmpty()) continue;
                    elementList.add(element);
                }
                struct.setElements(elementList);
                struct.setSizeInBytes(sizeInBytes);
                struct.setNumElements(numElements);
            }
            return structureList;
        }
        catch (Exception exception) {
            return totalStructureList;
        }
    }

    @Override
    public InterfaceStructureToken getRelatedAndFilter(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId structureId, String filter) {
        return this.getRelatedAndFilter(branch, connectionId, subMessageId, structureId, filter, ArtifactId.SENTINEL);
    }

    @Override
    public InterfaceStructureToken getRelatedAndFilter(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId structureId, String filter, ArtifactId viewId) {
        try {
            InterfaceStructureToken structure = (InterfaceStructureToken)((Object)this.getAccessor().getByRelation(branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, this.getFullFollowRelationDetails(), viewId));
            return this.parseStructure(branch, connectionId, structure, filter);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return InterfaceStructureToken.SENTINEL;
        }
    }

    @Override
    public Collection<InterfaceStructureToken> query(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, false);
    }

    public List<FollowRelation> getFullFollowRelationDetails() {
        LinkedList<FollowRelation> followRelations = new LinkedList<FollowRelation>();
        followRelations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceStructureContent_DataElement));
        followRelations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement, (FollowRelation[])new FollowRelation[]{FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceEnumeration_EnumerationState)}));
        followRelations.addAll(FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceElementPlatformType_PlatformType, CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet, CoreRelationTypes.InterfaceEnumeration_EnumerationState}));
        return followRelations;
    }

    private List<FollowRelation> getFollowRelationDetails() {
        LinkedList<FollowRelation> followRelations = new LinkedList<FollowRelation>();
        followRelations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceStructureContent_DataElement));
        followRelations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement, (FollowRelation[])new FollowRelation[]{FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType)}));
        followRelations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType));
        return followRelations;
    }

    @Override
    public InterfaceStructureToken getMessageHeaderStructure(BranchId branch, ArtifactId connectionId, ArtifactId messageId, ArtifactId viewId) {
        InterfaceMessageToken message = this.interfaceMessageApi.getWithRelations(branch, messageId, Arrays.asList(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceSubMessageContent_Structure), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceStructureContent_DataElement), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement), FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayIndexDescriptionSet_Set), FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType)), viewId);
        InterfaceConnection connection = this.interfaceConnectionApi.get(branch, connectionId);
        return this.getMessageHeaderStructure(branch, connection, message);
    }

    @Override
    public InterfaceStructureToken getMessageHeaderStructure(BranchId branch, InterfaceConnection connection, InterfaceMessageToken message) {
        PlatformTypeToken offsetType;
        if (message.isInvalid()) {
            return InterfaceStructureToken.SENTINEL;
        }
        boolean shouldValidate = (Boolean)connection.getTransportType().getByteAlignValidation().getValue();
        int validationSize = (Integer)connection.getTransportType().getByteAlignValidationSize().getValue();
        ApplicabilityToken applic = message.getApplicability();
        String initiatingNode = "Node";
        if (message.getPublisherNodes().size() > 0) {
            initiatingNode = (String)message.getPublisherNodes().get(0).getName().getValue();
        }
        String messageNumber = (String)message.getInterfaceMessageNumber().getValue();
        Long id = 0L;
        InterfaceStructureCategoryAttribute categoryEnum = new InterfaceStructureCategoryAttribute();
        InterfaceStructureToken messageHeader = new InterfaceStructureToken(id, String.valueOf(initiatingNode) + " M" + messageNumber + " Header");
        messageHeader.setAutogenerated(true);
        messageHeader.setNameAbbrev("");
        messageHeader.setDescription("This structure represents the software interface header for " + initiatingNode + " initiated message " + messageNumber + ".  The " + initiatingNode + " shall send this structure each time its associated message is transmitted.");
        messageHeader.setInterfaceMinSimultaneity("1");
        messageHeader.setInterfaceMaxSimultaneity("1");
        messageHeader.setInterfaceTaskFileType(0);
        messageHeader.setInterfaceStructureCategory(String.valueOf(categoryEnum.Network.getIdString()) + " " + categoryEnum.Network.getName());
        messageHeader.setApplicability(applic);
        LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
        PlatformTypeToken doubleType = new PlatformTypeToken(0L, "DOUBLE", "double", "64", "0.0", "604800.0", "seconds");
        PlatformTypeToken messageNumberType = new PlatformTypeToken(0L, "UINTEGER", "unsigned integer", "32", messageNumber, messageNumber, "");
        InterfaceStructureElementToken timetag = new InterfaceStructureElementToken(id, "Timetag", applic, doubleType);
        timetag.setValidationSize(validationSize);
        timetag.setShouldValidate(shouldValidate);
        timetag.setDescription("Indicates the time that the message was prepared for transmission.");
        timetag.setInterfaceElementAlterable(true);
        elements.add(timetag);
        InterfaceStructureElementToken element = new InterfaceStructureElementToken(id, "Message Number", applic, messageNumberType);
        element.setValidationSize(validationSize);
        element.setShouldValidate(shouldValidate);
        element.setDescription("Indicates the message number for this message.");
        elements.add(element);
        HashMap submessageStructures = new HashMap();
        for (InterfaceSubMessageToken subMessage : message.getSubMessages()) {
            String number = (String)subMessage.getInterfaceSubMessageNumber().getValue();
            List structures = subMessage.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceSubMessageContent_Structure).stream().map(s -> new InterfaceStructureToken((ArtifactReadable)s)).collect(Collectors.toList());
            submessageStructures.put(subMessage.getArtifactId(), structures);
            PlatformTypeToken structuresType = new PlatformTypeToken(0L, "UINTEGER", "unsigned integer", "32", "", "", "");
            if (structures.size() == 1) {
                structuresType.setInterfacePlatformTypeMinval(((InterfaceStructureToken)((Object)structures.get(0))).getInterfaceMinSimultaneity());
                structuresType.setInterfacePlatformTypeMaxval(((InterfaceStructureToken)((Object)structures.get(0))).getInterfaceMaxSimultaneity());
            } else {
                Integer minSimult = null;
                Integer maxSimult = null;
                for (InterfaceStructureToken struct : structures) {
                    String min = (String)struct.getInterfaceMinSimultaneity().getValue();
                    String max = (String)struct.getInterfaceMaxSimultaneity().getValue();
                    if (Strings.isNumeric((String)min) && Strings.isNumeric((String)max)) {
                        minSimult = minSimult == null ? Integer.parseInt(min) : minSimult + Integer.parseInt(min);
                        maxSimult = maxSimult == null ? Integer.parseInt(max) : maxSimult + Integer.parseInt(max);
                        continue;
                    }
                    structuresType.setInterfacePlatformTypeValidRangeDescription("Calculated");
                }
                if (minSimult != null && maxSimult != null) {
                    structuresType.setInterfacePlatformTypeMinval("" + minSimult);
                    structuresType.setInterfacePlatformTypeMaxval("" + maxSimult);
                }
            }
            element = new InterfaceStructureElementToken(id, "Number of Structures in Submessage " + number, applic, structuresType);
            if (!structuresType.getInterfacePlatformTypeMinval().equals(structuresType.getInterfacePlatformTypeMaxval())) {
                element.setInterfaceElementAlterable(true);
            }
            element.setValidationSize(validationSize);
            element.setShouldValidate(shouldValidate);
            element.setDescription("Indicates the number of structures in the submessage for a given transmission of it's message.");
            elements.add(element);
            offsetType = new PlatformTypeToken(0L, "UINTEGER", "unsigned integer", "32", "", "", "");
            element = new InterfaceStructureElementToken(id, "Submessage " + number + " Relative Offset", applic, offsetType);
            element.setDescription("Indicates the byte offset from the beginning of the message to the start of the submessage data.");
            element.setValidationSize(validationSize);
            element.setShouldValidate(shouldValidate);
            elements.add(element);
        }
        this.parseStructure(branch, connection, messageHeader, elements);
        messageHeader.getElements().stream().forEach(e -> {
            e.setIncludedInCounts(true);
            e.setShouldValidate(shouldValidate);
            e.setValidationSize(validationSize);
            if (((String)e.getName().getValue()).equals("Insert Spare")) {
                PlatformTypeToken spareType = new PlatformTypeToken(0L, "UINTEGER", "unsigned integer", "32", "", "", "");
                spareType.setInterfacePlatformTypeValidRangeDescription("n/a");
                e.setName("Byte Alignment Spare");
                e.setPlatformType(spareType);
                e.setInterfaceElementIndexStart(0);
                e.setInterfaceElementIndexEnd(0);
            }
        });
        messageHeader.setElements(messageHeader.getElements());
        int offset = (int)messageHeader.getSizeInBytes().doubleValue();
        int submessageNumber = 1;
        int offsetIndex = submessageNumber * 2 + 1;
        boolean isCalculated = false;
        while (offsetIndex < messageHeader.getElements().size()) {
            InterfaceStructureElementToken offsetElement = messageHeader.getElements().get(offsetIndex);
            offsetType = offsetElement.getPlatformType();
            if (isCalculated) {
                offsetType.setInterfacePlatformTypeValidRangeDescription("Calculated");
                offsetElement.setInterfaceElementAlterable(true);
            } else {
                offsetType.setInterfacePlatformTypeMinval(String.valueOf(offset));
                offsetType.setInterfacePlatformTypeMaxval(String.valueOf(offset));
                InterfaceStructureElementToken numStructsElement = messageHeader.getElements().get(offsetIndex - 1);
                String minNumElements = (String)numStructsElement.getPlatformType().getInterfacePlatformTypeMinval().getValue();
                String maxNumElements = (String)numStructsElement.getPlatformType().getInterfacePlatformTypeMaxval().getValue();
                if (Strings.isNumeric((String)minNumElements) && Strings.isNumeric((String)maxNumElements) && minNumElements.equals(maxNumElements)) {
                    InterfaceSubMessageToken submessage = (InterfaceSubMessageToken)((Object)((List)message.getSubMessages()).get(submessageNumber - 1));
                    for (InterfaceStructureToken structure : (List)submessageStructures.get(submessage.getArtifactId())) {
                        offset = (int)((double)offset + structure.getSizeInBytes() * (double)Integer.parseInt((String)structure.getInterfaceMaxSimultaneity().getValue()));
                    }
                } else {
                    isCalculated = true;
                }
            }
            offsetIndex = ++submessageNumber * 2 + 1;
        }
        return messageHeader;
    }

    @Override
    public Collection<InterfaceStructureToken> queryExact(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceStructureToken> query(BranchId branch, AttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<InterfaceStructureToken> query(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureToken> queryExact(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureToken> query(BranchId branch, AttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            List<InterfaceStructureToken> structureList = new LinkedList();
            structureList = (List)this.getAccessor().getAllByQuery(branch, query, this.getFullFollowRelationDetails(), isExact, pageNum, pageSize);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, ArtifactId.valueOf((Long)-1L), structure);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    @Override
    public List<InterfaceStructureToken> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureToken> getAllWithoutRelations(BranchId branch, long pageNum, long pageSize) {
        return this.getAllWithoutRelations(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureToken> getFiltered(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getFiltered(branch, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureToken> getFilteredWithoutRelations(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getFilteredWithoutRelations(branch, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, long pageNum, long pageSize) {
        return this.getAllRelated(branch, connectionId, subMessageId, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId subMessageId, String filter, long pageNum, long pageSize) {
        return null;
    }

    @Override
    public List<InterfaceStructureToken> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getAllWithoutRelations(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAllWithoutRelations(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getFiltered(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getFiltered(branch, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getFilteredWithoutRelations(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getFilteredWithoutRelations(branch, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, AttributeTypeId orderByAttribute) {
        return this.getAllRelated(branch, connectionId, subMessageId, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId subMessageId, String filter, AttributeTypeId orderByAttribute) {
        return null;
    }

    @Override
    public List<InterfaceStructureToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAll(branch, this.getFullFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, ArtifactId.valueOf((Long)-1L), structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllWithoutRelations(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAll(branch, this.getFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllWithRelations(BranchId branch, List<FollowRelation> followRelations, String filter, Collection<AttributeTypeId> attributes, AttributeTypeId orderByAttribute) {
        try {
            return (List)this.getAccessor().getAll(branch, followRelations, filter, attributes, 0L, 0L, orderByAttribute);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    @Override
    public List<InterfaceStructureToken> getFiltered(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByFilter(branch, filter, this.structureAttributeList, this.getFullFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, ArtifactId.valueOf((Long)-1L), structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getFilteredWithoutRelations(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByFilter(branch, filter, this.structureAttributeList, this.getFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllRelated(branch, connectionId, subMessageId, ArtifactId.SENTINEL, pageNum, pageSize, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, this.getFullFollowRelationDetails(), pageNum, pageSize, orderByAttribute, viewId);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, connectionId, structure, viewId, structure.getElements());
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public int getAllRelatedCount(BranchId branch, ArtifactId subMessageId) {
        int count = 0;
        try {
            count = this.getAccessor().getAllByRelationAndCount(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId);
            return count;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return 0;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllRelatedAndFilter(branch, connectionId, subMessageId, ArtifactId.SENTINEL, filter, pageNum, pageSize, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId connectionId, ArtifactId subMessageId, ArtifactId viewId, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, filter, this.structureAttributeList, this.getFullFollowRelationDetails(), pageNum, pageSize, orderByAttribute, this.elementAttributeList);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, connectionId, structure, viewId, structure.getElements());
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public int getAllRelatedAndFilterCount(BranchId branch, ArtifactId subMessageId, String filter) {
        int count = 0;
        try {
            count = this.getAccessor().getAllByRelationAndFilterAndCount(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, filter, this.structureAttributeList, this.getFollowRelationDetails(), this.elementAttributeList);
            return count;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return 0;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllByName(BranchId branch, String name, long pageNum, long pageSize) {
        try {
            return (List)this.getAccessor().getAll(branch, new LinkedList(), name, Arrays.asList(CoreAttributeTypes.Name), pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.Name);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    @Override
    public int getAllByNameCount(BranchId branch, String name) {
        return this.getAccessor().getAllByFilterAndCount(branch, name, Arrays.asList(CoreAttributeTypes.Name));
    }

    @Override
    public Collection<InterfaceStructureToken> getAllwithNoSubMessageRelations(BranchId branch, String filter, long pageNum, long pageSize) {
        LinkedList<RelationTypeSide> rel = new LinkedList<RelationTypeSide>();
        rel.add(CoreRelationTypes.InterfaceSubMessageContent_Structure);
        try {
            return this.getAccessor().getAllLackingRelationByFilter(branch, filter, this.structureAttributeList, rel, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    @Override
    public int getAllwithNoSubMessageRelationsCount(BranchId branch, String filter) {
        LinkedList<RelationTypeSide> rel = new LinkedList<RelationTypeSide>();
        rel.add(CoreRelationTypes.InterfaceSubMessageContent_Structure);
        return this.getAccessor().getAllLackingRelationByFilterAndCount(branch, filter, this.structureAttributeList, rel);
    }
}

