/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcException;

public class JdbcDbType
extends BaseId {
    public static final JdbcDbType h2 = new JdbcDbType(1);
    public static final JdbcDbType oracle = new JdbcDbType(2);
    public static final JdbcDbType foxpro = new JdbcDbType(3);
    public static final JdbcDbType mysql = new JdbcDbType(4);
    public static final JdbcDbType postgresql = new JdbcDbType(5);
    public static final JdbcDbType hsql = new JdbcDbType(6);
    public static final JdbcDbType sqlite = new JdbcDbType(7);
    private final boolean hintsSupported;

    private JdbcDbType(int id) {
        this(Long.valueOf(id), false);
    }

    private JdbcDbType(Long id, boolean hintsSupported) {
        super(id);
        this.hintsSupported = hintsSupported;
    }

    public static JdbcDbType getDbType(JdbcConnection connection) {
        return JdbcDbType.getDbType(connection.getMetaData());
    }

    public static JdbcDbType getDbType(DatabaseMetaData metaData) {
        try {
            JdbcDbType dbType;
            String dbName = metaData.getDatabaseProductName();
            String lowerCaseName = dbName.toLowerCase();
            if (lowerCaseName.contains("h2")) {
                dbType = h2;
            } else if (lowerCaseName.contains("oracle")) {
                dbType = oracle;
            } else if (lowerCaseName.contains("foxpro")) {
                dbType = foxpro;
            } else if (lowerCaseName.contains("mysql")) {
                dbType = mysql;
            } else if (lowerCaseName.contains("postgresql")) {
                dbType = postgresql;
            } else if (lowerCaseName.contains("hsql")) {
                dbType = hsql;
            } else if (lowerCaseName.contains("sqlite")) {
                dbType = sqlite;
            } else {
                throw JdbcException.newJdbcException("Unsupported database type [%s] ", dbName);
            }
            boolean hintsSupported = dbType.equals((Object)oracle) && metaData.getDatabaseMajorVersion() > 10;
            return new JdbcDbType(dbType.getId(), hintsSupported);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    public boolean areHintsSupported() {
        return this.hintsSupported;
    }

    public String getRegularExpMatchSql(String field) {
        if (this.equals((Object)oracle)) {
            return "REGEXP_LIKE (" + field + ", ?)";
        }
        if (this.equals((Object)hsql)) {
            return "REGEXP_MATCHES (" + field + ", ?)";
        }
        if (this.equals((Object)postgresql)) {
            return "exists (select * from REGEXP_MATCHES (" + field + ", ?))";
        }
        if (this.equals((Object)mysql)) {
            return "(" + field + " REGEXP ?)";
        }
        throw JdbcException.newJdbcException("RegExp matching is not supported for db [%s]", new Object[]{this});
    }

    public String getRecursiveWithSql() {
        if (this.matches(new Id[]{oracle, hsql})) {
            return "";
        }
        return "RECURSIVE";
    }

    public String getStringConversion() {
        if (this.matches(new Id[]{postgresql})) {
            return "::varchar(255)";
        }
        return "";
    }

    public String getRowNum() {
        if (this.matches(new Id[]{postgresql})) {
            return "row_number() over ()";
        }
        return "rownum";
    }

    public String getLimitRowsReturned(int limit) {
        if (this.matches(new Id[]{oracle, hsql})) {
            return " and rownum < " + limit;
        }
        return " limit " + limit;
    }

    public String getExpireDateDays(int expireLengthInDays) {
        if (this.matches(new Id[]{oracle, hsql})) {
            return "TRUNC(SYSDATE) - " + expireLengthInDays;
        }
        return "current_timestamp - interval '" + expireLengthInDays + " day'";
    }

    public String getInStringSql(String str, String searchString) {
        if (this.matches(new Id[]{oracle, hsql})) {
            return "instr(" + str + "," + searchString + ")";
        }
        return "strpos(" + str + "," + searchString + ")";
    }

    public String getCteRecursiveUnion() {
        return this.equals((Object)hsql) ? "UNION" : "UNION ALL";
    }

    public String getComplementSql() {
        return this.equals((Object)oracle) ? "MINUS" : "EXCEPT";
    }

    public String getValidationSql() {
        if (this.matches(new Id[]{oracle, h2})) {
            return "select 1 from dual";
        }
        if (this.matches(new Id[]{hsql})) {
            return "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        return "select 1";
    }

    public String getConstraintCheckingSql(boolean enable) {
        String value;
        String cmd;
        if (this.equals((Object)h2)) {
            cmd = "SET REFERENTIAL_INTEGRITY = %s";
            value = Boolean.toString(enable).toUpperCase();
        } else if (this.equals((Object)hsql)) {
            cmd = "SET DATABASE REFERENTIAL INTEGRITY %s";
            value = Boolean.toString(enable).toUpperCase();
        } else {
            cmd = "SET CONSTRAINTS ALL %s";
            value = enable ? "IMMEDIATE" : "DEFERRED";
        }
        return String.format(cmd, value);
    }

    public String getFunctionCallSql(String function) {
        if (this.equals((Object)oracle)) {
            return String.format("{ ? = call %s }", function);
        }
        return String.format("call %s", function);
    }

    public boolean isPaginationOrderingSupported() {
        return !this.matches(new Id[]{hsql});
    }

    public String getPostgresRecurse() {
        if (this.matches(new Id[]{postgresql})) {
            return " recursive";
        }
        return " ";
    }

    public String getPostgresCastStart() {
        if (this.matches(new Id[]{postgresql})) {
            return "CAST(";
        }
        return " ";
    }

    public String getPostgresCastVarCharEnd() {
        if (this.matches(new Id[]{postgresql})) {
            return "as varchar)";
        }
        return " ";
    }

    public String getPostgresCastBigIntEnd() {
        if (this.matches(new Id[]{postgresql})) {
            return "as bigint)";
        }
        return " ";
    }

    public String json_agg(String sqlToAggregate) {
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "jsonb_agg (";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "json_arrayagg (";
        }
        result = String.valueOf(result) + sqlToAggregate;
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + " returning clob ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String jsonb_array(String ... data) {
        int i;
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "jsonb_build_array(";
            i = 0;
            while (i < data.length) {
                result = String.valueOf(result) + " " + data[i] + " ";
                if (i < data.length - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
            result = String.valueOf(result) + ")";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "json_array(";
            i = 0;
            while (i < data.length) {
                result = String.valueOf(result) + " " + data[i] + " ";
                if (i < data.length - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
            result = String.valueOf(result) + " returning clob)";
        }
        return result;
    }

    public String jsonb_object(String ... data) {
        boolean keyOrValue;
        int i;
        if (data.length % 2 != 0) {
            throw new OseeArgumentException("Improper count of keys to create json object", (Object[])data);
        }
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "jsonb_build_object (";
            i = 0;
            while (i < data.length) {
                boolean bl = keyOrValue = i % 2 != 0;
                if (!keyOrValue) {
                    result = String.valueOf(result) + " '" + data[i] + "' ,";
                } else {
                    result = String.valueOf(result) + " " + data[i] + " ";
                    if (i < data.length - 2) {
                        result = String.valueOf(result) + ",";
                    }
                }
                ++i;
            }
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "json_object (";
            i = 0;
            while (i < data.length) {
                boolean bl = keyOrValue = i % 2 != 0;
                if (!keyOrValue) {
                    result = String.valueOf(result) + " key '" + data[i] + "' ";
                } else {
                    result = String.valueOf(result) + " value " + data[i] + " ";
                    if (i < data.length - 2) {
                        result = String.valueOf(result) + ",";
                    }
                }
                ++i;
            }
            result = String.valueOf(result) + " returning clob ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String json_object(String ... data) {
        boolean keyOrValue;
        int i;
        if (data.length % 2 != 0) {
            throw new OseeArgumentException("Improper count of keys to create json object", (Object[])data);
        }
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "json_build_object (";
            i = 0;
            while (i < data.length) {
                boolean bl = keyOrValue = i % 2 != 0;
                if (!keyOrValue) {
                    result = String.valueOf(result) + " '" + data[i] + "' ,";
                } else {
                    result = String.valueOf(result) + " " + data[i] + " ";
                    if (i < data.length - 2) {
                        result = String.valueOf(result) + ",";
                    }
                }
                ++i;
            }
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "json_object (";
            i = 0;
            while (i < data.length) {
                boolean bl = keyOrValue = i % 2 != 0;
                if (!keyOrValue) {
                    result = String.valueOf(result) + " key '" + data[i] + "' ";
                } else {
                    result = String.valueOf(result) + " value " + data[i] + " ";
                    if (i < data.length - 2) {
                        result = String.valueOf(result) + ",";
                    }
                }
                ++i;
            }
            result = String.valueOf(result) + " returning clob ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String jsonObjectContains(String value, String tableColumn, String jsonColumn) {
        String result = "";
        result = this.matches(new Id[]{postgresql}) ? " exists (select 1 from jsonb_array_elements(" + tableColumn + ") t1 where t1->>'value'::text like ?)" : "DBMS_LOB.INSTR( " + tableColumn + ", ? ) > 0";
        return result;
    }

    public String getJsonObjectContainsParameter(String value) {
        if (this.matches(new Id[]{postgresql})) {
            return "%" + value + "%";
        }
        return value;
    }

    public String cast(String value, String type) {
        String result = "";
        if (this.matches(new Id[]{postgresql}) || this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "CAST( " + value + " AS " + type + ")";
        }
        return result;
    }

    public String longToString() {
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "TEXT";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "varchar(20)";
        }
        return result;
    }

    public String split_part(String stringToSplit, String characterToSplitBy, long index) {
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "split_part(" + stringToSplit + ", '" + characterToSplitBy + "', " + index + ")";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "substr(" + stringToSplit + ", " + index + ", " + "instr(" + stringToSplit + ", '" + characterToSplitBy + "')" + "-2" + ")";
        }
        return result;
    }

    public String booleanTrue() {
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "true";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "1";
        }
        return result;
    }

    public String booleanFalse() {
        String result = "";
        if (this.matches(new Id[]{postgresql})) {
            result = String.valueOf(result) + "false";
        }
        if (this.matches(new Id[]{oracle})) {
            result = String.valueOf(result) + "0";
        }
        return result;
    }
}

