/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.xml.publishing.AbstractXmlNameSpecification;
import org.eclipse.osee.framework.core.xml.publishing.AbstractXmlNamespaceSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlAttributeSpecification;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

class AbstractXmlTagSpecification
extends AbstractXmlNameSpecification {
    final @NonNull Set<@NonNull XmlAttributeSpecification> attributes;
    final @NonNull String closeTag;
    final @NonNull String openTag;
    final @NonNull String regexOpenTag;
    final @NonNull String selfCloseTag;
    final int sizeBothTags;
    final int sizeCloseTag;
    final int sizeSelfCloseTag;
    final int sizeOpenTag;

    AbstractXmlTagSpecification(@NonNull AbstractXmlNamespaceSpecification abstractXmlNamespaceSpecification, @NonNull String tagName) {
        this(abstractXmlNamespaceSpecification, tagName, Set.of());
    }

    AbstractXmlTagSpecification(@NonNull AbstractXmlNamespaceSpecification abstractXmlNamespaceSpecification, @NonNull String tagName, @NonNull Set<@NonNull XmlAttributeSpecification> wordXmlAttributes) {
        super(abstractXmlNamespaceSpecification, tagName);
        Set safeWordXmlAttributes;
        Conditions.require((Object)tagName, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"tagName", (String)"cannot be null or blank", Strings::isInvalidOrBlank, IllegalArgumentException::new);
        this.attributes = safeWordXmlAttributes = (Set)Conditions.require(wordXmlAttributes, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"wordXmlAttributes", (String)"cannot be null or cannot contain null entries", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, Conditions::collectionContainsNull}), NullPointerException::new);
        this.openTag = "<" + this.fullName + ">";
        this.closeTag = "</" + this.fullName + ">";
        this.selfCloseTag = "<" + this.fullName + "/>";
        this.regexOpenTag = "<" + this.fullName + "[^>]*>";
        this.sizeOpenTag = this.openTag.length();
        this.sizeCloseTag = this.closeTag.length();
        this.sizeBothTags = this.sizeOpenTag + this.sizeCloseTag;
        this.sizeSelfCloseTag = this.selfCloseTag.length();
    }
}

