/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Objects;

public class InvalidPublishOptionsException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String jsonPublishOptionsString;
    private String publishingTemplateIdentifier;
    private String publishingTemplateName;

    public InvalidPublishOptionsException(String jsonPublishOptionsString) {
        this.jsonPublishOptionsString = jsonPublishOptionsString;
        this.publishingTemplateIdentifier = null;
        this.publishingTemplateName = null;
    }

    public InvalidPublishOptionsException(String jsonPublishOptionsString, Throwable cause) {
        this.initCause(cause);
        this.jsonPublishOptionsString = jsonPublishOptionsString;
        this.publishingTemplateIdentifier = null;
        this.publishingTemplateName = null;
    }

    @Override
    public String getMessage() {
        return InvalidPublishOptionsException.buildMessage(this.jsonPublishOptionsString, this.publishingTemplateIdentifier, this.publishingTemplateName);
    }

    public void setPublishingTemplateInformation(String identifier, String name) {
        this.publishingTemplateIdentifier = identifier;
        this.publishingTemplateName = name;
    }

    public static String buildMessage(String jsonPublishOptionsString, String publishingTemplateIdentifier, String publishingTemplateName) {
        return new StringBuilder(1024).append("\n").append("Invalid JSON Publish Options string.").append("\n").append("   Publishing Template Identifier: ").append(Objects.nonNull(publishingTemplateIdentifier) ? publishingTemplateIdentifier : "(null)").append("\n").append("   Publishing Template Name:       ").append(Objects.nonNull(publishingTemplateName) ? publishingTemplateName : "(null)").append("\n").append("   JSON Follows:").append("\n").append("\n").append(jsonPublishOptionsString).append("\n").append("\n").toString();
    }
}

