/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.data.MaterialColors;
import org.eclipse.osee.framework.core.data.MaterialShades;
import org.eclipse.osee.framework.core.data.MaterialVariant;

public class MaterialIcon {
    public static MaterialIcon SENTINEL = new MaterialIcon("padding", MaterialColors.NONE, MaterialShades.NONE, MaterialVariant.NONE);
    private final String icon;
    private final MaterialColors color;
    private final MaterialShades lightShade;
    private final MaterialShades darkShade;
    private final MaterialVariant variant;

    public MaterialIcon(String icon) {
        this.icon = icon;
        this.color = MaterialColors.NONE;
        this.lightShade = MaterialShades.NONE;
        this.darkShade = MaterialShades.NONE;
        this.variant = MaterialVariant.NONE;
    }

    public MaterialIcon(String icon, MaterialColors color, MaterialShades shade) {
        this(icon, color, shade, shade, MaterialVariant.NONE);
    }

    public MaterialIcon(String icon, MaterialColors color, MaterialShades shade, MaterialVariant variant) {
        this(icon, color, shade, shade, variant);
    }

    public MaterialIcon(String icon, MaterialColors color, MaterialShades lightShade, MaterialShades darkShade, MaterialVariant variant) {
        this.icon = icon;
        this.color = color;
        this.lightShade = lightShade;
        this.darkShade = darkShade;
        this.variant = variant;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color.getValue();
    }

    public String getLightShade() {
        return this.lightShade.getValue();
    }

    public String getDarkShade() {
        return this.darkShade.getValue();
    }

    public String getVariant() {
        return this.variant.getValue();
    }
}

