/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.Zip;

public class MapEntryAttributeUtil {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Map.Entry<String, String> EMPTY_MAP_ENTRY = Map.entry("", "");
    public static final Charset MAP_ENTRY_CHARSET = StandardCharsets.UTF_8;
    private static Class<Map.Entry<String, String>> mapEntryClass = Map.Entry.class;
    private static final ObjectMapper objectMapper = MapEntryAttributeUtil.create();

    private static ObjectMapper create() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule mapEntryDeserializerSimpleModule = new SimpleModule("MapEntryDeserializer", new Version(1, 0, 0, null, null, null));
        mapEntryDeserializerSimpleModule.addDeserializer(mapEntryClass, (JsonDeserializer)new MapEntryDeserializer());
        SimpleModule mapEntrySerializerSimpleModule = new SimpleModule("MapEntrySerializer", new Version(1, 0, 0, null, null, null));
        mapEntrySerializerSimpleModule.addSerializer(mapEntryClass, (JsonSerializer)new MapEntrySerializer());
        objectMapper.registerModule((Module)mapEntryDeserializerSimpleModule);
        objectMapper.registerModule((Module)mapEntrySerializerSimpleModule);
        return objectMapper;
    }

    public static boolean isValidMapEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry mapEntry = (Map.Entry)object;
        Object key = mapEntry.getKey();
        Object value = mapEntry.getValue();
        return Strings.isValidAndNonBlank(key) && value instanceof String;
    }

    public static boolean isValidMapEntryStorageString(Object object) {
        return Strings.isValidAndNonBlank((Object)object);
    }

    public static Map.Entry<String, String> jsonDecode(String input) {
        if (Objects.isNull(input)) {
            throw new OseeCoreException("MapEntryAttributeUtil::jsonDecode, the parameter \"input\" cannot be null.", new Object[0]);
        }
        if (input.isBlank()) {
            return EMPTY_MAP_ENTRY;
        }
        try {
            Map.Entry mutableMapEntry = (Map.Entry)objectMapper.readValue(input, mapEntryClass);
            Map.Entry<String, String> immutableFoldableMapEntry = Map.entry((String)mutableMapEntry.getKey(), (String)mutableMapEntry.getValue());
            return immutableFoldableMapEntry;
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"MapEntryAttributeUtil::jsonDecode, failed to create object from the string value.").indentInc().follows((CharSequence)"JSON String", (CharSequence)input).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    public static String jsonEncode(Map.Entry<String, String> mapEntry) {
        if (Objects.isNull(mapEntry)) {
            throw new OseeCoreException("MapEntryAttributeUtil::jsonEncode, the parameter \"mapEntry\" cannot be null.", new Object[0]);
        }
        try {
            String storageString = objectMapper.writeValueAsString(mapEntry);
            return storageString;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private MapEntryAttributeUtil() {
    }

    public static class LocalData {
        private int size;
        private Map.Entry<String, String> mapEntry;
        private byte[] storageBytes;
        private String storageString;

        public LocalData() {
            this.clear();
        }

        public void clear() {
            this.size = -1;
            this.mapEntry = EMPTY_MAP_ENTRY;
            this.storageBytes = EMPTY_BYTE_ARRAY;
            this.storageString = "";
        }

        public Map.Entry<String, String> getMapEntry() {
            return this.mapEntry;
        }

        public byte[] getStorageBytes() {
            return Arrays.copyOf(this.storageBytes, this.storageBytes.length);
        }

        public String getStorageString() {
            return this.storageString;
        }

        public boolean isDataValid() {
            return this.size >= 0;
        }

        public boolean isEqual(Map.Entry<String, String> otherMapEntry) {
            return this.isDataValid() && MapEntryAttributeUtil.isValidMapEntry(otherMapEntry) ? this.mapEntry.equals(otherMapEntry) : false;
        }

        public void set(Map.Entry<String, String> mapEntry) {
            if (!MapEntryAttributeUtil.isValidMapEntry(mapEntry)) {
                this.clear();
                return;
            }
            try {
                String storageString = MapEntryAttributeUtil.jsonEncode(mapEntry);
                byte[] storageBytes = storageString.getBytes(MAP_ENTRY_CHARSET);
                Map.Entry<String, String> immutableFoldableMapEntry = Map.entry(mapEntry.getKey(), mapEntry.getValue());
                this.mapEntry = immutableFoldableMapEntry;
                this.storageString = storageString;
                this.storageBytes = storageBytes;
                this.size = this.storageString.length();
            }
            catch (Exception exception) {
                this.clear();
            }
        }

        public void set(String storageString) {
            if (!MapEntryAttributeUtil.isValidMapEntryStorageString(storageString)) {
                this.clear();
                return;
            }
            try {
                Map.Entry<String, String> immutableFoldableMapEntry = MapEntryAttributeUtil.jsonDecode(storageString);
                String normalizedStorageString = MapEntryAttributeUtil.jsonEncode(this.mapEntry);
                byte[] storageBytes = normalizedStorageString.getBytes(MAP_ENTRY_CHARSET);
                this.mapEntry = immutableFoldableMapEntry;
                this.storageString = normalizedStorageString;
                this.storageBytes = storageBytes;
                this.size = this.storageString.length();
            }
            catch (Exception exception) {
                this.clear();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean setFromCompressed(byte[] compressedContent) {
            if (Objects.isNull(compressedContent) || compressedContent.length <= 0) {
                this.clear();
                return false;
            }
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ByteArrayInputStream dataStoreRawContentByteArrayInputStream = new ByteArrayInputStream(compressedContent);){
                    byte[] storageBytes = Zip.decompressBytes((InputStream)dataStoreRawContentByteArrayInputStream);
                    if (Objects.isNull(storageBytes) || storageBytes.length <= 0) {
                        this.clear();
                        return false;
                    }
                    String storageString = new String(storageBytes, MAP_ENTRY_CHARSET);
                    if (!MapEntryAttributeUtil.isValidMapEntryStorageString(storageString)) {
                        this.clear();
                        return false;
                    }
                    Map.Entry<String, String> immutableFoldableMapEntry = MapEntryAttributeUtil.jsonDecode(storageString);
                    this.mapEntry = immutableFoldableMapEntry;
                    this.storageString = storageString;
                    this.storageBytes = storageBytes;
                    this.size = this.storageString.length();
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.clear();
                return false;
            }
        }

        public int size() {
            return this.size >= 0 ? this.size : 0;
        }
    }

    private static class MapEntryDeserializer
    extends StdDeserializer<Map.Entry<String, String>> {
        private static final long serialVersionUID = 1L;

        public MapEntryDeserializer() {
            super(null);
        }

        public MapEntryDeserializer(Class<Map.Entry<String, String>> mapEntryClass) {
            super(mapEntryClass);
        }

        public Map.Entry<String, String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            String key = jsonNode.get("key").asText();
            String value = jsonNode.get("value").asText();
            return Map.entry(key, value);
        }
    }

    private static class MapEntrySerializer
    extends StdSerializer<Map.Entry<String, String>> {
        private static final long serialVersionUID = 1L;

        public MapEntrySerializer() {
            super(null);
        }

        public MapEntrySerializer(Class<Map.Entry<String, String>> mapEntryClass) {
            super(mapEntryClass);
        }

        public void serialize(Map.Entry<String, String> mapEntry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("key", mapEntry.getKey());
            jsonGenerator.writeStringField("value", mapEntry.getValue());
            jsonGenerator.writeEndObject();
        }
    }
}

