/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AttributeTypeEnum<T extends EnumToken>
extends AttributeTypeGeneric<T> {
    private final List<T> enumTokens;

    public AttributeTypeEnum(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType, int enumCount, DisplayHint ... hints) {
        super(id, namespace, name, mediaType, description, taggerType, "", null, null, hints);
        this.enumTokens = new ArrayList<T>(enumCount);
    }

    protected void addEnum(T enumeration) {
        this.enumTokens.add(enumeration);
    }

    <E extends T> void appendEnumValues(AttributeTypeEnum<E> attributeType) {
        List<T> newEnumTokens = attributeType.enumTokens;
        for (EnumToken enumValue : newEnumTokens) {
            if (this.containsEnumWithName(enumValue.getName())) continue;
            this.enumTokens.add((T)((Object)enumValue));
        }
    }

    private boolean containsEnumWithName(String name) {
        for (EnumToken enumValue : this.enumTokens) {
            if (!enumValue.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public AttributeTypeEnum<EnumToken> getAsEnumToken() {
        return this;
    }

    public Optional<T> getEnum(String name) {
        for (EnumToken enumToken : this.enumTokens) {
            if (!enumToken.getName().equals(name)) continue;
            return Optional.of(enumToken);
        }
        return Optional.empty();
    }

    public Optional<T> getEnum(int ordinal) {
        for (EnumToken enumToken : this.enumTokens) {
            if (enumToken.getIdIntValue() != ordinal) continue;
            return Optional.of(enumToken);
        }
        return Optional.empty();
    }

    public Long getEnumOrdinal(String enumName) {
        for (EnumToken enumToken : this.enumTokens) {
            if (!enumToken.getName().equals(enumName)) continue;
            return enumToken.getId();
        }
        throw new OseeArgumentException("[%s] is not a valid enum name for [%s]", new Object[]{enumName, this});
    }

    public List<String> getEnumStrValues() {
        ArrayList<String> enumStringValues = new ArrayList<String>();
        for (EnumToken enumToken : this.enumTokens) {
            enumStringValues.add(enumToken.getName());
        }
        return enumStringValues;
    }

    public Collection<T> getEnumValues() {
        return Collections.unmodifiableCollection(this.enumTokens);
    }

    public Collection<T> getEnumValuesByNamespace(NamespaceToken namespace) {
        ArrayList<EnumToken> enumValues = new ArrayList<EnumToken>();
        for (EnumToken enumToken : this.enumTokens) {
            for (NamespaceToken currentEnumNamespace : enumToken.getNamespaces()) {
                if (!currentEnumNamespace.equals(namespace) && !currentEnumNamespace.equals(NamespaceToken.SENTINEL) && !currentEnumNamespace.equals(NamespaceToken.OSEE)) continue;
                enumValues.add(enumToken);
            }
        }
        return Collections.unmodifiableCollection(enumValues);
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    public boolean isValidEnum(ArtifactTypeToken artTypeToken, String enumName) {
        for (EnumToken enumToken : artTypeToken.getValidEnumValues(this)) {
            if (!enumToken.getName().equals(enumName)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidEnum(String enumName) {
        for (EnumToken enumToken : this.enumTokens) {
            if (!enumToken.getName().equals(enumName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFromStorageString(String storedValue) {
        for (EnumToken enumToken : this.enumTokens) {
            if (enumToken == null || !enumToken.getName().equals(storedValue)) continue;
            return (T)((Object)enumToken);
        }
        EnumToken enumeration = (EnumToken)((EnumToken)((Object)this.enumTokens.get(0))).clone(Long.valueOf(this.enumTokens.size()));
        enumeration.setName(storedValue);
        this.addEnum(enumeration);
        return (T)((Object)enumeration);
    }
}

