/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.importing;

import java.util.regex.Matcher;
import org.eclipse.osee.define.rest.api.importing.BlockFieldToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class BlockField {
    protected String data;
    protected final BlockFieldToken bft;
    protected boolean match = false;
    protected boolean created = false;

    public BlockField(BlockFieldToken bft) {
        this.bft = bft;
        this.data = "";
    }

    public BlockField fillContent(String content) {
        Conditions.assertNotNullOrEmpty((String)content, (String)"null content in add content to block", (Object[])new Object[0]);
        String strippedContent = content.replaceAll("<[^>]+>", "").replaceAll("&amp;", "&");
        Matcher contentMatcher = this.bft.contentRegex.matcher(strippedContent);
        if (contentMatcher.find()) {
            this.data = contentMatcher.group(1);
            this.match = true;
        } else {
            this.data = "";
        }
        return this;
    }

    public void appendContent(String content, boolean first) {
        String newline = "";
        if (!first && Strings.isValid((String)this.data)) {
            newline = "\n";
        }
        this.data = String.valueOf(this.data) + newline + content;
    }

    public String getImportTypeName() {
        return this.bft.getName();
    }

    public Long getId() {
        return this.bft.getId();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public AttributeTypeToken getOseeType() {
        return this.bft.getOseeType();
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean value) {
        this.match = value;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean value) {
        this.created = value;
    }
}

