/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.AtsConstants;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;

public class RestoreActionsFromTasksOperation {
    private final TasksFromAction tfa;
    private final AtsApi atsApi;

    public RestoreActionsFromTasksOperation(TasksFromAction tfa, AtsApi atsApi) {
        this.tfa = tfa;
        this.atsApi = atsApi;
    }

    public TasksFromAction run() {
        this.restore();
        return this.tfa;
    }

    private void restore() {
        IAtsChangeSet changes = this.atsApi.createChangeSet(AtsConstants.RestoreTasksFromActions.getName());
        for (ArtifactToken taskTok : this.tfa.getSourceTasks()) {
            IAtsTeamWorkflow teamWf;
            IAtsTask task = this.atsApi.getTaskService().getTask(taskTok);
            Collection related = this.atsApi.getRelationResolver().getRelated((IAtsObject)task, AtsRelationTypes.Derive_From);
            if (related.size() != 1 || !((ArtifactToken)related.iterator().next()).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) || (teamWf = this.atsApi.getWorkItemService().getTeamWf((ArtifactToken)related.iterator().next())) == null || !teamWf.isCancelled()) continue;
            String cancelledFromState = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, (Object)"");
            TransitionData tData = new TransitionData(AtsConstants.RestoreTasksFromActions.name(), Arrays.asList(teamWf), cancelledFromState, Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), "", changes, new TransitionOption[]{TransitionOption.None});
            tData.setExecute(false);
            TransitionResults results = this.atsApi.getWorkItemService().transition(tData);
            if (!results.isSuccess() || results.isErrors()) {
                this.tfa.getRd().errorf(results.toString(), new Object[0]);
                return;
            }
            this.atsApi.getActionService().addActionToConfiguredGoal(teamWf.getTeamDefinition(), teamWf, (Collection)teamWf.getActionableItems(), null, changes);
        }
        if (this.tfa.getRd().isErrors()) {
            return;
        }
        TransactionToken tx = changes.executeIfNeeded();
        if (tx.isValid()) {
            this.tfa.getRd().log("Success.  Restored Action(s) from Task(s)");
            this.tfa.getRd().setTxId(tx.getIdString());
        } else {
            this.tfa.getRd().log("Nothing to Do");
        }
    }
}

