/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.AtsConstants;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.task.CreateTasksOperation;
import org.eclipse.osee.ats.rest.internal.workitem.operations.CreateTasksFromActionsOperation;
import org.eclipse.osee.ats.rest.internal.workitem.operations.RestoreActionsFromTasksOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AtsTaskEndpointImpl
implements AtsTaskEndpointApi {
    private final AtsApi atsApi;

    public AtsTaskEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public ChangeReportTaskData create(ChangeReportTaskData changeReportTaskData) {
        return this.atsApi.getTaskService().createTasks(changeReportTaskData);
    }

    public NewTaskSet create(NewTaskSet newTaskSet) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskSet, this.atsApi);
        if ((newTaskSet = operation.validate()).isErrors()) {
            return newTaskSet;
        }
        operation.run();
        return newTaskSet;
    }

    public JaxAtsTask get(long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (task.getId().equals(IAtsWorkItem.SENTINEL.getId())) {
            throw new OseeArgumentException("No Task found with id %d", new Object[]{taskId});
        }
        JaxAtsTask jaxAtsTask = CreateTasksOperation.createNewJaxTask((Long)task.getId(), (AtsApi)this.atsApi);
        return jaxAtsTask;
    }

    public void delete(long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (task.isValid()) {
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Delete Task", AtsCoreUsers.SYSTEM_USER);
            changes.deleteArtifact(task);
            changes.execute();
        }
    }

    public TasksFromAction create(TasksFromAction tfa) {
        tfa.getRd().log(String.valueOf(AtsConstants.CreateTasksFromActions.name()) + "\n");
        CreateTasksFromActionsOperation op = new CreateTasksFromActionsOperation(tfa, this.atsApi);
        return op.run();
    }

    public TasksFromAction restore(TasksFromAction tfa) {
        tfa.getRd().log(String.valueOf(AtsConstants.CreateTasksFromActions.name()) + "\n");
        RestoreActionsFromTasksOperation op = new RestoreActionsFromTasksOperation(tfa, this.atsApi);
        return op.run();
    }
}

