/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.ats.api.workflow.note.IAtsStateNoteService;
import org.eclipse.osee.ats.core.demo.DemoUtil;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.rest.internal.demo.AbstractPopulateDemoDatabase;
import org.eclipse.osee.framework.core.data.ArtifactAnnotation;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class Pdd15CreateNotesAndAnnotations
extends AbstractPopulateDemoDatabase {
    public Pdd15CreateNotesAndAnnotations(XResultData rd, AtsApi atsApi) {
        super(rd, atsApi);
    }

    @Override
    public void run() {
        this.rd.logf("\n\nRunning [%s]...\n", new Object[]{this.getClass().getSimpleName()});
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
        Collection aias = DemoUtil.getActionableItems((AtsApi)this.atsApi, (ArtifactToken[])new ArtifactToken[]{DemoArtifactToken.SAW_Code_AI});
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        ActionResult actionResult = this.atsApi.getActionService().createAction(null, DemoArtifactToken.SAW_NotesAnnotations_Code_TeamWf.getName(), "Problem with the Diagram View", ChangeTypes.Problem, "1", false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        changes.execute();
        if (actionResult.getResults().isErrors()) {
            this.rd.errorf("Error creating Action in %s: %s", new Object[]{this.getClass().getSimpleName(), actionResult.getResults().toString()});
            return;
        }
        IAtsTeamWorkflow teamWf = actionResult.getFirstTeam();
        changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
        IAtsStateNoteService noteService = this.atsApi.getWorkItemService().getStateNoteService();
        noteService.addNote((IAtsWorkItem)teamWf, AtsStateNoteType.Info, TeamState.Analyze.getName(), "This is my informational note.", changes);
        noteService.addNote((IAtsWorkItem)teamWf, AtsStateNoteType.Problem, TeamState.Implement.getName(), "This is my problem note.", changes);
        noteService.addNote((IAtsWorkItem)teamWf, AtsStateNoteType.Warning, TeamState.Implement.getName(), "This is my warning note.", changes);
        noteService.addNote((IAtsWorkItem)teamWf, AtsStateNoteType.Other, TeamState.Analyze.getName(), "Other note.", changes);
        changes.addAttribute((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"Now is the time\n\nfor all good men.");
        changes.execute();
        changes = this.atsApi.createChangeSet("Create Annotations");
        changes.addAnnotation(teamWf.getStoreObject(), ArtifactAnnotation.getError((String)"my.annotation", (String)"This is error annotation"));
        changes.addAnnotation(teamWf.getStoreObject(), ArtifactAnnotation.getWarning((String)"my.annotation", (String)"This is warning annotation"));
        changes.addAnnotation(teamWf.getStoreObject(), ArtifactAnnotation.getInfo((String)"my.annotation", (String)"This is info annotation"));
        changes.execute();
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            return DemoArtifactToken.SAW_NotesAnnotations_Code_TeamWf;
        }
    }
}

