/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsTypeTokenProvider;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConvertAtsConfigGuidAttributesOperation {
    private final AtsApi atsApi;
    AttributeTypeString WorkPackageGuid = AtsTypeTokenProvider.ats.createString(Long.valueOf(1152921504606847876L), "ats.Work Package Guid", "text/plain", "", new DisplayHint[0]);
    private static AttributeTypeString ActionableItem = AtsTypeTokenProvider.ats.createString(Long.valueOf(0x10000000000000E0L), "ats.Actionable Item", "text/plain", "Actionable Items that are impacted by this change.", new DisplayHint[0]);
    private static AttributeTypeString TeamDefinition = AtsTypeTokenProvider.ats.createString(Long.valueOf(0x10000000000000E1L), "ats.Team Definition", "text/plain", "", new DisplayHint[0]);
    boolean workPackagesLoaded = false;

    public ConvertAtsConfigGuidAttributesOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData createUpdateConfig(XResultData rd) {
        this.atsApi.getLogger().error("starting", new Object[0]);
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andNotExists((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference).getItemIds());
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andNotExists((AttributeTypeToken)TeamDefinition).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)2000);
        int size = subDivide.size();
        int count = 1;
        for (Collection artIds : subDivide) {
            this.atsApi.getLogger().info(String.format("processing %s / %s", count++, size), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            IAtsChangeSet changes = this.atsApi.createChangeSet("Update TeamDef, AI and WorkPkg TeamWf GUIDs");
            for (ArtifactToken art : allArtifacts) {
                ConvertAtsConfigGuidAttributesOperation.convertTeamDefinitionIfNeeded(changes, art, this.atsApi);
                ConvertAtsConfigGuidAttributesOperation.convertActionableItemsIfNeeded(changes, art, this.atsApi);
                this.atsApi.getLogger().error("Work Item - " + art.toStringWithId(), new Object[0]);
            }
            TransactionToken transaction = changes.executeIfNeeded();
            if (transaction != null && transaction.isValid()) {
                this.atsApi.getLogger().info("================================== > executed", new Object[0]);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Update Program Team Def GUID");
        for (IAtsProgram program : this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.Program}).getItems(IAtsProgram.class)) {
            ConvertAtsConfigGuidAttributesOperation.convertTeamDefinitionIfNeeded(changes, program.getStoreObject(), this.atsApi);
        }
        changes.executeIfNeeded();
        changes = this.atsApi.createChangeSet("Remove Action AI and TeamDef GUIDs");
        for (ArtifactToken actionArt : this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), false, new ArtifactTypeToken[]{AtsArtifactTypes.Action})) {
            changes.deleteAttributes((ArtifactId)actionArt, (AttributeTypeToken)TeamDefinition);
            changes.deleteAttributes((ArtifactId)actionArt, (AttributeTypeToken)ActionableItem);
        }
        changes.executeIfNeeded();
        changes = this.atsApi.createChangeSet("Update AIs for ats.Review GUIDs");
        for (IAtsProgram program : this.atsApi.getQueryService().createQuery(WorkItemType.Review, new WorkItemType[0]).getItems(IAtsAbstractReview.class)) {
            ConvertAtsConfigGuidAttributesOperation.convertActionableItemsIfNeeded(changes, program.getStoreObject(), this.atsApi);
        }
        changes.executeIfNeeded();
        this.atsApi.getLogger().error("complete", new Object[0]);
        return rd;
    }

    private Set<ArtifactId> getWorkItemIdsMissingWorkPacakge() {
        List haveWorkPackageGuid = this.atsApi.getQueryService().getArtifactIdsFromQuery("SELECT UNIQUE attr.art_id FROM OSEE_ATTRIBUTE attr, OSEE_TXS txs WHERE attr.GAMMA_ID = txs.GAMMA_ID AND txs.BRANCH_ID = 570 AND txs.TX_CURRENT = 1 AND attr.ATTR_TYPE_ID = 1152921504606847876", new Object[0]);
        List haveWorkPackageId = this.atsApi.getQueryService().getArtifactIdsFromQuery("SELECT UNIQUE attr.art_id FROM OSEE_ATTRIBUTE attr, OSEE_TXS txs WHERE attr.GAMMA_ID = txs.GAMMA_ID AND txs.BRANCH_ID = 570 AND txs.TX_CURRENT = 1 AND attr.ATTR_TYPE_ID = 473096133909456789", new Object[0]);
        HashSet<ArtifactId> missingWorkPackage = new HashSet<ArtifactId>();
        missingWorkPackage.addAll(Collections.setComplement((Collection)haveWorkPackageGuid, (Collection)haveWorkPackageId));
        missingWorkPackage.addAll(Collections.setComplement((Collection)haveWorkPackageId, (Collection)haveWorkPackageGuid));
        return missingWorkPackage;
    }

    public static void convertActionableItemsIfNeeded(IAtsChangeSet changes, ArtifactToken art, AtsApi atsApi) {
        Collection currentAiRefIds = atsApi.getAttributeResolver().getAttributeValues((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
        LinkedList<ArtifactToken> neededAiRefIds = new LinkedList<ArtifactToken>();
        for (IAttribute iAttribute : atsApi.getAttributeResolver().getAttributes((ArtifactId)art, (AttributeTypeToken)ActionableItem)) {
            String aiArtGuid = (String)iAttribute.getValue();
            ArtifactToken ai = atsApi.getQueryService().getArtifactByGuidOrSentinel(aiArtGuid);
            if (ai.isInvalid()) {
                atsApi.getLogger().error("AI not found for aiArtGuid " + aiArtGuid + " for art " + art.toStringWithId(), new Object[0]);
                continue;
            }
            if (currentAiRefIds.contains(ai)) continue;
            neededAiRefIds.add(ai);
        }
        for (ArtifactId artifactId : neededAiRefIds) {
            changes.addAttribute((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, (Object)artifactId);
        }
        List list = atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)art, (AttributeTypeToken)ActionableItem);
        LinkedList<String> neededAiGuidIds = new LinkedList<String>();
        Collection aiArts = atsApi.getAttributeResolver().getAttributeValues((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
        for (ArtifactId id : aiArts) {
            IAtsActionableItem ai = (IAtsActionableItem)atsApi.getConfigService().getConfigurations().getIdToAi().get(id.getId());
            if (ai == null) {
                ai = (IAtsActionableItem)atsApi.getQueryService().getConfigItem(id);
            }
            if (ai == null) {
                atsApi.getLogger().error("AI not found for id " + id + " for art " + art.toStringWithId(), new Object[0]);
                continue;
            }
            if (list.contains(ai.getStoreObject().getGuid())) continue;
            neededAiGuidIds.add(ai.getStoreObject().getGuid());
        }
        for (String guid : neededAiGuidIds) {
            changes.addAttribute((ArtifactId)art, (AttributeTypeToken)ActionableItem, (Object)guid);
        }
    }

    public static void convertTeamDefinitionIfNeeded(IAtsChangeSet changes, ArtifactToken art, AtsApi atsApi) {
        String teamDefGuid;
        ArtifactId teamDefId = atsApi.getAttributeResolver().getSoleArtifactIdReference(art, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
        if (teamDefId.isInvalid() && Strings.isValid((String)(teamDefGuid = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)TeamDefinition, (Object)"")))) {
            ArtifactToken artifact = atsApi.getQueryService().getArtifactByGuidOrSentinel(teamDefGuid);
            TeamDefinition teamDef = atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)artifact);
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (Object)teamDef.getStoreObject());
        }
        if (!Strings.isValid((String)(teamDefGuid = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)TeamDefinition, (Object)"")))) {
            ArtifactId teamDefArt = atsApi.getAttributeResolver().getSoleArtifactIdReference(art, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL);
            ArtifactToken artifact = atsApi.getQueryService().getArtifact(teamDefArt);
            if (artifact != null) {
                changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)TeamDefinition, (Object)artifact.getGuid());
            }
        }
    }
}

