/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.util.PublishingTemplate;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterion;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterionListBuilder;
import org.eclipse.osee.orcs.core.util.PublishingTemplateSetter;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class SetupPublishing {
    private static final boolean matchPreviewTemplatesByName = true;
    private static Boolean newValues = false;
    private static Boolean noTags = false;
    private static final String previewTemplatesNotMatchByNameSuffix = " (NOT MATCHED BY NAME)";
    private static Supplier<List<PublishingTemplate>> publishingTemplatesSupplier = new Supplier<List<PublishingTemplate>>(){

        @Override
        public List<PublishingTemplate> get() {
            return List.of(new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordEditTemplate", "templates/WordEditTemplate.json", "templates/Word Edit Template.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.SPECIALIZED_EDIT.name()))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordMergeTemplate", "templates/WordMergeTemplate.json", "templates/PREVIEW_ALL.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.MERGE.name()), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.DIFF.name(), RendererOption.THREE_WAY_MERGE.getKey()))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_VALUE.getKey()), null, "templates/PREVIEW_ALL.xml", new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.DIFF.name())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD, PresentationType.PREVIEW_SERVER.name(), RendererOption.PREVIEW_ALL_VALUE.getKey())).toList()), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey()), "templates/PREVIEW_ALL_NO_ATTRIBUTES.json", "templates/PREVIEW_ALL.xml", new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, "DIFF_NO_ATTRIBUTES")).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD, PresentationType.PREVIEW_SERVER.name(), RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey())).toList()), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey()), "templates/PREVIEW_ALL_RECURSE.json", "templates/PREVIEW_ALL.xml", new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD, PresentationType.PREVIEW_SERVER.name(), RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey())).toList()), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey()), "templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.json", "templates/PREVIEW_ALL.xml", new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD, PresentationType.PREVIEW_SERVER.name(), RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey())).toList()));
        }
    };
    private static String RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD = "org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer";
    private static String RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD = "org.eclipse.osee.framework.ui.skynet.render.MSWordRestRenderer";
    private static String RENDERER_IDENTIFIER_TIS = "org.eclipse.osee.framework.ui.skynet.render.TisRenderer";
    private static String RENDERER_IDENTIFIER_WORD = "org.eclipse.osee.framework.ui.skynet.word";

    private static void createDataRights(TransactionBuilder tx) {
        ArtifactToken dataRightsArt = tx.createArtifact((ArtifactId)CoreArtifactTokens.DocumentTemplates, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", SetupPublishing.class));
    }

    private static void createWordTemplates(final TransactionBuilder tx) {
        PublishingTemplate.load(publishingTemplatesSupplier, new PublishingTemplateSetter(){

            @Override
            public String set(ArtifactToken parent, String name, String content, String rendererOptions, List<String> matchCriteria) {
                Objects.requireNonNull(tx, "SetupPublishing::createPublishingTemplate, parameter \"tx\" cannot be null.");
                ArtifactToken publishingTemplateArtifact = tx.createArtifact((ArtifactId)parent, CoreArtifactTypes.RendererTemplateWholeWord, name);
                if (Objects.nonNull(rendererOptions)) {
                    tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)rendererOptions);
                }
                if (Objects.nonNull(content)) {
                    tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)content);
                }
                if (Objects.nonNull(matchCriteria)) {
                    matchCriteria.forEach(matchCriterion -> {
                        AttributeId attributeId = tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, matchCriterion);
                    });
                }
                return "AT-".concat(publishingTemplateArtifact.getIdString());
            }
        }, SetupPublishing.class, true);
    }

    private static String previewTemplateName(String templateBaseName) {
        return templateBaseName;
    }

    public static void setup(TransactionBuilder tx) {
        Objects.requireNonNull(tx, "SetupPublishing::setup, the parameter \"tx\" cannot be null.");
        SetupPublishing.createWordTemplates(tx);
        SetupPublishing.createDataRights(tx);
    }

    public static void setupConfiguration(OrcsApi orcsApi) {
        try {
            JdbcClient jdbcClient = orcsApi.getJdbcService().getClient();
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.no.tags", (String)noTags.toString());
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.new.values", (String)newValues.toString());
        }
        catch (Exception exception) {}
    }

    private SetupPublishing() {
    }
}

