/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing.templatemanager;

import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.define.operations.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;

public class TemplateManagerEndpointImpl
implements TemplateManagerEndpoint {
    private final DefineOperations defineOperations;

    public TemplateManagerEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "TemplateManagerEndpointImpl::new, parameter \"defineOperations\" cannot be null.");
    }

    public void deleteCache() {
        try {
            PublishingPermissions.verify();
            this.defineOperations.getTemplateManagerOperations().deleteCache();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(publishingTemplateRequest);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplate getPublishingTemplate(String primaryKey, String secondaryKey) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(primaryKey, secondaryKey);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups() {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplateKeyGroups();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

