/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.api.importing.IArtifactExtractor;
import org.eclipse.osee.define.api.importing.IArtifactExtractorDelegate;
import org.eclipse.osee.define.api.importing.RoughArtifact;
import org.eclipse.osee.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.OutlineResolution;
import org.eclipse.osee.define.rest.importing.parsers.RoughArtifactMetaData;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class WordOutlineExtractorDelegate
implements IArtifactExtractorDelegate {
    private static final String WORD_OUTLINE_PARSER_NAME = "Word Outline";
    private static final Pattern WT_ELEMENT_REGEX = Pattern.compile("<w:t.*?>(.*?)</w:t>", 32);
    private static final Pattern LIST_ITEM_REGEX = Pattern.compile("<wx:t wx:val=\"([0-9.]+\\s*)\".*/>");
    private static final Pattern OUTLINE_NUMBER_REGEX = Pattern.compile("((?>\\d+\\.)+\\d*(?>-\\d+)*)\\s*");
    private static final Pattern TOC_HYPERLINK_PATTERN = Pattern.compile(".*<w:pStyle w:val=\"TOC\\d+?\"/>.*", 32);
    private boolean possibleTableOfContents;
    private ContentType lastDeterminedContentType = ContentType.OUTLINE_TITLE;
    private Map<String, RoughArtifact> duplicateCatcher;
    private Map<String, String> roughArtMeta;
    protected RoughArtifact previousNamedArtifact;
    protected RoughArtifact roughArtifact;
    protected StringBuilder wordFormattedContent;
    protected StringBuffer lastHeaderNumber;
    private StringBuffer lastHeaderName;
    private boolean initalized;
    private final OutlineResolution outlineResolution = new OutlineResolution();

    public boolean isApplicable(IArtifactExtractor parser) {
        return parser != null && WORD_OUTLINE_PARSER_NAME.equals(parser.getName());
    }

    public void initialize() {
        this.duplicateCatcher = new HashMap<String, RoughArtifact>();
        this.roughArtMeta = new HashMap<String, String>();
        this.lastHeaderNumber = new StringBuffer();
        this.lastHeaderName = new StringBuffer();
        this.previousNamedArtifact = null;
        this.roughArtifact = null;
        this.wordFormattedContent = new StringBuilder();
        this.initalized = true;
        this.possibleTableOfContents = false;
    }

    public void dispose() {
        this.duplicateCatcher = null;
        this.roughArtMeta = null;
        this.previousNamedArtifact = null;
        this.roughArtifact = null;
        this.lastHeaderNumber = null;
        this.lastHeaderName = null;
        this.initalized = false;
        this.possibleTableOfContents = false;
    }

    public final @NonNull XResultData processContent(OrcsApi orcsApi, @NonNull XResultData results, RoughArtifactCollector collector, boolean forceBody, boolean forcePrimaryType, String headerNumber, String listIdentifier, String paragraphStyle, String content, boolean isParagraph) {
        Objects.requireNonNull("WordOutlineExtractorDelegate::processContent, parameter \"results\" cannot be null.");
        if (Strings.isValid((String)content) && this.initalized) {
            StringBuilder outlineName;
            StringBuilder outlineNumber;
            boolean newOutlineNumber;
            if (!this.possibleTableOfContents) {
                this.possibleTableOfContents = TOC_HYPERLINK_PATTERN.matcher(content).matches();
                if (this.possibleTableOfContents) {
                    results.error("Document cannot contain a table of contents");
                }
            }
            if (newOutlineNumber = this.processOutlineNumberAndName(content, outlineNumber = new StringBuilder(), outlineName = new StringBuilder(), paragraphStyle)) {
                this.setContent();
                String number = outlineNumber.toString();
                this.roughArtifact = this.setUpNewArtifact(orcsApi, results, collector, number);
                if (this.roughArtifact == null) {
                    return results;
                }
                this.previousNamedArtifact = this.roughArtifact;
                this.processHeadingText(this.roughArtifact, WordCoreUtil.textOnly((String)outlineName.toString()));
                this.roughArtMeta.put(number, paragraphStyle);
                this.resetReqNumber();
            } else {
                this.addChildRoughArtifact(orcsApi, results, content, collector);
            }
        } else {
            throw new OseeCoreException("%s::processContent() Either passed in content is invalid or *Delegate hasn't been initialized...", new Object[]{this.toString()});
        }
        return results;
    }

    protected void addChildRoughArtifact(OrcsApi orcsApi, XResultData results, String content, RoughArtifactCollector collector) {
        this.wordFormattedContent.append(content);
    }

    protected void resetReqNumber() {
    }

    private boolean processOutlineNumberAndName(String content, StringBuilder outlineNumberStorage, StringBuilder outlineName, String paragraphStyle) {
        boolean outlineNumberDetected;
        Matcher listItemMatcher = LIST_ITEM_REGEX.matcher(content);
        if (listItemMatcher.find()) {
            String number = listItemMatcher.group(1).trim();
            if (this.duplicateCatcher.get(number) == null) {
                if (this.previousNamedArtifact == null) {
                    outlineNumberStorage.append(number);
                } else {
                    boolean valid = this.determineIfValid(number, paragraphStyle);
                    if (valid) {
                        outlineNumberStorage.append(number);
                    }
                }
            }
        } else {
            this.specializedOutlineNumberTitleExtract(content, outlineNumberStorage, outlineName, paragraphStyle);
        }
        boolean bl = outlineNumberDetected = outlineNumberStorage.length() != 0;
        if (outlineNumberDetected) {
            this.lastHeaderNumber.setLength(0);
            this.setLastHeaderNumber(outlineNumberStorage.toString());
            this.grabNameAndTemplateContent(content, outlineName);
            if (outlineName.length() != 0) {
                this.lastHeaderName.setLength(0);
                this.lastHeaderName.append(outlineName.toString());
            }
        }
        return outlineNumberDetected;
    }

    private boolean determineIfValid(String number, String paragraphStyle) {
        boolean result = false;
        if (this.previousNamedArtifact != null && this.previousNamedArtifact.getSectionNumber() != null) {
            String sectionNumber = this.previousNamedArtifact.getSectionNumber().getNumberString();
            if (this.checkSectionNumber(sectionNumber)) {
                return true;
            }
            String metaData = this.roughArtMeta.get(sectionNumber);
            paragraphStyle = Strings.isValid((String)paragraphStyle) ? paragraphStyle : "";
            boolean invalid = this.outlineResolution.isInvalidOutlineNumber(number, sectionNumber);
            result = !invalid && RoughArtifactMetaData.matches(metaData, paragraphStyle);
        } else {
            result = true;
        }
        return result;
    }

    protected boolean checkSectionNumber(String sectionNumber) {
        return false;
    }

    private void grabNameAndTemplateContent(String paragraph, StringBuilder outLineStorage) {
        if (outLineStorage.length() == 0) {
            Matcher wtElementMatcher = WT_ELEMENT_REGEX.matcher(paragraph);
            while (wtElementMatcher.find()) {
                Matcher checkingForOutlineNumber = OUTLINE_NUMBER_REGEX.matcher(wtElementMatcher.group(1));
                if (checkingForOutlineNumber.matches()) continue;
                outLineStorage.append(wtElementMatcher.group(1));
            }
        }
    }

    private void specializedOutlineNumberTitleExtract(String paragraph, StringBuilder outlineNumberStorage, StringBuilder outlineTitleStorage, String paragraphStyle) {
        StringBuilder wtStorage = new StringBuilder(paragraph.length());
        Matcher wtElementMatcher = WT_ELEMENT_REGEX.matcher(paragraph);
        while (wtElementMatcher.find()) {
            wtStorage.append(wtElementMatcher.group(1));
        }
        int indexOfFirstSpace = wtStorage.toString().indexOf(" ");
        if (indexOfFirstSpace != -1) {
            CharSequence paragraphNumber = wtStorage.subSequence(0, indexOfFirstSpace);
            Matcher outlineNumberMatcher = OUTLINE_NUMBER_REGEX.matcher(paragraphNumber);
            if (outlineNumberMatcher.matches() && paragraphNumber.length() > 2) {
                this.processSpecializedOutlineNumberAndTitle(outlineNumberMatcher.group(), wtStorage.subSequence(indexOfFirstSpace, wtStorage.length()).toString(), outlineNumberStorage, outlineTitleStorage, paragraphStyle);
            } else {
                outlineTitleStorage = wtStorage;
            }
        } else {
            outlineTitleStorage = wtStorage;
        }
    }

    private void processSpecializedOutlineNumberAndTitle(String currentOutlineNumber, String formOfOutlineTitle, StringBuilder outlineNumberStorage, StringBuilder outlineTitleStorage, String paragraphStyle) {
        boolean valid = this.determineIfValid(currentOutlineNumber, paragraphStyle);
        this.lastDeterminedContentType = valid ? ContentType.OUTLINE_TITLE : ContentType.CONTENT;
        switch (this.lastDeterminedContentType) {
            case CONTENT: {
                break;
            }
            default: {
                outlineNumberStorage.append(currentOutlineNumber);
                if (!Strings.isValid((String)formOfOutlineTitle)) break;
                outlineTitleStorage.append(formOfOutlineTitle);
            }
        }
    }

    protected void postProcessContent(StringBuilder wordFormattedContent, RoughArtifact roughArtifact) {
    }

    protected void setContent() {
        if (this.roughArtifact != null) {
            this.roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, this.wordFormattedContent.toString());
            this.postProcessContent(this.wordFormattedContent, this.roughArtifact);
            this.wordFormattedContent.setLength(0);
        }
    }

    public void finish(OrcsApi orcsApi, XResultData results, RoughArtifactCollector collector) {
        this.setContent();
    }

    public void finish() {
        this.setContent();
    }

    public void processHeadingText(RoughArtifact roughArtifact, String headingText) {
        roughArtifact.setName(headingText.trim());
    }

    private RoughArtifact setUpNewArtifact(OrcsApi orcsApi, XResultData results, RoughArtifactCollector collector, String outlineNumber) {
        RoughArtifact duplicateArtifact = this.duplicateCatcher.get(outlineNumber);
        if (duplicateArtifact == null) {
            RoughArtifact roughArtifact = new RoughArtifact(orcsApi, results, RoughArtifactKind.PRIMARY);
            this.duplicateCatcher.put(outlineNumber, roughArtifact);
            if (collector != null) {
                collector.addRoughArtifact(roughArtifact);
            }
            roughArtifact.setSectionNumber(outlineNumber);
            roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, outlineNumber);
            return roughArtifact;
        }
        String previousArtifcatName = this.previousNamedArtifact != null ? this.previousNamedArtifact.getName() : "null";
        results.logf("Paragraph %s found more than once following \"%s\" which is a duplicate of %s", new Object[]{outlineNumber, previousArtifcatName, duplicateArtifact.getName()});
        return null;
    }

    public String getName() {
        return "General Outline Documents";
    }

    public String getLastHeaderNumber() {
        return this.getBufferString(this.lastHeaderNumber);
    }

    private void setLastHeaderNumber(String headerNumber) {
        this.lastHeaderNumber.append(headerNumber);
    }

    public String getLastHeaderName() {
        return this.getBufferString(this.lastHeaderName);
    }

    private String getBufferString(StringBuffer builder) {
        return builder != null ? builder.toString() : null;
    }

    public static enum ContentType {
        CONTENT,
        OUTLINE_TITLE;

    }
}

