/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.operations.publishing.templatemanager.AbstractPublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.ArtifactPublishingTemplate;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

class ArtifactPublishingTemplateCache
extends AbstractPublishingTemplateCache {
    private static ArtifactPublishingTemplateCache artifactPublishingTemplateCache = null;
    private final PublishingUtils publishingUtils;

    private ArtifactPublishingTemplateCache(Log logger, OrcsApi orcsApi) {
        super(logger);
        this.publishingUtils = new PublishingUtils(orcsApi);
    }

    static synchronized PublishingTemplateCache create(Log logger, OrcsApi orcsApi) {
        return Objects.nonNull(artifactPublishingTemplateCache) ? artifactPublishingTemplateCache : (artifactPublishingTemplateCache = new ArtifactPublishingTemplateCache(logger, orcsApi));
    }

    Optional<ArtifactPublishingTemplate> createPublishingTemplate(ArtifactReadable artifactReadable) {
        try {
            return Optional.of(new ArtifactPublishingTemplate(artifactReadable));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "ArtifactPublishingTemplateCache::createPublishingTemplate, Invalid Publishing Template.", new Object[0]);
            return Optional.empty();
        }
    }

    @Override
    public synchronized List<PublishingTemplateInternal> loadTemplates() {
        return this.publishingUtils.getArtifactReadablesByType(new BranchSpecification((BranchId)CoreBranches.COMMON), CoreArtifactTypes.RendererTemplateWholeWord).orElseThrow(() -> {
            PublishingUtils.Cause cause = this.publishingUtils.getLastCause();
            Optional<Exception> exception = PublishingUtils.Cause.OK.equals((Object)cause) ? null : this.publishingUtils.getLastError();
            String message = new Message().title((CharSequence)"ArtifactPublishingTemplateCache::loadTemplates, no Publishing Templates found.").indentInc().segment((CharSequence)"Query Result", (Object)cause).reasonFollowsIfPresent(exception).toString();
            return new OseeCoreException(message, new Object[]{exception});
        }).stream().map(this::createPublishingTemplate).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableList());
    }
}

