/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderDataFactory;
import org.eclipse.osee.orcs.rest.model.transaction.TransferInitData;
import org.eclipse.osee.orcs.rest.model.transaction.TransferOpType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTupleTypes;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionEndpointImpl
implements TransactionEndpoint {
    private final OrcsApi orcsApi;
    @Context
    private UriInfo uriInfo;

    public TransactionEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<Transaction> getAllTxs() {
        return OrcsRestUtil.asTransactions((ResultSet<? extends TransactionReadable>)this.orcsApi.getTransactionFactory().getAllTxs());
    }

    public Transaction getTx(TransactionId tx) {
        return OrcsRestUtil.asTransaction(this.orcsApi.getTransactionFactory().getTx(tx));
    }

    public TransactionResult create(TransactionBuilder tx) {
        TransactionToken token = tx.commit();
        TransactionResult result = new TransactionResult();
        result.setTx(token);
        XResultData resultData = new XResultData();
        resultData.setTxId(token.getIdString());
        resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
        result.setResults(resultData);
        result.setFailedGammas(tx.getGammaIdsFailed());
        return result;
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        return this.orcsApi.getTransactionFactory().compareTxs(txId1, txId2);
    }

    public TransactionBuilderData exportTxsDiff(TransactionId txId1, TransactionId txId2) {
        TransactionBuilderDataFactory tbdf = new TransactionBuilderDataFactory(this.orcsApi);
        try {
            return tbdf.loadFromChanges(txId1, txId2);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Response setTxComment(TransactionId txId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().setTxComment(txId, comment));
    }

    public Response purgeTxs(String txIds) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().purgeTxs(txIds));
    }

    public Response purgeUnusedBackingDataAndTransactions() {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        this.orcsApi.getTransactionFactory().purgeUnusedBackingDataAndTransactions();
        return Response.ok().build();
    }

    public Response replaceWithBaselineTxVersion(UserId userId, BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().replaceWithBaselineTxVersion(userId, branchId, txId, artId, comment));
    }

    public List<ChangeItem> getArtifactHistory(ArtifactId artifact, BranchId branch) {
        return this.orcsApi.getTransactionFactory().getArtifactHistory(artifact, branch);
    }

    public TransferInitData initTransactionTransfer(TransferInitData data) {
        if (data == null) {
            throw new OseeCoreException("initTransactionTransfer given null data", new Object[0]);
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Adding tuple for transfer init");
        List branches = data.getBranchIds();
        for (BranchId branch : branches) {
            tx.addTuple3(TransferTupleTypes.ExportedBranch, (Object)data.getExportId(), (Object)branch, (Object)data.getTransferDBType());
            tx.addTuple4(TransferTupleTypes.TransferFile, (Object)branch, (Object)data.getBaseTxId(), (Object)TransactionId.valueOf((Long)Lib.generateUuid()), (Object)TransferOpType.PREV_TX);
        }
        return data;
    }

    public XResultData generateTransferFile(TransactionId exportId) {
        XResultData results = new XResultData();
        return results;
    }

    public XResultData applyTransferFile(String fileName) {
        XResultData results = new XResultData();
        return results;
    }
}

