/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.publishing;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class WordRenderArtifactWrapperServerImpl
implements PublishingArtifact {
    private final ArtifactReadable artifact;
    private boolean endsSection;
    private int outlineLevel;
    private boolean startsSection;

    public WordRenderArtifactWrapperServerImpl(ArtifactReadable artifact) {
        this.artifact = artifact;
        this.outlineLevel = 0;
        this.startsSection = false;
        this.endsSection = false;
    }

    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
        throw new UnsupportedOperationException();
    }

    public void clearEndOfSection() {
        this.endsSection = false;
    }

    public void clearStartOfSection() {
        this.startsSection = false;
    }

    public boolean equals(Object other) {
        return this.artifact.equals(other);
    }

    public List<String> fetchAttributesAsStringList(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public ApplicabilityId getApplicability() {
        return this.artifact.getApplicability();
    }

    public ApplicabilityToken getApplicabilityToken() {
        throw new UnsupportedOperationException();
    }

    public ArtifactReadable getArtifact() {
        return this.artifact;
    }

    public ArtifactId getArtifactId() {
        return ArtifactId.create((Id)this.artifact);
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifact.getArtifactType();
    }

    public String getArtifactTypeName() {
        return this.artifact.getArtifactType().getName();
    }

    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount(AttributeTypeToken type) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        throw new UnsupportedOperationException();
    }

    public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> attributeType) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
        return this.artifact.getAttributeValues(attributeType);
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeValuesAsString(AttributeTypeToken attributeType) {
        return this.artifact.getAttributeValuesAsString(attributeType);
    }

    public BranchToken getBranch() {
        return this.artifact.getBranch();
    }

    public List<ArtifactReadable> getChildren() {
        int childOutlineLevel = this.getOutlineLevel() + 1;
        LinkedList children = this.artifact.getChildren().stream().map(WordRenderArtifactWrapperServerImpl::new).peek(artifact -> artifact.setOutlineLevel(childOutlineLevel)).collect(Collectors.toCollection(LinkedList::new));
        if (!children.isEmpty()) {
            ((PublishingArtifact)children.getFirst()).setStartOfSection();
            ((PublishingArtifact)children.getLast()).setEndOfSection();
        }
        List artifactReadableChildren = children;
        return artifactReadableChildren;
    }

    public List<PublishingArtifact> getChildrenAsPublishingArtifacts() {
        List<ArtifactReadable> publishingArtifactChildren = this.getChildren();
        return publishingArtifactChildren;
    }

    public Collection<ArtifactId> getChildrenIds() {
        throw new UnsupportedOperationException();
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getDescendants() {
        return this.artifact.getDescendants().stream().map(WordRenderArtifactWrapperServerImpl::new).collect(Collectors.toList());
    }

    public void getDescendants(List<ArtifactReadable> descendants) {
        throw new UnsupportedOperationException();
    }

    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        throw new UnsupportedOperationException();
    }

    public Collection<RelationTypeToken> getExistingRelationTypes() {
        throw new UnsupportedOperationException();
    }

    public String getGuid() {
        return this.artifact.getGuid();
    }

    public Long getId() {
        return this.artifact.getId();
    }

    public TransactionId getLastModifiedTransaction() {
        throw new UnsupportedOperationException();
    }

    public int getMaximumRelationAllowed(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public ModificationType getModificationType() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public int getOutlineLevel() {
        return this.outlineLevel;
    }

    public ArtifactReadable getParent() {
        ArtifactReadable parent = this.artifact.getParent();
        return Objects.nonNull(parent) ? new WordRenderArtifactWrapperServerImpl(parent) : null;
    }

    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public int getRelatedCount(RelationTypeSide typeAndSide) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactId> getRelatedIds(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getRelatedList(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<IRelationLink> getRelations(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public String getSafeName() {
        throw new UnsupportedOperationException();
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeTypeToken, String defaultValue) {
        return (String)this.artifact.getSoleAttributeValue(attributeTypeToken, (Object)defaultValue);
    }

    public AttributeId getSoleAttributeId(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public Long getSoleAttributeId(AttributeTypeToken attributeType, Long defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeTypeToken, T defaultValue) {
        return (T)this.artifact.getSoleAttributeValue(attributeTypeToken, defaultValue);
    }

    public TransactionId getTransaction() {
        return this.artifact.getTransaction();
    }

    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        return this.artifact.getValidAttributeTypes();
    }

    public Collection<RelationTypeToken> getValidRelationTypes() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.artifact.hashCode();
    }

    public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return this.artifact.isAttributeTypeValid(attributeType);
    }

    public boolean isDescendantOf(ArtifactToken parent) {
        throw new UnsupportedOperationException();
    }

    public boolean isEndOfSection() {
        return this.endsSection;
    }

    public boolean isHistorical() {
        return this.artifact.isHistorical();
    }

    public boolean isInvalid() {
        return this.artifact.isInvalid();
    }

    public boolean isOfType(ArtifactTypeId ... artifactTypeId) {
        return this.artifact.isOfType(artifactTypeId);
    }

    public boolean isStartOfSection() {
        return this.startsSection;
    }

    public void setEndOfSection() {
        this.endsSection = true;
    }

    public void setOutlineLevel(int level) {
        this.outlineLevel = level;
    }

    public void setStartOfSection() {
        this.startsSection = true;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.isNull(message) ? new Message() : message;
        outMessage.indent(indent).title((CharSequence)"PublishingArtifact (WordRenderArtifactWrapperServerImpl)").indentInc().segment((CharSequence)"Identifier", (Object)this.getIdString()).segment((CharSequence)"Name", (Object)this.getName()).segment((CharSequence)"Type", (Object)this.getArtifactTypeName()).segment((CharSequence)"Start Section", (Object)this.startsSection).segment((CharSequence)"End Section", (Object)this.endsSection).segment((CharSequence)"Outline Level", (Object)this.outlineLevel).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

