/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.transition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class TransitionData {
    private String cancellationReason;
    private AttributeTypeToken cancellationReasonAttrType = AttributeTypeToken.SENTINEL;
    private String cancellationReasonDetails;
    private Collection<ArtifactToken> workItemIds = new HashSet<ArtifactToken>();
    private String name;
    private Collection<TransitionOption> transitionOptions = new HashSet<TransitionOption>();
    private Collection<AtsUser> toAssignees = new HashSet<AtsUser>();
    private String toStateName;
    private boolean executeChanges = false;
    @JsonIgnore
    private Collection<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
    private AtsUser transitionUser;
    private ArtifactId transitionUserArtId;
    private boolean workflowsReloaded = false;
    private boolean dialogCancelled = false;
    @JsonIgnore
    private final List<IAtsTransitionHook> transitionHooks = new ArrayList<IAtsTransitionHook>();
    @JsonIgnore
    private IAtsChangeSet changes;
    private boolean debug = false;

    public TransitionData() {
    }

    public TransitionData(String name, Collection<? extends IAtsWorkItem> workItems, String toStateName, Collection<AtsUser> toAssignees, String cancellationReason, IAtsChangeSet changes, TransitionOption ... transitionOption) {
        this.setName(name);
        this.setWorkItems(Collections.castAll(workItems));
        this.setToStateName(toStateName);
        this.setCancellationReason(cancellationReason);
        this.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReason);
        this.setToAssignees(toAssignees);
        TransitionOption[] transitionOptionArray = transitionOption;
        int n = transitionOption.length;
        int n2 = 0;
        while (n2 < n) {
            TransitionOption opt = transitionOptionArray[n2];
            this.getTransitionOptions().add(opt);
            ++n2;
        }
        this.changes = changes;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public Collection<ArtifactToken> getWorkItemIds() {
        return this.workItemIds;
    }

    public void setWorkItemIds(Collection<ArtifactToken> workItemIds) {
        this.workItemIds = workItemIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<AtsUser> getToAssignees() {
        return this.toAssignees;
    }

    public void setToAssignees(Collection<AtsUser> toAssignees) {
        this.toAssignees = toAssignees;
    }

    public String getToStateName() {
        return this.toStateName;
    }

    public void setToStateName(String toStateName) {
        this.toStateName = toStateName;
    }

    public boolean isExecuteChanges() {
        return this.executeChanges;
    }

    public void setExecuteChanges(boolean executeChanges) {
        this.executeChanges = executeChanges;
    }

    @JsonIgnore
    public Collection<IAtsWorkItem> getWorkItems() {
        return this.workItems;
    }

    public void setWorkItems(Collection<IAtsWorkItem> workItems) {
        this.workItems = workItems;
    }

    public AtsUser getTransitionUser() {
        return this.transitionUser;
    }

    public void setTransitionUser(AtsUser transitionUser) {
        this.transitionUser = transitionUser;
    }

    public boolean isWorkflowsReloaded() {
        return this.workflowsReloaded;
    }

    public void setWorkflowsReloaded(boolean workflowsReloaded) {
        this.workflowsReloaded = workflowsReloaded;
    }

    public Collection<TransitionOption> getTransitionOptions() {
        return this.transitionOptions;
    }

    public void setTransitionOptions(Collection<TransitionOption> transitionOptions) {
        this.transitionOptions = transitionOptions;
    }

    public String getCancellationReasonDetails() {
        return this.cancellationReasonDetails;
    }

    public void setCancellationReasonDetails(String cancellationReasonDetails) {
        this.cancellationReasonDetails = cancellationReasonDetails;
    }

    public boolean isDialogCancelled() {
        return this.dialogCancelled;
    }

    public void setDialogCancelled(boolean dialogCancelled) {
        this.dialogCancelled = dialogCancelled;
    }

    public ArtifactId getTransitionUserArtId() {
        return this.transitionUserArtId;
    }

    public void setTransitionUserArtId(ArtifactId transitionUserArtId) {
        this.transitionUserArtId = transitionUserArtId;
    }

    public AttributeTypeToken getCancellationReasonAttrType() {
        return this.cancellationReasonAttrType;
    }

    public void setCancellationReasonAttrType(AttributeTypeToken cancellationReasonAttrType) {
        this.cancellationReasonAttrType = cancellationReasonAttrType;
    }

    public void addTransitionOption(TransitionOption transitionOption) {
        this.transitionOptions.add(transitionOption);
    }

    public void removeTransitionOption(TransitionOption transitionOption) {
        this.transitionOptions.remove((Object)transitionOption);
    }

    public boolean isOverrideAssigneeCheck() {
        return this.transitionOptions.contains((Object)TransitionOption.OverrideAssigneeCheck);
    }

    public boolean isOverrideWorkingBranchCheck() {
        return this.transitionOptions.contains((Object)TransitionOption.OverrideWorkingBranchCheck);
    }

    public boolean isOverrideTransitionValidityCheck() {
        return this.transitionOptions.contains((Object)TransitionOption.OverrideTransitionValidityCheck);
    }

    public void addTransitionHook(IAtsTransitionHook transitionHook) {
        this.transitionHooks.add(transitionHook);
    }

    public List<IAtsTransitionHook> getTransitionHooks() {
        return this.transitionHooks;
    }

    public IAtsChangeSet getChanges() {
        return this.changes;
    }

    public boolean isWorkingBranchInWork(IAtsTeamWorkflow teamWf, AtsApi atsApi) {
        return atsApi.getBranchService().isWorkingBranchInWork(teamWf);
    }

    public boolean isBranchInCommit(IAtsTeamWorkflow teamWf, AtsApi atsApi) {
        return atsApi.getBranchService().isBranchInCommit(teamWf);
    }

    public boolean isSystemUserAssingee(IAtsWorkItem workItem) {
        return workItem.getAssignees().stream().anyMatch(SystemUser.OseeSystem::equals);
    }

    public boolean isSystemUser() {
        return AtsCoreUsers.isAtsCoreUser(this.getTransitionUser());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getHasTransitionOptions(TransitionOption transitionOption) {
        return this.getTransitionOptions().contains((Object)transitionOption);
    }
}

