/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ReviewDefectItem {
    private Date date = new Date();
    private String description = "";
    private String location = "";
    private String resolution = "";
    private String userId;
    private Long id;
    private String guid;
    private Severity severity = Severity.None;
    private Disposition disposition = Disposition.None;
    private InjectionActivity injectionActivity = InjectionActivity.None;
    private String notes = "";
    private boolean closed = false;
    private String closedUserId = "";

    public ReviewDefectItem(UserToken user, Severity severity, Disposition disposition, InjectionActivity injectionActivity, String description, String resolution, String location, Date date, String notes) {
        this(user.getUserId(), severity, disposition, injectionActivity, description, resolution, location, date, notes);
    }

    public ReviewDefectItem(String userId, Severity severity, Disposition disposition, InjectionActivity injectionActivity, String description, String resolution, String location, Date date, String notes) {
        this.userId = userId;
        if (severity != null) {
            this.severity = severity;
        }
        if (disposition != null) {
            this.disposition = disposition;
        }
        if (injectionActivity != null) {
            this.injectionActivity = injectionActivity;
        }
        if (description != null) {
            this.description = description;
        }
        if (resolution != null) {
            this.resolution = resolution;
        }
        if (location != null) {
            this.location = location;
        }
        if (date != null) {
            this.date = date;
        }
        if (notes != null) {
            this.notes = notes;
        }
        this.id = Lib.generateId();
        this.guid = String.valueOf(this.id);
    }

    public ReviewDefectItem(String xml, boolean andGuid, IAtsPeerToPeerReview review) {
        this.fromXml(xml, andGuid, review);
    }

    public ReviewDefectItem() {
        this.id = Lib.generateId();
        this.guid = String.valueOf(this.id);
    }

    public void update(ReviewDefectItem dItem, boolean andGuid, IAtsPeerToPeerReview review) {
        this.fromXml(dItem.toXml(andGuid), andGuid, review);
    }

    public String getDate(String pattern) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern).format(this.date);
        }
        return this.date.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReviewDefectItem) {
            ReviewDefectItem di = (ReviewDefectItem)obj;
            return di.id.equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toXml(boolean andGuid) {
        StringBuilder sb = new StringBuilder("<severity>" + this.severity.name() + "</severity>" + "<disposition>" + this.disposition.name() + "</disposition>" + "<injectionActivity>" + this.injectionActivity.name() + "</injectionActivity>" + "<date>" + this.date.getTime() + "</date>" + "<user>" + this.userId + "</user>" + "<description>" + this.description + "</description>" + "<location>" + this.location + "</location>" + "<resolution>" + this.resolution + "</resolution>" + "<closed>" + this.closed + "</closed>" + "<notes>" + this.notes + "</notes>" + "<id>" + this.id + "</id> " + "<closeduserid>" + this.closedUserId + "</closeduserid>");
        if (andGuid) {
            sb.append("<guid>" + this.guid + "</guid>");
        }
        return sb.toString();
    }

    private void fromXml(String xml, boolean andGuid, IAtsPeerToPeerReview review) {
        this.severity = Severity.valueOf(AXml.getTagData((String)xml, (String)"severity"));
        this.disposition = Disposition.valueOf(AXml.getTagData((String)xml, (String)"disposition"));
        this.injectionActivity = InjectionActivity.valueOf(AXml.getTagData((String)xml, (String)"injectionActivity"));
        Date date = new Date();
        date.setTime(Long.valueOf(AXml.getTagData((String)xml, (String)"date")));
        this.date = date;
        this.userId = AXml.getTagData((String)xml, (String)"user");
        this.closedUserId = AXml.getTagData((String)xml, (String)"closeduserid");
        this.description = AXml.getTagData((String)xml, (String)"description");
        this.location = AXml.getTagData((String)xml, (String)"location");
        this.resolution = AXml.getTagData((String)xml, (String)"resolution");
        this.closed = AXml.getTagBooleanData((String)xml, (String)"closed");
        this.notes = AXml.getTagData((String)xml, (String)"notes");
        String idStr = AXml.getTagData((String)xml, (String)"id");
        if (Strings.isNumeric((String)idStr)) {
            this.id = Long.valueOf(idStr);
            if (this.id < 0L) {
                this.id = this.id * -1L;
            }
        }
        this.guid = AXml.getTagData((String)xml, (String)"guid");
        if (this.id == null && Strings.isValid((String)this.guid)) {
            this.id = this.guid.hashCode();
            if (this.id < 0L) {
                this.id = this.id * -1L;
            }
        }
        if (Strings.isInValid((String)this.guid)) {
            this.guid = String.valueOf(this.id);
        }
        if (Strings.isInValid((String)this.guid) && (this.id == null || this.id <= 0L)) {
            throw new OseeArgumentException("Invalid guid/id in review %s and xml [%x]", new Object[]{review.toStringWithId(), xml});
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return (Object)((Object)this.severity) + " - " + (Object)((Object)this.disposition) + " - " + (Object)((Object)this.injectionActivity) + " - " + this.userId + " on " + DateUtil.getMMDDYYHHMM((Date)this.date) + "\n";
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    public void setDisposition(Disposition disposition) {
        this.disposition = disposition;
    }

    public InjectionActivity getInjectionActivity() {
        return this.injectionActivity;
    }

    public void setInjectionActivity(InjectionActivity injectionActivity) {
        this.injectionActivity = injectionActivity;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getClosedUserId() {
        return this.closedUserId;
    }

    public void setClosedUserId(String closedUserId) {
        this.closedUserId = closedUserId;
    }

    public static enum Disposition {
        None,
        Accept,
        Reject,
        Duplicate;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            Disposition[] dispositionArray = Disposition.values();
            int n = dispositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Disposition e = dispositionArray[n2];
                values.add(e.name());
                ++n2;
            }
            return values;
        }
    }

    public static enum InjectionActivity {
        None,
        Planning,
        System_Level_Requirements,
        System_Design,
        Software_Requirements,
        Software_Design,
        Code,
        Test,
        Other;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            InjectionActivity[] injectionActivityArray = InjectionActivity.values();
            int n = injectionActivityArray.length;
            int n2 = 0;
            while (n2 < n) {
                InjectionActivity e = injectionActivityArray[n2];
                values.add(e.name());
                ++n2;
            }
            return values;
        }
    }

    public static enum Severity {
        None,
        Major,
        Minor,
        Issue;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity e = severityArray[n2];
                if (!e.equals((Object)None)) {
                    values.add(e.name());
                }
                ++n2;
            }
            return values;
        }
    }
}

