/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class ListMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 64;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_MIN_SPLIT_SIZE = 128;
    private int cursor;
    private final Function<V, K> keyExtractor;
    private final ArrayList<Element<K, V>> list;
    private transient List<V> listView;
    private final HashMap<K, Element<K, V>> map;
    private transient Map<K, V> mapView;
    private final int minSplitSize;
    private long safety;

    public ListMap() {
        this(64, 0.75f, 128, null);
    }

    public ListMap(int initialCapacity, float loadFactor, int minimumSplitSize) {
        this(initialCapacity, loadFactor, minimumSplitSize, null);
    }

    public ListMap(int initialCapacity, float loadFactor, int minSplitSize, Function<V, K> keyExtractor) {
        if (minSplitSize < 1) {
            throw new IllegalArgumentException("ListMap::new, the parameter \"minSpitSize\" cannot be less than 1.");
        }
        this.map = new HashMap(initialCapacity, loadFactor);
        this.list = new ArrayList(initialCapacity);
        this.minSplitSize = minSplitSize;
        this.cursor = -1;
        this.safety = 0L;
        this.keyExtractor = keyExtractor;
        this.mapView = null;
        this.listView = null;
    }

    public Stream<Element<K, V>> backwardsStream(boolean parallel) {
        return this.getBackwardsSpliterator().map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> backwardsStream(int index, boolean parallel) {
        return this.getBackwardsSpliterator((K)index).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> backwardsStream(K key, boolean parallel) {
        return this.getBackwardsSpliterator(key).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public void clear() {
        this.cursor = -1;
        this.map.clear();
        this.list.clear();
    }

    private Optional<Element<K, V>> findValue(V value) {
        if (Objects.nonNull(this.keyExtractor)) {
            K key = this.keyExtractor.apply(value);
            return Optional.of(this.map.get(key));
        }
        for (Element<K, V> element : this.list) {
            if (!element.getValue().equals(value)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public Stream<Element<K, V>> forwardStream(boolean parallel) {
        return this.getForwardSpliterator().map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> forwardStream(int index, boolean parallel) {
        return this.getForwardSpliterator((K)index).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> forwardStream(K key, boolean parallel) {
        return this.getForwardSpliterator(key).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Optional<V> get(int index) {
        if (this.outOfBounds(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(index);
        this.cursor = index;
        return Optional.of(element.getValue());
    }

    public Optional<V> get(K key) {
        if (Objects.isNull(key)) {
            return Optional.empty();
        }
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = element.getPosition();
        assert (this.inBounds(this.cursor)) : new Message().title("ListMap::get, position from an element is out of bounds.").indentInc().segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getValue());
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator() {
        Spliterator<Element<K, V>> spliterator = this.getBackwardsSpliterator(this.list.size() - 1, 0, this.safety);
        return Optional.ofNullable(spliterator);
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator(int index) {
        if (this.outOfBounds(index)) {
            return Optional.empty();
        }
        Spliterator<Element<K, V>> spliterator = this.getBackwardsSpliterator(index, 0, this.safety);
        return Optional.ofNullable(spliterator);
    }

    private Spliterator<Element<K, V>> getBackwardsSpliterator(int start, int end, long safetyMark) {
        if (start < 0 || start >= this.list.size() || end > start || end < 0) {
            return null;
        }
        Spliterator spliterator = new Spliterator<Element<K, V>>(start, end, safetyMark){
            private Element<K, V> currentElement;
            private Element<K, V> lastElement;
            private final long safety;
            {
                this.currentElement = ListMap.this.list.get(n);
                this.lastElement = ListMap.this.list.get(n2);
                this.safety = l;
            }

            @Override
            public int characteristics() {
                this.checkSafety();
                return 16720;
            }

            private void checkSafety() {
                if (this.safety != ListMap.this.safety) {
                    throw new ConcurrentModificationException("A ListMap forwared spliterator detected a modification of the ListMap.");
                }
            }

            @Override
            public long estimateSize() {
                this.checkSafety();
                return this.currentElement.getPosition() - this.lastElement.getPosition() + 1;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element<K, V>> action) {
                this.checkSafety();
                if (Objects.isNull(this.currentElement)) {
                    return false;
                }
                action.accept(this.currentElement);
                if (this.currentElement == this.lastElement) {
                    this.currentElement = null;
                    return true;
                }
                int position = this.currentElement.getPosition();
                this.currentElement = ListMap.this.list.get(--position);
                return true;
            }

            @Override
            public Spliterator<Element<K, V>> trySplit() {
                this.checkSafety();
                int c = this.currentElement.getPosition();
                int l = this.lastElement.getPosition();
                int r = c - l + 1;
                int h = r >>> 1;
                if (h < ListMap.this.minSplitSize) {
                    return null;
                }
                int ac = c;
                int al = c - h + 1;
                int bc = c - h;
                int bl = l;
                this.currentElement = ListMap.this.list.get(bc);
                this.lastElement = ListMap.this.list.get(bl);
                return ListMap.this.getBackwardsSpliterator(ac, al, this.safety);
            }
        };
        return spliterator;
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            return Optional.empty();
        }
        int index = element.getPosition();
        return this.getBackwardsSpliterator((K)index);
    }

    public Optional<V> getCurrent() {
        if (this.outOfBounds(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.cursor);
        assert (element.getPosition() == this.cursor) : new Message().title("ListMap::getCurrent, position from element at cursor does not match cursor position.").indentInc().segment((CharSequence)"Cursor Position", this.cursor).segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getValue());
    }

    public Optional<K> getCurrentKey() {
        if (this.outOfBounds(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.cursor);
        assert (element.getPosition() == this.cursor) : new Message().title("ListMap::getCurrentKey, position from element at cursor does not match cursor position.").indentInc().segment((CharSequence)"Cursor Position", this.cursor).segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getKey());
    }

    public int getCurrentPosition() {
        return this.inBounds(this.cursor) ? this.cursor : (this.cursor = -1);
    }

    public Optional<V> getFirst() {
        if (this.list.isEmpty()) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(0);
        assert (element.getPosition() == 0) : new Message().title("ListMap::getFirst, position from element at start of list is not zero.").indentInc().segment((CharSequence)"Element", element).toString();
        this.cursor = element.getPosition();
        return Optional.of(element.getValue());
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator() {
        Spliterator<Element<K, V>> spliterator = this.getForwardSpliterator(0, this.list.size() - 1, this.safety);
        return Optional.ofNullable(spliterator);
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator(int index) {
        if (this.outOfBounds(index)) {
            return Optional.empty();
        }
        Spliterator<Element<K, V>> spliterator = this.getForwardSpliterator(index, this.list.size() - 1, this.safety);
        return Optional.ofNullable(spliterator);
    }

    private Spliterator<Element<K, V>> getForwardSpliterator(int start, int end, long safetyMark) {
        if (this.outOfBounds(start) || this.outOfBounds(end) || end < start) {
            throw new IndexOutOfBoundsException();
        }
        Spliterator spliterator = new Spliterator<Element<K, V>>(start, end, safetyMark){
            private Element<K, V> currentElement;
            private Element<K, V> lastElement;
            private final long safety;
            {
                this.currentElement = ListMap.this.list.get(n);
                this.lastElement = ListMap.this.list.get(n2);
                this.safety = l;
            }

            @Override
            public int characteristics() {
                this.checkSafety();
                return 16720;
            }

            private void checkSafety() {
                if (this.safety != ListMap.this.safety) {
                    throw new ConcurrentModificationException("A ListMap forwared spliterator detected a modification of the ListMap.");
                }
            }

            @Override
            public long estimateSize() {
                this.checkSafety();
                return this.lastElement.getPosition() - this.currentElement.getPosition() - 1;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element<K, V>> action) {
                this.checkSafety();
                if (Objects.isNull(this.currentElement)) {
                    return false;
                }
                action.accept(this.currentElement);
                if (this.currentElement == this.lastElement) {
                    this.currentElement = null;
                    return true;
                }
                int position = this.currentElement.getPosition();
                this.currentElement = ListMap.this.list.get(++position);
                return true;
            }

            @Override
            public Spliterator<Element<K, V>> trySplit() {
                this.checkSafety();
                int c = this.currentElement.getPosition();
                int l = this.lastElement.getPosition();
                int r = l - c + 1;
                int h = r >>> 1;
                if (h < ListMap.this.minSplitSize) {
                    return null;
                }
                int ac = c;
                int al = c + h - 1;
                int bc = c + h;
                int bl = l;
                this.currentElement = ListMap.this.list.get(bc);
                this.lastElement = ListMap.this.list.get(bl);
                return ListMap.this.getForwardSpliterator(ac, al, this.safety);
            }
        };
        return spliterator;
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            return Optional.empty();
        }
        int index = element.getPosition();
        return this.getForwardSpliterator((K)index);
    }

    public Optional<V> getLast() {
        if (this.list.isEmpty()) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.list.size() - 1);
        this.cursor = element.getPosition();
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext() {
        if (this.outOfBoundsOrAtEnd(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(++this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext(int index) {
        if (this.outOfBoundsOrAtEnd(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = index + 1;
        Element<K, V> element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        int position = element.getPosition();
        if (this.outOfBoundsOrAtEnd(position)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = position + 1;
        element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious() {
        if (this.outOfBoundsOrAtStart(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(--this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious(int index) {
        if (this.outOfBoundsOrAtStart(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = index - 1;
        Element<K, V> element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        int position = element.getPosition();
        if (this.outOfBoundsOrAtStart(position)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = position - 1;
        element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    private boolean inBounds(int index) {
        return index >= 0 && index < this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<V> listView() {
        return Objects.nonNull(this.listView) ? this.listView : (this.listView = new ListView());
    }

    public Map<K, V> mapView() {
        return Objects.nonNull(this.mapView) ? this.mapView : (this.mapView = new MapView());
    }

    private boolean outOfBounds(int index) {
        return index < 0 || index >= this.list.size();
    }

    private boolean outOfBoundsOrAtEnd(int index) {
        return this.outOfBounds(index) || index == this.list.size() - 1;
    }

    private boolean outOfBoundsOrAtStart(int index) {
        return this.outOfBounds(index) || index == 0;
    }

    public Optional<V> put(K key, V value) {
        Objects.requireNonNull(key, "ListMap::put, parameter \"key\" cannot be null.");
        Objects.requireNonNull(value, "ListMap::put parameter \"value\" cannot be null.");
        Element<K, V> oldElement = this.map.get(key);
        if (Objects.nonNull(oldElement)) {
            int position = oldElement.getPosition();
            Element<K, V> element = new Element<K, V>(key, value, position);
            this.map.put(key, element);
            this.list.set(position, element);
            ++this.safety;
            this.cursor = position;
            return Optional.of(oldElement.getValue());
        }
        int position = this.list.size();
        Element<K, V> element = new Element<K, V>(key, value, position);
        this.map.put(key, element);
        this.list.add(element);
        ++this.safety;
        this.cursor = position;
        return Optional.empty();
    }

    public Optional<V> put(K key, V value, int index) {
        Objects.requireNonNull(key, "ListMap::put, parameter \"key\" cannot be null.");
        Objects.requireNonNull(value, "ListMap::put parameter \"value\" cannot be null.");
        if (index < 0 || index > this.list.size()) {
            throw new IndexOutOfBoundsException("ListMap::put parameter \"index\" is out of bounds.");
        }
        Element<K, V> oldElement = this.map.get(key);
        if (Objects.nonNull(oldElement)) {
            int position = oldElement.getPosition();
            Element<K, V> element = new Element<K, V>(key, value, position);
            this.map.put(key, element);
            this.list.set(position, element);
            ++this.safety;
            this.cursor = position;
            return Optional.of(oldElement.getValue());
        }
        Element<K, V> element = new Element<K, V>(key, value, index);
        this.map.put(key, element);
        this.list.add(index, element);
        ++this.safety;
        this.cursor = index;
        int i = index + 1;
        while (i < this.list.size()) {
            Element<K, V> oldListElement = this.list.get(i);
            Element<K, V> newListElement = new Element<K, V>(oldListElement.getKey(), oldListElement.getValue(), i);
            this.list.set(i, newListElement);
            ++i;
        }
        return Optional.empty();
    }

    public Optional<V> put(V value) {
        if (Objects.isNull(this.keyExtractor)) {
            throw new UnsupportedOperationException("ListMap::put(V value), a key extractor function is not available.");
        }
        Objects.requireNonNull(value, "ListMap::put parameter \"value\" cannot be null.");
        return this.put(this.keyExtractor.apply(value), value);
    }

    public void putAll(List<? extends V> list) {
        if (Objects.isNull(this.keyExtractor)) {
            throw new UnsupportedOperationException("ListMap::putAll(List<V> list), a key extractor function is not available.");
        }
        list.forEach(value -> {
            Optional<Object> optional = this.put(this.keyExtractor.apply(value), value);
        });
    }

    public void putAll(ListMap<? extends K, ? extends V> listMap) {
        listMap.list.forEach((Consumer<Element<K, V>>)((Consumer<Element>)entry -> {
            Optional optional = this.put(entry.getKey(), entry.getValue());
        }));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().forEach(entry -> {
            Optional optional = this.put(entry.getKey(), entry.getValue());
        });
    }

    public Optional<V> remove(K key) {
        if (Objects.isNull(key)) {
            return Optional.empty();
        }
        this.cursor = -1;
        Element<K, V> element = this.map.remove(key);
        if (Objects.isNull(element)) {
            return Optional.empty();
        }
        int position = element.getPosition();
        this.list.remove(position);
        return Optional.of(element.getValue());
    }

    public int size() {
        return this.list.size();
    }

    public static class Element<K, V> {
        private final K key;
        private final int position;
        private final V value;

        Element(K key, V value, int position) {
            this.key = Objects.requireNonNull(key, "ListMap.Element::new, null keys are not allowed.");
            this.value = Objects.requireNonNull(value, "ListMap.Element::new, null values are not allowed.");
            if (position < 0) {
                throw new IndexOutOfBoundsException("ListMap.Element::new, position is less than zero.");
            }
            this.position = position;
        }

        public K getKey() {
            return this.key;
        }

        int getPosition() {
            return this.position;
        }

        public V getValue() {
            return this.value;
        }
    }

    final class ListView
    implements List<V> {
        ListView() {
        }

        @Override
        public void add(int index, V value) {
            Objects.requireNonNull(value, "ListMap.ListView::add, parameter \"value\" cannot be null.");
            if (Objects.isNull(ListMap.this.keyExtractor)) {
                throw new UnsupportedOperationException("ListMap.ListView::add(), a key extractor function is not available.");
            }
            ListMap.this.put(ListMap.this.keyExtractor.apply(value), value, index);
        }

        @Override
        public boolean add(V value) {
            Objects.requireNonNull(value, "ListMap.ListView::add, parameter \"value\" cannot be null.");
            if (Objects.isNull(ListMap.this.keyExtractor)) {
                throw new UnsupportedOperationException("ListMap.ListView::add(), a key extractor function is not available.");
            }
            Object key = ListMap.this.keyExtractor.apply(value);
            Element currentValue = ListMap.this.map.get(key);
            if (Objects.isNull(value)) {
                ListMap.this.put(key, value);
                return true;
            }
            if (currentValue.equals(value)) {
                return false;
            }
            ListMap.this.put(key, value);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Objects.requireNonNull(collection, "ListMap.ListView::addAll, parameter \"collection\" cannot be null.");
            if (Objects.isNull(ListMap.this.keyExtractor)) {
                throw new UnsupportedOperationException("ListMap.ListView::addAll(), a key extractor function is not available.");
            }
            if (collection.isEmpty()) {
                return false;
            }
            for (Object value : collection) {
                ListMap.this.put(ListMap.this.keyExtractor.apply(value), value);
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> collection) {
            Objects.requireNonNull(collection, "ListMap.ListView::addAll, parameter \"collection\" cannot be null.");
            if (Objects.isNull(ListMap.this.keyExtractor)) {
                throw new UnsupportedOperationException("ListMap.ListView::addAll(), a key extractor function is not available.");
            }
            if (index < 0 || index > ListMap.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (collection.isEmpty()) {
                return false;
            }
            for (Object value : collection) {
                ListMap.this.put(ListMap.this.keyExtractor.apply(value), value, index++);
            }
            return true;
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            Objects.requireNonNull(object, "ListMap.ListView::contains, parameter \"object\" cannot be null.");
            Object value = object;
            if (Objects.nonNull(ListMap.this.keyExtractor)) {
                Object key = ListMap.this.keyExtractor.apply(value);
                return ListMap.this.map.containsKey(key);
            }
            for (Element entry : ListMap.this.list) {
                if (!value.equals(entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "ListMap.ListView::addAll, parameter \"collection\" cannot be null.");
            for (Object object : collection) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public V get(int index) {
            if (ListMap.this.outOfBounds(index)) {
                throw new IndexOutOfBoundsException(new Message().title("ListMap.ListView::get, index is out of bounds.").indentInc().segment((CharSequence)"index", index).segment((CharSequence)"List Map Size", ListMap.this.size()).toString());
            }
            return ListMap.this.get(index).orElse(null);
        }

        @Override
        public int indexOf(Object object) {
            Object value = object;
            return ListMap.this.findValue(value).map(Element::getPosition).orElse(-1);
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                Iterator<Element<K, V>> entryIterator;
                {
                    this.entryIterator = ((ListView)ListView.this).ListMap.this.list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIterator.hasNext();
                }

                @Override
                public V next() {
                    Element element = this.entryIterator.next();
                    return element.getValue();
                }

                @Override
                public void remove() {
                    this.entryIterator.remove();
                }
            };
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<V> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(int index) {
            if (ListMap.this.outOfBounds(index)) {
                throw new IndexOutOfBoundsException(new Message().title("ListMap.ListView::remove, index is out of bounds.").indentInc().segment((CharSequence)"index", index).segment((CharSequence)"List Map Size", ListMap.this.size()).toString());
            }
            Element element = ListMap.this.list.get(index);
            Object rv = element.getValue();
            ListMap.this.remove(element.getKey());
            return rv;
        }

        @Override
        public boolean remove(Object object) {
            Objects.requireNonNull(object, "ListMap.ListView::remove, parameter \"object\" cannot be null.");
            Object value = object;
            return ListMap.this.findValue(value).map(element -> ListMap.this.remove(element.getKey())).isPresent();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "ListMap.ListView::remove, parameter \"collection\" cannot be null.");
            boolean result = false;
            for (Object object : collection) {
                result |= this.remove(object);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean result = false;
            for (Element element : ListMap.this.list) {
                if (collection.contains(element.getValue())) continue;
                result |= ListMap.this.remove(element.getKey()).isPresent();
            }
            return result;
        }

        @Override
        public V set(int index, V value) {
            Objects.requireNonNull(value, "ListMap.ListView::set, parameter \"value\" cannot be null.");
            if (ListMap.this.outOfBounds(index)) {
                throw new IndexOutOfBoundsException(new Message().title("ListMap.ListView::remove, index is out of bounds.").indentInc().segment((CharSequence)"index", index).segment((CharSequence)"List Map Size", ListMap.this.size()).toString());
            }
            Element oldElement = ListMap.this.list.get(index);
            Element newElement = new Element(oldElement.getKey(), value, index);
            ListMap.this.list.set(index, newElement);
            return oldElement.getValue();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }

    final class MapView
    implements Map<K, V> {
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private transient Collection<V> valueSet = null;

        MapView() {
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            Objects.requireNonNull(key, "ListMap.MapView::containsKey, parameter \"key\" cannot be null.");
            return ListMap.this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object object) {
            Objects.requireNonNull(object, "ListMap.MapView::containsValue, parameter \"object\" cannot be null.");
            Object value = object;
            if (Objects.nonNull(ListMap.this.keyExtractor)) {
                Object key = ListMap.this.keyExtractor.apply(value);
                return ListMap.this.map.containsKey(key);
            }
            for (Element entry : ListMap.this.list) {
                if (!value.equals(entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Objects.nonNull(this.entrySet) ? this.entrySet : (this.entrySet = new EntrySet());
        }

        @Override
        public V get(Object key) {
            Objects.requireNonNull(key, "ListMap.MapView::get, parameter \"key\" cannot be null.");
            Object kKey = key;
            return ListMap.this.get(kKey).orElse(null);
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(ListMap.this.map.keySet());
        }

        @Override
        public V put(K key, V value) {
            Objects.requireNonNull(key, "ListMap.MapView::put, parameter \"key\" cannot be null.");
            Objects.requireNonNull(value, "ListMap.MapView::put, parameter \"value\" cannot be null.");
            return ListMap.this.put(key, value).orElse(null);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            ListMap.this.putAll(map);
        }

        @Override
        public V remove(Object key) {
            Object kKey = key;
            return ListMap.this.remove(kKey).orElse(null);
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }

        @Override
        public Collection<V> values() {
            return Objects.nonNull(this.valueSet) ? this.valueSet : (this.valueSet = new ValueSet());
        }

        final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Element<K, V>> entryIterator;
                    {
                        this.entryIterator = ((MapView)((EntrySet)EntrySet.this).MapView.this).ListMap.this.list.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entryIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Element element = this.entryIterator.next();
                        Map.Entry entry = new Map.Entry<K, V>(element){
                            Element<K, V> entryElement;
                            {
                                this.entryElement = element;
                            }

                            @Override
                            public K getKey() {
                                return this.entryElement.getKey();
                            }

                            @Override
                            public V getValue() {
                                return this.entryElement.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                        return entry;
                    }

                    @Override
                    public void remove() {
                        this.entryIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ((MapView)MapView.this).ListMap.this.map.size();
            }
        }

        final class ValueSet
        extends AbstractCollection<V> {
            ValueSet() {
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Element<K, V>> entryIterator;
                    {
                        this.entryIterator = ((MapView)((ValueSet)ValueSet.this).MapView.this).ListMap.this.list.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entryIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        Element element = this.entryIterator.next();
                        Object value = element.getValue();
                        return value;
                    }

                    @Override
                    public void remove() {
                        this.entryIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ((MapView)MapView.this).ListMap.this.map.size();
            }
        }
    }
}

