/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class AtsUsersUtility {
    private static final Pattern addressPattern = Pattern.compile(".+?@.+?\\.[a-z]+");

    private AtsUsersUtility() {
    }

    public static Collection<AtsUser> getValidEmailUsers(Collection<AtsUser> users) {
        HashSet<AtsUser> validUsers = new HashSet<AtsUser>();
        for (AtsUser user : users) {
            if (!AtsUsersUtility.isEmailValid(user.getEmail())) continue;
            validUsers.add(user);
        }
        return validUsers;
    }

    public static Collection<AtsUser> getActiveEmailUsers(Collection<AtsUser> users) {
        HashSet<AtsUser> activeUsers = new HashSet<AtsUser>();
        for (AtsUser user : users) {
            if (!user.isActive()) continue;
            activeUsers.add(user);
        }
        return activeUsers;
    }

    public static boolean isEmailValid(String email) {
        if (Strings.isValid((String)email)) {
            return addressPattern.matcher(email).matches();
        }
        return false;
    }

    public static Collection<AtsUser> getUsers(Collection<String> userIds, IAtsUserService userService) {
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        for (String userId : userIds) {
            users.add(userService.getUserByUserId(userId));
        }
        return users;
    }
}

