/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.column.AtsColumn;
import org.eclipse.osee.ats.api.column.AtsColumnToken;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.column.IAtsColumnProvider;
import org.eclipse.osee.ats.api.column.IAtsColumnService;
import org.eclipse.osee.ats.api.config.AtsAttrValCol;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.core.column.ActionableItemsColumn;
import org.eclipse.osee.ats.core.column.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.core.column.AgileTeamPointsColumn;
import org.eclipse.osee.ats.core.column.AssigneeColumn;
import org.eclipse.osee.ats.core.column.AtsAttributeValueColumnHandler;
import org.eclipse.osee.ats.core.column.AtsIdColumn;
import org.eclipse.osee.ats.core.column.AttributeColumn;
import org.eclipse.osee.ats.core.column.CancelReasonColumn;
import org.eclipse.osee.ats.core.column.CancelledByColumn;
import org.eclipse.osee.ats.core.column.CancelledDateColumn;
import org.eclipse.osee.ats.core.column.CancelledReasonColumn;
import org.eclipse.osee.ats.core.column.CancelledReasonDetailsColumn;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.core.column.CompletedByColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledByColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledDateColumn;
import org.eclipse.osee.ats.core.column.CompletedDateColumn;
import org.eclipse.osee.ats.core.column.CreatedDateColumn;
import org.eclipse.osee.ats.core.column.DerivedFromAtsIdColumn;
import org.eclipse.osee.ats.core.column.DerivedFromTeamDefColumn;
import org.eclipse.osee.ats.core.column.FeatureImpactReferenceColumn;
import org.eclipse.osee.ats.core.column.FoundInVersionColumn;
import org.eclipse.osee.ats.core.column.IdColumn;
import org.eclipse.osee.ats.core.column.ImplementerColumn;
import org.eclipse.osee.ats.core.column.IncorporatedInColumn;
import org.eclipse.osee.ats.core.column.InsertionActivityColumn;
import org.eclipse.osee.ats.core.column.InsertionColumn;
import org.eclipse.osee.ats.core.column.ParentTitleColumn;
import org.eclipse.osee.ats.core.column.PercentCompleteTasksColumn;
import org.eclipse.osee.ats.core.column.PriorityColumn;
import org.eclipse.osee.ats.core.column.SprintOrderColumn;
import org.eclipse.osee.ats.core.column.StateColumn;
import org.eclipse.osee.ats.core.column.TargetedVersionColumn;
import org.eclipse.osee.ats.core.column.TaskPointsColumn;
import org.eclipse.osee.ats.core.column.TaskRelatedArtifactTypeColumn;
import org.eclipse.osee.ats.core.column.TaskRiskFactorsColumn;
import org.eclipse.osee.ats.core.column.TeamColumn;
import org.eclipse.osee.ats.core.column.TitleColumn;
import org.eclipse.osee.ats.core.column.TypeColumn;
import org.eclipse.osee.ats.core.internal.column.WorkDefinitionColumn;
import org.eclipse.osee.ats.core.internal.column.ev.AtsColumnProviderCollector;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageIdColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageNameColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageProgramColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageTypeColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;

public class AtsColumnService
implements IAtsColumnService {
    public static final String CELL_ERROR_PREFIX = "!Error";
    private Map<String, AtsColumn> columnIdToAtsColumn;
    private final AtsApi atsApi;

    public AtsColumnService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public AtsColumn getColumn(String id) {
        AtsColumn column;
        if (this.columnIdToAtsColumn == null) {
            this.columnIdToAtsColumn = new HashMap<String, AtsColumn>();
        }
        if ((column = this.columnIdToAtsColumn.get(id)) != null) {
            return column;
        }
        for (AtsAttrValCol attrCol : this.atsApi.getConfigService().getConfigurations().getViews().getAttrColumns()) {
            if (!id.equals(attrCol.getId())) continue;
            column = new AtsAttributeValueColumnHandler(attrCol, this.atsApi);
            break;
        }
        if (column == null) {
            if (id.equals(AtsColumnTokens.LegacyPcrIdColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.LegacyPcrIdColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.QuantityUnderReviewColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.QuantityUnderReviewColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.NotesColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.NotesColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.PercentCompleteWorkflowColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.PercentCompleteWorkflowColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.UnPlannedWorkColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.UnPlannedWorkColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.CrashOrBlankDisplayColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.CrashOrBlankDisplayColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.ExternalReferenceColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.ExternalReferenceColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.HowToReproduceProblemColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.HowToReproduceProblemColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.ProblemFirstObservedColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.ProblemFirstObservedColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.RiskAnalysisColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.RiskAnalysisColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.RevisitDateColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.RevisitDateColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.RootCauseColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.RootCauseColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.ProposedResolutionColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.ProposedResolutionColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.ImpactToMissionOrCrewColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.ImpactToMissionOrCrewColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkaroundColumn.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnTokens.WorkaroundColumn, this.atsApi);
            } else if (id.equals(AtsColumnTokens.ActionableItemsColumn.getId())) {
                column = new ActionableItemsColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TeamColumn.getId())) {
                column = new TeamColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.AssigneeColumn.getId())) {
                column = new AssigneeColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.AtsIdColumn.getId())) {
                column = new AtsIdColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.ActivityIdColumn.getId())) {
                column = new WorkPackageColumn(this.atsApi.getEarnedValueServiceProvider());
            } else if (id.equals(AtsColumnTokens.ImplementersColumn.getId())) {
                column = new ImplementerColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CreatedDateColumn.getId())) {
                column = new CreatedDateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CompletedDateColumn.getId())) {
                column = new CompletedDateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CancelledDateColumn.getId())) {
                column = new CancelledDateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CancelledByColumn.getId())) {
                column = new CancelledByColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CancelledReason.getId())) {
                column = new CancelledReasonColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CancelReason.getId())) {
                column = new CancelReasonColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CancelledReasonDetails.getId())) {
                column = new CancelledReasonDetailsColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.ChangeTypeColumn.getId())) {
                column = new ChangeTypeColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.PriorityColumn.getId())) {
                column = new PriorityColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CompletedByColumn.getId())) {
                column = new CompletedByColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CompletedCancelledByColumn.getId())) {
                column = new CompletedCancelledByColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CompletedCancelledDateColumn.getId())) {
                column = new CompletedCancelledDateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.StateColumn.getId())) {
                column = new StateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.NameColumn.getId()) || id.equals(AtsColumnTokens.TitleColumn.getId())) {
                column = new TitleColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TypeColumn.getId())) {
                column = new TypeColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.PercentCompleteTasksColumn.getId())) {
                column = new PercentCompleteTasksColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.IdColumn.getId())) {
                column = new IdColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkDefinitionColumn.getId())) {
                column = new WorkDefinitionColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkPackageNameColumn.getId())) {
                column = new WorkPackageNameColumn(this.atsApi.getEarnedValueServiceProvider(), this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkPackageIdColumn.getId())) {
                column = new WorkPackageIdColumn(this.atsApi.getEarnedValueServiceProvider(), this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkPackageTypeColumn.getId())) {
                column = new WorkPackageTypeColumn(this.atsApi.getEarnedValueServiceProvider(), this.atsApi);
            } else if (id.equals(AtsColumnTokens.WorkPackageProgramColumn.getId())) {
                column = new WorkPackageProgramColumn(this.atsApi.getEarnedValueServiceProvider(), this.atsApi);
            } else if (id.equals(AtsColumnTokens.StateColumn.getId())) {
                column = new StateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.InsertionColumn.getId())) {
                column = new InsertionColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.InsertionActivityColumn.getId())) {
                column = new InsertionActivityColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TargetedVersionColumn.getId())) {
                column = new TargetedVersionColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.FoundInVersionColumn.getId())) {
                column = new FoundInVersionColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.SprintOrderColumn.getId())) {
                column = new SprintOrderColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.AgileTeamPointsColumn.getId())) {
                column = new AgileTeamPointsColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.CompletedCancelledDateColumn.getId())) {
                column = new CompletedCancelledDateColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.AgileFeatureGroupColumn.getId())) {
                column = new AgileFeatureGroupColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TaskToRelatedArtifactTypeColumnToken.getId())) {
                column = new TaskRelatedArtifactTypeColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.ParentTitleColumn.getId())) {
                column = new ParentTitleColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.IncorporatedInColumn.getId())) {
                column = new IncorporatedInColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.FeatureImpactReferenceColumn.getId())) {
                column = new FeatureImpactReferenceColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TaskPointsColumn.getId())) {
                column = new TaskPointsColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.TaskRiskFactorsColumn.getId())) {
                column = new TaskRiskFactorsColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.DerivedFromAtsIdColumn.getId())) {
                column = new DerivedFromAtsIdColumn(this.atsApi);
            } else if (id.equals(AtsColumnTokens.DerivedFromTeamDefColumn.getId())) {
                column = new DerivedFromTeamDefColumn(this.atsApi);
            }
        }
        if (column == null) {
            for (IAtsColumnProvider provider : AtsColumnProviderCollector.getColumnProviders()) {
                column = provider.getColumn(id, this.atsApi);
                if (column != null) break;
            }
        }
        if (column == null) {
            AttributeTypeGeneric attrType;
            if (id.startsWith("attribute.")) {
                attrType = this.atsApi.tokenService().getAttributeType(id.replaceFirst("attribute\\.", ""));
                column = new AttributeColumn(this.atsApi, (AttributeTypeToken)attrType);
            }
            if (id.startsWith("ats.")) {
                try {
                    attrType = this.atsApi.tokenService().getAttributeType(id);
                    if (attrType != null) {
                        column = new AttributeColumn(this.atsApi, (AttributeTypeToken)attrType);
                    }
                }
                catch (OseeTypeDoesNotExist oseeTypeDoesNotExist) {}
            }
        }
        this.add(id, column);
        return column;
    }

    public String getColumnText(AtsColumnToken column, IAtsObject atsObject) {
        return this.getColumnText(column.getId(), atsObject);
    }

    public String getColumnText(String id, IAtsObject atsObject) {
        String result = "";
        AtsColumn column = this.getColumn(id);
        result = column == null ? "column not supported" : column.getColumnText(atsObject);
        return result;
    }

    public String getColumnText(AtsConfigurations configurations, AtsColumnToken column, IAtsObject atsObject) {
        return this.getColumnText(configurations, column.getId(), atsObject);
    }

    public String getColumnText(AtsConfigurations configurations, String id, IAtsObject atsObject) {
        String result = "";
        AtsColumn column = this.getColumn(id);
        result = column == null ? "column not supported" : column.getColumnText(atsObject);
        return result;
    }

    public void add(String id, AtsColumn column) {
        this.columnIdToAtsColumn.put(id, column);
    }

    public AtsColumn getColumn(AtsColumnToken columnId) {
        return this.getColumn(columnId.getId());
    }

    public Collection<IAtsColumnProvider> getColumProviders() {
        return AtsColumnProviderCollector.getColumnProviders();
    }
}

