/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;

public class ActionableItemServiceImpl
implements IAtsActionableItemService {
    private final IAttributeResolver attrResolver;
    private final AtsApi atsApi;

    public ActionableItemServiceImpl(IAttributeResolver attrResolver, AtsApi atsApi) {
        this.attrResolver = attrResolver;
        this.atsApi = atsApi;
    }

    public ActionableItem getActionableItemById(ArtifactId aiId) {
        ActionableItem ai = null;
        if (aiId instanceof ActionableItem) {
            ai = (ActionableItem)aiId;
        }
        if (ai == null) {
            ai = (ActionableItem)this.atsApi.getConfigService().getConfigurations().getIdToAi().get(aiId.getId());
        }
        if (ai == null) {
            if (this.atsApi.isIde()) {
                ai = this.atsApi.getServerEndpoints().getConfigEndpoint().getActionableItem(ArtifactId.valueOf((Long)aiId.getId()));
                ai.setAtsApi(this.atsApi);
            } else {
                ArtifactToken aiArt = this.atsApi.getQueryService().getArtifact(aiId);
                if (aiArt == null) {
                    return ai;
                }
                if (aiArt.isValid()) {
                    ActionableItem ai2 = this.createActionableItem(aiArt);
                    this.atsApi.getConfigService().getConfigurations().addAi(ai2);
                    ai = ai2;
                }
            }
        }
        return ai;
    }

    public ActionableItem createActionableItem(ArtifactToken aiArt) {
        ArtifactToken parent;
        ActionableItem ai = new ActionableItem(aiArt, this.atsApi);
        ai.setName(aiArt.getName());
        ai.setId(aiArt.getId());
        ai.setGuid(aiArt.getGuid());
        ArtifactId programId = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
        if (programId.isValid()) {
            ai.setProgramId(programId.getIdString());
        }
        for (String workTypeStr : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.WorkType)) {
            WorkType workType = WorkType.valueOfOrNone((String)workTypeStr);
            if (!workType.isNotNone()) continue;
            ai.getWorkTypes().add(workType);
        }
        ai.getTags().addAll(this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)aiArt, (AttributeTypeToken)CoreAttributeTypes.StaticId));
        for (String csci : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.CSCI)) {
            ai.getCscis().add(csci);
        }
        ai.setDescription((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)""));
        ai.setActive(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        ai.setActionable(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true)).booleanValue());
        ai.setAllowUserActionCreation(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.AllowUserActionCreation, (Object)true)).booleanValue());
        ArtifactToken teamDefArt = this.atsApi.getRelationResolver().getRelatedOrNull((ArtifactId)aiArt, AtsRelationTypes.TeamActionableItem_TeamDefinition);
        if (teamDefArt != null && teamDefArt.isValid()) {
            ai.setTeamDefId(teamDefArt.getId());
        }
        if ((parent = this.atsApi.getRelationResolver().getParent((ArtifactId)aiArt)) != null) {
            ai.setParentId(parent.getId());
        }
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)aiArt)) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) continue;
            ai.getChildren().add(child.getId());
        }
        return ai;
    }

    public List<IAtsActionableItem> getActiveActionableItemsAndChildren(IAtsTeamDefinition teamDef) {
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        this.getActiveActionableItemsAndChildrenRecurse((TeamDefinition)teamDef, ais);
        return ais;
    }

    private void getActiveActionableItemsAndChildrenRecurse(TeamDefinition teamDef, List<IAtsActionableItem> ais) {
        for (ActionableItem ai : teamDef.getActionableItems()) {
            if (!ai.isActive() || !ai.isActionable()) continue;
            ais.add((IAtsActionableItem)ai);
        }
        for (TeamDefinition childTeamDef : teamDef.getChildrenTeamDefs()) {
            this.getActiveActionableItemsAndChildrenRecurse(childTeamDef, ais);
        }
    }

    public Set<IAtsActionableItem> getActionableItems(IAtsWorkItem workItem) {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        if (!this.atsApi.getStoreService().isDeleted((IAtsObject)workItem)) {
            for (ArtifactId id : this.getActionableItemIds(workItem)) {
                ActionableItem aia = this.getActionableItemById(id);
                if (aia == null) {
                    OseeLog.logf(ActionableItemServiceImpl.class, (Level)Level.SEVERE, (String)"Actionable Item id [%s] from [%s] doesn't match item in AtsConfigCache", (Object[])new Object[]{id, workItem.toStringWithId()});
                    continue;
                }
                ais.add((IAtsActionableItem)aia);
            }
        }
        return ais;
    }

    public String getActionableItemsStr(IAtsWorkItem workItem) {
        return AtsObjects.toString("; ", this.getActionableItems(workItem));
    }

    public Collection<ArtifactId> getActionableItemIds(IAtsWorkItem workItem) {
        return this.attrResolver.getAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
    }

    public void addActionableItem(IAtsWorkItem workItem, IAtsActionableItem aia, IAtsChangeSet changes) {
        if (!this.getActionableItemIds(workItem).contains(aia.getArtifactId())) {
            changes.addAttribute((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, (Object)aia.getStoreObject());
        }
    }

    public void removeActionableItem(IAtsWorkItem workItem, IAtsActionableItem aia, IAtsChangeSet changes) {
        changes.deleteAttribute((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, (Object)aia.getStoreObject());
    }

    public Result setActionableItems(IAtsWorkItem workItem, Collection<IAtsActionableItem> newItems, IAtsChangeSet changes) {
        Set<IAtsActionableItem> existingAias = this.getActionableItems(workItem);
        for (IAtsActionableItem existingAia : existingAias) {
            if (newItems.contains(existingAia)) continue;
            this.removeActionableItem(workItem, existingAia, changes);
        }
        for (IAtsActionableItem newItem : newItems) {
            if (existingAias.contains(newItem)) continue;
            this.addActionableItem(workItem, newItem, changes);
        }
        return Result.TrueResult;
    }

    public boolean hasActionableItems(IAtsWorkItem workItem) {
        return this.attrResolver.getAttributeCount(workItem, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference) > 0;
    }

    public Collection<ActionableItem> getActionableItems(IAtsTeamDefinition teamDef) {
        return teamDef.getActionableItems();
    }

    public IAtsActionableItem getActionableItem(IAtsTeamDefinition teamDef) {
        ActionableItem ai = null;
        Collection related = teamDef.getActionableItems();
        if (related != null) {
            if (related.isEmpty()) {
                return null;
            }
            if (related.size() > 1) {
                throw new OseeStateException("Multiple AIs related to teamDef; Invalid method for this", new Object[0]);
            }
            if (related.size() == 1) {
                ai = (ActionableItem)related.iterator().next();
            }
        }
        return ai;
    }

    public Collection<IAtsActionableItem> getActionableItems(IAtsAction action) {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        for (IAtsTeamWorkflow team : this.atsApi.getWorkItemService().getTeams((Object)action)) {
            aias.addAll(this.atsApi.getActionableItemService().getActionableItems((IAtsWorkItem)team));
        }
        return aias;
    }

    public ActionableItem createActionableItem(String name, long id, IAtsChangeSet changes) {
        ArtifactToken artifact = changes.createArtifact(AtsArtifactTypes.ActionableItem, name, Long.valueOf(id));
        return this.createActionableItem(artifact);
    }

    public ActionableItem createActionableItem(String name, IAtsChangeSet changes) {
        return this.createActionableItem(name, Lib.generateArtifactIdAsInt(), changes);
    }

    public IAtsActionableItem getActionableItem(String value) {
        return this.getActionableItemById(ArtifactId.valueOf((String)value));
    }

    public Collection<AtsUser> getSubscribed(IAtsActionableItem ai) {
        return this.atsApi.getUserService().getRelatedUsers(this.atsApi, ai.getArtifactToken(), AtsRelationTypes.SubscribedUser_User);
    }

    public Collection<AtsUser> getLeads(IAtsActionableItem ai) {
        return this.atsApi.getUserService().getRelatedUsers(this.atsApi, ai.getStoreObject(), AtsRelationTypes.TeamLead_Lead);
    }

    public IAtsTeamDefinition getTeamDefinitionInherited(IAtsActionableItem ai) {
        return this.atsApi.getTeamDefinitionService().getImpactedTeamDef(ai);
    }

    public Set<IAtsActionableItem> getAIsFromItemAndChildren(IAtsActionableItem ai) {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        ais.add(ai);
        for (IAtsActionableItem art : ai.getChildrenActionableItems()) {
            ais.addAll(this.getAIsFromItemAndChildren(art));
        }
        return ais;
    }

    public Set<IAtsActionableItem> getActionableItemsFromItemAndChildren(IAtsActionableItem ai) {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        this.getActionableItemsFromItemAndChildren(ai, ais);
        return ais;
    }

    public void getActionableItemsFromItemAndChildren(IAtsActionableItem ai, Set<IAtsActionableItem> aias) {
        for (IAtsActionableItem art : ai.getChildrenActionableItems()) {
            aias.add(art);
            for (IAtsActionableItem childArt : ai.getChildrenActionableItems()) {
                this.getActionableItemsFromItemAndChildren(childArt, aias);
            }
        }
    }

    public Set<IAtsActionableItem> getActionableItems(Collection<String> actionableItemNames) {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        for (ActionableItem ai : this.atsApi.getConfigService().getConfigurations().getIdToAi().values()) {
            if (!actionableItemNames.contains(ai.getName())) continue;
            ais.add((IAtsActionableItem)ai);
        }
        return ais;
    }

    public Collection<IAtsTeamDefinition> getImpactedTeamDefs(Collection<IAtsActionableItem> ais) {
        return this.atsApi.getTeamDefinitionService().getImpactedTeamDefs(ais);
    }

    public Collection<IAtsActionableItem> getActionableItems(Active active, IAtsQueryService queryService) {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        for (ActionableItem ai : this.atsApi.getConfigService().getConfigurations().getIdToAi().values()) {
            if (active != Active.Both && (active != Active.Active || !ai.isActive()) && (active != Active.InActive || !ai.isInActive())) continue;
            ais.add((IAtsActionableItem)ai);
        }
        return ais;
    }

    public String getNotActionableItemError(IAtsConfigObject configObject) {
        return "Action can not be written against " + configObject.getName() + " \"" + configObject + "\" (" + configObject.getIdString() + ").\n\nChoose another item.";
    }

    public ActionableItem getTopActionableItem(AtsApi atsApi) {
        return atsApi.getActionableItemService().getActionableItemById(atsApi.getConfigService().getConfigurations().getTopActionableItem());
    }

    public Collection<IAtsActionableItem> getActionableItemsAll(IAtsQueryService queryService) {
        return this.getActionableItems(Active.Both, queryService);
    }

    public List<IAtsActionableItem> getTopLevelActionableItems(Active active) {
        ActionableItem topAi = this.getTopActionableItem(this.atsApi);
        if (topAi == null) {
            return Collections.emptyList();
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getActive(this.getChildren((IAtsActionableItem)topAi, false), active));
    }

    public List<IAtsActionableItem> getActive(Collection<IAtsActionableItem> ais, Active active) {
        ArrayList<IAtsActionableItem> results = new ArrayList<IAtsActionableItem>();
        for (IAtsActionableItem ai : ais) {
            if (active == Active.Both) {
                results.add(ai);
                continue;
            }
            boolean attributeActive = ai.isActive();
            if (active == Active.Active && attributeActive) {
                results.add(ai);
                continue;
            }
            if (active != Active.InActive || attributeActive) continue;
            results.add(ai);
        }
        return results;
    }

    public Set<IAtsActionableItem> getChildren(IAtsActionableItem topActionableItem, boolean recurse) {
        HashSet<IAtsActionableItem> children = new HashSet<IAtsActionableItem>();
        for (IAtsActionableItem child : topActionableItem.getChildrenActionableItems()) {
            children.add(child);
            if (!recurse) continue;
            children.addAll(this.getChildren(child, recurse));
        }
        return children;
    }

    public Collection<IAtsActionableItem> getUserEditableActionableItems(Collection<IAtsActionableItem> actionableItems) {
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        for (IAtsActionableItem ai : actionableItems) {
            if (!ai.isAllowUserActionCreation()) continue;
            ais.add(ai);
        }
        return ais;
    }
}

