/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile.operations;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.IAgileStory;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxAgileStory;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.agile.AgileFolders;
import org.eclipse.osee.ats.core.agile.AgileProgram;
import org.eclipse.osee.ats.core.agile.AgileProgramBacklog;
import org.eclipse.osee.ats.core.agile.AgileProgramBacklogItem;
import org.eclipse.osee.ats.core.agile.AgileProgramFeature;
import org.eclipse.osee.ats.core.agile.AgileStory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class AgileProgramOperations {
    private final AtsApi atsApi;

    public AgileProgramOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public IAgileProgram createAgileProgram(IAgileProgram agileProgram) {
        ArtifactToken userArt = this.atsApi.getQueryService().getArtifact((IAtsObject)this.atsApi.getUserService().getCurrentUser());
        ArtifactToken agileProgramArt = this.atsApi.getQueryService().getArtifact((IAtsObject)agileProgram);
        if (agileProgramArt == null) {
            IAtsChangeSet changes = this.atsApi.createChangeSet("Create new Agile Program");
            agileProgramArt = changes.createArtifact(AtsArtifactTypes.AgileProgram, agileProgram.getName(), agileProgram.getId());
            changes.setSoleAttributeValue((ArtifactId)agileProgramArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
            ArtifactId topAgileFolder = AgileFolders.getOrCreateTopAgileFolder(this.atsApi, (ArtifactId)userArt, changes);
            if (topAgileFolder.notEqual((Id)this.atsApi.getRelationResolver().getParent((ArtifactId)agileProgramArt))) {
                changes.unrelateFromAll(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)agileProgramArt);
                changes.addChild(topAgileFolder, (ArtifactId)agileProgramArt);
            }
            for (Long aTeamId : agileProgram.getTeamIds()) {
                IAgileTeam aTeam = (IAgileTeam)this.atsApi.getQueryService().getConfigItem(aTeamId);
                if (aTeam == null) continue;
                changes.unrelateAll((Object)aTeam, CoreRelationTypes.DefaultHierarchical_Parent);
                changes.addChild((ArtifactId)agileProgramArt, (ArtifactId)aTeam.getStoreObject());
            }
            changes.execute();
        }
        return AgileProgramOperations.getAgileProgram(this.atsApi, agileProgramArt);
    }

    public static IAgileProgram getAgileProgram(AtsApi atsApi, Object artifact) {
        AgileProgram program = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            program = new AgileProgram(atsApi.getLogger(), atsApi, art);
        }
        return program;
    }

    public static IAgileProgramFeature getAgileProgramFeature(AtsApi atsApi, Object artifact) {
        AgileProgramFeature feature = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            feature = new AgileProgramFeature(atsApi.getLogger(), atsApi, art);
        }
        return feature;
    }

    public IAgileProgramFeature createAgileProgramFeature(IAgileProgramBacklogItem programBacklogItem, JaxAgileProgramFeature feature) {
        ArtifactToken agileProgramBacklogItemArt = this.atsApi.getQueryService().getArtifact(programBacklogItem.getId());
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create new Agile Program");
        ArtifactToken featureArt = changes.createArtifact(AtsArtifactTypes.AgileProgramFeature, feature.getName(), feature.getId());
        changes.setSoleAttributeValue((ArtifactId)agileProgramBacklogItemArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.addChild((ArtifactId)agileProgramBacklogItemArt, (ArtifactId)featureArt);
        changes.execute();
        return AgileProgramOperations.getAgileProgramFeature(this.atsApi, featureArt);
    }

    public static IAgileStory getAgileStory(AtsApi atsApi, Object artifact) {
        AgileStory story = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            story = new AgileStory(atsApi.getLogger(), atsApi, art);
        }
        return story;
    }

    public IAgileStory createAgileStory(IAgileProgramFeature feature, JaxAgileStory story) {
        ArtifactToken featureArt = this.atsApi.getQueryService().getArtifact(feature.getId());
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create new Agile Story");
        ArtifactToken storyArt = changes.createArtifact(AtsArtifactTypes.AgileStory, story.getName(), story.getId());
        changes.setSoleAttributeValue((ArtifactId)storyArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.addChild((ArtifactId)featureArt, (ArtifactId)storyArt);
        changes.execute();
        return AgileProgramOperations.getAgileStory(this.atsApi, storyArt);
    }

    public static IAgileProgramBacklog getAgileProgramBacklog(AtsApi atsApi, Object artifact) {
        AgileProgramBacklog progBacklog = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            progBacklog = new AgileProgramBacklog(atsApi.getLogger(), atsApi, art);
        }
        return progBacklog;
    }

    public IAgileProgramBacklog createAgileProgramBacklog(IAgileProgram agileProgram, JaxAgileProgramBacklog jaxProgramBacklog) {
        ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(agileProgram.getId());
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create new Program Backlog");
        ArtifactToken programBacklogArt = changes.createArtifact(AtsArtifactTypes.AgileProgramBacklog, jaxProgramBacklog.getName(), jaxProgramBacklog.getId());
        changes.setSoleAttributeValue((ArtifactId)programBacklogArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.addChild((ArtifactId)programArt, (ArtifactId)programBacklogArt);
        changes.execute();
        return AgileProgramOperations.getAgileProgramBacklog(this.atsApi, programBacklogArt);
    }

    public IAgileProgramBacklogItem createAgileProgramBacklogItem(IAgileProgramBacklog agileProgramBacklog, JaxAgileProgramBacklogItem jaxProgramBacklogItem) {
        ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(agileProgramBacklog.getId());
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create new Program Backlog Item");
        ArtifactToken item = changes.createArtifact(AtsArtifactTypes.AgileProgramBacklogItem, jaxProgramBacklogItem.getName(), jaxProgramBacklogItem.getId());
        changes.setSoleAttributeValue((ArtifactId)item, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.addChild((ArtifactId)programArt, (ArtifactId)item);
        changes.execute();
        return AgileProgramOperations.getAgileProgramBacklogItem(this.atsApi, item);
    }

    public static IAgileProgramBacklogItem getAgileProgramBacklogItem(AtsApi atsApi, Object artifact) {
        AgileProgramBacklogItem item = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            item = new AgileProgramBacklogItem(atsApi.getLogger(), atsApi, art);
        }
        return item;
    }
}

