/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceNode
extends PLGenericDBObject {
    public static final InterfaceNode SENTINEL = new InterfaceNode();
    private String description;
    private String interfaceNodeNumber;
    private String interfaceNodeGroupId;
    private ApplicabilityToken applicability;
    private String interfaceNodeBackgroundColor = this.generateColor() ? "#81d4fa" : "#c5e1a5";
    private String interfaceNodeAddress;
    private String nameAbbrev;
    private String interfaceNodeCodeGenName;
    private String InterfaceNodeType;
    private String notes;
    private boolean interfaceNodeCodeGen;
    private boolean interfaceNodeBuildCodeGen;
    private boolean interfaceNodeToolUse;
    private ArtifactReadable artifactReadable;

    public InterfaceNode(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceNode(ArtifactReadable art) {
        super(art);
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceNodeBackgroundColor((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeBackgroundColor, (Object)""));
        this.setInterfaceNodeAddress((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeAddress, (Object)""));
        this.setInterfaceNodeNumber((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeNumber, (Object)""));
        this.setInterfaceNodeGroupId((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeGroupId, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        this.setNameAbbrev((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.NameAbbrev, (Object)""));
        this.setInterfaceNodeCodeGenName((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeCodeGenName, (Object)""));
        this.setInterfaceNodeType((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeType, (Object)""));
        this.setNotes((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Notes, (Object)""));
        this.setInterfaceNodeCodeGen((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeCodeGen, (Object)false));
        this.setInterfaceNodeBuildCodeGen((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeBuildCodeGen, (Object)false));
        this.setInterfaceNodeToolUse((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceNodeToolUse, (Object)false));
        this.setArtifactReadable(art);
    }

    public InterfaceNode(Long id, String name) {
        super(id, name);
    }

    public InterfaceNode() {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public String getInterfaceNodeBackgroundColor() {
        return this.interfaceNodeBackgroundColor;
    }

    public void setInterfaceNodeBackgroundColor(String interfaceNodeBackgroundColor) {
        this.interfaceNodeBackgroundColor = interfaceNodeBackgroundColor;
    }

    public String getInterfaceNodeAddress() {
        return this.interfaceNodeAddress;
    }

    public void setInterfaceNodeAddress(String interfaceNodeAddress) {
        this.interfaceNodeAddress = interfaceNodeAddress;
    }

    public String getInterfaceNodeNumber() {
        return this.interfaceNodeNumber;
    }

    public void setInterfaceNodeNumber(String interfaceNodeNumber) {
        this.interfaceNodeNumber = interfaceNodeNumber;
    }

    public String getInterfaceNodeGroupId() {
        return this.interfaceNodeGroupId;
    }

    public void setInterfaceNodeGroupId(String interfaceNodeGroupId) {
        this.interfaceNodeGroupId = interfaceNodeGroupId;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }

    private void setArtifactReadable(ArtifactReadable artifactReadable) {
        this.artifactReadable = artifactReadable;
    }

    public String getNameAbbrev() {
        return this.nameAbbrev;
    }

    public void setNameAbbrev(String nameAbbrev) {
        this.nameAbbrev = nameAbbrev;
    }

    public String getInterfaceNodeCodeGenName() {
        return this.interfaceNodeCodeGenName;
    }

    public void setInterfaceNodeCodeGenName(String interfaceNodeCodeGenName) {
        this.interfaceNodeCodeGenName = interfaceNodeCodeGenName;
    }

    public String getInterfaceNodeType() {
        return this.InterfaceNodeType;
    }

    public void setInterfaceNodeType(String interfaceNodeType) {
        this.InterfaceNodeType = interfaceNodeType;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isInterfaceNodeCodeGen() {
        return this.interfaceNodeCodeGen;
    }

    public void setInterfaceNodeCodeGen(boolean interfaceNodeCodeGen) {
        this.interfaceNodeCodeGen = interfaceNodeCodeGen;
    }

    public boolean isInterfaceNodeBuildCodeGen() {
        return this.interfaceNodeBuildCodeGen;
    }

    public void setInterfaceNodeBuildCodeGen(boolean interfaceNodeBuildCodeGen) {
        this.interfaceNodeBuildCodeGen = interfaceNodeBuildCodeGen;
    }

    public boolean isInterfaceNodeToolUse() {
        return this.interfaceNodeToolUse;
    }

    public void setInterfaceNodeToolUse(boolean interfaceNodeToolUse) {
        this.interfaceNodeToolUse = interfaceNodeToolUse;
    }

    public String getColor() {
        return this.interfaceNodeBackgroundColor;
    }

    @JsonIgnore
    private boolean generateColor() {
        return ThreadLocalRandom.current().nextInt(1, 3) > 1;
    }
}

