/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.internal.InterfaceEnumerationAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class InterfaceEnumerationApiImpl
implements InterfaceEnumerationApi {
    private ArtifactAccessor<InterfaceEnumeration> accessor;
    private final List<RelationTypeSide> affectedRelations;

    public InterfaceEnumerationApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new InterfaceEnumerationAccessor(orcsApi));
        this.affectedRelations = this.createAffectedRelationTypeSideList();
    }

    @Override
    public ArtifactAccessor<InterfaceEnumeration> getAccessor() {
        return this.accessor;
    }

    private List<RelationTypeSide> createAffectedRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceEnumeration_EnumerationState);
        return relations;
    }

    public void setAccessor(ArtifactAccessor<InterfaceEnumeration> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceEnumeration> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public InterfaceEnumeration get(BranchId branch, ArtifactId enumId, List<FollowRelation> relations) {
        try {
            return this.getAccessor().get(branch, enumId, relations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceEnumeration.SENTINEL;
        }
    }

    @Override
    public List<InterfaceEnumeration> get(BranchId branch, List<ArtifactId> enumIds, List<FollowRelation> relations) {
        try {
            return (List)this.getAccessor().get(branch, enumIds, relations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceEnumeration>();
        }
    }

    @Override
    public Collection<InterfaceEnumeration> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceEnumeration> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<InterfaceEnumeration> query(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceEnumeration> queryExact(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceEnumeration> query(BranchId branch, MimAttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceEnumeration>();
        }
    }
}

