/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.DataRightResult;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordMLProducer;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WordRenderUtil {
    private static final String APPLICABILITY = "Applicability";
    private static final String ARTIFACT_ID = "Artifact Id";
    private static final String ARTIFACT_TYPE = "Artifact Type";

    public static Optional<DataRightContentBuilder> getDataRights(List<PublishingArtifact> artifacts, BranchId branchId, boolean recurse, boolean notHistorical, String overrideClassification, ArtifactAcceptor descendantArtifactAcceptor, DataRightsProvider dataRightsProvider) {
        assert (Objects.nonNull(branchId)) : "WordRenderUtil::getDataRights, parameter \"branchId\" cannot be null.";
        assert (Objects.nonNull(dataRightsProvider)) : "WordRenderUtil::getDataRights, parameter \"dataRightsProvider\" cannot be null.";
        try {
            if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
                return Optional.empty();
            }
            List<PublishingArtifact> allArtifacts = WordRenderUtil.getPublishArtifacts(artifacts, recurse, notHistorical, descendantArtifactAcceptor);
            if (allArtifacts.isEmpty()) {
                return Optional.empty();
            }
            DataRightResult dataRightResult = dataRightsProvider.getDataRights(branchId, overrideClassification, allArtifacts.stream().map(ArtifactId::create).collect(Collectors.toList()));
            DataRightContentBuilder dataRightContentBuilder = new DataRightContentBuilder(dataRightResult);
            return Optional.of(dataRightContentBuilder);
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"WordRenderUtil::getDataRights, failed to obtain data rights for publishing artifacts.").indentInc().segment((CharSequence)"Publishing Branch Identifier", (Object)branchId).segment((CharSequence)"Recursive", (Object)recurse).segment((CharSequence)"Not Historical", (Object)notHistorical).segment((CharSequence)"Override Classification", (Object)overrideClassification).segment((CharSequence)"Top Level Publishing Artifacts", artifacts, Id::getId).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    public static WordCoreUtil.pageType getPageOrientation(PublishingArtifact artifact) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        try {
            if (Objects.isNull(artifact) || artifact.isInvalid()) {
                return defaultPageType;
            }
            if (!artifact.isAttributeTypeValid(CoreAttributeTypes.PageOrientation)) {
                return defaultPageType;
            }
            String pageTypeString = artifact.getSoleAttributeAsString(CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString(pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static List<PublishingArtifact> getPublishArtifacts(List<PublishingArtifact> artifacts, boolean recursive, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
            return null;
        }
        Iterator<PublishingArtifact> artifactIterator = artifacts.iterator();
        PublishingArtifact artifact = artifacts.iterator().next();
        artifact.setStartOfSection();
        artifact.clearEndOfSection();
        artifact.setOutlineLevel(0);
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            artifact.setStartOfSection();
            artifact.clearEndOfSection();
            artifact.setOutlineLevel(0);
        }
        artifact.setEndOfSection();
        LinkedList<PublishingArtifact> allArtifacts = new LinkedList<PublishingArtifact>();
        HashSet<ArtifactId> checkSet = recursive ? new HashSet<ArtifactId>() : null;
        WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifacts, 0, recursive, notHistorical, descendantArtifactAcceptor);
        return allArtifacts;
    }

    public static String getStartingParagraphNumber(ArtifactReadable artifact, PublishingTemplate publishingTemplate) {
        String startParagraphNumber = "1";
        if (Objects.isNull(publishingTemplate) || Objects.isNull(artifact)) {
            return startParagraphNumber;
        }
        if (publishingTemplate.test(WordCoreUtil::isNotArtifactPublishingTemplateInsertToken)) {
            return startParagraphNumber;
        }
        if (!artifact.isAttributeTypeValid(CoreAttributeTypes.ParagraphNumber)) {
            return startParagraphNumber;
        }
        String paragraphNumber = artifact.getSoleAttributeAsString(CoreAttributeTypes.ParagraphNumber, "");
        if (Strings.isInvalidOrBlank((String)paragraphNumber)) {
            return startParagraphNumber;
        }
        return paragraphNumber;
    }

    private static void loadChildrenRecursive(List<PublishingArtifact> allArtifacts, Set<ArtifactId> checkSet, List<PublishingArtifact> levelArtifacts, int outlineLevel, boolean recurse, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        Iterator<PublishingArtifact> artifactIterator = levelArtifacts.iterator();
        PublishingArtifact artifact = null;
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            if (Objects.isNull(artifact) || artifact.isInvalid() || Objects.nonNull(checkSet) && checkSet.contains(artifact)) continue;
            if (outlineLevel > 0 && Objects.nonNull(descendantArtifactAcceptor) && !descendantArtifactAcceptor.isOk(artifact)) {
                checkSet.add(artifact);
                continue;
            }
            if (Objects.nonNull(checkSet)) {
                checkSet.add(artifact);
            }
            allArtifacts.add(artifact);
            if (!recurse || notHistorical && artifact.isHistorical()) continue;
            WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifact.getChildrenAsPublishingArtifacts(), outlineLevel + 1, recurse, notHistorical, descendantArtifactAcceptor);
        }
    }

    public static void processAttributes(List<AttributeOptions> attributeOptionsArray, AttributeProcessor attributeProcessor, AttributeTypeFunction attributeTypeFunction, OrderedAttributeTypeSupplier orderedAttributeTypeSupplier, ArtifactReadable artifact, AttributeTypeToken headingAttributeType, boolean renderAllAttributes, boolean outlining) {
        for (AttributeOptions attributeOptions : attributeOptionsArray) {
            AttributeTypeToken attributeType2;
            String attributeName = attributeOptions.getAttributeName();
            if (renderAllAttributes || "*".equals(attributeName)) {
                for (AttributeTypeToken attributeType2 : (Iterable)orderedAttributeTypeSupplier.get()) {
                    if (outlining && attributeType2.equals(headingAttributeType)) continue;
                    attributeProcessor.process(attributeOptions, attributeType2, true);
                }
                continue;
            }
            attributeType2 = (AttributeTypeToken)attributeTypeFunction.apply(attributeName);
            if (!artifact.isAttributeTypeValid(attributeType2)) continue;
            attributeProcessor.process(attributeOptions, attributeType2, false);
        }
    }

    public static void processMetadataOptions(MetadataOptions[] metadataOptionsArray, Map<ApplicabilityId, ApplicabilityToken> applicabilityTokens, ArtifactReadable artifact, WordMLProducer wordMl) {
        if (Objects.nonNull(metadataOptionsArray)) {
            Arrays.asList(metadataOptionsArray).forEach(element -> {
                String value;
                String name = element.getType();
                String format = element.getFormat();
                String label = element.getLabel();
                switch (name) {
                    case "Applicability": {
                        ApplicabilityToken applicabilityToken;
                        value = artifact.getApplicability().isValid() ? (Objects.nonNull(applicabilityToken = (ApplicabilityToken)applicabilityTokens.get(artifact.getApplicability())) ? applicabilityToken.getName() : artifact.getApplicability().getIdString()) : "unknown";
                        break;
                    }
                    case "Artifact Type": {
                        value = artifact.getArtifactType().getName();
                        break;
                    }
                    case "Artifact Id": {
                        value = artifact.getIdString();
                        break;
                    }
                    default: {
                        value = "";
                    }
                }
                wordMl.startParagraph();
                wordMl.addWordMl(WordCoreUtil.replaceRendererOptionToken(label, format, name, value));
                wordMl.endParagraph();
            });
        }
    }

    public static void renderAttribute(AttributeTypeToken attributeType, RelationOrderFunction relationOrderFunction, ArtifactReadable artifact, WordMLProducer wordMl, String label, String format) {
        String name = attributeType.getUnqualifiedName();
        if (attributeType.equals(CoreAttributeTypes.RelationOrder)) {
            if (Objects.isNull(relationOrderFunction)) {
                return;
            }
            wordMl.startParagraph();
            wordMl.addRunWithTextEscape((CharSequence)name);
            wordMl.endParagraph();
            String data = (String)relationOrderFunction.apply(artifact);
            wordMl.addWordMl(data);
        } else {
            String value = artifact.getAttributeValuesAsString(attributeType);
            wordMl.startParagraph();
            wordMl.addWordMl(WordCoreUtil.replaceRendererOptionToken(label, format, name, value));
            wordMl.endParagraph();
        }
    }

    public static String renderWordAttribute(ArtifactReadable artifact, ArtifactId viewId, WordMLProducer wordMl, RendererMap rendererMap, PresentationType presentationType, String label, String footer, String permanentLinkUrl, boolean artifactIsChanged, TransactionToken historicalArtifactTransactionToken, Set<String> unknownGuids, RenderWordTemplateContentOperation renderWordTemplateContentOperation, ExceptionHandler exceptionHandler) {
        String wordMlContentDataAndFooter;
        block14: {
            if (Objects.nonNull(wordMl) && Strings.isValidAndNonBlank((String)label)) {
                wordMl.addParagraph(label);
            }
            ArtifactId artifactId = ArtifactId.create(artifact);
            BranchId branchId = BranchId.valueOf(artifact.getBranch().getId());
            WordTemplateContentData wtcData = new WordTemplateContentData();
            wtcData.setArtId(artifactId);
            wtcData.setBranch(branchId);
            wtcData.setViewId(viewId);
            wtcData.setFooter(presentationType != PresentationType.SPECIALIZED_EDIT ? footer : "");
            wtcData.setIsEdit(presentationType == PresentationType.SPECIALIZED_EDIT);
            wtcData.setLinkType((LinkType)((Object)rendererMap.getRendererOptionValue(RendererOption.LINK_TYPE)));
            wtcData.setPresentationType(presentationType);
            wtcData.setTxId(historicalArtifactTransactionToken);
            wtcData.setPermanentLinkUrl(permanentLinkUrl);
            wtcData.setArtIsChanged(artifactIsChanged);
            wordMlContentDataAndFooter = "";
            try {
                Pair content = (Pair)renderWordTemplateContentOperation.apply(wtcData);
                if (Objects.nonNull(content)) {
                    wordMlContentDataAndFooter = (String)content.getFirst();
                    Set contentUnknownGuids = (Set)content.getSecond();
                    if (!contentUnknownGuids.isEmpty()) {
                        unknownGuids.addAll((Collection)content.getSecond());
                    }
                }
            }
            catch (Exception e) {
                if (Objects.nonNull(wordMl)) {
                    wordMl.addParagraphNoEscape("Failed to parse content for artifact.");
                    wordMl.startParagraph();
                    wordMl.addRunWithTextEscape("Artifact: ", artifact.toStringWithId());
                    wordMl.endParagraph();
                    wordMl.startParagraph();
                    wordMl.addRunWithTextEscape("Branch: ", branchId.toString());
                    wordMl.endParagraph();
                }
                OseeCoreException renderException = new OseeCoreException(new Message().title((CharSequence)"Failed to parse content for artifact.").indentInc().segment((CharSequence)"Artifact", (Object)artifact.toStringWithId()).segment((CharSequence)"Branch", (Object)branchId).reasonFollowsWithTrace((Throwable)e).toString(), (Throwable)e);
                if (!Objects.nonNull(exceptionHandler)) break block14;
                exceptionHandler.accept(renderException);
            }
        }
        if (Objects.nonNull(wordMl)) {
            if (PresentationType.SPECIALIZED_EDIT.equals((Object)presentationType)) {
                wordMl.addEditParagraphNoEscape(WordCoreUtil.getStartEditImage(artifact.getGuid()));
                if (Objects.nonNull(wordMlContentDataAndFooter)) {
                    wordMl.addWordMl(wordMlContentDataAndFooter);
                }
                wordMl.addEditParagraphNoEscape(WordCoreUtil.getEndEditImage(artifact.getGuid()));
            } else if (Objects.nonNull(wordMlContentDataAndFooter)) {
                wordMl.addWordMl(wordMlContentDataAndFooter);
                if (WordCoreUtil.containsLists(wordMlContentDataAndFooter)) {
                    wordMl.resetListValue();
                }
            } else if (Objects.nonNull(footer)) {
                wordMl.addWordMl(footer);
            }
        }
        return wordMlContentDataAndFooter;
    }

    public static void setupPublishingTemplate(PublishingTemplate publishingTemplate, ArtifactReadable artifact, WordMLProducer wordMl, String outlineNumber, String outlineType, int maxOutline) {
        publishingTemplate.update(WordCoreUtil::cleanupPageNumberTypeStart1);
        String finalOutlineNumber = Strings.isInvalidOrBlank((String)outlineNumber) ? WordRenderUtil.getStartingParagraphNumber(artifact, publishingTemplate) : outlineNumber;
        publishingTemplate.update(tc -> WordCoreUtil.initializePublishingTemplateOutliningNumbers(finalOutlineNumber, tc, outlineType));
        wordMl.setNextParagraphNumberTo(finalOutlineNumber);
        if (maxOutline < 9) {
            wordMl.setMaxOutlineLevel(maxOutline);
        }
    }

    @FunctionalInterface
    public static interface ArtifactAcceptor {
        default public ArtifactAcceptor isKo(ArtifactAcceptor baseArtifactAcceptor) {
            Objects.requireNonNull(baseArtifactAcceptor);
            return t -> !this.isOk(t);
        }

        public boolean isOk(ArtifactReadable var1);
    }

    @FunctionalInterface
    public static interface AttributeProcessor {
        public void process(AttributeOptions var1, AttributeTypeToken var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AttributeTypeFunction
    extends Function<String, AttributeTypeToken> {
    }

    @FunctionalInterface
    public static interface DataRightsProvider {
        public DataRightResult getDataRights(BranchId var1, String var2, List<ArtifactId> var3);
    }

    @FunctionalInterface
    public static interface ExceptionHandler
    extends Consumer<Throwable> {
    }

    @FunctionalInterface
    public static interface OrderedAttributeTypeSupplier
    extends Supplier<Iterable<AttributeTypeToken>> {
    }

    @FunctionalInterface
    public static interface RelationOrderFunction
    extends Function<ArtifactReadable, String> {
    }

    @FunctionalInterface
    public static interface RenderWordTemplateContentOperation
    extends Function<WordTemplateContentData, Pair<String, Set<String>>> {
    }
}

