/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.osee.framework.core.publishing.RendererOptions;
import org.eclipse.osee.framework.core.publishing.TemplateContent;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplate
implements ToMessage {
    public static final PublishingTemplate SENTINEL;
    private String identifier;
    private String name;
    private RendererOptions rendererOptions;
    private TemplateContent templateContent;

    static {
        PublishingTemplate sentinelPublishingTemplate = new PublishingTemplate();
        sentinelPublishingTemplate.sentinel();
        SENTINEL = sentinelPublishingTemplate;
    }

    public PublishingTemplate() {
        this.identifier = null;
        this.name = null;
        this.rendererOptions = null;
        this.templateContent = null;
    }

    public PublishingTemplate(String identifier, String name, RendererOptions rendererOptions, TemplateContent templateContent) {
        this.identifier = Objects.requireNonNull(identifier, "PublishingTemplate::new, parameter \"identifier\" cannot be null.");
        this.name = Objects.requireNonNull(name, "PublishingTemplate::new, parameter \"name\" cannot be null.");
        this.rendererOptions = Objects.requireNonNull(rendererOptions, "PublishingTemplate::new, parameter \"rendererOptions\" cannot be null.");
        this.templateContent = Objects.requireNonNull(templateContent, "PublishingTemplate::new, parameter \"templateContent\" cannot be null.");
    }

    @JsonIgnore
    public void defaults() {
        if (Objects.isNull(this.identifier)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.name)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.rendererOptions)) {
            this.rendererOptions = new RendererOptions();
        }
        this.rendererOptions.defaults();
        if (Objects.isNull(this.templateContent)) {
            this.templateContent = new TemplateContent();
        }
        this.templateContent.defaults();
    }

    public String getIdentifier() {
        if (Objects.isNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::getIdentifier, the member \"identifier\" has not been set.");
        }
        return this.identifier;
    }

    public String getName() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::getName, the member \"name\" has not been set.");
        }
        return this.name;
    }

    public RendererOptions getRendererOptions() {
        if (Objects.isNull(this.rendererOptions)) {
            throw new IllegalStateException("PublishingTemplate::getRendererOptions, the member \"rendererOptions\" has not been set.");
        }
        return this.rendererOptions;
    }

    public TemplateContent getTemplateContent() {
        if (Objects.isNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::getTemplateContent, the member \"templateContent\" has not been set.");
        }
        return this.templateContent;
    }

    @JsonIgnore
    public boolean isSentinel() {
        return this == SENTINEL || "SENTINEL".equals(this.identifier) || "SENTINEL".equals(this.name);
    }

    @JsonIgnore
    public boolean isNotSentinel() {
        return !this.isSentinel();
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.identifier) && !this.identifier.isBlank() && Objects.nonNull(this.name) && !this.name.isBlank() && Objects.nonNull(this.rendererOptions) && this.rendererOptions.isValid() && Objects.nonNull(this.templateContent) && this.templateContent.isValid();
    }

    private void sentinel() {
        this.identifier = "SENTINEL";
        this.name = "SENTINEL";
        this.rendererOptions = new RendererOptions();
        this.rendererOptions.defaults();
        this.templateContent = new TemplateContent();
        this.templateContent.defaults();
    }

    public void setIdentifier(String identifier) {
        if (Objects.nonNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::setIdentifier, member \"identifier\" has already been set.");
        }
        this.identifier = Objects.requireNonNull(identifier, "PublishingTemplate::setIdentifier, parameter \"identifier\" cannot be null.");
    }

    public void setName(String name) {
        if (Objects.nonNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::setName, member \"name\" has already been set.");
        }
        this.name = Objects.requireNonNull(name, "PublishingTemplate::setName, parameter \"name\" cannot be null.");
    }

    public void setRendererOptions(RendererOptions rendererOptions) {
        if (Objects.nonNull(this.rendererOptions)) {
            throw new IllegalStateException("PublishingTemplate::setRendererOptions, member \"rendererOptions\" has already been set.");
        }
        this.rendererOptions = Objects.requireNonNull(rendererOptions, "PublishingTemplate::setRendererOptions, parameter \"rendererOptions\" cannot be null.");
    }

    public void setTemplateContent(TemplateContent templateContent) {
        if (Objects.nonNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::setTemplateContent, member \"templateContent\" has already been set.");
        }
        this.templateContent = Objects.requireNonNull(templateContent, "PublishingTemplate::setTemplateContent, parameter \"templateContent\" cannot be null.");
    }

    @JsonIgnore
    public void update(Function<CharSequence, CharSequence> updater) {
        this.templateContent.replace(updater.apply(this.templateContent.getTemplateString()));
    }

    @JsonIgnore
    public boolean test(Predicate<CharSequence> tester) {
        return tester.test(this.templateContent.getTemplateString());
    }

    @JsonIgnore
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Template").indentInc().segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).toMessage((ToMessage)this.rendererOptions).toMessage((ToMessage)this.templateContent).indentDec();
        return outMessage;
    }

    @JsonIgnore
    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

