/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.orcs.db.internal.search.util.TokenOrderProcessor;

public class MatchTokenOrderProcessor
implements TokenOrderProcessor {
    private final List<MatchLocation> locations = new LinkedList<MatchLocation>();
    private final List<String> tokensToSearch = new ArrayList<String>();
    private int matchIdx = 0;
    private int matchStart = -1;
    private int numTokensToMatch = 0;

    @Override
    public int getTotalTokensToMatch() {
        return this.numTokensToMatch;
    }

    @Override
    public void acceptTokenToMatch(String token) {
        this.tokensToSearch.add(token);
        ++this.numTokensToMatch;
    }

    @Override
    public boolean processToken(String token, MatchLocation match) {
        if (!this.tokensToSearch.get(this.matchIdx).equals(token)) {
            this.matchIdx = 0;
        }
        if (this.tokensToSearch.get(this.matchIdx).equals(token)) {
            if (this.matchIdx == 0) {
                this.matchStart = match.getStartPosition();
            }
            ++this.matchIdx;
            if (this.matchIdx == this.numTokensToMatch) {
                this.locations.add(this.createMatchLocation(this.matchStart, match.getEndPosition()));
                this.matchIdx = 0;
            }
        }
        return !this.locations.isEmpty();
    }

    private MatchLocation createMatchLocation(int start, int end) {
        return new MatchLocation(start + 1, end);
    }

    @Override
    public List<MatchLocation> getLocations() {
        return this.locations;
    }

    @Override
    public void clearAllLocations() {
        this.locations.clear();
    }
}

