/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.net.URI;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.account.admin.Subscription;
import org.eclipse.osee.account.admin.SubscriptionAdmin;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;

@PermitAll
@Path(value="/unsubscribe")
public class UnsubscribeResource {
    private final SubscriptionAdmin manager;
    protected static final String UNSUBSCRIBE_TEMPLATE = "unsubscribe.html";
    protected static final String UNSUBSCRIBE_SUCCESS_TEMPLATE = "unsubscribe_success.html";
    protected static final String UNSUBSCRIBE_NO_SUBSCRIPTION_TEMPLATE = "unsubscribe_no_subscription.html";
    protected static final String ACCOUNT_DISPLAY_NAME_TAG = "accountDisplayName";
    protected static final String SUBSCRIPTION_NAME_TAG = "subscriptionName";
    protected static final String UNSUBSCRIBE_URL = "unsubscribeUrl";

    public UnsubscribeResource(SubscriptionAdmin manager) {
        this.manager = manager;
    }

    @Path(value="/ui/{subscription-uuid}")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getUnsubscribePage(@PathParam(value="subscription-uuid") String subscriptionUuid) {
        ViewModel page;
        Subscription subscription = this.manager.getSubscriptionsByEncodedId(subscriptionUuid);
        if (subscription.isActive()) {
            String uuid = (String)subscription.getGuid();
            URI unsubscribeUri = UriBuilder.fromPath((String)"{subscription-uuid}").path("confirm").build(new Object[]{uuid});
            page = this.newUnsubscribePage(unsubscribeUri, subscription.getName(), subscription.getAccountName());
        } else {
            page = this.newUnsubscribeNoSubscriptionFoundPage(subscription.getName(), subscription.getAccountName());
        }
        return page;
    }

    @Path(value="/ui/{subscription-uuid}/confirm")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public ViewModel processUnsubscribePage(@Encoded @PathParam(value="subscription-uuid") String subscriptionUuid) {
        Subscription subscription = this.manager.getSubscriptionsByEncodedId(subscriptionUuid);
        boolean modified = this.manager.setSubscriptionActive(subscription, false);
        ViewModel page = modified ? this.newUnsubscribeSuccessPage(subscription.getName(), subscription.getAccountName()) : this.newUnsubscribeNoSubscriptionFoundPage(subscription.getName(), subscription.getAccountName());
        return page;
    }

    private ViewModel newUnsubscribePage(URI unsubscribeUri, String subscriptionName, String accountName) {
        return new ViewModel(UNSUBSCRIBE_TEMPLATE).param(UNSUBSCRIBE_URL, (Object)unsubscribeUri).param(ACCOUNT_DISPLAY_NAME_TAG, (Object)accountName).param(SUBSCRIPTION_NAME_TAG, (Object)subscriptionName);
    }

    private ViewModel newUnsubscribeNoSubscriptionFoundPage(String subscriptionName, String accountName) {
        return new ViewModel(UNSUBSCRIBE_NO_SUBSCRIPTION_TEMPLATE).param(ACCOUNT_DISPLAY_NAME_TAG, (Object)accountName).param(SUBSCRIPTION_NAME_TAG, (Object)subscriptionName);
    }

    private ViewModel newUnsubscribeSuccessPage(String subscriptionName, String accountName) {
        return new ViewModel(UNSUBSCRIBE_SUCCESS_TEMPLATE).param(ACCOUNT_DISPLAY_NAME_TAG, (Object)accountName).param(SUBSCRIPTION_NAME_TAG, (Object)subscriptionName);
    }
}

