/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatch;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatchType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskTeamWfData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.StaticTaskDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;

public class ChangeReportTasksUtil {
    public static final String NO_CHANGE_ITEMS_FOUND = "No Change Items (Working Branch or Commit) Found";
    public static final String TASKS_MUST_BE_AUTOGEN_TASKS = "Tasks must be Auto Generated Tasks";
    public static final String TASKS_MUST_BE_AUTOGEN_CHANGE_REPORT_RELATED_TASKS = "Tasks must be Auto Generated Change Report Related Tasks";
    public static final String FINAL_TASK_GEN_TAG = "finalTaskgen";
    public static final String FINAL_TASK_GEN_MSG = "Final Task Generation has already been run.";

    private ChangeReportTasksUtil() {
    }

    public static void getBranchOrCommitChangeData(ChangeReportTaskData crtd, CreateTasksDefinition setDef) {
        AtsApi atsApi = AtsApiService.get();
        IAtsTeamWorkflow chgRptTeamWf = atsApi.getWorkItemService().getTeamWf(crtd.getChgRptTeamWf());
        List changeItems = null;
        BranchToken workOrParentBranch = null;
        if (atsApi.getBranchService().isWorkingBranchInWork(chgRptTeamWf)) {
            BranchToken workingBranch;
            workOrParentBranch = workingBranch = atsApi.getBranchService().getWorkingBranch(chgRptTeamWf);
            changeItems = atsApi.getBranchService().getChangeData(BranchId.valueOf((Long)workingBranch.getId()));
            crtd.getResults().logf("Using Working Branch %s\n", new Object[]{workingBranch.toStringWithId()});
        } else if (atsApi.getBranchService().isCommittedBranchExists(chgRptTeamWf)) {
            TransactionToken tx = atsApi.getBranchService().getEarliestTransactionId(chgRptTeamWf);
            workOrParentBranch = atsApi.getBranchService().getBranch(tx.getBranch());
            changeItems = atsApi.getBranchService().getChangeData((TransactionId)tx);
            crtd.getResults().logf("Using Commit Branch %s\n", new Object[]{workOrParentBranch.toStringWithId()});
        }
        if (workOrParentBranch != null) {
            crtd.setWorkOrParentBranch(workOrParentBranch.getIdString());
        }
        if (changeItems == null || changeItems.isEmpty()) {
            crtd.getResults().warning(NO_CHANGE_ITEMS_FOUND);
            crtd.setChangeItems(Collections.emptyList());
            return;
        }
        crtd.setChangeItems(changeItems);
    }

    public static void determinExistingTaskMatchType(Map<ArtifactId, ArtifactToken> idToArtifact, ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, CreateTasksDefinition setDef, WorkType workType, IAtsTeamWorkflow destTeamWf) {
        AtsApi atsApi = AtsApiService.get();
        Collection<Object> tasks = Collections.emptyList();
        if (destTeamWf != null) {
            tasks = atsApi.getTaskService().getTasks(destTeamWf);
        }
        LinkedList<IAtsTask> staticTasksFound = new LinkedList<IAtsTask>();
        List staticTaskDefs = crtd.getSetDef().getStaticTaskDefs();
        if (!staticTaskDefs.isEmpty()) {
            block0: for (IAtsTask iAtsTask : tasks) {
                boolean bl = false;
                for (StaticTaskDefinition taskDef : staticTaskDefs) {
                    if (iAtsTask.getName().equals(taskDef.getName())) {
                        for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                            if (!taskMatch.getTaskName().equals(iAtsTask.getName())) continue;
                            taskMatch.setTaskName(iAtsTask.getName());
                            taskMatch.setType(ChangeReportTaskMatchType.Match);
                            taskMatch.setTaskWf(iAtsTask);
                            taskMatch.setTaskTok(iAtsTask.getArtifactToken());
                            staticTasksFound.add(iAtsTask);
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue block0;
                }
            }
        }
        tasks.removeAll(staticTasksFound);
        LinkedList<IAtsTask> linkedList = new LinkedList<IAtsTask>();
        Collection addlTaskMatches = crttwd.getTaskMatches();
        block3: for (ChangeReportTaskMatch changeReportTaskMatch : addlTaskMatches) {
            if (!changeReportTaskMatch.getMatchType().equals((Object)ChangeReportTaskMatchType.AdditionalTskCompAsNeeded)) continue;
            for (IAtsTask iAtsTask : tasks) {
                if (!iAtsTask.getName().equals(changeReportTaskMatch.getTaskName())) continue;
                changeReportTaskMatch.setTaskName(iAtsTask.getName());
                changeReportTaskMatch.setType(ChangeReportTaskMatchType.Match);
                changeReportTaskMatch.setTaskWf(iAtsTask);
                changeReportTaskMatch.setTaskTok(iAtsTask.getArtifactToken());
                linkedList.add(iAtsTask);
                continue block3;
            }
        }
        tasks.removeAll(linkedList);
        for (IAtsTask iAtsTask : tasks) {
            ArtifactId artifactId = atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)iAtsTask, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, ArtifactId.SENTINEL);
            if (artifactId.isValid()) {
                boolean found = false;
                for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                    if (!artifactId.getId().equals(taskMatch.getChgRptArt().getId()) || !iAtsTask.getName().equals(taskMatch.getTaskName())) continue;
                    taskMatch.setTaskName(iAtsTask.getName());
                    taskMatch.setType(ChangeReportTaskMatchType.Match);
                    taskMatch.setTaskWf(iAtsTask);
                    taskMatch.setTaskTok(iAtsTask.getArtifactToken());
                    found = true;
                    break;
                }
                if (found) continue;
                ChangeReportTaskMatch newTaskMatch = new ChangeReportTaskMatch();
                newTaskMatch.setTaskName(iAtsTask.getName());
                newTaskMatch.setTaskWf(iAtsTask);
                newTaskMatch.setTaskTok(iAtsTask.getArtifactToken());
                newTaskMatch.setType(ChangeReportTaskMatchType.TaskRefAttrButNoRefChgArt);
                crttwd.addTaskMatch(newTaskMatch);
                continue;
            }
            ChangeReportTaskMatch taskMatch = new ChangeReportTaskMatch();
            taskMatch.setTaskName(iAtsTask.getName());
            taskMatch.setTaskWf(iAtsTask);
            taskMatch.setTaskTok(iAtsTask.getArtifactToken());
            taskMatch.setType(ChangeReportTaskMatchType.TaskRefAttrMissing);
            crttwd.addTaskMatch(taskMatch);
        }
    }

    public static ChangeReportTaskMatch getTaskMatch(IAtsTask task, ArtifactId referencedChgArt, ChangeReportTaskTeamWfData crttwd, AtsApi atsApi) {
        ArtifactId taskRefArt = atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, ArtifactId.SENTINEL);
        for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
            if (!referencedChgArt.getId().equals(taskRefArt.getId())) continue;
            taskMatch.setTaskName(task.getName());
            taskMatch.setType(ChangeReportTaskMatchType.Match);
            taskMatch.setTaskWf(task);
            taskMatch.setTaskTok(task.getArtifactToken());
            return taskMatch;
        }
        return null;
    }

    public static IAtsTeamWorkflow getDestTeamWfOrNull(ChangeReportTaskTeamWfData crttwd, WorkType workType, AtsApi atsApi, IAtsTeamWorkflow sourceTeamWf, IAtsTeamDefinition destTeamDef) {
        ArtifactToken chgRptTeamWf = crttwd.getChgRptTeamWf();
        Collection derivedTo = atsApi.getRelationResolver().getRelated((ArtifactId)chgRptTeamWf, AtsRelationTypes.Derive_To);
        IAtsAction parentAction = sourceTeamWf.getParentAction();
        Collection teamWorkflows = parentAction.getTeamWorkflows();
        for (ArtifactToken related : derivedTo) {
            IAtsTeamWorkflow teamWf;
            if (!related.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) || !(teamWf = atsApi.getWorkItemService().getTeamWf(related)).getTeamDefinition().equals(crttwd.getDestTeamDef())) continue;
            crttwd.setDestTeamWf(teamWf.getStoreObject());
            return teamWf;
        }
        for (IAtsTeamWorkflow teamWf : teamWorkflows) {
            if (teamWf.equals(sourceTeamWf) || !teamWf.getTeamDefinition().equals(destTeamDef) || !ChangeReportTasksUtil.notAlreadyDerived(teamWf)) continue;
            crttwd.setDestTeamWf(teamWf.getArtifactToken());
            return teamWf;
        }
        return null;
    }

    private static boolean notAlreadyDerived(IAtsTeamWorkflow teamWf) {
        return AtsApiService.get().getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.Derive_From).isEmpty();
    }
}

