/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.resources;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.BundleContext;

@Provider
public class JaxRsHtmlWadlGenerator
extends WadlGenerator {
    private static final String WADL_TRANSFORMED_FLAG = "was.wadl.transformed";
    private Log logger;
    @Context
    private HttpHeaders headers;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(BundleContext bundleContext, Map<String, Object> props) {
    }

    public void stop() {
    }

    protected void doFilter(ContainerRequestContext context, Message m) {
        Response response;
        m.getExchange().put((Object)WADL_TRANSFORMED_FLAG, (Object)Boolean.FALSE);
        if ("true".equals(System.getProperty("disable_wadl"))) {
            try {
                context.setRequestUri(new URI(context.getUriInfo().getRequestUri().toString().replace("?_wadl", "404")));
            }
            catch (Exception exception) {}
        } else {
            super.doFilter(context, m);
        }
        Boolean wasTransformed = (Boolean)m.getExchange().get((Object)WADL_TRANSFORMED_FLAG);
        if (wasTransformed.booleanValue() && (response = (Response)m.getExchange().get(Response.class)) != null) {
            MediaType type = MediaType.TEXT_HTML_TYPE;
            response = Response.fromResponse((Response)response).type(type).build();
            m.getExchange().put(Response.class, (Object)JAXRSUtils.copyResponseIfNeeded((Response)response));
        }
    }

    public StringBuilder generateWADL(String baseURI, List<ClassResourceInfo> cris, boolean isJson, Message m, UriInfo ui) {
        StringBuilder wadl;
        StringBuilder toReturn = wadl = super.generateWADL(baseURI, cris, isJson, m, ui);
        List acceptableMediaTypes = this.headers.getAcceptableMediaTypes();
        if (JaxRsUtils.isHtmlSupported(acceptableMediaTypes)) {
            URL templateUrl = OseeInf.getResourceAsUrl((String)"transforms/wadl.xsl", ((Object)((Object)this)).getClass());
            if (templateUrl != null) {
                AutoCloseable wadlStream = null;
                InputStream templateStream = null;
                try {
                    try {
                        templateStream = templateUrl.openStream();
                        StringWriter writer = new StringWriter();
                        StreamSource wadlSource = new StreamSource(new StringReader(wadl.toString()));
                        StreamSource templateSource = new StreamSource(templateStream);
                        StreamResult output = new StreamResult(writer);
                        this.transformWadl(wadlSource, templateSource, output);
                        toReturn = new StringBuilder(writer.toString());
                        m.getExchange().put((Object)WADL_TRANSFORMED_FLAG, (Object)Boolean.TRUE);
                    }
                    catch (Exception ex) {
                        this.logger.warn((Throwable)ex, "Error applying wadl transform", new Object[0]);
                        Lib.close(wadlStream);
                        Lib.close((AutoCloseable)templateStream);
                    }
                }
                finally {
                    Lib.close(wadlStream);
                    Lib.close((AutoCloseable)templateStream);
                }
            } else {
                this.logger.warn("WADL to HTML template url was null - templatePath[%s]", new Object[]{templateUrl});
            }
        }
        return toReturn;
    }

    private void transformWadl(StreamSource wadlSource, StreamSource templateSource, StreamResult output) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(templateSource);
        Transformer xformer = template.newTransformer();
        xformer.transform(wadlSource, output);
    }
}

