/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.mvc;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jaxrs.mvc.ViewResolver;
import org.eclipse.osee.jaxrs.mvc.ViewWriter;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

@Provider
public class ViewModelWriter
implements MessageBodyWriter<ViewModel> {
    private final ConcurrentHashMap<String, ViewResolver<?>> resolvers = new ConcurrentHashMap();
    @Context
    private ResourceInfo resourceInfo;

    public void addResolver(ServiceReference<ViewResolver<?>> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        Bundle bundle = reference.getBundle();
        ViewResolver resolver = (ViewResolver)bundle.getBundleContext().getService(reference);
        this.resolvers.put(componentName, resolver);
    }

    public void removeResolver(ServiceReference<ViewResolver<?>> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        this.resolvers.remove(componentName);
    }

    private Iterable<ViewResolver<?>> getViewResolvers() {
        return this.resolvers.values();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ViewModel.class.isAssignableFrom(type);
    }

    public long getSize(ViewModel model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ViewModel model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ViewWriter writer = this.resolve(model, mediaType);
        if (writer == null) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "Template [%s] could not be resolved", new Object[]{model.getViewId()});
        }
        httpHeaders.putSingle((Object)"Content-Type", (Object)writer.getMediaType());
        writer.write(httpHeaders, entityStream);
    }

    private ViewWriter resolve(ViewModel model, MediaType mediaType) {
        ViewWriter toReturn = null;
        if (model instanceof ViewWriter) {
            toReturn = (ViewWriter)model;
        } else {
            Class resourceClass = this.resourceInfo.getResourceClass();
            Iterable<ViewResolver<?>> resolvers = this.getViewResolvers();
            List<MediaType> mediaTypes = ViewModelWriter.getMediaTypesProduced(this.resourceInfo);
            mediaTypes.add(0, mediaType);
            toReturn = this.resolve(model, resourceClass, mediaTypes, resolvers);
        }
        return toReturn;
    }

    private ViewWriter resolve(ViewModel model, Class<?> resolvingClass, Iterable<MediaType> mediaTypes, Iterable<ViewResolver<?>> resolvers) {
        ResolvedView<?> toReturn = null;
        block0: for (ViewResolver<?> resolver : resolvers) {
            for (MediaType mediaType : mediaTypes) {
                ResolvedView<?> writer = this.resolve(model, resolvingClass, mediaType, resolver);
                if (writer == null) continue;
                toReturn = writer;
                continue block0;
            }
        }
        return toReturn;
    }

    private <T> ResolvedView<T> resolve(ViewModel model, Class<?> resourceClass, MediaType mediaType, ViewResolver<T> resolver) {
        ResolvedView<Object> toReturn = null;
        Object viewReference = resolver.resolve(model.getViewId(), mediaType);
        if (viewReference != null) {
            toReturn = ViewModelWriter.newResolved(resolver, resourceClass, mediaType, model, viewReference);
        }
        return toReturn;
    }

    private static <T> List<T> getAnnotations(Method method, Class<T> clazz) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (method != null) {
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().isAssignableFrom(clazz)) {
                    Annotation object = annotation;
                    annotations.add(object);
                }
                ++n2;
            }
        }
        return annotations;
    }

    private static List<MediaType> getMediaTypesProduced(ResourceInfo resourceInfo) {
        ArrayList<MediaType> produces = new ArrayList<MediaType>();
        boolean hasText = false;
        Method method = resourceInfo.getResourceMethod();
        List<Produces> annotations = ViewModelWriter.getAnnotations(method, Produces.class);
        for (Produces annotation : annotations) {
            String[] mediaTypes;
            String[] stringArray = mediaTypes = annotation.value();
            int n = mediaTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String mediaType = stringArray[n2];
                MediaType toAdd = MediaType.valueOf((String)mediaType);
                if (MediaType.TEXT_HTML_TYPE.equals((Object)toAdd)) {
                    hasText = true;
                } else {
                    produces.add(toAdd);
                }
                ++n2;
            }
        }
        if (hasText) {
            produces.add(0, MediaType.TEXT_HTML_TYPE);
        }
        if (produces.isEmpty()) {
            produces.add(MediaType.WILDCARD_TYPE);
        }
        return produces;
    }

    private static <T> ResolvedView<T> newResolved(ViewResolver<T> resolver, Class<?> resourceClass, MediaType mediaType, ViewModel model, T viewReference) {
        String viewId = model.getViewId();
        ResolvedView<T> toReturn = new ResolvedView<T>(viewId, resolver, mediaType, viewReference);
        toReturn.asMap().putAll(model.asMap());
        return toReturn;
    }

    private static final class ResolvedView<T>
    extends ViewModel
    implements ViewWriter {
        private final ViewResolver<T> resolver;
        private final MediaType mediaType;
        private final T viewReference;

        public ResolvedView(String viewId, ViewResolver<T> resolver, MediaType mediaType, T viewReference) {
            super(viewId);
            this.resolver = resolver;
            this.mediaType = mediaType;
            this.viewReference = viewReference;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public void write(MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
            this.resolver.write((ViewModel)this, this.viewReference, this.mediaType, httpHeaders, entityStream);
        }
    }
}

