/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlEncoderDecoder;

public class WordMLProducer {
    private final Appendable appendable;
    private int flattenedLevelCount;
    private int maxOutlineLevel;
    private int outlineLevel;
    private final int[] outlineNumber;

    public WordMLProducer(Appendable appendable) {
        this.appendable = Objects.requireNonNull(appendable, "WordMLProducer::new, parameter \"appendable\" cannot be null.");
        this.flattenedLevelCount = 0;
        this.maxOutlineLevel = 9;
        this.outlineLevel = 0;
        this.outlineNumber = new int[10];
    }

    public void addBold() {
        this.append("<w:b/>");
    }

    public void addEditParagraphNoEscape(CharSequence text) {
        this.startParagraph();
        this.append(text);
        this.endParagraph();
    }

    public void addErrorRow(CharSequence id, CharSequence name, CharSequence type, CharSequence description) {
        this.addTableRow(id, name, type, description);
    }

    public void addNoProof() {
        this.append("<w:noProof/>");
    }

    public void addOleData(CharSequence oleData) {
        this.append("<w:docOleData>");
        this.append(oleData);
        this.append("</w:docOleData>");
    }

    public void addPageMargins() {
        this.append("<w:pgMar w:top=\"1440\" w:right=\"1296\" w:bottom=\"1440\" w:left=\"1296\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/>");
    }

    public void addPageSize(WordCoreUtil.pageType pageType2) {
        this.append(pageType2.getPageSize());
    }

    public void addParagraph(CharSequence text) {
        this.startParagraph();
        this.addTextInsideParagraph(text);
        this.endParagraph();
    }

    public void addParagraphBold(CharSequence text) {
        this.startParagraph();
        this.startRun();
        this.startRunPresentation();
        this.addBold();
        this.endRunPresentation();
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.startRunPresentation();
        this.addBold();
        this.endRunPresentation();
        this.endRun();
        this.endParagraph();
    }

    public void addParagraphNoEscape(CharSequence text) {
        this.startParagraph();
        this.startRun();
        this.startText();
        this.append(text);
        this.endText();
        this.endRun();
        this.endParagraph();
    }

    private void addParagraphStyle(CharSequence style) {
        this.append("<w:pStyle w:val=\"");
        this.append(style);
        this.append("\"/>");
    }

    private void addParagraphStyle(CharSequence style, int outlineLevel) {
        this.append("<w:pStyle w:val=\"");
        this.append(style);
        this.append(Integer.toString(outlineLevel));
        this.append("\"/>");
    }

    public void addRunWithTextEscape(CharSequence text) {
        CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)text);
        this.startRun();
        this.startText();
        this.append(xmlEncodedText);
        this.endText();
        this.endRun();
    }

    public void addRunWithTextEscape(CharSequence ... texts) {
        if (Objects.isNull(texts) || texts.length == 0) {
            return;
        }
        this.startRun();
        this.startText();
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)text);
            this.append(xmlEncodedText);
            ++n2;
        }
        this.endText();
        this.endRun();
    }

    public void addRunWithTextNoEscape(CharSequence text) {
        this.startRun();
        this.startText();
        this.append(text);
        this.endText();
        this.endRun();
    }

    public void addRunWithTextNoEscape(CharSequence ... texts) {
        if (Objects.isNull(texts) || texts.length == 0) {
            return;
        }
        this.startRun();
        this.startText();
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.append(text);
            ++n2;
        }
        this.endText();
        this.endRun();
    }

    public void addTableCaption(CharSequence captionText) {
        this.append("<w:p wsp:rsidR=\"003571A9\" wsp:rsidRDefault=\"00AE7B3F\" wsp:rsidP=\"00AE7B3F\">");
        this.startParagraphPresentation();
        this.addParagraphStyle("Caption");
        this.endParagraphPresentation();
        this.addRunWithTextNoEscape((CharSequence)"Table ");
        this.append("<w:fldSimple w:instr=\" SEQ Table \\* ARABIC \">");
        this.startRun();
        this.startRunPresentation();
        this.addNoProof();
        this.endRunPresentation();
        this.startText();
        this.append("#");
        this.endText();
        this.endRun();
        this.append("</w:fldSimple>");
        this.addRunWithTextNoEscape(": ", captionText);
        this.endParagraph();
    }

    public void addTableColumn(CharSequence text) {
        this.startTableColumn();
        this.addParagraph(text);
        this.endTableColumn();
    }

    public void addTableColumns(CharSequence ... texts) {
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.addTableColumn(text);
            ++n2;
        }
    }

    public void addTableColumnHeader(CharSequence text) {
        this.startTableColumn();
        this.addParagraphBold(text);
        this.endTableColumn();
    }

    public void addTableColumnHeaders(CharSequence ... texts) {
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.addTableColumnHeader(text);
            ++n2;
        }
    }

    public void addTableRow(CharSequence ... texts) {
        this.startTableRow();
        this.addTableColumns(texts);
        this.endTableRow();
    }

    public void addTableHeaderRow(CharSequence ... texts) {
        this.startTableRow();
        this.addTableColumnHeaders(texts);
        this.endTableRow();
    }

    public void addTablePresentation(WordCoreUtil.tablePresentation tablePresentation2) {
        this.append(tablePresentation2.get());
    }

    public void addTextInsideParagraph(CharSequence text) {
        this.startRun();
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.endRun();
    }

    public void addTextInsideParagraph(CharSequence text, CharSequence rgbHexColor) {
        StringBuilder runPresentationWithColor = WordCoreUtil.getRunPresentationWithRgbHexColor(rgbHexColor);
        this.startRun();
        this.append(runPresentationWithColor);
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.endRun();
    }

    public void addWordMl(CharSequence wordMl) {
        this.append(wordMl);
    }

    protected void append(CharSequence value) {
        try {
            this.appendable.append(value);
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private void appendEscaped(CharSequence value) {
        CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)value);
        CharSequence xmlEncodedTextWithWordMlHardLineBreaks = WordCoreUtil.replaceVerticalWhitespaceCharactersWithWordMlHardLineBreaks(xmlEncodedText);
        this.append(xmlEncodedTextWithWordMlHardLineBreaks);
    }

    public void createHyperLinkDoc(CharSequence filename) {
        StringBuilder hyperlinkDocument = WordCoreUtil.getHyperlinkDocument(filename);
        this.append(hyperlinkDocument);
    }

    public void endAppendixSubSection() {
        this.endSubSection();
    }

    public void endErrorLog() {
        this.endTable();
        this.addTableCaption("Error Log");
        this.endAppendixSubSection();
        this.setPageBreak(true, 1, true);
    }

    public void endListPresentation() {
        this.append("</w:listPr>");
    }

    public void endOutlineSubSection() {
        this.endOutlineSubSection(false);
    }

    private void endOutlineSubSection(boolean force) {
        if (!force && this.flattenedLevelCount > 0) {
            --this.flattenedLevelCount;
        } else {
            this.endSubSection();
            if (this.outlineLevel + 1 < this.outlineNumber.length) {
                this.outlineNumber[this.outlineLevel + 1] = 0;
            }
            --this.outlineLevel;
        }
    }

    public void endParagraph() {
        this.append("</w:p>");
    }

    public void endParagraphPresentation() {
        this.append("</w:pPr>");
    }

    public void endRun() {
        this.append("</w:r>");
    }

    public void endRunPresentation() {
        this.append("</w:rPr>");
    }

    public void endSection() {
        this.append("</wx:sect>");
    }

    public void endSectionPresentation() {
        this.append("</w:sectPr>");
    }

    public void endSubSection() {
        this.append("</wx:sub-section>");
    }

    public void endTable() {
        this.append("</w:tbl>");
        this.endSubSection();
    }

    public void endTableColumn() {
        this.append("</w:tc>");
    }

    public void endTableRow() {
        this.append("</w:tr>");
    }

    public void endText() {
        this.append("</w:t>");
    }

    private CharSequence getOutlineNumber() {
        StringBuilder strB = new StringBuilder();
        int i = 1;
        while (i < this.outlineLevel) {
            strB.append(String.valueOf(this.outlineNumber[i]));
            strB.append(".");
            ++i;
        }
        strB.append(String.valueOf(this.outlineNumber[this.outlineLevel]));
        return strB;
    }

    public boolean okToStartSubsection() {
        return this.outlineLevel < this.maxOutlineLevel;
    }

    public void resetListValue() {
        this.startParagraph();
        this.append("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>");
        this.endParagraph();
        this.startParagraph();
        this.append("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>");
        this.endParagraph();
    }

    public void setMaxOutlineLevel(int maxOutlineLevel) {
        this.maxOutlineLevel = maxOutlineLevel <= 9 ? maxOutlineLevel : 9;
    }

    public void setNextParagraphNumberTo(String outlineNumber) {
        String[] nextOutlineNumbers = outlineNumber.split("\\.");
        if (nextOutlineNumbers.length > 9) {
            nextOutlineNumbers = Arrays.copyOf(nextOutlineNumbers, 9);
        }
        Arrays.fill(this.outlineNumber, 0);
        try {
            int i = 0;
            while (i < nextOutlineNumbers.length) {
                this.outlineNumber[i + 1] = Integer.parseInt(nextOutlineNumbers[i]);
                ++i;
            }
            int n = nextOutlineNumbers.length;
            this.outlineNumber[n] = this.outlineNumber[n] - 1;
            this.outlineLevel = nextOutlineNumbers.length - 1;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering) {
        this.setPageBreak(chapterNumbering, chapterStyle, restartNumbering, WordCoreUtil.pageType.PORTRAIT);
    }

    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering, WordCoreUtil.pageType pageType2) {
        this.startParagraph();
        this.startParagraphPresentation();
        this.startSectionPresentation();
        this.addPageSize(pageType2);
        this.addPageMargins();
        if (chapterNumbering) {
            this.append("<w:pgNumType ");
            if (restartNumbering) {
                this.append("w:start=\"1\" ");
            }
            this.append("w:chap-style=\"");
            this.append(Integer.toString(chapterStyle));
            this.append("\"/>");
        }
        this.endSectionPresentation();
        this.endParagraphPresentation();
        this.endParagraph();
    }

    public void setPageLayout(WordCoreUtil.pageType pageType2) {
        if (WordCoreUtil.pageType.LANDSCAPE.equals((Object)pageType2)) {
            this.startParagraph();
            this.startParagraphPresentation();
            this.startSectionPresentation();
            this.addPageSize(pageType2);
            this.endSectionPresentation();
            this.endParagraphPresentation();
            this.endParagraph();
        }
    }

    public void startAppendixSubSection(CharSequence style, CharSequence headingText) {
        this.startSubSection();
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText})) {
            this.startParagraph();
            this.startParagraphPresentation();
            this.addParagraphStyle(style);
            this.endParagraphPresentation();
            this.addTextInsideParagraph(headingText);
            this.endParagraph();
        }
    }

    public void startErrorLog() {
        this.startAppendixSubSection("Heading1", "Error Log");
        this.startTable();
        this.append("<w:tblPr><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblBorders><w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/></w:tblBorders></w:tblPr>");
        this.addTableHeaderRow("Artifact Id", "Artifact Name", "Artifact Type", "Description");
    }

    public void startListPresentation() {
        this.append("<w:listPr>");
    }

    public CharSequence startOutlineSubSection() {
        CharSequence paragraphNumber = this.startOutlineSubSection("Times New Roman", null, null);
        return paragraphNumber;
    }

    public void startOutlineSubSection(CharSequence style, int outlineLevel, CharSequence outlineNumber, CharSequence font, CharSequence headingText) {
        this.startSubSection();
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText})) {
            this.startParagraph();
            this.startParagraphPresentation();
            this.addParagraphStyle(style, outlineLevel);
            this.startListPresentation();
            this.append("<wx:t wx:val=\"");
            this.append(outlineNumber);
            this.append("\" wx:wTabBefore=\"540\" wx:wTabAfter=\"90\"/><wx:font wx:val=\"");
            this.append(font);
            this.append("\"/>");
            this.endListPresentation();
            this.endParagraphPresentation();
            this.addTextInsideParagraph(headingText);
            this.endParagraph();
        }
    }

    public CharSequence startOutlineSubSection(CharSequence font, CharSequence headingText, CharSequence outlineType) {
        if (this.okToStartSubsection()) {
            this.outlineNumber[++this.outlineLevel] = this.outlineNumber[this.outlineLevel] + 1;
            CharSequence paragraphNumber = this.getOutlineNumber();
            this.startOutlineSubSection(Objects.nonNull(outlineType) ? outlineType : "Heading", this.outlineLevel, paragraphNumber, font, headingText);
            return paragraphNumber;
        }
        ++this.flattenedLevelCount;
        this.endOutlineSubSection(true);
        return this.startOutlineSubSection(font, headingText, outlineType);
    }

    public void startParagraph() {
        this.append("<w:p>");
    }

    public void startParagraphPresentation() {
        this.append("<w:pPr>");
    }

    public void startRun() {
        this.append("<w:r>");
    }

    public void startRunPresentation() {
        this.append("<w:rPr>");
    }

    public void startSection() {
        this.append("<wx:sect>");
    }

    public void startSectionPresentation() {
        this.append("<w:sectPr>");
    }

    public void startSubSection() {
        this.append("<wx:sub-section>");
    }

    public void startTable() {
        this.startSubSection();
        this.append("<w:tbl>");
    }

    public void startTableColumn() {
        this.append("<w:tc>");
    }

    public void startTableRow() {
        this.append("<w:tr>");
    }

    public void startText() {
        this.append("<w:t>");
    }
}

