/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateScalarKey;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateVectorKey;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;
import org.eclipse.osee.logger.Log;

abstract class AbstractPublishingTemplateCache
implements PublishingTemplateCache {
    protected RankMap<List<PublishingTemplateInternal>> keyMap;
    private List<PublishingTemplateInternal> list;
    protected Log logger;

    AbstractPublishingTemplateCache(Log logger) {
        this.logger = logger;
        this.deleteCache();
    }

    private void addToKeyMap(PublishingTemplateInternal publishingTemplateInternal) {
        PublishingTemplateKeyType[] publishingTemplateKeyTypeArray = PublishingTemplateKeyType.values();
        int n = publishingTemplateKeyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PublishingTemplateKeyType primaryKey = publishingTemplateKeyTypeArray[n2];
            Iterable<PublishingTemplateScalarKey> secondaryKeyIterable = publishingTemplateInternal.getKeyIterable(primaryKey);
            for (PublishingTemplateScalarKey secondaryKey : secondaryKeyIterable) {
                this.keyMap.get(new Object[]{primaryKey, secondaryKey}).ifPresentOrElse(publishingTemplateInternalList -> {
                    boolean bl = publishingTemplateInternalList.add(publishingTemplateInternal);
                }, () -> {
                    ArrayList<PublishingTemplateInternal> publishingTemplateInternalList = new ArrayList<PublishingTemplateInternal>();
                    publishingTemplateInternalList.add(publishingTemplateInternal);
                    this.keyMap.associate(publishingTemplateInternalList, new Object[]{primaryKey, secondaryKey});
                });
            }
            ++n2;
        }
    }

    private void sortMatchCritera() {
        this.keyMap.stream(new Object[0]).filter(publishingTemplateInternalList -> publishingTemplateInternalList.size() > 1).forEach(publishingTemplateInternalList -> publishingTemplateInternalList.sort(new Comparator<PublishingTemplateInternal>(){

            @Override
            public int compare(PublishingTemplateInternal o1, PublishingTemplateInternal o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }));
    }

    private void logDuplicates() {
        this.keyMap.streamEntries(new Object[0]).filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            if (!this.logger.isInfoEnabled()) {
                return;
            }
            PublishingTemplateKeyType primaryKey = (PublishingTemplateKeyType)entry.getKey(0);
            Object secondaryKey = entry.getKey(1);
            List publishingTemplateInternalList = (List)entry.getValue();
            PublishingTemplateScalarKey primaryTemplateName = ((PublishingTemplateInternal)publishingTemplateInternalList.get(0)).getName();
            PublishingTemplateScalarKey primaryTemplateIdentifier = ((PublishingTemplateInternal)publishingTemplateInternalList.get(0)).getIdentifier();
            Message message = new Message().blank().title((CharSequence)"PublishingTemplateProvider has detected a conflict.").indentInc().segment((CharSequence)"Key Type", (Object)primaryKey).segment((CharSequence)"Publishing Template Key", secondaryKey).title((CharSequence)"The Publishing Template That Will Be Used").indentInc().segment((CharSequence)"Name", (Object)primaryTemplateName).segment((CharSequence)"Identifier", (Object)primaryTemplateIdentifier).indentDec();
            this.logger.infoNoFormat(null, (CharSequence)message.toString());
        });
    }

    private synchronized void cacheTemplates() {
        RankHashMap keyMap;
        if (this.isCacheLoaded()) {
            return;
        }
        this.list = this.loadTemplates();
        this.keyMap = keyMap = new RankHashMap("KeyMap", 2, 256, 0.75f, new Predicate[]{o -> o instanceof PublishingTemplateKeyType, o -> o instanceof PublishingTemplateScalarKey || o instanceof PublishingTemplateVectorKey});
        this.list.stream().forEach(this::addToKeyMap);
        this.sortMatchCritera();
        this.logDuplicates();
    }

    @Override
    public void deleteCache() {
        this.keyMap = null;
        this.list = null;
    }

    @Override
    public Optional<PublishingTemplateInternal> findFirstTemplate(PublishingTemplateKeyType key, String identifier) {
        this.loadCacheIfNeeded();
        if (Objects.isNull(key) || Objects.isNull(identifier)) {
            return Optional.empty();
        }
        Optional<PublishingTemplateInternal> firstTemplate = this.keyMap.get(new Object[]{key, new PublishingTemplateScalarKey(identifier, key)}).map(templateList -> templateList.size() > 0 ? (PublishingTemplateInternal)templateList.get(0) : null);
        return firstTemplate;
    }

    @Override
    public Optional<PublishingTemplateInternal> findFirstTemplateByMatchCriteria(List<String> matchCriteria) {
        this.loadCacheIfNeeded();
        Optional<PublishingTemplateInternal> firstTemplate = matchCriteria.stream().map(matchCriterionString -> new PublishingTemplateScalarKey(matchCriterionString, PublishingTemplateKeyType.MATCH_CRITERIA)).map(matchCriterionKey -> this.keyMap.get(new Object[]{PublishingTemplateKeyType.MATCH_CRITERIA, matchCriterionKey})).filter(Optional::isPresent).map(Optional::get).findFirst().map(publishingTemplateInternalList -> publishingTemplateInternalList.isEmpty() ? null : (PublishingTemplateInternal)publishingTemplateInternalList.get(0));
        return firstTemplate;
    }

    @Override
    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups() {
        this.loadCacheIfNeeded();
        List publishingTemplateKeyGroupList = this.list.stream().map(PublishingTemplateInternal::getPublishingTemplateKeyGroup).collect(Collectors.toUnmodifiableList());
        return new PublishingTemplateKeyGroups(publishingTemplateKeyGroupList);
    }

    protected boolean isCacheLoaded() {
        return Objects.nonNull(this.keyMap);
    }

    protected void loadCacheIfNeeded() {
        if (!this.isCacheLoaded()) {
            this.cacheTemplates();
        }
    }

    protected abstract List<PublishingTemplateInternal> loadTemplates();
}

