/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class PublishingUtils {
    private final ThreadLocal<Cause> lastCause = new ThreadLocal<Cause>(){

        @Override
        protected Cause initialValue() {
            return Cause.OK;
        }
    };
    private final ThreadLocal<Exception> lastError = new ThreadLocal();
    private final OrcsTokenService orcsTokenService;
    private final QueryFactory queryFactory;

    public PublishingUtils(OrcsApi orcsApi) {
        this.queryFactory = Objects.requireNonNull(orcsApi.getQueryFactory());
        this.orcsTokenService = Objects.requireNonNull(orcsApi.tokenService());
    }

    private QueryBuilder getBranchQuery(BranchSpecification branchSpecification) {
        return branchSpecification.hasView() ? this.queryFactory.fromBranch(branchSpecification.getBranchId(), branchSpecification.getViewId()) : this.queryFactory.fromBranch(branchSpecification.getBranchId());
    }

    private QueryBuilder getBranchQuery(ArtifactSpecification artifactSpecification) {
        return artifactSpecification.hasView() ? this.queryFactory.fromBranch(artifactSpecification.getBranchId(), artifactSpecification.getViewId()) : this.queryFactory.fromBranch(artifactSpecification.getBranchId());
    }

    public Optional<ArtifactReadable> getArtifactReadableByGuid(BranchSpecification branchSpecification, String guid) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andGuid(guid).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByIdentifier(ArtifactSpecification artifactSpecification) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(artifactSpecification).andId(artifactSpecification.getArtifactId()).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByName(BranchSpecification branchSpecification, String artifactName) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andNameEquals(artifactName).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeAndName(BranchSpecification branchSpecification, ArtifactTypeToken artifactTypeToken, String artifactName) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeNameAndName(BranchSpecification branchSpecification, String artifactTypeName, String artifactName) {
        return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getArtifactReadableByTypeAndName(branchSpecification, (ArtifactTypeToken)artifactTypeToken, artifactName));
    }

    public Optional<ArtifactReadable> getArtifactReadablePossiblyDeletedByIdentifierAndTransactionIdWithDeleteAttributes(ArtifactSpecification artifactSpecification, TransactionId transactionId) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(artifactSpecification).fromTransaction(transactionId).andId(artifactSpecification.getArtifactId()).includeDeletedArtifacts().includeDeletedAttributes().getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadablePossiblyDeletedByIdentifierWithDeletedAttributes(ArtifactSpecification artifactSpecification) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(artifactSpecification).andId(artifactSpecification.getArtifactId()).includeDeletedArtifacts().includeDeletedAttributes().getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<List<ArtifactReadable>> getArtifactReadablesByIdentifiers(BranchSpecification branchSpecification, Collection<ArtifactId> artifactIds) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andIds(artifactIds).getResults().getList());
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<List<ArtifactReadable>> getArtifactReadablesByType(BranchSpecification branchSpecification, ArtifactTypeToken artifactTypeToken) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).getResults().getList());
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<List<ArtifactReadable>> getArtifactReadablesFilterByTxCommentForChange(BranchSpecification branchSpecification) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andTxComment("(E|P)R\\s?\\d{5}", CoreAttributeTypes.NameWord).getResults().getList());
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactToken> getArtifactTokenByIdentifier(ArtifactSpecification artifactSpecification) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(artifactSpecification).andId(artifactSpecification.getArtifactId()).asArtifactToken());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactTypeToken> getArtifactTypeTokenByName(String artifactTypeName) {
        this.startOperation();
        try {
            return Optional.of(this.orcsTokenService.getArtifactType(artifactTypeName));
        }
        catch (OseeTypeDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<Branch> getBranchByIdentifier(BranchId branchId) {
        this.startOperation();
        try {
            return Optional.of((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branchId)).getResults().getExactlyOne());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeAndName(BranchSpecification branchSpecification, ArtifactId parent, ArtifactTypeToken artifactTypeToken, String artifactName) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, parent).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeNameAndName(BranchSpecification branchSpecification, ArtifactId parent, String artifactTypeName, String artifactName) {
        return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getChildArtifactReadableByTypeAndName(branchSpecification, parent, (ArtifactTypeToken)artifactTypeToken, artifactName));
    }

    public Cause getLastCause() {
        return this.lastCause.get();
    }

    public Optional<Exception> getLastError() {
        return Optional.ofNullable(this.lastError.get());
    }

    public Optional<List<ArtifactReadable>> getRecursiveChildenArtifactReadablesByAttributeTypeAndAttributeValue(BranchSpecification branchSpecification, ArtifactId parent, AttributeTypeId attributeTypeId, String value) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andAttributeIs(AttributeTypeToken.valueOf((Long)attributeTypeId.getId()), value).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent).getResults().getList());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<List<ArtifactReadable>> getRecursiveChildenArtifactReadablesOfTypeByAttributeTypeAndAttributeValue(BranchSpecification branchSpecification, ArtifactId parent, ArtifactTypeToken artifactTypeToken, AttributeTypeId attributeTypeId, String value) {
        this.startOperation();
        try {
            return Optional.of(this.getBranchQuery(branchSpecification).andAttributeIs(AttributeTypeToken.valueOf((Long)attributeTypeId.getId()), value).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).getResults().getList());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<List<ArtifactId>> getWorkFlowArtifactIdentifiers(ArtifactId artifactId) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andRelatedTo(AtsRelationTypes.Goal_Goal, artifactId).asArtifactIds());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    private void startOperation() {
        this.lastCause.remove();
        this.lastError.remove();
    }

    public static enum Cause {
        ERROR,
        MORE_THAN_ONE,
        NOT_FOUND,
        OK;

    }
}

