/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureToken;

public class InterfaceStructureEndpointImpl
implements InterfaceStructureEndpoint {
    private final BranchId branch;
    private final ArtifactId connectionId;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;

    public InterfaceStructureEndpointImpl(BranchId branch, ArtifactId connectionId, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi) {
        this.branch = branch;
        this.connectionId = connectionId;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getAllStructures(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (this.subMessageId.getId() == 0L) {
            return Arrays.asList(this.interfaceStructureApi.getMessageHeaderStructure(this.branch, this.connectionId, this.messageId, viewId));
        }
        if (Strings.isValid((String)filter)) {
            return this.interfaceStructureApi.getAllRelatedAndFilter(this.branch, this.connectionId, this.subMessageId, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
        }
        return this.interfaceStructureApi.getAllRelated(this.branch, this.connectionId, this.subMessageId, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
    }

    @Override
    public InterfaceStructureToken getStructure(ArtifactId structureId, String filter, ArtifactId viewId) {
        if (Strings.isValid((String)filter)) {
            return this.interfaceStructureApi.getRelatedAndFilter(this.branch, this.connectionId, this.subMessageId, structureId, filter, viewId);
        }
        return this.interfaceStructureApi.getRelated(this.branch, this.connectionId, this.subMessageId, structureId, viewId);
    }
}

