/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class ExpressionOp
extends Expression {
    static final ExpressionOp limitOneExpression = new ExpressionOp(96, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), (Expression)new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER));

    ExpressionOp(int n, Expression[] expressionArray) {
        super(n);
        switch (this.opType) {
            case 90: {
                this.nodes = expressionArray;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(int n, Expression expression, Expression expression2) {
        super(n);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 37: 
            case 93: 
            case 94: 
            case 96: 
            case 98: {
                return;
            }
            case 88: {
                this.dataType = expression.dataType;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(Expression expression, Type type) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.dataType = type;
        this.alias = expression.alias;
    }

    ExpressionOp(Expression expression, Type type, Expression expression2) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.dataType = type;
        this.alias = expression.alias;
    }

    ExpressionOp(Expression expression) {
        super(expression.dataType.isDateTimeTypeWithZone() ? 91 : 93);
        switch (expression.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(93, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, expression.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(93, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, expression.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, expression.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, expression.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        this.alias = expression.alias;
    }

    public static Expression getCastExpression(Session session, Expression expression, Type type) {
        if (expression.getType() == 1) {
            Object object = type.castToType(session, expression.getValue(session), expression.getDataType());
            return new ExpressionValue(object, type);
        }
        return new ExpressionOp(expression, type);
    }

    public static Expression getConvertExpression(Session session, Expression expression, Type type) {
        if (expression.getType() == 1) {
            Object object = type.convertToType(session, expression.getValue(session), expression.getDataType());
            return new ExpressionValue(object, type);
        }
        ExpressionOp expressionOp = new ExpressionOp(expression, type);
        expressionOp.opType = 92;
        return expressionOp;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String string2 = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 37: {
                stringBuilder.append(' ').append("LIKE").append(' ');
                stringBuilder.append(string).append(' ').append(string2).append(' ');
                break;
            }
            case 91: {
                stringBuilder.append(' ').append("CAST").append('(');
                stringBuilder.append(string).append(' ').append("AS").append(' ');
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(')');
                break;
            }
            case 92: {
                stringBuilder.append(string);
                break;
            }
            case 94: {
                stringBuilder.append(' ').append("CASEWHEN").append('(');
                stringBuilder.append(string).append(',').append(string2).append(')');
                break;
            }
            case 98: {
                stringBuilder.append(string).append(',').append(string2);
                break;
            }
            case 96: {
                if (string != null) {
                    stringBuilder.append(' ').append("OFFSET").append(' ');
                    stringBuilder.append(string).append(' ');
                }
                if (string2 == null) break;
                stringBuilder.append(' ').append("FETCH").append(' ');
                stringBuilder.append("FIRST");
                stringBuilder.append(string2).append(' ').append(string2).append(' ');
                stringBuilder.append("ROWS").append(' ').append("ONLY");
                stringBuilder.append(' ');
                break;
            }
            case 93: {
                stringBuilder.append(string).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    stringBuilder.append("LOCAL").append(' ');
                    break;
                }
                stringBuilder.append("TIME").append(' ').append("ZONE");
                stringBuilder.append(' ');
                stringBuilder.append(string2);
                break;
            }
            case 90: {
                stringBuilder.append("CONCAT_WS").append(936);
                stringBuilder.append(string);
                for (int i = 0; i < this.nodes.length; ++i) {
                    stringBuilder.append(',').append(this.nodes[i].getSQL());
                }
                stringBuilder.append(922);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuilder.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
            case 37: {
                stringBuilder.append("LIKE").append(' ').append("ARG ");
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(' ');
                break;
            }
            case 26: {
                stringBuilder.append("VALUE").append(' ').append("LIST ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuilder.append(this.nodes[n2].describe(session, n + 1));
                    stringBuilder.append(' ');
                }
                return stringBuilder.toString();
            }
            case 91: {
                stringBuilder.append("CAST").append(' ');
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(' ');
                break;
            }
            case 92: {
                stringBuilder.append("CONVERT").append(' ');
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(' ');
                break;
            }
            case 94: {
                stringBuilder.append("CASEWHEN").append(' ');
                break;
            }
            case 90: {
                stringBuilder.append("CONCAT_WS").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg_left=[");
            stringBuilder.append(this.nodes[0].describe(session, n + 1));
            stringBuilder.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuilder.append(" arg_right=[");
            stringBuilder.append(this.nodes[1].describe(session, n + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List list, boolean bl) {
        if (this.opType == 1) {
            return list;
        }
        switch (this.opType) {
            case 94: {
                bl = false;
                break;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            list = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        switch (this.opType) {
            case 94: {
                break;
            }
            default: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n] == null) continue;
                    this.nodes[n].resolveTypes(session, this);
                }
            }
        }
        block3 : switch (this.opType) {
            case 1: {
                break;
            }
            case 37: {
                this.dataType = this.nodes[0].dataType;
                if (this.nodes[0].opType != 1 || this.nodes[1] != null && this.nodes[1].opType != 1) break;
                this.setAsConstantValue(session, expression);
                break;
            }
            case 91: 
            case 92: {
                Expression expression2 = this.nodes[0];
                Type type = expression2.dataType;
                if (type != null && !this.dataType.canConvertFrom(type)) {
                    throw Error.error(5561);
                }
                if (expression2.opType == 1) {
                    this.setAsConstantValue(session, expression);
                    break;
                }
                if (this.nodes[0].opType != 8) break;
                expression2.dataType = this.dataType;
                break;
            }
            case 93: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        if (this.nodes[1].opType == 1) {
                            this.nodes[1].valueData = Type.SQL_INTERVAL_HOUR_TO_MINUTE.castToType(session, this.nodes[1].valueData, this.nodes[1].dataType);
                            this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                        } else {
                            throw Error.error(5563);
                        }
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block3;
                    }
                }
                throw Error.error(5563);
            }
            case 94: {
                this.resolveTypesForCaseWhen(session, expression);
                break;
            }
            case 90: {
                for (n = 0; n < this.nodes.length; ++n) {
                    this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 98: {
                this.resolveTypesForAlternative(session);
                break;
            }
            case 96: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        throw Error.error(5567);
                    }
                    if (!this.nodes[0].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                if (this.nodes[1] == null) break;
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType.isIntegralType()) break;
                throw Error.error(5563);
            }
            case 88: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
    }

    void resolveTypesForAlternative(Session session) {
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        }
        if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.exprSubType == 91) {
            if (this.nodes[1].dataType == null) {
                this.nodes[1].dataType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
            }
            this.dataType = this.nodes[1].dataType;
            if (!this.nodes[1].dataType.equals(this.nodes[0].dataType)) {
                if (this.dataType.isCharacterType()) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.nodes[0] = new ExpressionOp(this.nodes[0], this.dataType);
            }
        } else {
            this.dataType = Type.getAggregateType(this.nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(this.nodes[1].dataType, this.dataType);
        }
    }

    void resolveTypesForCaseWhen(Session session, Expression expression) {
        this.nodes[1].resolveTypes(session, this);
        Expression expression2 = this;
        while (expression2.opType == 94) {
            this.dataType = expression2.exprSubType == 91 ? expression2.nodes[1].dataType : Type.getAggregateType(expression2.nodes[1].dataType, this.dataType);
            if (expression2.nodes[1].nodes[1].opType == 94) {
                expression2 = expression2.nodes[1].nodes[1];
                continue;
            }
            expression2 = expression2.nodes[1].nodes[0];
        }
        expression2 = this;
        while (expression2.opType == 94) {
            if (expression2.nodes[1].dataType == null) {
                expression2.nodes[1].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[1].dataType == null) {
                expression2.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[0].dataType == null) {
                expression2.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[1].opType == 94) {
                expression2 = expression2.nodes[1].nodes[1];
                continue;
            }
            expression2 = expression2.nodes[1].nodes[0];
        }
        expression2 = this;
        while (expression2.opType == 94) {
            expression2.nodes[0].resolveTypes(session, expression2);
            if (expression2.nodes[0].isUnresolvedParam()) {
                expression2.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expression2.nodes[1].nodes[0].resolveTypes(session, expression2.nodes[1]);
            if (expression2.nodes[1].nodes[1].opType != 94) {
                expression2.nodes[1].nodes[1].resolveTypes(session, expression2.nodes[1]);
            }
            expression2 = expression2.nodes[1].nodes[1];
        }
        if (!(expression != null && expression.opType == 98 || this.dataType != null && this.dataType.typeCode != 0)) {
            throw Error.error(5567);
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 37: {
                Object object;
                boolean bl = this.nodes[1] != null;
                int n = Integer.MAX_VALUE;
                if (this.dataType.isBinaryType()) {
                    Object object2;
                    BinaryData binaryData = (BinaryData)this.nodes[0].getValue(session);
                    if (binaryData == null) {
                        return null;
                    }
                    if (bl) {
                        object2 = (BinaryData)this.nodes[1].getValue(session);
                        if (object2 == null) {
                            return null;
                        }
                        if (((BinaryData)object2).length(session) != 1L) {
                            throw Error.error(3412);
                        }
                        n = ((BinaryData)object2).getBytes()[0];
                    }
                    object2 = binaryData.getBytes();
                    byte[] byArray = new byte[((byte[])object2).length];
                    boolean bl2 = false;
                    int n2 = 0;
                    int n3 = 0;
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        if (object2[i] == n) {
                            if (bl2) {
                                ++n2;
                                byArray[n3++] = (byte)object2[i];
                                bl2 = false;
                                continue;
                            }
                            bl2 = true;
                            if (i != ((Object)object2).length - 1) continue;
                            throw Error.error(3458);
                        }
                        if (object2[i] == 95 || object2[i] == 37) {
                            if (!bl2) break;
                            ++n2;
                            byArray[n3++] = (byte)object2[i];
                            bl2 = false;
                            continue;
                        }
                        if (bl2) {
                            throw Error.error(3458);
                        }
                        byArray[n3++] = (byte)object2[i];
                    }
                    byArray = (byte[])ArrayUtil.resizeArrayIfDifferent(byArray, n3);
                    return new BinaryData(byArray, false);
                }
                String string = (String)Type.SQL_VARCHAR.convertToType(session, this.nodes[0].getValue(session), this.nodes[0].getDataType());
                if (string == null) {
                    return null;
                }
                if (bl) {
                    object = (String)Type.SQL_VARCHAR.convertToType(session, this.nodes[1].getValue(session), this.nodes[1].getDataType());
                    if (object == null) {
                        return null;
                    }
                    if (((String)object).length() != 1) {
                        throw Error.error(3439);
                    }
                    n = ((String)object).getBytes()[0];
                }
                object = string.toCharArray();
                char[] cArray = new char[((char[])object).length];
                boolean bl3 = false;
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < ((char[])object).length; ++i) {
                    if (object[i] == n) {
                        if (bl3) {
                            ++n4;
                            cArray[n5++] = (char)object[i];
                            bl3 = false;
                            continue;
                        }
                        bl3 = true;
                        if (i != ((Object)object).length - 1) continue;
                        throw Error.error(3458);
                    }
                    if (object[i] == 95 || object[i] == 37) {
                        if (!bl3) break;
                        ++n4;
                        cArray[n5++] = (char)object[i];
                        bl3 = false;
                        continue;
                    }
                    if (bl3) {
                        throw Error.error(3458);
                    }
                    cArray[n5++] = (char)object[i];
                }
                return new String(cArray, 0, n5);
            }
            case 95: {
                return this.nodes[0].getValue(session);
            }
            case 88: {
                if (this.nodes[0].dataType.isCharacterType()) {
                    Object object = this.nodes[1].getValue(session);
                    if (object == null) {
                        return null;
                    }
                    CharacterType characterType = (CharacterType)this.nodes[1].dataType;
                    long l = ((CharacterType)this.nodes[1].dataType).size(session, object);
                    characterType = (CharacterType)this.nodes[0].dataType;
                    object = this.nodes[0].getValue(session);
                    if (object == null) {
                        return null;
                    }
                    return characterType.substring(session, object, 0L, l, true, false);
                }
                BinaryData binaryData = (BinaryData)this.nodes[1].getValue(session);
                if (binaryData == null) {
                    return null;
                }
                long l = binaryData.length(session);
                BinaryType binaryType = (BinaryType)this.nodes[0].dataType;
                binaryData = (BinaryData)this.nodes[0].getValue(session);
                if (binaryData == null) {
                    return null;
                }
                return binaryType.substring(session, binaryData, 0L, l, true);
            }
            case 91: {
                Object object = this.dataType.castToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraintArray = this.dataType.userTypeModifier.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        constraintArray[i].checkCheckConstraint(session, null, null, object);
                    }
                }
                return object;
            }
            case 92: {
                Object object = this.dataType.convertToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraintArray = this.dataType.userTypeModifier.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        constraintArray[i].checkCheckConstraint(session, null, null, object);
                    }
                }
                return object;
            }
            case 94: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(bl)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 90: {
                String string = (String)this.nodes[0].getValue(session);
                if (string == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (int i = 1; i < this.nodes.length; ++i) {
                    String string2 = (String)this.nodes[i].getValue(session);
                    if (string2 == null) continue;
                    if (bl) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    bl = true;
                }
                return stringBuilder.toString();
            }
            case 93: {
                Object object;
                Object object3 = this.nodes[0].getValue(session);
                Object object4 = object = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (object3 == null) {
                    return null;
                }
                if (this.nodes[1] != null && object == null) {
                    return null;
                }
                long l = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(object);
                return ((DateTimeType)this.dataType).changeZone(session, object3, this.nodes[0].dataType, (int)l, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }
}

