/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.regex;

import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.jdk.core.type.CharSequenceWindow;

public class TokenMatcher {
    private final Matcher coreTokenMatcher;
    private final Function<CharSequence, Matcher> coreTokenMatcherFunction;
    private boolean done;
    private int endExclusive;
    private final CharSequence input;
    private Matcher prefixMatcher;
    private final Function<CharSequence, Matcher> prefixMatcherFunction;
    private final boolean prefixSuffixRequired;
    private int prefixStartInclusive;
    private int startInclusive;
    private boolean started;
    private Matcher suffixMatcher;
    private final Function<CharSequence, Matcher> suffixMatcherFunction;
    private int suffixStartInclusive;

    TokenMatcher(CharSequence input, Boolean prefixSuffixRequired, Function<CharSequence, Matcher> prefixMatcherFunction, Function<CharSequence, Matcher> coreTokenMatcherFunction, Function<CharSequence, Matcher> suffixMatcherFunction) {
        this.input = input;
        this.prefixSuffixRequired = prefixSuffixRequired;
        this.prefixMatcherFunction = prefixMatcherFunction;
        this.coreTokenMatcherFunction = coreTokenMatcherFunction;
        this.suffixMatcherFunction = suffixMatcherFunction;
        this.coreTokenMatcher = this.coreTokenMatcherFunction.apply(input);
        this.suffixMatcher = null;
        this.prefixMatcher = null;
        this.startInclusive = 0;
        this.endExclusive = -1;
        this.prefixStartInclusive = -1;
        this.suffixStartInclusive = -1;
        this.started = false;
        this.done = false;
    }

    public int coreTokenEnd(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return this.coreTokenMatcher.end(group);
    }

    public CharSequence coreTokenGroupCharSequence(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        int start = this.coreTokenStart(group);
        int end = this.coreTokenEnd(group);
        CharSequenceWindow charSequenceWindow = new CharSequenceWindow(this.input, start, end);
        return charSequenceWindow;
    }

    public String coreTokenGroupString(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return this.coreTokenMatcher.group(group);
    }

    public int coreTokenStart(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return this.coreTokenMatcher.start(group);
    }

    public int end() {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return this.endExclusive;
    }

    /*
     * Unable to fully structure code
     */
    public boolean find() {
        if (!this.done) ** GOTO lbl42
        throw new IllegalStateException();
lbl-1000:
        // 1 sources

        {
            coreTokenStartInclusive = this.coreTokenMatcher.start();
            coreTokenEndExclusive = this.coreTokenMatcher.end();
            suffixStringWindow = new CharSequenceWindow(this.input, coreTokenEndExclusive);
            suffixMatcher = this.suffixMatcherFunction.apply(suffixStringWindow);
            if (!suffixMatcher.lookingAt()) {
                if (this.prefixSuffixRequired) continue;
                this.startInclusive = coreTokenStartInclusive;
                this.endExclusive = coreTokenEndExclusive;
                this.prefixStartInclusive = -1;
                this.suffixStartInclusive = -1;
                this.prefixMatcher = null;
                this.suffixMatcher = null;
                this.started = true;
                this.done = false;
                return true;
            }
            suffixLength = suffixMatcher.end();
            prefixStringWindow = new CharSequenceWindow(this.input, coreTokenStartInclusive, 0);
            prefixMatcher = this.prefixMatcherFunction.apply(prefixStringWindow);
            if (!prefixMatcher.lookingAt()) {
                if (this.prefixSuffixRequired) continue;
                this.startInclusive = coreTokenStartInclusive;
                this.endExclusive = coreTokenEndExclusive;
                this.prefixStartInclusive = -1;
                this.suffixStartInclusive = -1;
                this.prefixMatcher = null;
                this.suffixMatcher = null;
                this.started = true;
                this.done = false;
                return true;
            }
            prefixLength = prefixMatcher.end();
            this.startInclusive = coreTokenStartInclusive - prefixLength;
            this.endExclusive = coreTokenEndExclusive + suffixLength;
            this.prefixStartInclusive = coreTokenStartInclusive - 1;
            this.suffixStartInclusive = coreTokenEndExclusive;
            this.prefixMatcher = prefixMatcher;
            this.suffixMatcher = suffixMatcher;
            this.started = true;
            this.done = false;
            return true;
lbl42:
            // 3 sources

            ** while (this.coreTokenMatcher.find())
        }
lbl43:
        // 1 sources

        this.startInclusive = -1;
        this.endExclusive = -1;
        this.prefixStartInclusive = -1;
        this.suffixStartInclusive = -1;
        this.prefixMatcher = null;
        this.suffixMatcher = null;
        this.started = true;
        this.done = true;
        return false;
    }

    public int prefixEnd(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return Objects.nonNull(this.prefixMatcher) ? this.prefixStartInclusive - this.prefixMatcher.start(group) + 1 : -1;
    }

    public CharSequence prefixGroupCharSequence(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        int startInclusive = this.prefixStart(group);
        int endExclusive = this.prefixEnd(group);
        CharSequenceWindow charSequenceWindow = new CharSequenceWindow(this.input, startInclusive, endExclusive);
        return charSequenceWindow;
    }

    public int prefixStart(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return Objects.nonNull(this.prefixMatcher) ? this.prefixStartInclusive - this.prefixMatcher.end(group) + 1 : -1;
    }

    public int start() {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return this.startInclusive;
    }

    public int suffixEnd(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return Objects.nonNull(this.suffixMatcher) ? this.suffixMatcher.end(group) + this.suffixStartInclusive : -1;
    }

    public CharSequence suffixGroupCharSequence(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        if (Objects.isNull(this.suffixMatcher)) {
            return null;
        }
        int start = this.suffixStart(group);
        int end = this.suffixEnd(group);
        CharSequenceWindow charSequenceWindow = new CharSequenceWindow(this.input, start, end);
        return charSequenceWindow;
    }

    public String suffixGroupString(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return Objects.nonNull(this.suffixMatcher) ? this.suffixMatcher.group(group) : null;
    }

    public int suffixStart(int group) {
        if (!this.started || this.done) {
            throw new IllegalStateException();
        }
        return Objects.nonNull(this.suffixMatcher) ? this.suffixMatcher.start(group) + this.suffixStartInclusive : -1;
    }
}

