/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;

public abstract class AbstractAtsAttributeResolverServiceImpl
implements IAttributeResolver {
    protected AtsApi atsApi;

    public AbstractAtsAttributeResolverServiceImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String getStaticIdValue(IAtsWorkItem workItem, String key, String defaultValue) {
        for (String value : this.getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.StaticId)) {
            if (!value.startsWith(String.valueOf(key) + "=")) continue;
            return value.replaceFirst(String.valueOf(key) + "=", "");
        }
        return defaultValue;
    }

    public void setStaticIdValue(IAtsWorkItem workItem, String key, String value, IAtsChangeSet changes) {
        for (IAttribute attr : this.getAttributes((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.StaticId)) {
            if (!((String)attr.getValue()).startsWith(String.valueOf(key) + "=")) continue;
            changes.setAttribute(workItem, (AttributeId)attr, (Object)(String.valueOf(key) + "=" + value));
            return;
        }
        changes.addAttribute((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)(String.valueOf(key) + "=" + value));
    }
}

