/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.util.Date;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.internal.log.AtsLog;
import org.eclipse.osee.ats.core.internal.log.AtsLogReader;
import org.eclipse.osee.ats.core.internal.log.AtsLogWriter;
import org.eclipse.osee.ats.core.internal.log.LogItem;
import org.eclipse.osee.ats.core.workflow.log.AtsLogStoreProvider;

public class AtsLogFactory
implements IAtsLogFactory {
    public IAtsLog getLog() {
        return new AtsLog();
    }

    public IAtsLog getLogLoaded(IAtsWorkItem workItem, IAttributeResolver attrResolver) {
        IAtsLog log = this.getLog();
        AtsLogReader reader = new AtsLogReader(log, this.getLogProvider(workItem, attrResolver));
        reader.load();
        return log;
    }

    public IAtsLogItem newLogItem(LogType type, Date date, AtsUser user, String state, String msg) {
        return new LogItem(type, date, user.getUserId(), state, msg);
    }

    public void writeToStore(IAtsWorkItem workItem, IAttributeResolver attrResolver, IAtsChangeSet changes) {
        AtsLogWriter writer = new AtsLogWriter(workItem.getLog(), this.getLogProvider(workItem, attrResolver));
        writer.save(changes);
        this.getLogLoaded(workItem, attrResolver);
    }

    public ILogStorageProvider getLogProvider(IAtsWorkItem workItem, IAttributeResolver attrResolver) {
        return new AtsLogStoreProvider(workItem, attrResolver);
    }
}

