/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class ChangeTypeColumn
extends AbstractServicesColumn {
    public ChangeTypeColumn(AtsApi atsApi) {
        super(atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        return ChangeTypeColumn.getChangeTypeStr(atsObject);
    }

    public static String getChangeTypeStr(IAtsObject atsObject) {
        return (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)"");
    }

    public static String getChangeTypeStr(IAtsWorkItem workItem, AtsApi atsApi) {
        ChangeTypes changeType = ChangeTypeColumn.getChangeType(workItem, atsApi);
        if (changeType == ChangeTypes.None) {
            return "";
        }
        return changeType.name();
    }

    public static ChangeTypes getChangeType(String cTypeStr, AtsApi atsApi) {
        return ChangeTypes.getChangeType((Object)cTypeStr);
    }

    public static ChangeTypes getChangeType(IAtsWorkItem workItem, AtsApi atsApi) {
        return ChangeTypes.getChangeType((Object)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)""));
    }

    public static ChangeTypes getChangeType(IAtsAction action, AtsApi atsApi) {
        return ChangeTypes.getChangeType((Object)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)action, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)""));
    }

    public static ChangeTypes getChangeType(IAtsObject atsObject, AtsApi atsApi) {
        ChangeTypes type = null;
        if (atsObject instanceof IAtsWorkItem) {
            type = ChangeTypeColumn.getChangeType((IAtsWorkItem)atsObject.getStoreObject(), atsApi);
        } else if (atsObject instanceof IAtsAction) {
            type = ChangeTypeColumn.getChangeType((IAtsAction)atsObject.getStoreObject(), atsApi);
        }
        return type;
    }

    public static void setChangeType(IAtsObject workItem, ChangeTypes changeType, IAtsChangeSet changes) {
        if (changeType == null || changeType == ChangeTypes.None) {
            changes.deleteAttributes(workItem, (AttributeTypeToken)AtsAttributeTypes.ChangeType);
        } else {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)changeType.name());
        }
    }
}

