/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.windows;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Processes;

public class Registry {
    public static final String HKEY_LOCAL_MACHINE = "HKLM";
    public static final String HKEY_CURRENT_USER = "HKCU";
    public static final String REG_SZ = "REG_SZ";
    public static final String REG_HELP_CMD = "reg /?";

    public static boolean isRegVersion(double lowerBound, double upperBound) {
        String regVersion;
        double foundVersion;
        boolean matched = false;
        String out = Processes.executeCommandToString(REG_HELP_CMD);
        Pattern pattern = Pattern.compile(".*version\\s(\\d*\\.\\d+).*", 32);
        Matcher matcher = pattern.matcher(out.toString());
        if (matcher.matches() && (foundVersion = Double.parseDouble(regVersion = matcher.group(1).trim())) >= lowerBound && foundVersion <= upperBound) {
            matched = true;
        }
        return matched;
    }

    public static RegVersion getVersion() {
        Registry r = new Registry();
        RegVersion regVersion = null;
        regVersion = Registry.isRegVersion(1.0, 1.99) ? r.new RegVersion_1_00() : r.new RegVersion_3_0();
        return regVersion;
    }

    public static String[] getValue(RegVersion version, String root, String path, String key) {
        String[] toReturn = null;
        String out = Processes.executeCommandToString(version.getQueryCmd(root, path, key));
        Pattern pattern = Pattern.compile(version.getQueryPattern(key), 32);
        Matcher matcher = pattern.matcher(out.toString());
        if (matcher.matches()) {
            toReturn = new String[matcher.groupCount()];
            int i = 1;
            while (i <= matcher.groupCount()) {
                toReturn[i - 1] = matcher.group(i).trim();
                ++i;
            }
        }
        if (toReturn != null) {
            String[] stringArray = toReturn;
            int n = toReturn.length;
            int n2 = 0;
            while (n2 < n) {
                String temp = stringArray[n2];
                System.out.println("VAL: " + temp);
                ++n2;
            }
        }
        return toReturn;
    }

    public static boolean prependRegistryValue(File updatedReg, String root, String path, String key, String value) {
        RegVersion version = Registry.getVersion();
        String[] regArray = Registry.getValue(version, root, path, key);
        if (regArray != null && regArray[1].contains(value)) {
            System.out.println("Value is already there.");
            return true;
        }
        String command = version.getUpdateCommand(root, path, key, value, regArray);
        if (version.isVersion().equals("1.00") && updatedReg.exists() && updatedReg.isFile()) {
            command = String.valueOf(updatedReg.getAbsolutePath()) + command.replaceAll("reg", "");
        }
        String out = Processes.executeCommandToString(command);
        System.out.println("The string: " + out);
        return !out.toString().contains("err:");
    }

    public static boolean prependRegistryValue(String root, String path, String key, String value) {
        RegVersion version = Registry.getVersion();
        String[] regArray = Registry.getValue(version, root, path, key);
        String out = Processes.executeCommandToString(version.getUpdateCommand(root, path, key, value, regArray));
        System.out.println("The string: " + out);
        return !out.toString().contains("err:");
    }

    public static void main(String[] args) {
        Registry.prependRegistryValue(HKEY_CURRENT_USER, "environment", "path", "HI THERE");
    }

    public static interface RegVersion {
        public String getQueryCmd(String var1, String var2, String var3);

        public String getQueryPattern(String var1);

        public String getUpdateCommand(String var1, String var2, String var3, String var4, String[] var5);

        public String isVersion();
    }

    public class RegVersion_1_00
    implements RegVersion {
        @Override
        public String getQueryCmd(String root, String path, String key) {
            return "reg query " + root + "\\" + path + "\\" + key;
        }

        @Override
        public String getQueryPattern(String key) {
            return "out:\\s*(\\w*)\\s*" + key + "\\s*(.*)";
        }

        @Override
        public String getUpdateCommand(String root, String path, String key, String value, String[] regArray) {
            String cmd = "";
            if (regArray != null) {
                value = String.valueOf(value) + File.pathSeparator + regArray[1];
                System.out.println("THE VALUE IS: " + value);
                cmd = "reg update \"" + root + "\\" + path + "\\" + key + "=" + value + "\"";
            } else {
                cmd = "reg add \"" + root + "\\" + path + "\\" + key + "=" + value + "\"";
            }
            System.out.println("THE CMD IS: " + cmd);
            return cmd;
        }

        @Override
        public String isVersion() {
            return "1.00";
        }
    }

    public class RegVersion_3_0
    implements RegVersion {
        @Override
        public String getQueryCmd(String root, String path, String key) {
            return "reg query " + root + "\\" + path + " /v " + key;
        }

        @Override
        public String getQueryPattern(String key) {
            return ".*?" + key + "\\s*(\\w*)\\s*(\\S*).*";
        }

        @Override
        public String getUpdateCommand(String root, String path, String key, String value, String[] regArray) {
            String type = Registry.REG_SZ;
            if (regArray != null) {
                value = String.valueOf(value) + File.pathSeparator + regArray[1];
                type = regArray[0];
            }
            return "reg add " + root + "\\" + path + " /v " + key + " /t " + type + " /f /d \"" + value + "\"";
        }

        @Override
        public String isVersion() {
            return "3.0";
        }
    }
}

