/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarLexer;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarParser;
import org.eclipse.osee.framework.core.publishing.PublishingTemplateInsertTokenType;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.regex.TokenMatcher;
import org.eclipse.osee.framework.jdk.core.util.regex.TokenPattern;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlEncoderDecoder;

public class WordCoreUtil {
    private static final Pattern ANNOTATIONS_REMOVAL_PATTERN = Pattern.compile("(?:<.??aml:annotation.*?>|<.??aml:content.*?>|<w:delText>.*?</w:delText>)");
    private static final Pattern APPENDIX_START_LETTER_PATTERN = Pattern.compile("<w:start w:val=\"1\"/><w:nfc w:val=\"3\"/><w:pStyle w:val=\"APPENDIX1\"/>");
    private static final String APPENDIX_START_LETTER_TEMPLATE_PART_A = "<w:start w:val=\"";
    private static final String APPENDIX_START_LETTER_TEMPLATE_PART_B = "\"/><w:nfc w:val=\"3\"/><w:pStyle w:val=\"APPENDIX1\"/>";
    private static final int APPENDIX_START_LETTER_TEMPLATE_SIZE = "<w:start w:val=\"".length() + "\"/><w:nfc w:val=\"3\"/><w:pStyle w:val=\"APPENDIX1\"/>".length();
    public static final String BIN_DATA = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAUAEcDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDuI/HV3L4l1XTJvEnhmwtrKK1aC5uYSRd+bEHZkzcKNoPTBbhhz3Ol478fWvhjR9TFhcW0us2awt9nmRmQeY4AViMDcU3sF3bsKWxgGix0bxLpfi3Xtahs9JnTVltSYnv5IzC0UW1hkQncMk4PHAHHOBleLPh/rWrz+Kv7Nu9PWHXls2b7TvDRtAcbPlBGCAG3c9Nu3ncPfhHBSxEPaWUEovdav3OZOyv/ADPXe2ljJ81nY0ta8fjw7N4nluxDdw6V9mWC2tYpRKryoSBM5GxVJxhlzgcHLEA9pBMtxBHMgcJIodRIhRgCM8qwBB9iARXAa98P9Q1l/G4W7tok11bI2pO4lWgAyHGOASAMjOAc44wen/4S/wAPwfub/XtGtryP5Z4P7QjPlyDhlycHg5HIB9hXHiKNGdOH1dXlpe3+GHS383N+vQpN31ObtPGOsap4k1fSrW40azvrG+8iHS7+OVJbqEYPmLKG/iUOwxG2BtzkHJ2bfxxp0/iHW9KeG5hGkrF5k0kD4kdyRtUbckk7Ao6yFjtBAycbxb4O1jxRJIj2+jRTx3Mb2OswySxXdrErBsbAp3sMvj94qkkHCkVY1Hwjrp1Xxbd6RqcNpJrltbiG4ywkt5Yl2bcAH5WXPzghlJ4U4zXTKGCqRV2otpddneN3dJ3VuZ6rmVnvoT7yNh/G3h+LTdQv5r14YdOZEu1mtpY5YS+Nm6NlD4bcMHGDz6GoLTxvY33i+Hw9BZ6gsslm90ZZ7OWELhgoG10Bwfm+Y4XIABJOBx0vww1N9D8WWNpBpOnJqy2KWlvDcSSRwiAjducxgktjOcEkk59a7WXw/dj4jW/iSGSF7ZtMbT54nYq6fvPMV1wCGyeCDtx1yelZ1KGAgpcsm3Z21W/LFrZd3Jb20GnNnR0UUV45oFFFFABRRRQAUUUUAFFFFABRRRQB/9k=";
    public static final String BIN_DATA_END = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAUAEcDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD1jUPE2oR+NF8NabpdtcTf2f8Ab2mubxoVC+YY9uFjck5wf886s2t6fYIE1XUNPsrpIFnmie6UCNSQu7LbSV3naGIGTjoeK5HxB4emufiUmsXXhn+29KGji1CYt32zecWztldei55H9761V17wjfal4hvL210VI7U+EpbCzjYxAwXLFgsYAbCkIxXI+XBIzivYWGwk1BOSj7t3qt+2r0+5fMzvJXO11/XrTQNMubmaSFrmO2muILV5gj3HlIXYLnk8DkgHGc1Pouo/2xoOnan5Xk/bLaO48vdu2b1DYzgZxnrivMdQ8E681ra7dJhvDJ4QXSHiedB5FyhVwWzweR8pXPzKMlR8w9H8MWc+neE9GsbqPy7m2sYIZUyDtdY1BGRweQelY4rD4elh04TUpX79PS44tt6mUnifVb3xVrWiaZpFlL/ZXkeZNc37Rb/NTeMKsT9MEdfSp/GHi+08J6Je3mIbq8tokm+w/aAkjRtKse/oSFy3XGMjFc3J4cdPH/iXU9T8Hf21Z332X7HJttZNuyLa/EsilcnHbnb9KyvG/gnXtSuvGH2HSYb4av8AYJrSUzovktCNjgbuQ+CfQbWb5s/KeylhcFOvTUpJRtBvXdvk5k3zabyb0VrNIlykkzstT8c2OhTa62rrDBaaZ5IieO6SWW5eRC2zyh8yNxxu6jLcAEjpoJ4rmCOeCVJYZVDxyRsGV1IyCCOCCO9eZeJfBeuas/xCW2tkA1ZbBrFnlUCYwgF165U5GBuwMkc45r02CRpYI5HheF3UM0UhBZCR907SRkdOCR7muHF0sPClCVJ+87X1/uQe3q5J+a6bFRbvqSUUUV55YUUUUAFZV54Y8P6jdPdX2h6Zc3MmN809pG7tgYGSRk8AD8KKKuFScHeDt6Ba5owQRW0EcEESRQxKEjjjUKqKBgAAcAAdqkooqG76sAooooAKKKKAP//Z";
    public static final String BOLD = "<w:b/>";
    private static final String BOOKMARK_TEMPLATE_PART_A = "<aml:annotation aml:id=\"";
    private static final String BOOKMARK_TEMPLATE_PART_B = "\" w:type=\"Word.Bookmark.Start\" w:name=\"OSEE.";
    private static final String BOOKMARK_TEMPLATE_PART_C = "\"/><aml:annotation aml:id=\"";
    private static final String BOOKMARK_TEMPLATE_PART_D = "\" w:type=\"Word.Bookmark.End\"/>";
    private static final int BOOKMARK_TEMPLATE_SIZE = "<aml:annotation aml:id=\"".length() + "\" w:type=\"Word.Bookmark.Start\" w:name=\"OSEE.".length() + "\"/><aml:annotation aml:id=\"".length() + "\" w:type=\"Word.Bookmark.End\"/>".length();
    private static final String CAPTION_TEMPLATE_PART_A = "<w:fldSimple w:instr=\" STYLEREF 1 \\s \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple><w:r><w:noBreakHyphen/></w:r><w:fldSimple w:instr=\" SEQ ";
    private static final String CAPTION_TEMPLATE_PART_B = " \\* ARABIC \\s 1 \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple>";
    private static final String CAPTION_TEMPLATE_PART_C = "<w:r><w:t>";
    private static final String CAPTION_TEMPLATE_PART_D = "</w:t></w:r>";
    private static final int CAPTION_TEMPLATE_SIZE = "<w:fldSimple w:instr=\" STYLEREF 1 \\s \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple><w:r><w:noBreakHyphen/></w:r><w:fldSimple w:instr=\" SEQ ".length() + " \\* ARABIC \\s 1 \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple>".length() + "<w:r><w:t>".length() + "</w:t></w:r>".length();
    public static final String CONFIGAPP = "configuration";
    public static final String CONFIGGRPAPP = "configurationgroup";
    private static final Pattern DATA_RIGHTS_NO_ARTIFACT_FOUND_REMOVAL_PATTERN = Pattern.compile("<w:p>[\\s||\\S]+?<w:r><w:t>NO DATA RIGHTS ARTIFACT FOUND</w:t></w:r>[\\s\\S]+?</w:p>");
    public static final String DEFAULT_FONT = "Times New Roman";
    public static final String DOCUMENT = "<w:wordDocument>";
    public static final String DOCUMENT_END = "</w:wordDocument>";
    public static final String FEATUREAPP = "feature";
    public static final String FILE_NAME = "fileName";
    private static final StringBuilder FOOTER_PAGE_SIZE = new StringBuilder("<w:type w:val=\"continuous\"/><w:pgSz w:w=\"12240\" w:h=\"15840\" w:code=\"1\"/>");
    private static final Pattern FOOTER_REMOVAL_PATTERN = Pattern.compile("<w:ftr[\\s\\S]+?</w:ftr>");
    public static final Pattern FOOTER_ENTIRE_EXTRA_PARA_REMOVAL_PATTERN = Pattern.compile("<w:p[^>]*><w:pPr>(<w:spacing w:after=\"[\\d]*\"[^>]*>)*(</w:spacing>)*<w:sectPr[^>]*>(<w:r><w:t>)?<w:ftr[^>]*>[\\s\\S]+</w:ftr>[\\s\\S]+</w:sectPr></w:pPr></w:p>");
    public static final Pattern FOOTER_ENTIRE_REMOVAL_PATTERN = Pattern.compile("<w:sectPr[^>]*><w:ftr[\\s\\S]+?</w:ftr>[\\s\\S]+?</w:sectPr>");
    private static final StringBuilder HARD_LINE_BREAK = new StringBuilder("<w:br/>");
    private static final String HYPERLINK_DOCUMENT_TEMPLATE_PART_A = "<w:p><w:hlink w:dest=\"";
    private static final String HYPERLINK_DOCUMENT_TEMPLATE_PART_B = "\"><w:r wsp:rsidRPr=\"00CE6681\"><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>";
    private static final String HYPERLINK_DOCUMENT_TEMPLATE_PART_C = "</w:t></w:r></w:hlink></w:p>";
    private static final int HYPERLINK_DOCUMENT_TEMPLATE_SIZE = "<w:p><w:hlink w:dest=\"".length() + "\"><w:r wsp:rsidRPr=\"00CE6681\"><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>".length() + "</w:t></w:r></w:hlink></w:p>".length();
    private static final String INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_PART_A = "<w:start w:val=\"(\\d*?)\"/><w:pStyle w:val=\"Heading";
    private static final String INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_PART_B = "\"/>";
    private static final int INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_SIZE = "<w:start w:val=\"(\\d*?)\"/><w:pStyle w:val=\"Heading".length() + "\"/>".length();
    private static final Pattern INSERT_HERE_TEST_PATTERN = Pattern.compile("INSERT_(ARTIFACT|LINK)_HERE", 42);
    private static final Pattern LINE_BREAKS_REMOVAL_PATTERN = Pattern.compile("\\v");
    private static final String LINK_INTERNAL_DOC_TEMPLATE_PART_A = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> HYPERLINK \\l \"OSEE.";
    private static final String LINK_INTERNAL_DOC_TEMPLATE_PART_B = "\" </w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>";
    private static final String LINK_INTERNAL_DOC_TEMPLATE_PART_C = "</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r>";
    private static final int LINK_INTERNAL_DOC_TEMPLATE_SIZE = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> HYPERLINK \\l \"OSEE.".length() + "\" </w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>".length() + "</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r>".length();
    private static final String LINK_TEMPLATE_PART_A = "<w:hlink w:dest=\"";
    private static final String LINK_TEMPLATE_PART_B = "\"><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>";
    private static final String LINK_TEMPLATE_PART_C = "</w:t></w:r></w:hlink>";
    private static final int LINK_TEMPLATE_SIZE = "<w:hlink w:dest=\"".length() + "\"><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>".length() + "</w:t></w:r></w:hlink>".length();
    public static final Pattern LIST_EMPTY_REMOVAL_PATTERN = Pattern.compile("<w:p wsp:rsidP=\"[^\"]*?\" wsp:rsidR=\"[^\"]*?\" wsp:rsidRDefault=\"[^\"]*?\"><w:pPr><w:pStyle w:val=\"[^\"]*?\"></w:pStyle><w:listPr><wx:t wx:val=\"([^>]*?)\"></wx:t><wx:font wx:val=\"[^\"]*?\"></wx:font></w:listPr></w:pPr><w:r><w:t></w:t></w:r></w:p>");
    public static final String LIST_PRESENTATION = "<w:listPr>";
    public static final String LIST_PRESENTATION_END = "</w:listPr>";
    public static final String LIST_NUMBER_FIELD_PARAGRAPH_PRESENTATION = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>";
    public static final String LIST_NUMBER_FIELD_RUN = "<w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>";
    public static final String LIST_NUMBER_FIELD = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>";
    public static final String LIST_NUMBER_FIELD_TAIL_REG_EXP = "<w:r(>| .*?>)<w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r(>| .*?>)<w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM \"listreset\"";
    public static final String MAX_TAG_OCCURENCE = "30";
    public static final String NO_PROOF = "<w:noProof/>";
    public static final String OSEE_BOOKMARK_REGEX = "^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>";
    public static final String OSEE_HYPERLINK_REGEX = "<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>";
    private static final String OSEE_LINK_MARKER_TEMPLATE_PART_A = "OSEE_LINK(";
    private static final String OSEE_LINK_MARKER_TEMPLATE_PART_B = ")";
    private static final int OSEE_LINK_MARKER_TEMPLATE_SIZE = "OSEE_LINK(".length() + ")".length();
    public static final int OUTLINE_LEVEL_MAXIMUM = 9;
    private static final StringBuilder PAGE_BREAK = new StringBuilder("<w:r><w:br w:type=\"page\"/></w:r>");
    public static final String PAGE_MARGINS = "<w:pgMar w:top=\"1440\" w:right=\"1296\" w:bottom=\"1440\" w:left=\"1296\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/>";
    private static final Pattern PAGE_NUMBER_TYPE_START_1_REMOVAL_PATTERN = Pattern.compile("<w:pgNumType [^>]*w:start=\"1\"/>");
    private static final Pattern PAGE_SIZE_REMOVAL_PATTERN = Pattern.compile("<w:pgSz [^>]*/>");
    public static final String PARAGRAPH = "<w:p>";
    public static final String PARAGRAPH_EMPTY = "<w:p/>";
    public static final String PARAGRAPH_END = "</w:p>";
    public static final String PARAGRAPH_PRESENTATION = "<w:pPr>";
    public static final String PARAGRAPH_PRESENTATION_END = "</w:pPr>";
    public static final String PARAGRAPH_STYLE_TEMPLATE_PART_A = "<w:pStyle w:val=\"";
    public static final String PARAGRAPH_STYLE_TEMPLATE_PART_B = "\"/>";
    public static final String PARAGRAPH_RUN_TEXT = "<w:p><w:r><w:t>";
    public static final String PARAGRAPH_RUN_TEXT_SPACE_PRESERVE = "<w:p><w:r><w:t xml:space=\"preserve\">";
    public static final String PARAGRAPH_RUN_TEXT_END = "</w:t></w:r></w:p>";
    private static final String PIC_TAG_DATA = "<w:r><w:pict><v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\" o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\"><v:stroke joinstyle=\"miter\"/><v:formulas><v:f eqn=\"if lineDrawn pixelLineWidth 0\"/><v:f eqn=\"sum @0 1 0\"/><v:f eqn=\"sum 0 0 @1\"/><v:f eqn=\"prod @2 1 2\"/><v:f eqn=\"prod @3 21600 pixelWidth\"/><v:f eqn=\"prod @3 21600 pixelHeight\"/><v:f eqn=\"sum @0 0 1\"/><v:f eqn=\"prod @6 1 2\"/><v:f eqn=\"prod @7 21600 pixelWidth\"/><v:f eqn=\"sum @8 21600 0\"/><v:f eqn=\"prod @7 21600 pixelHeight\"/><v:f eqn=\"sum @10 21600 0\"/></v:formulas><v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/><o:lock v:ext=\"edit\" aspectratio=\"t\"/></v:shapetype><w:binData w:name=\"wordml://%s\">%s</w:binData><v:shape id=\"_x0000_i1025\" type=\"#_x0000_t75\" style=\"width:53.25pt;height:15pt\"><v:imagedata src=\"wordml://%s\" o:title=\"%s\"/></v:shape></w:pict></w:r>";
    private static final String REFERENCE_INTERNAL_DOC_TEMPLATE_PART_A = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> REF OSEE.";
    private static final String REFERENCE_INTERNAL_DOC_TEMPLATE_PART_B = " \\h ";
    private static final String REFERENCE_INTERNAL_DOC_TEMPLATE_PART_C = "</w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>Sec#</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r><w:r><w:t> ";
    private static final String REFERENCE_INTERNAL_DOC_TEMPLATE_PART_D = "</w:t></w:r>";
    private static final int REFERENCE_INTERNAL_DOC_TEMPLATE_SIZE = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> REF OSEE.".length() + " \\h ".length() + "</w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>Sec#</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r><w:r><w:t> ".length() + "</w:t></w:r>".length();
    private static final Pattern REVIEW_COMMENT_TEST_PATTERN = Pattern.compile("<aml:annotation[^>]*w:type=\"Word.Comment.Start\"/?>(</aml:annotation>)?[\\s\\S]+?<aml:annotation[^>]*w:type=\"Word.Comment.End\"/?>(</aml:annotation>)?[\\s\\S]+?</aml:annotation></w:r>");
    public static final Pattern REVIEW_COMMENT_REMOVAL_PATTERN = Pattern.compile("<aml:annotation[^>]*w:type=\"Word.Comment.(?:Start|End)\"/?>(</aml:annotation>)?");
    public static final Pattern REVIEW_COMMENT_REFERENCE_REMOVAL_PATTERN = Pattern.compile("<w:r[^>]*><w:rPr><w:rStyle w:val=\"CommentReference\"/?>(</w:rStyle>)?</w:rPr><aml:annotation[^>]*w:type=\"Word.Comment\"[^>]*><aml:content>[\\s\\S]+?</aml:content></aml:annotation></w:r>");
    public static final Pattern RGB_HEX_COLOR_PATTERN = Pattern.compile("[0-9A-Fa-f]{6}");
    public static final String RGB_COLOR_RUN_TEMPLATE_PART_A = "<w:rPr><w:color w:val=\"";
    public static final String RGB_COLOR_RUN_TEMPLATE_PART_B = "\"/></w:rPr>";
    public static final int RGB_COLOR_RUN_TEMPLATE_SIZE = "<w:rPr><w:color w:val=\"".length() + "\"/></w:rPr>".length();
    public static final String RUN = "<w:r>";
    public static final String RUN_END = "</w:r>";
    public static final String RUN_PRESENTATION = "<w:rPr>";
    public static final String RUN_PRESENTATION_BOLD = "<w:rPr><w:b/></w:rPr>";
    public static final String RUN_PRESENTATION_END = "</w:rPr>";
    @Deprecated
    public static final String START_TABLE_ROW = "<w:tr wsp:rsidR=";
    public static final String SECTION = "<wx:sect>";
    private static final Pattern SECTION_EMPTY_BREAK_REMOVAL_PATTERN = Pattern.compile("<w:sectPr[^>]*>(<w:type[^>]*>(</w:type>)*)*<w:pgSz[^>]*>(</w:pgSz>)*<w:pgMar[^>]*>(</w:pgMar>)*<w:cols[^>]*>(</w:cols>)*</w:sectPr>");
    public static final String SECTION_END = "</wx:sect>";
    public static final String SECTION_PRESENTATION = "<w:sectPr>";
    public static final String SECTION_PRESENTATION_END = "</w:sectPr>";
    private static final String SUB_DOC = "<wx:sect><w:p><w:pPr><w:sectPr><w:pgSz w:w=\"12240\" w:h=\"15840\"/><w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/><w:cols w:space=\"720\"/><w:docGrid w:line-pitch=\"360\"/></w:sectPr></w:pPr></w:p><w:subDoc w:link=\"fileName\"/></wx:sect><wx:sect><wx:sub-section><w:p><w:pPr><w:pStyle w:val=\"Heading1\"/></w:pPr></w:p><w:sectPr><w:type w:val=\"continuous\"/><w:pgSz w:w=\"12240\" w:h=\"15840\"/><w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/><w:cols w:space=\"720\"/><w:docGrid w:line-pitch=\"360\"/></w:sectPr></wx:sub-section></wx:sect>";
    public static final String SUBSECTION = "<wx:sub-section>";
    public static final String SUBSECTION_END = "</wx:sub-section>";
    public static final String TABLE = "<w:tbl>";
    public static final String TABLE_END = "</w:tbl>";
    public static final String TABLE_COLUMN = "<w:tc>";
    public static final String TABLE_COLUMN_END = "</w:tc>";
    public static final String TABLE_ROW = "<w:tr>";
    public static final String TABLE_ROW_END = "</w:tr>";
    private static final Pattern TEST_FOR_LIST_PATTERN = Pattern.compile("<w:listPr>(<w:ilvl([^>]*?)/?>(</w:ilvl>)?)?(<w:ilfo([^>]*?)/?>(</w:ilfo>)?)?<wx:t wx:val=\"([^>]*?)\"/?>(</wx:t>)?<wx:font wx:val=\"[^\"]*?\"/?>(</wx:font>)?</w:listPr>");
    public static final String TEXT = "<w:t>";
    public static final String TEXT_SPACE_PRESERVE = "<w:t xml:space=\"preserve\">";
    public static final String TEXT_END = "</w:t>";
    private static final TokenPattern TOKEN_PATTERN_ADD_CHAPTER_NUM_TO_CAPTION_AND_BOOKMARK = TokenPattern.compile((Boolean)true, (String)" \"=rtsni:w elpmiSdlf:w<(.*?)(>[^<]*(?<=[ >]p:w)<)", (String)"SEQ (Figure|Table)", (String)" \\\\\\* ARABIC \">.*?</w:fldSimple>(.*?)(</w:p[^>]*?>)");
    private static final TokenPattern TOKEN_PATTERN_CHANGE_HYPERLINKS_TO_REFERENCES = TokenPattern.compile((Boolean)true, (String)"\\s*>[^<]*(?<=r:w)<\\s*>[^<]*(?<=r:w/)<\\s*>/\"nigeb\"\\s*=\\s*epyTrahCdlf:w\\s*rahCdlf:w<\\s*>[^<]*(?<=r:w)<", (String)"<w:instrText>\\s+HYPERLINK[^\"&]*(?:\"|&quot;)OSEE\\.([^\"&]*)(?:\"|&quot;)\\s+</w:instrText>", (String)".*?<w:fldChar\\s*w:fldCharType\\s*=\\s*\"separate\"\\s*/>.*?<w:rStyle\\s*w:val\\s*=\\s*\"Hyperlink\"\\s*/>(.*?)<w:fldChar\\s*w:fldCharType\\s*=\\s*\"end\"\\s*/>\\s*</w:r>");
    private static final TokenPattern TOKEN_PATTERN_PROCESS_PUBLISHING_TEMPLATE = TokenPattern.compile((Boolean)false, (String)"\\s*>[^<]*(?<=t:w)<\\s*>[^<]*(?<=r:w)<(?:\\s*>[^<]*(?<=rPp:w/)<.*?>[^<]*(?<=rPp:w)<)?\\s*>[^<]*(?<=p:w)<", (String)"INSERT_(ARTIFACT|LINK)_HERE", (String)"\\s*</w:t>\\s*</w:r>\\s*</w:p>");
    private static final Pattern WORD_ANNOTATIONS_REMOVAL_PATTERN = Pattern.compile("(?:<w:delText>|w:type\\s*=\\s*\"Word\\.(?:Insertion|Formatting|Deletion)\")");
    public static final String WORD_ML_TAGS = "(\\<[^>]*?>){0,30}";
    public static final String END = "E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?";
    public static final String ELSE = "E(\\<[^>]*?>){0,30}l(\\<[^>]*?>){0,30}s(\\<[^>]*?>){0,30}e ?";
    public static final String FEATURE = "F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e";
    public static final String CONFIG = "C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n";
    public static final String CONFIGGRP = "C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p";
    public static final String NOT = "N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t";
    public static final String ENDBRACKETS = "(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?";
    public static final String OPTIONAL_ENDBRACKETS = " ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?";
    public static final String BEGINFEATURE = "F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?";
    public static final String ENDFEATURE = "E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?";
    public static final String BEGINCONFIG = "C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?";
    public static final String ENDCONFIG = "E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?";
    public static final String BEGINCONFIGGRP = "C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?";
    public static final String ENDCONFIGGRP = "E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?";
    public static final String ELSE_EXP = "(F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n)(\\<[^>]*?>){0,30} (\\<[^>]*?>){0,30}E(\\<[^>]*?>){0,30}l(\\<[^>]*?>){0,30}s(\\<[^>]*?>){0,30}e ?";
    public static final Pattern ELSE_PATTERN = Pattern.compile("(F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n)(\\<[^>]*?>){0,30} (\\<[^>]*?>){0,30}E(\\<[^>]*?>){0,30}l(\\<[^>]*?>){0,30}s(\\<[^>]*?>){0,30}e ?", 40);
    public static final String BIN_DATA_STRING = "<w:binData.*?w:name=\"(.*?)\".*?</w:binData>";
    public static final Pattern BIN_DATA_PATTERN = Pattern.compile("<w:binData.*?w:name=\"(.*?)\".*?</w:binData>", 42);
    public static final Pattern IMG_SRC_PATTERN = Pattern.compile("<v:imagedata.*?src=\"([^\"]+)", 34);
    public static final Pattern FULL_PATTERN = Pattern.compile("(F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?)|(E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?)|(C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?)|(E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?)|(C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?)|(E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?)", 40);
    public static final int beginFeatureMatcherGroup = 1;
    public static final int beginConfigGroupMatcherGroup = 26;
    public static final int beginConfigMatcherGroup = 78;
    public static final int endFeatureMatcherGroup = 12;
    public static final int endConfigGroupMatcherGroup = 53;
    public static final int endConfigMatcherGroup = 100;
    public static final int endFeatureBracketMatcherGroup = 23;
    public static final int endConfigGroupBracketMatcherGroup = 75;
    public static final int endConfigBracketMatcherGroup = 117;

    public static CharSequence addChapterNumToCaptionAndBookmark(CharSequence input, CharSequence amlBookmarkStart, CharSequence amlBookmarkEnd) {
        CharSequence replacerText = WordCoreUtil.replacer(input, TOKEN_PATTERN_ADD_CHAPTER_NUM_TO_CAPTION_AND_BOOKMARK, (TokenMatcher tokenMatcher) -> {
            CharSequence paraStart = tokenMatcher.prefixGroupCharSequence(2);
            CharSequence preStyleRefTags = tokenMatcher.prefixGroupCharSequence(1);
            CharSequence seqType = tokenMatcher.coreTokenGroupCharSequence(1);
            CharSequence captionText = tokenMatcher.suffixGroupCharSequence(1);
            CharSequence paraEnd = tokenMatcher.suffixGroupCharSequence(2);
            captionText = XmlEncoderDecoder.xmlToText((CharSequence)captionText, (int)XmlEncoderDecoder.REMOVE_TAGS);
            StringBuilder newCaption = WordCoreUtil.getCaption(paraStart, amlBookmarkStart, preStyleRefTags, seqType, amlBookmarkEnd, captionText, paraEnd);
            return newCaption;
        });
        return replacerText;
    }

    public static boolean areApplicabilityTagsInvalid(String wordml, BranchId branch, HashCollection<String, String> validFeatureValues, Set<String> allValidConfigurations, Set<String> allValidConfigurationGroups) {
        Matcher matcher = FULL_PATTERN.matcher(wordml);
        Stack<ApplicabilityBlock> applicabilityBlocks = new Stack<ApplicabilityBlock>();
        int applicBlockCount = 0;
        while (matcher.find()) {
            String endConfigurationGroup;
            String beginFeature = matcher.group(1) != null ? WordCoreUtil.textOnly(matcher.group(1)) : null;
            String beginConfiguration = matcher.group(78) != null ? WordCoreUtil.textOnly(matcher.group(78)) : null;
            String beginConfigurationGroup = matcher.group(26) != null ? WordCoreUtil.textOnly(matcher.group(26)) : null;
            String endFeature = matcher.group(12) != null ? WordCoreUtil.textOnly(matcher.group(12)) : null;
            String endConfiguration = matcher.group(100) != null ? WordCoreUtil.textOnly(matcher.group(100)) : null;
            String string = endConfigurationGroup = matcher.group(53) != null ? WordCoreUtil.textOnly(matcher.group(53)) : null;
            if (beginFeature != null && beginFeature.toLowerCase().contains(FEATUREAPP)) {
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Feature, beginFeature));
                continue;
            }
            if (beginConfiguration != null && beginConfiguration.toLowerCase().contains(CONFIGAPP)) {
                if (!WordCoreUtil.isValidConfigurationBracket(beginConfiguration, allValidConfigurations)) continue;
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Configuration, beginConfiguration));
                continue;
            }
            if (beginConfigurationGroup != null && beginConfigurationGroup.toLowerCase().contains(CONFIGGRPAPP)) {
                if (!WordCoreUtil.isValidConfigurationGroupBracket(beginConfigurationGroup, allValidConfigurationGroups)) continue;
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.ConfigurationGroup, beginConfigurationGroup));
                continue;
            }
            if (endFeature != null && endFeature.toLowerCase().contains(FEATUREAPP)) {
                --applicBlockCount;
                if (applicabilityBlocks.isEmpty()) {
                    return true;
                }
                if (!WordCoreUtil.isInvalidFeatureBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher, branch, validFeatureValues)) continue;
                return true;
            }
            if (endConfiguration != null && endConfiguration.toLowerCase().contains(CONFIGAPP)) {
                --applicBlockCount;
                if (applicabilityBlocks.isEmpty()) {
                    return true;
                }
                if (!WordCoreUtil.isInvalidConfigurationBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher)) continue;
                return true;
            }
            if (endConfigurationGroup == null || !endConfigurationGroup.toLowerCase().contains(CONFIGGRPAPP)) continue;
            --applicBlockCount;
            if (applicabilityBlocks.isEmpty()) {
                return true;
            }
            if (!WordCoreUtil.isInvalidConfigurationGroupBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher)) continue;
            return true;
        }
        return applicBlockCount != 0;
    }

    public static CharSequence changeHyperlinksToReferences(CharSequence input, Set<String> headerGuids) {
        CharSequence replacerText = WordCoreUtil.replacer(input, TOKEN_PATTERN_CHANGE_HYPERLINKS_TO_REFERENCES, (TokenMatcher tokenMatcher) -> {
            CharSequence identifier = tokenMatcher.coreTokenGroupCharSequence(1);
            CharSequence text = tokenMatcher.suffixGroupCharSequence(1);
            CharSequence regularText = XmlEncoderDecoder.xmlToText((CharSequence)text, (int)XmlEncoderDecoder.REMOVE_TAGS);
            CharSequence xmlText = XmlEncoderDecoder.textToXml((CharSequence)regularText);
            boolean isHeader = headerGuids.contains(identifier);
            StringBuilder newText = WordCoreUtil.getWordMlReference(identifier, isHeader, xmlText);
            return newText;
        });
        return replacerText;
    }

    private static CharSequence cleaner(CharSequence input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        ChangeSet changeSet = new ChangeSet(input);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            changeSet.delete(start, end);
        }
        if (!changeSet.hasChanges()) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (StringWriter stringWriter = new StringWriter(input.length());){
                changeSet.applyChanges((Writer)stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return input;
        }
    }

    private static CharSequence cleaner(CharSequence input, Pattern ... patterns) {
        CharSequence output = input;
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            output = WordCoreUtil.cleaner(output, pattern);
            ++n2;
        }
        return output;
    }

    public static CharSequence cleanupFooter(CharSequence input) {
        CharSequence noFooterText = WordCoreUtil.cleaner(input, FOOTER_REMOVAL_PATTERN);
        CharSequence newFooterText = WordCoreUtil.replacer(noFooterText, PAGE_SIZE_REMOVAL_PATTERN, (Matcher matcher) -> FOOTER_PAGE_SIZE);
        return newFooterText;
    }

    public static CharSequence cleanupPageNumberTypeStart1(CharSequence input) {
        CharSequence noPageText = WordCoreUtil.cleaner(input, PAGE_NUMBER_TYPE_START_1_REMOVAL_PATTERN);
        return noPageText;
    }

    private static boolean containsIgnoreCase(Collection<String> validValues, String val) {
        for (String validValue : validValues) {
            if (!validValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLists(CharSequence input) {
        return TEST_FOR_LIST_PATTERN.matcher(input).find();
    }

    public static boolean containsWordAnnotations(CharSequence input) {
        return WORD_ANNOTATIONS_REMOVAL_PATTERN.matcher(input).find();
    }

    private static ApplicabilityBlock createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicType, String beginExpression) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock(applicType);
        beginExpression = beginExpression.replace(" [", "[");
        beginApplic.setApplicabilityExpression(beginExpression);
        return beginApplic;
    }

    private static StringBuilder getAppendixStart(char appendixLetter) {
        int appendixNumber = Character.toLowerCase(appendixLetter) - 97 + 1;
        int size = APPENDIX_START_LETTER_TEMPLATE_SIZE + 1;
        StringBuilder output = new StringBuilder(size).append(APPENDIX_START_LETTER_TEMPLATE_PART_A).append(appendixNumber).append(APPENDIX_START_LETTER_TEMPLATE_PART_B);
        return output;
    }

    private static StringBuilder getCaption(CharSequence paragraphStart, CharSequence amlBookmarkStart, CharSequence preStyleRefTags, CharSequence sequenceType, CharSequence amlBookmarkEnd, CharSequence captionText, CharSequence paragraphEnd) {
        CharSequence xmlEscapedCaptionText = XmlEncoderDecoder.textToXml((CharSequence)captionText);
        int size = CAPTION_TEMPLATE_SIZE + paragraphStart.length() + amlBookmarkStart.length() + preStyleRefTags.length() + sequenceType.length() + amlBookmarkEnd.length() + xmlEscapedCaptionText.length() + paragraphEnd.length();
        StringBuilder output = new StringBuilder(2 * size).append(paragraphStart).append(amlBookmarkStart).append(preStyleRefTags).append(CAPTION_TEMPLATE_PART_A).append(sequenceType).append(CAPTION_TEMPLATE_PART_B).append(amlBookmarkEnd).append(CAPTION_TEMPLATE_PART_C).append(xmlEscapedCaptionText).append("</w:t></w:r>").append(paragraphEnd);
        return output;
    }

    private static String getEditImage(boolean isStart, String guid) {
        String imageId = String.format("%s_%s", guid, isStart ? "START.jpg" : "END.jpg");
        String imageData = isStart ? BIN_DATA : BIN_DATA_END;
        return String.format(PIC_TAG_DATA, imageId, imageData, imageId, guid);
    }

    public static String getEndEditImage(String guid) {
        return WordCoreUtil.getEditImage(false, guid);
    }

    public static StringBuilder getHyperlinkDocument(CharSequence filename) {
        if (Objects.isNull(filename) || filename.length() == 0) {
            throw new IllegalArgumentException("The file name can not be null or empty.");
        }
        int size = HYPERLINK_DOCUMENT_TEMPLATE_SIZE + filename.length();
        StringBuilder output = new StringBuilder(size * 2).append(HYPERLINK_DOCUMENT_TEMPLATE_PART_A).append(filename).append(HYPERLINK_DOCUMENT_TEMPLATE_PART_B).append(filename).append(HYPERLINK_DOCUMENT_TEMPLATE_PART_C);
        return output;
    }

    public static PublishingTemplateInsertTokenType getInsertHereTokenType(CharSequence templateContent) {
        Matcher matcher = INSERT_HERE_TEST_PATTERN.matcher(templateContent);
        if (matcher.find()) {
            return PublishingTemplateInsertTokenType.parse(matcher.group(1));
        }
        return PublishingTemplateInsertTokenType.NONE;
    }

    public static StringBuilder getLink(LinkType destLinkType, CharSequence linkId, CharSequence linkText) {
        int parametersSize = linkId.length() + linkText.length();
        StringBuilder output = LinkType.OSEE_SERVER_LINK.equals((Object)destLinkType) ? new StringBuilder((LINK_TEMPLATE_SIZE + parametersSize) * 2).append(LINK_TEMPLATE_PART_A).append(linkId).append(LINK_TEMPLATE_PART_B).append(linkText).append(LINK_TEMPLATE_PART_C) : new StringBuilder((LINK_INTERNAL_DOC_TEMPLATE_SIZE + parametersSize) * 2).append(LINK_INTERNAL_DOC_TEMPLATE_PART_A).append(linkId).append(LINK_INTERNAL_DOC_TEMPLATE_PART_B).append(linkText).append(LINK_INTERNAL_DOC_TEMPLATE_PART_C);
        return output;
    }

    public static StringBuilder getOseeLinkMarker(CharSequence guid) {
        int size = OSEE_LINK_MARKER_TEMPLATE_SIZE + guid.length();
        StringBuilder output = new StringBuilder(size * 2).append(OSEE_LINK_MARKER_TEMPLATE_PART_A).append(guid).append(OSEE_LINK_MARKER_TEMPLATE_PART_B);
        return output;
    }

    public static StringBuilder getRunPresentationWithRgbHexColor(CharSequence rgbHexColor) {
        if (Objects.isNull(rgbHexColor)) {
            throw new IllegalArgumentException("rgbHexColor can not be null.");
        }
        if (rgbHexColor.length() != 6 || !RGB_HEX_COLOR_PATTERN.matcher(rgbHexColor).lookingAt()) {
            throw new IllegalArgumentException("rgbHexColor should be a hex string 6 characters long.");
        }
        int size = RGB_COLOR_RUN_TEMPLATE_SIZE + 6;
        StringBuilder output = new StringBuilder(size * 2).append(RGB_COLOR_RUN_TEMPLATE_PART_A).append(rgbHexColor).append(RGB_COLOR_RUN_TEMPLATE_PART_B);
        return output;
    }

    public static StringBuilder getUnknownArtifactLink(CharSequence guid, BranchId branch) {
        String message = String.format("Invalid Link: artifact with guid:[%s] on branchUuid:[%s] does not exist", guid, branch);
        String internalLink = String.format("http://none/%s?guid=%s&amp;branchUuid=%s", "unknown", guid, branch);
        StringBuilder artifactLink = WordCoreUtil.getLink(LinkType.OSEE_SERVER_LINK, internalLink, message);
        return artifactLink;
    }

    public static String getStartEditImage(String guid) {
        return WordCoreUtil.getEditImage(true, guid);
    }

    public static StringBuilder getWordMlBookmark(Long uuid) {
        int size = BOOKMARK_TEMPLATE_SIZE + 1 + 19 + 1;
        StringBuilder output = new StringBuilder(size * 2).append(BOOKMARK_TEMPLATE_PART_A).append("0").append(BOOKMARK_TEMPLATE_PART_B).append(uuid).append(BOOKMARK_TEMPLATE_PART_C).append("0").append(BOOKMARK_TEMPLATE_PART_D);
        return output;
    }

    private static StringBuilder getWordMlReference(CharSequence linkId, boolean addParagraphNumber, CharSequence linkText) {
        String paragraphNumSwitch = addParagraphNumber ? "\\n " : "";
        CharSequence xmlEscapedLinkText = XmlEncoderDecoder.textToXml((CharSequence)linkText);
        int size = REFERENCE_INTERNAL_DOC_TEMPLATE_SIZE + linkId.length() + paragraphNumSwitch.length() + xmlEscapedLinkText.length();
        StringBuilder output = new StringBuilder(size * 2).append(REFERENCE_INTERNAL_DOC_TEMPLATE_PART_A).append(linkId).append(REFERENCE_INTERNAL_DOC_TEMPLATE_PART_B).append(paragraphNumSwitch).append(REFERENCE_INTERNAL_DOC_TEMPLATE_PART_C).append(xmlEscapedLinkText).append("</w:t></w:r>");
        return output;
    }

    public static CharSequence initializePublishingTemplateOutliningNumbers(String outlineNumber, CharSequence template, String outlineType) {
        boolean appendixOutlineType;
        if (Objects.isNull(outlineNumber)) {
            return template;
        }
        boolean bl = appendixOutlineType = Objects.nonNull(outlineType) && outlineType.equalsIgnoreCase("APPENDIX");
        if (appendixOutlineType) {
            char[] chars = outlineNumber.toCharArray();
            template = WordCoreUtil.setAppendixStartLetter(chars[0], template);
            return template;
        }
        String[] outlineNumbers = outlineNumber.split("\\.");
        if (outlineNumbers.length > 9) {
            outlineNumbers = Arrays.copyOf(outlineNumbers, 9);
        }
        template = WordCoreUtil.setHeadingNumbers(outlineNumbers, template);
        return template;
    }

    public static boolean isExpressionInvalid(String expression, BranchId branch, HashCollection<String, String> validFeatureValues) {
        ApplicabilityGrammarLexer lex = new ApplicabilityGrammarLexer((CharStream)new ANTLRStringStream(expression.toUpperCase()));
        ApplicabilityGrammarParser parser = new ApplicabilityGrammarParser((TokenStream)new CommonTokenStream((TokenSource)lex));
        try {
            parser.start();
        }
        catch (RecognitionException recognitionException) {
            return true;
        }
        HashMap<String, List<String>> featureIdValuesMap = parser.getIdValuesMap();
        if (featureIdValuesMap.isEmpty()) {
            return true;
        }
        for (String featureId : featureIdValuesMap.keySet()) {
            if (validFeatureValues.containsKey((Object)(featureId = featureId.trim()).toUpperCase())) {
                List<String> values = featureIdValuesMap.get(featureId);
                if (values.contains("Default")) continue;
                Collection validValues = validFeatureValues.getValues((Object)featureId.toUpperCase());
                for (String val : values) {
                    if ((val = val.trim()).equals("(") || val.equals(OSEE_LINK_MARKER_TEMPLATE_PART_B) || val.equals("|") || val.equals("&") || WordCoreUtil.containsIgnoreCase(validValues, val)) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean isInvalidConfigurationBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher) {
        return applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.Configuration;
    }

    private static boolean isInvalidConfigurationGroupBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher) {
        return applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.ConfigurationGroup;
    }

    private static boolean isInvalidFeatureBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher, BranchId branch, HashCollection<String, String> validFeatureValues) {
        if (applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.Feature) {
            return true;
        }
        String applicabilityExpression = applicabilityBlock.getApplicabilityExpression();
        return WordCoreUtil.isExpressionInvalid(applicabilityExpression, branch, validFeatureValues);
    }

    private static boolean isValidConfigurationBracket(String beginConfig, Set<String> allValidConfigurations) {
        String[] configs;
        beginConfig = WordCoreUtil.textOnly(beginConfig);
        int start = beginConfig.indexOf("[") + 1;
        int end = beginConfig.indexOf("]");
        String applicExpText = beginConfig.substring(start, end);
        String[] stringArray = configs = applicExpText.split("&|\\|");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            String configKey = config.split("=")[0].trim().toUpperCase();
            if (!allValidConfigurations.contains(configKey)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidConfigurationGroupBracket(String beginConfigGroup, Set<String> allValidConfigurationGroups) {
        String[] configs;
        beginConfigGroup = WordCoreUtil.textOnly(beginConfigGroup);
        int start = beginConfigGroup.indexOf("[") + 1;
        int end = beginConfigGroup.indexOf("]");
        String applicExpText = beginConfigGroup.substring(start, end);
        String[] stringArray = configs = applicExpText.split("&|\\|");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            String configKey = config.split("=")[0].trim().toUpperCase();
            if (!allValidConfigurationGroups.contains(configKey)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void processPublishingTemplate(CharSequence templateContent, Consumer<CharSequence> segmentProcessor, Consumer<CharSequence> tailProcessor) {
        TokenMatcher tokenMatcher = TOKEN_PATTERN_PROCESS_PUBLISHING_TEMPLATE.tokenMatcher(templateContent);
        int lastEndIndex = 0;
        while (tokenMatcher.find()) {
            int tokenStart = tokenMatcher.start();
            int tokenEnd = tokenMatcher.end();
            CharSequence segment = templateContent.subSequence(lastEndIndex, tokenStart);
            lastEndIndex = tokenEnd;
            segmentProcessor.accept(segment);
        }
        CharSequence tail = templateContent.subSequence(lastEndIndex, templateContent.length());
        tailProcessor.accept(tail);
    }

    public static CharSequence removeAnnotations(CharSequence input) {
        CharSequence newText = WordCoreUtil.cleaner(input, ANNOTATIONS_REMOVAL_PATTERN);
        return newText;
    }

    public static CharSequence removeEmptyLists(CharSequence input) {
        CharSequence newText = WordCoreUtil.cleaner(input, LIST_EMPTY_REMOVAL_PATTERN);
        return newText;
    }

    public static CharSequence removeFootersAndNoDataRightsStatements(CharSequence input) {
        CharSequence newText = WordCoreUtil.cleaner(input, FOOTER_ENTIRE_EXTRA_PARA_REMOVAL_PATTERN, FOOTER_ENTIRE_REMOVAL_PATTERN, DATA_RIGHTS_NO_ARTIFACT_FOUND_REMOVAL_PATTERN);
        return newText;
    }

    public static CharSequence removeReviewComments(CharSequence input) {
        Matcher reviewCommentMatcher = REVIEW_COMMENT_TEST_PATTERN.matcher(input);
        if (!reviewCommentMatcher.find()) {
            return input;
        }
        CharSequence noCommentStartOrEndText = WordCoreUtil.cleaner(input, REVIEW_COMMENT_REMOVAL_PATTERN);
        CharSequence noReviewCommentText = WordCoreUtil.cleaner(noCommentStartOrEndText, REVIEW_COMMENT_REFERENCE_REMOVAL_PATTERN);
        return noReviewCommentText;
    }

    private static CharSequence replacer(CharSequence input, Pattern pattern, Function<Matcher, StringBuilder> newTextFunction) {
        Matcher matcher = pattern.matcher(input);
        ChangeSet changeSet = new ChangeSet(input);
        while (matcher.find()) {
            int tokenStart = matcher.start();
            int tokenEnd = matcher.end();
            StringBuilder newText = newTextFunction.apply(matcher);
            changeSet.replace(tokenStart, tokenEnd, newText);
        }
        if (!changeSet.hasChanges()) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (StringWriter stringWriter = new StringWriter(input.length() * 2);){
                changeSet.applyChanges((Writer)stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return input;
        }
    }

    private static CharSequence replacer(CharSequence input, Supplier<Pattern> patternFunction, BiFunction<Matcher, ChangeSet, Boolean> newTextFunction) {
        ChangeSet changeSet = new ChangeSet(input);
        boolean done = false;
        int start = 0;
        while (!done) {
            Matcher matcher = patternFunction.get().matcher(input);
            if (!matcher.find(start)) break;
            start = matcher.end();
            done = newTextFunction.apply(matcher, changeSet);
        }
        if (!changeSet.hasChanges()) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (StringWriter stringWriter = new StringWriter(input.length() * 2);){
                changeSet.applyChanges((Writer)stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return input;
        }
    }

    private static CharSequence replacer(CharSequence input, TokenPattern tokenPattern, Function<TokenMatcher, StringBuilder> newTextFunction) {
        TokenMatcher tokenMatcher = tokenPattern.tokenMatcher(input);
        ChangeSet changeSet = new ChangeSet(input);
        while (tokenMatcher.find()) {
            int tokenStart = tokenMatcher.start();
            int tokenEnd = tokenMatcher.end();
            StringBuilder newText = newTextFunction.apply(tokenMatcher);
            changeSet.replace(tokenStart, tokenEnd, newText);
        }
        if (!changeSet.hasChanges()) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (StringWriter stringWriter = new StringWriter(input.length() * 2);){
                changeSet.applyChanges((Writer)stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static CharSequence replaceEmptySectionBreaksWithPageBreaks(CharSequence input) {
        CharSequence output = WordCoreUtil.replacer(input, SECTION_EMPTY_BREAK_REMOVAL_PATTERN, (Matcher matcher) -> PAGE_BREAK);
        return output;
    }

    public static CharSequence replaceVerticalWhitespaceCharactersWithWordMlHardLineBreaks(CharSequence input) {
        CharSequence output = WordCoreUtil.replacer(input, LINE_BREAKS_REMOVAL_PATTERN, (Matcher matcher) -> HARD_LINE_BREAK);
        return output;
    }

    public static CharSequence setAppendixStartLetter(char appendixLetter, CharSequence input) {
        CharSequence output = WordCoreUtil.replacer(input, APPENDIX_START_LETTER_PATTERN, (Matcher matcher) -> {
            StringBuilder newText = WordCoreUtil.getAppendixStart(appendixLetter);
            return newText;
        });
        return output;
    }

    public static CharSequence setHeadingNumbers(String[] outlineNumbers, CharSequence template) {
        Integer[] indexArray = new Integer[]{0};
        int size = INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_SIZE + 1;
        StringBuilder searchStringBuilder = new StringBuilder(size * 2).append(INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_PART_A);
        return WordCoreUtil.replacer(template, () -> {
            Integer index = indexArray[0];
            int headingNumber = index + 1;
            searchStringBuilder.setLength(INITIAL_HEADING_NUMBER_REGEX_TEMPLATE_PART_A.length());
            searchStringBuilder.append(headingNumber).append("\"/>");
            return Pattern.compile(searchStringBuilder.toString());
        }, (Matcher matcher, ChangeSet changeSet) -> {
            Integer index = indexArray[0];
            int start = matcher.start(1);
            int end = matcher.end(1);
            changeSet.replace(start, end, outlineNumbers[index].toCharArray());
            integerArray[0] = index = Integer.valueOf(index + 1);
            if (index >= outlineNumbers.length) {
                return true;
            }
            return false;
        });
    }

    @Deprecated
    public static String textOnly(String str) {
        return XmlEncoderDecoder.xmlToText((CharSequence)str, (int)XmlEncoderDecoder.REMOVE_TAGS).toString();
    }

    public static enum pageType {
        LANDSCAPE("<w:pgSz w:w=\"15840\" w:h=\"12240\" w:orient=\"landscape\" w:code=\"1\" />"),
        PORTRAIT("<w:pgSz w:w=\"12240\" w:h=\"15840\" w:code=\"1\" />");

        private static final String marginsAndColumns = "<w:pgMar w:top=\"1440\" w:right=\"1440\" w:bottom=\"1440\" w:left=\"1440\" w:header=\"432\" w:footer=\"432\" w:gutter=\"0\"/><w:cols w:space=\"720\"/>";
        private static final String newPagePrefix = "<w:p><w:pPr><w:spacing w:after=\"0\"/>";
        private static final String newPageSuffix = "</w:pPr></w:p>";
        private static final int newPageTemplateSize;
        private final String pageSizeWordMl;
        private final String pageSizeWithMarginsAndColumnsWordMl;

        static {
            newPageTemplateSize = WordCoreUtil.SECTION_PRESENTATION.length() + marginsAndColumns.length() + newPagePrefix.length() + newPageSuffix.length() + WordCoreUtil.SECTION_PRESENTATION_END.length();
        }

        private pageType(String pageSizeWordMl) {
            this.pageSizeWordMl = pageSizeWordMl;
            this.pageSizeWithMarginsAndColumnsWordMl = pageSizeWordMl.concat(marginsAndColumns);
        }

        public String getPageSize() {
            return this.pageSizeWordMl;
        }

        public String getPageSizeWithMarginsAndColumns() {
            return this.pageSizeWithMarginsAndColumnsWordMl;
        }

        private void getSection(CharSequence sectionPresentationWordMl, StringBuilder output) {
            output.append(WordCoreUtil.SECTION_PRESENTATION).append(sectionPresentationWordMl).append(this.pageSizeWithMarginsAndColumnsWordMl).append(WordCoreUtil.SECTION_PRESENTATION_END);
        }

        public StringBuilder getSection(CharSequence sectionPresentationWordMl) {
            int size = this.pageSizeWithMarginsAndColumnsWordMl.length() + sectionPresentationWordMl.length();
            StringBuilder output = new StringBuilder(size * 2);
            this.getSection(sectionPresentationWordMl, output);
            return output;
        }

        public StringBuilder getNewPage(CharSequence sectionPresentationWordMl) {
            int size = newPageTemplateSize + sectionPresentationWordMl.length();
            StringBuilder output = new StringBuilder(size * 2);
            output.append(newPagePrefix);
            this.getSection(sectionPresentationWordMl, output);
            output.append(newPageSuffix);
            return output;
        }

        public boolean isPortrait() {
            return this == PORTRAIT;
        }

        public boolean isLandscape() {
            return this == LANDSCAPE;
        }

        public static pageType fromString(String value) {
            return LANDSCAPE.name().equalsIgnoreCase(value) ? LANDSCAPE : PORTRAIT;
        }

        public static pageType getDefault() {
            return PORTRAIT;
        }
    }

    public static enum tablePresentation {
        WIDTH_AUTO_BORDER_SINGLE_JUSTIFIED_LEFT("<w:tblPr><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblBorders><w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/></w:tblBorders></w:tblPr>"),
        WIDTH_5_694_BORDER_NONE_JUSTIFIED_CENTER("<w:tblPr><w:tblW w:w=\"8200\" w:type=\"dxa\"/><w:jc w:val=\"center\"/></w:tblPr>");

        private final String tablePresentationWordMl;

        private tablePresentation(String tablePresentationWordMl) {
            this.tablePresentationWordMl = tablePresentationWordMl;
        }

        public String get() {
            return this.tablePresentationWordMl;
        }
    }
}

