/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.MimAttributeQueryElement;
import org.eclipse.osee.mim.types.MimRelatedArtifact;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ArtifactAccessorImpl<T extends PLGenericDBObject>
implements ArtifactAccessor<T> {
    private ArtifactTypeToken artifactType = ArtifactTypeToken.SENTINEL;
    private final OrcsApi orcsApi;

    private Class<T> getType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public ArtifactAccessorImpl(ArtifactTypeToken artifactType, OrcsApi orcsApi) {
        this.setArtifactType(artifactType);
        this.orcsApi = orcsApi;
    }

    @Override
    public T get(BranchId branch, ArtifactId artId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.get(branch, artId, new LinkedList<RelationTypeSide>());
    }

    @Override
    public Collection<T> getAll(BranchId branch, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, new LinkedList<RelationTypeSide>(), clazz);
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelation(branch, artId, relation, relatedId, new LinkedList<RelationTypeSide>(), clazz);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, new LinkedList<RelationTypeSide>(), clazz);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, new LinkedList<RelationTypeSide>(), clazz);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>(), clazz);
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelationWithoutId(branch, relation, relatedId, new LinkedList<RelationTypeSide>(), clazz);
    }

    private boolean hasSetApplic(Class<?> type) {
        return this.getSetApplic(type) != null;
    }

    private Method getSetApplic(Class<?> type) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType()) && method.getName().endsWith("Applicability")) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), false, clazz);
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelation(branch, artId, relation, relatedId, followRelations);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, followRelations);
    }

    @Override
    public T get(BranchId branch, ArtifactId artId, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.get(branch, artId, followRelations);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, followRelations);
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelationWithoutId(branch, relation, relatedId, followRelations);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Collection<RelationTypeSide> followRelations, boolean isExact, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, followRelations, isExact);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, boolean isExact, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), isExact, clazz);
    }

    private Collection<T> fetchCollection(QueryBuilder query, BranchId branch) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<PLGenericDBObject> artifactList = new LinkedList<PLGenericDBObject>();
        for (ArtifactReadable artifact : query.asArtifacts()) {
            if (!artifact.isValid()) continue;
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)this.getType().getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.getSetApplic(this.getType()) != null && !query.areApplicabilityTokensIncluded()) {
                this.getSetApplic(this.getType()).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    private T fetchSingle(QueryBuilder query, BranchId branch) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = query.asArtifactOrSentinel();
        if (artifact.isValid()) {
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)this.getType().getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.getSetApplic(this.getType()) != null && !query.areApplicabilityTokensIncluded()) {
                this.getSetApplic(this.getType()).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            return (T)((Object)returnObj);
        }
        return (T)((Object)((PLGenericDBObject)((Object)this.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))));
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId, Collection<RelationTypeSide> relations) throws IllegalArgumentException, SecurityException {
        LinkedList<ArtifactMatch> artifactList = new LinkedList<ArtifactMatch>();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch);
        for (RelationTypeSide relation : relations) {
            query = query.andRelatedTo(relation, relatedId);
        }
        for (ArtifactReadable artifact : query.asArtifacts()) {
            if (!artifact.isValid()) continue;
            artifactList.add(new ArtifactMatch(artifact));
        }
        return artifactList;
    }

    @Override
    public T get(BranchId branch, ArtifactId artId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.get(branch, artId, new LinkedList<RelationTypeSide>());
    }

    @Override
    public T get(BranchId branch, ArtifactId artId, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andId(artId);
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchSingle(query, branch);
    }

    @Override
    public Collection<T> getAll(BranchId branch) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, new LinkedList<RelationTypeSide>());
    }

    @Override
    public Collection<T> getAll(BranchId branch, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, new LinkedList<RelationTypeSide>(), "", new LinkedList<AttributeTypeId>(), 0L, 0L, AttributeTypeId.SENTINEL, viewId);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, 0L, 0L);
    }

    @Override
    public Collection<T> getAll(BranchId branch, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, new LinkedList<RelationTypeSide>(), pageCount, pageSize);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, pageCount, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<T> getAll(BranchId branch, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAll(BranchId branch, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, new LinkedList<RelationTypeSide>(), pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, "", new LinkedList<AttributeTypeId>(), pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, "", new LinkedList<AttributeTypeId>(), pageCount, pageSize, orderByAttribute, viewId);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAll(branch, followRelations, filter, attributes, pageCount, pageSize, orderByAttribute, ArtifactId.SENTINEL);
    }

    @Override
    public Collection<T> getAll(BranchId branch, Collection<RelationTypeSide> followRelations, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize, AttributeTypeId orderByAttribute, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch, viewId).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType});
        if (Strings.isValid((String)filter)) {
            query = query.and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
        }
        if (orderByAttribute != null && orderByAttribute.isValid()) {
            query = query.setOrderByAttribute(orderByAttribute);
        }
        if (pageCount != 0L && pageSize != 0L) {
            query = query.isOnPage(pageCount, pageSize);
        }
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchCollection(query, branch);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, new LinkedList<RelationTypeSide>());
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, 0L, 0L);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, new LinkedList<RelationTypeSide>(), pageCount, pageSize);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, followRelations, pageCount, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, new LinkedList<RelationTypeSide>(), orderByAttribute);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, followRelations, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByFilter(branch, filter, attributes, new LinkedList<RelationTypeSide>(), pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType}).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
        if (orderByAttribute != null && orderByAttribute.isValid()) {
            query = query.setOrderByAttribute(orderByAttribute);
        }
        if (pageCount != 0L && pageSize != 0L) {
            query = query.isOnPage(pageCount, pageSize);
        }
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchCollection(query, branch);
    }

    @Override
    public int getAllByFilterAndCount(BranchId branch, String filter, Collection<AttributeTypeId> attributes) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType});
        if (Strings.isValid((String)filter)) {
            query = query.and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
        }
        return query.getCount();
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelationWithoutId(branch, relation, relatedId, new LinkedList<RelationTypeSide>());
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andRelatedTo(relation, relatedId);
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchSingle(query, branch);
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelation(branch, artId, relation, relatedId, new LinkedList<RelationTypeSide>());
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getByRelation(branch, artId, relation, relatedId, followRelations, ArtifactId.SENTINEL);
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch, viewId).includeApplicabilityTokens().andRelatedTo(relation, relatedId).andId(artId);
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchSingle(query, branch);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, new LinkedList<RelationTypeSide>());
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, followRelations, 0L, 0L);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, new LinkedList<RelationTypeSide>(), pageCount, pageSize);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, followRelations, pageCount, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, new LinkedList<RelationTypeSide>(), orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, followRelations, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, new LinkedList<RelationTypeSide>(), pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, "", new LinkedList<AttributeTypeId>(), followRelations, pageCount, pageSize, orderByAttribute, new LinkedList<AttributeTypeId>(), ArtifactId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelation(branch, relation, relatedId, "", new LinkedList<AttributeTypeId>(), followRelations, pageCount, pageSize, orderByAttribute, new LinkedList<AttributeTypeId>(), viewId);
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute, Collection<AttributeTypeId> followAttributes, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch, viewId).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andRelatedTo(relation, relatedId);
        if (Strings.isValid((String)filter)) {
            query = query.and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
            if (followAttributes.size() > 0) {
                query = query.followSearch(followAttributes, filter, new QueryOption[0]);
            }
        }
        if (orderByAttribute != null && orderByAttribute.isValid()) {
            query = query.setOrderByAttribute(orderByAttribute);
        }
        if (pageCount != 0L && pageSize != 0L) {
            query = query.isOnPage(pageCount, pageSize);
        }
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchCollection(query, branch);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>());
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations, 0L, 0L);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>(), 0L, 0L);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations, pageCount, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>(), orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>(), 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations, pageCount, pageSize, orderByAttribute, new LinkedList<AttributeTypeId>());
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute, Collection<AttributeTypeId> followAttributes) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByRelationAndFilter(branch, relation, relatedId, filter, attributes, followRelations, pageCount, pageSize, orderByAttribute, followAttributes, ArtifactId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, long pageCount, long pageSize, AttributeTypeId orderByAttribute, Collection<AttributeTypeId> followAttributes, ArtifactId viewId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch, viewId).includeApplicabilityTokens().andRelatedTo(relation, relatedId).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
        if (followAttributes.size() > 0) {
            query = query.followSearch(followAttributes, filter, new QueryOption[0]);
        }
        if (orderByAttribute != null && orderByAttribute.isValid()) {
            query = query.setOrderByAttribute(orderByAttribute);
        }
        if (pageCount != 0L && pageSize != 0L) {
            query = query.isOnPage(pageCount, pageSize);
        }
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return this.fetchCollection(query, branch);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, false);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, boolean isExact) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), isExact);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Collection<RelationTypeSide> followRelations, boolean isExact) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, followRelations, isExact, 0L, 0L);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), false, pageCount, pageSize);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, boolean isExact, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), isExact, pageCount, pageSize);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Collection<RelationTypeSide> followRelations, boolean isExact, long pageCount, long pageSize) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, followRelations, isExact, pageCount, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, false, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, boolean isExact, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return null;
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Collection<RelationTypeSide> followRelations, boolean isExact, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), isExact, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), false, pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, boolean isExact, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.getAllByQuery(branch, query, new LinkedList<RelationTypeSide>(), isExact, pageCount, pageSize, orderByAttribute);
    }

    @Override
    public Collection<T> getAllByQuery(BranchId branch, MimAttributeQuery query, Collection<RelationTypeSide> followRelations, boolean isExact, long pageCount, long pageSize, AttributeTypeId orderByAttribute) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        QueryOption[] queryOptions = isExact ? QueryOption.EXACT_MATCH_OPTIONS : QueryOption.CONTAINS_MATCH_OPTIONS;
        QueryBuilder executeQuery = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType});
        if (!query.getRelated().equals(MimRelatedArtifact.SENTINEL)) {
            executeQuery = executeQuery.andRelatedTo(RelationTypeSide.create((RelationTypeToken)query.getRelated().getRelation(), (RelationSide)RelationSide.fromString((String)query.getRelated().getSide())), query.getRelated().getRelatedId());
        }
        for (MimAttributeQueryElement q : query.getQueries()) {
            executeQuery = executeQuery.and(q.getAttributeId(), q.getValue(), queryOptions);
        }
        if (orderByAttribute != null && orderByAttribute.isValid()) {
            executeQuery = executeQuery.setOrderByAttribute(orderByAttribute);
        }
        if (pageCount != 0L && pageSize != 0L) {
            executeQuery = executeQuery.isOnPage(pageCount, pageSize);
        }
        for (RelationTypeSide rel : followRelations) {
            executeQuery = executeQuery.follow(rel);
        }
        return this.fetchCollection(executeQuery, branch);
    }

    @Override
    public int getAllByRelationAndFilterAndCount(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes) throws IllegalArgumentException, SecurityException {
        return this.getAllByRelationAndFilterAndCount(branch, relation, relatedId, filter, attributes, new LinkedList<RelationTypeSide>());
    }

    @Override
    public int getAllByRelationAndFilterAndCount(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations) throws IllegalArgumentException, SecurityException {
        return this.getAllByRelationAndFilterAndCount(branch, relation, relatedId, filter, attributes, followRelations);
    }

    @Override
    public int getAllByRelationAndFilterAndCount(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Collection<RelationTypeSide> followRelations, Collection<AttributeTypeId> followAttributes) throws IllegalArgumentException, SecurityException {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andRelatedTo(relation, relatedId).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY});
        if (followAttributes.size() > 0) {
            query = query.followSearch(followAttributes, filter, new QueryOption[0]);
        }
        for (RelationTypeSide rel : followRelations) {
            query = query.follow(rel);
        }
        return query.getCount();
    }

    @Override
    public int getAllByRelationAndCount(BranchId branch, RelationTypeSide relation, ArtifactId relatedId) throws IllegalArgumentException, SecurityException {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andRelatedTo(relation, relatedId);
        return query.getCount();
    }
}

